/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.selenesedriver;

import com.thoughtworks.selenium.Selenium;
import com.thoughtworks.selenium.SeleniumException;
import java.io.File;
import java.util.Map;
import org.openqa.selenium.internal.selenesedriver.ElementFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SendKeys
extends ElementFunction<Void> {
    @Override
    public Void apply(Selenium selenium, Map<String, ?> args) {
        String locator = this.getLocator(args);
        CharSequence[] allKeys = (CharSequence[])args.get("value");
        StringBuilder builder = new StringBuilder();
        for (CharSequence seq : allKeys) {
            builder.append(seq);
        }
        if (this.isFileInput(selenium, locator)) {
            String toType = builder.toString();
            if (this.isLocalFile(toType)) {
                toType = this.convertToFileUrl(toType);
            }
            selenium.attachFile(locator, toType);
        } else {
            selenium.typeKeys(locator, builder.toString());
        }
        return null;
    }

    private String convertToFileUrl(String toType) {
        return new File(toType).toURI().toString();
    }

    private boolean isFileInput(Selenium selenium, String locator) {
        try {
            String type = selenium.getAttribute(locator + "@type");
            return "file".equals(type.toLowerCase());
        }
        catch (SeleniumException e) {
            return false;
        }
    }

    private boolean isLocalFile(String name) {
        File file = new File(name);
        return file.exists() && file.canRead();
    }
}

