/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal.seleniumemulation;

import com.thoughtworks.selenium.Wait;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.internal.seleniumemulation.ScriptMutator;
import org.openqa.selenium.internal.seleniumemulation.SeleneseCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaitForCondition
extends SeleneseCommand<Void> {
    private final ScriptMutator mutator;

    public WaitForCondition(ScriptMutator mutator) {
        this.mutator = mutator;
    }

    @Override
    protected Void handleSeleneseCommand(final WebDriver driver, String script, String timeout) {
        StringBuilder builder = new StringBuilder();
        this.mutator.mutate(script, builder);
        final String modified = builder.toString();
        new Wait(){

            public boolean until() {
                Object result = ((JavascriptExecutor)driver).executeScript(modified, new Object[0]);
                if (result == null) {
                    return false;
                }
                if (result instanceof String) {
                    return !"".equals(result);
                }
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return true;
            }
        }.wait("Failed to resolve " + script, Long.valueOf(timeout));
        return null;
    }
}

