/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.http;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.JsonOutput;
import org.openqa.selenium.remote.http.BytesContentSupplier;
import org.openqa.selenium.remote.http.FileContentSupplier;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.InputStreamContentSupplier;

public class Contents {
    private static final Json JSON = new Json();

    private Contents() {
    }

    public static Supplier empty() {
        return Contents.bytes(new byte[0]);
    }

    public static Supplier utf8String(CharSequence value) {
        Require.nonNull((String)"Value to return", (Object)value);
        return Contents.string(value, StandardCharsets.UTF_8);
    }

    public static Supplier string(CharSequence value, Charset charset) {
        Require.nonNull((String)"Value to return", (Object)value);
        Require.nonNull((String)"Character set", (Object)charset);
        return Contents.bytes(value.toString().getBytes(charset));
    }

    public static Supplier file(File file) {
        return new FileContentSupplier(file);
    }

    public static Supplier fromStream(InputStream stream, long length) {
        return new InputStreamContentSupplier(stream, length);
    }

    public static Supplier bytes(byte[] bytes) {
        return new BytesContentSupplier(bytes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] bytes(Supplier supplier) {
        Require.nonNull((String)"Supplier of input", (Object)supplier);
        try (InputStream is = (InputStream)supplier.get();){
            byte[] byArray;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                is.transferTo(bos);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String utf8String(Supplier supplier) {
        return Contents.string(supplier, StandardCharsets.UTF_8);
    }

    @Deprecated
    public static String string(Supplier supplier, Charset charset) {
        Require.nonNull((String)"Supplier of input", (Object)supplier);
        Require.nonNull((String)"Character set", (Object)charset);
        return supplier.contentAsString(charset);
    }

    @Deprecated
    public static String string(HttpMessage<?> message) {
        return message.contentAsString();
    }

    public static Reader utf8Reader(Supplier supplier) {
        Require.nonNull((String)"Supplier", (Object)supplier);
        return Contents.reader(supplier, StandardCharsets.UTF_8);
    }

    public static Reader reader(Supplier supplier, Charset charset) {
        Require.nonNull((String)"Supplier of input", (Object)supplier);
        Require.nonNull((String)"Character set", (Object)charset);
        return supplier.reader(charset);
    }

    public static Reader reader(HttpMessage<?> message) {
        return Contents.reader(message.getContent(), message.getContentEncoding());
    }

    public static Supplier asJson(Object obj) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (JsonOutput out = JSON.newOutput((Appendable)new OutputStreamWriter((OutputStream)output, StandardCharsets.UTF_8));){
            out.writeClassName(false);
            out.write(obj);
        }
        return Contents.bytes(output.toByteArray());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T> T fromJson(HttpMessage<?> message, Type typeOfT) {
        try (Reader reader = Contents.reader(message);){
            Object object;
            block14: {
                JsonInput input = JSON.newInput(reader);
                try {
                    object = input.read(typeOfT);
                    if (input == null) break block14;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                input.close();
            }
            return (T)object;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Deprecated
    public static String string(File input) throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            String string;
            block12: {
                InputStream isr = Files.newInputStream(input.toPath(), new OpenOption[0]);
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = isr.read(buffer)) != -1) {
                        bos.write(buffer, 0, len);
                    }
                    string = Base64.getEncoder().encodeToString(bos.toByteArray());
                    if (isr == null) break block12;
                }
                catch (Throwable throwable) {
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                isr.close();
            }
            return string;
        }
    }

    public static interface Supplier
    extends java.util.function.Supplier<InputStream>,
    AutoCloseable {
        public long length();

        @Override
        public void close() throws IOException;

        public String contentAsString(Charset var1);

        default public Reader reader(Charset charset) {
            return new InputStreamReader((InputStream)this.get(), charset);
        }
    }
}

