/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlCheckBoxInput;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlHiddenInput;
import com.gargoylesoftware.htmlunit.html.HtmlHtml;
import com.gargoylesoftware.htmlunit.html.HtmlImageInput;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.html.HtmlSelect;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextArea;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.Point;
import org.openqa.selenium.RenderedWebElement;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.htmlunit.HtmlUnitMouse;
import org.openqa.selenium.htmlunit.InputKeysContainer;
import org.openqa.selenium.interactions.internal.Coordinates;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.openqa.selenium.internal.Locatable;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.internal.WrapsElement;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlUnitWebElement
implements RenderedWebElement,
WrapsDriver,
FindsById,
FindsByLinkText,
FindsByXPath,
FindsByTagName,
FindsByCssSelector,
Locatable {
    protected final HtmlUnitDriver parent;
    protected final HtmlElement element;
    private static final char nbspChar = '\u00a0';
    private static final String[] blockLevelsTagNames = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address", "ul", "ol", "pre", "br"};
    private static final String[] booleanAttributes = new String[]{"checked", "selected", "multiple"};
    private String toString;

    public HtmlUnitWebElement(HtmlUnitDriver parent, HtmlElement element) {
        this.parent = parent;
        this.element = element;
    }

    public void click() {
        try {
            this.verifyCanInteractWithElement();
        }
        catch (InvalidElementStateException e) {
            // empty catch block
        }
        HtmlUnitMouse mouse = (HtmlUnitMouse)this.parent.getMouse();
        mouse.click(this.getCoordinates());
    }

    public void submit() {
        this.assertElementNotStale();
        try {
            if (this.element instanceof HtmlForm) {
                this.submitForm((HtmlForm)this.element);
                return;
            }
            if (this.element instanceof HtmlSubmitInput || this.element instanceof HtmlImageInput) {
                this.element.click();
                return;
            }
            if (this.element instanceof HtmlInput) {
                this.submitForm(this.element.getEnclosingForm());
                return;
            }
            WebElement form = this.findParentForm();
            if (form == null) {
                throw new NoSuchElementException("Unable to find the containing form");
            }
            form.submit();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void submitForm(HtmlForm form) {
        this.assertElementNotStale();
        ArrayList<String> names = new ArrayList<String>();
        names.add("input");
        names.add("button");
        List allElements = form.getHtmlElementsByTagNames(names);
        HtmlElement submit = null;
        for (HtmlElement element : allElements) {
            if (!this.isSubmitElement(element) || !this.isBefore(submit)) continue;
            submit = element;
        }
        if (submit == null) {
            if (this.parent.isJavascriptEnabled()) {
                ScriptResult eventResult = form.fireEvent("submit");
                if (!ScriptResult.isFalse((ScriptResult)eventResult)) {
                    this.parent.executeScript("arguments[0].submit()", form);
                }
                return;
            }
            throw new WebDriverException("Cannot locate element used to submit form");
        }
        try {
            submit.click();
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private boolean isSubmitElement(HtmlElement element) {
        HtmlButton button;
        HtmlElement candidate = null;
        if (element instanceof HtmlSubmitInput && !((HtmlSubmitInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlImageInput && !((HtmlImageInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlButton && "submit".equalsIgnoreCase((button = (HtmlButton)element).getTypeAttribute()) && !button.isDisabled()) {
            candidate = element;
        }
        return candidate != null;
    }

    private boolean isBefore(HtmlElement submit) {
        return submit == null;
    }

    public String getValue() {
        return this.getAttribute("value");
    }

    public void clear() {
        this.assertElementNotStale();
        if (this.element instanceof HtmlInput) {
            ((HtmlInput)this.element).setValueAttribute("");
        } else if (this.element instanceof HtmlTextArea) {
            ((HtmlTextArea)this.element).setText("");
        }
    }

    private void verifyCanInteractWithElement() {
        this.assertElementNotStale();
        Boolean displayed = this.parent.implicitlyWaitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return HtmlUnitWebElement.this.isDisplayed();
            }
        });
        if (displayed == null || !displayed.booleanValue()) {
            throw new ElementNotVisibleException("You may only sendKeys to visible elements");
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("You may only sendKeys to enabled elements");
        }
    }

    private void switchFocusToThisIfNeeded() {
        HtmlUnitWebElement oldActiveElement = (HtmlUnitWebElement)this.parent.switchTo().activeElement();
        boolean jsEnabled = this.parent.isJavascriptEnabled();
        boolean oldActiveEqualsCurrent = oldActiveElement.equals(this);
        boolean isBody = oldActiveElement.getTagName().toLowerCase().equals("body");
        if (jsEnabled && !oldActiveEqualsCurrent && !isBody) {
            oldActiveElement.element.blur();
            this.element.focus();
        }
    }

    public void sendKeyDownEvent(Keys modifierKey) {
        this.sendSingleKeyEvent(modifierKey, "keydown");
    }

    public void sendKeyUpEvent(Keys modifierKey) {
        this.sendSingleKeyEvent(modifierKey, "keyup");
    }

    private void sendSingleKeyEvent(Keys modifierKey, String eventDescription) {
        this.verifyCanInteractWithElement();
        this.switchFocusToThisIfNeeded();
        HtmlUnitKeyboard keyboard = (HtmlUnitKeyboard)this.parent.getKeyboard();
        keyboard.performSingleKeyAction(this.getElement(), modifierKey, eventDescription);
    }

    public void sendKeys(CharSequence ... value) {
        this.verifyCanInteractWithElement();
        InputKeysContainer keysContainer = new InputKeysContainer(this.isInputElement(), value);
        this.switchFocusToThisIfNeeded();
        HtmlUnitKeyboard keyboard = (HtmlUnitKeyboard)this.parent.getKeyboard();
        keyboard.sendKeys(this.element, this.getValue(), keysContainer);
        if (this.isInputElement() && keysContainer.wasSubmitKeyFound()) {
            this.submit();
        }
    }

    private boolean isInputElement() {
        return this.element instanceof HtmlInput;
    }

    public String getTagName() {
        this.assertElementNotStale();
        return this.element.getNodeName();
    }

    public String getAttribute(String name) {
        this.assertElementNotStale();
        String lowerName = name.toLowerCase();
        String value = this.element.getAttribute(name);
        if (this.element instanceof HtmlInput && ("selected".equals(lowerName) || "checked".equals(lowerName))) {
            return ((HtmlInput)this.element).isChecked() ? "true" : null;
        }
        if ("disabled".equals(lowerName)) {
            return this.isEnabled() ? "false" : "true";
        }
        for (String booleanAttribute : booleanAttributes) {
            if (!booleanAttribute.equals(lowerName)) continue;
            if (value.equals(DomElement.ATTRIBUTE_NOT_DEFINED)) {
                return null;
            }
            return "true";
        }
        if ("index".equals(lowerName) && this.element instanceof HtmlOption) {
            HtmlSelect select = ((HtmlOption)this.element).getEnclosingSelect();
            List allOptions = select.getOptions();
            for (int i = 0; i < allOptions.size(); ++i) {
                HtmlOption option = select.getOption(i);
                if (!this.element.equals(option)) continue;
                return String.valueOf(i);
            }
            return null;
        }
        if ("readonly".equalsIgnoreCase(lowerName)) {
            if (this.element instanceof HtmlInput) {
                return String.valueOf(((HtmlInput)this.element).isReadOnly());
            }
            if (this.element instanceof HtmlTextArea) {
                return "".equals(((HtmlTextArea)this.element).getReadOnlyAttribute()) ? "false" : "true";
            }
            return null;
        }
        if ("value".equals(lowerName)) {
            if (this.element instanceof HtmlTextArea) {
                return ((HtmlTextArea)this.element).getText();
            }
            return value == null ? "" : value;
        }
        if (!"".equals(value)) {
            return value;
        }
        if (this.element.hasAttribute(name)) {
            return "";
        }
        return null;
    }

    public boolean toggle() {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only toggle visible elements");
        }
        if (!this.isEnabled()) {
            throw new InvalidElementStateException("You may only toggle enabled elements");
        }
        try {
            HtmlOption option;
            HtmlSelect select;
            if (this.element instanceof HtmlCheckBoxInput) {
                this.element.click();
                return this.isSelected();
            }
            if (this.element instanceof HtmlOption && (select = (option = (HtmlOption)this.element).getEnclosingSelect()).isMultipleSelectEnabled()) {
                option.setSelected(!option.isSelected());
                return this.isSelected();
            }
            throw new InvalidElementStateException("You may only toggle checkboxes or options in a select which allows multiple selections: " + this.getTagName());
        }
        catch (IOException e) {
            throw new WebDriverException("Unexpected exception: " + e);
        }
    }

    public boolean isSelected() {
        this.assertElementNotStale();
        if (this.element instanceof HtmlInput) {
            return ((HtmlInput)this.element).isChecked();
        }
        if (this.element instanceof HtmlOption) {
            return ((HtmlOption)this.element).isSelected();
        }
        throw new UnsupportedOperationException("Unable to determine if element is selected. Tag name is: " + this.element.getTagName());
    }

    public void setSelected() {
        this.assertElementNotStale();
        if (!this.isDisplayed()) {
            throw new ElementNotVisibleException("You may only select visible elements");
        }
        String disabledValue = this.element.getAttribute("disabled");
        if (disabledValue.length() > 0) {
            throw new InvalidElementStateException("You may not select a disabled element");
        }
        if (this.element instanceof HtmlInput) {
            ((HtmlInput)this.element).setChecked(true);
        } else if (this.element instanceof HtmlOption) {
            ((HtmlOption)this.element).setSelected(true);
        } else {
            throw new InvalidElementStateException("Unable to select element. Tag name is: " + this.element.getTagName());
        }
    }

    public boolean isEnabled() {
        this.assertElementNotStale();
        return !this.element.hasAttribute("disabled");
    }

    public boolean isDisplayed() {
        this.assertElementNotStale();
        if (!this.parent.isJavascriptEnabled()) {
            return true;
        }
        return !(this.element instanceof HtmlHiddenInput) && this.element.isDisplayed();
    }

    public Point getLocation() {
        this.assertElementNotStale();
        try {
            return new Point(this.readAndRound("left"), this.readAndRound("top"));
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element", (Throwable)e);
        }
    }

    public Dimension getSize() {
        this.assertElementNotStale();
        try {
            int width = this.readAndRound("width");
            int height = this.readAndRound("height");
            return new Dimension(width, height);
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element", (Throwable)e);
        }
    }

    private int readAndRound(String property) {
        String cssValue = this.getValueOfCssProperty(property).replaceAll("[^0-9\\.]", "");
        if (cssValue.length() == 0) {
            return 5;
        }
        return Math.round(Float.parseFloat(cssValue));
    }

    public void dragAndDropBy(int moveRightBy, int moveDownBy) {
        this.assertElementNotStale();
        throw new UnsupportedOperationException("dragAndDropBy");
    }

    public void dragAndDropOn(RenderedWebElement element) {
        this.assertElementNotStale();
        throw new UnsupportedOperationException("dragAndDropOn");
    }

    public String getText() {
        this.assertElementNotStale();
        StringBuffer toReturn = new StringBuffer();
        StringBuffer textSoFar = new StringBuffer();
        this.getTextFromNode((DomNode)this.element, toReturn, textSoFar, this.element instanceof HtmlPreformattedText);
        String text = toReturn.toString() + this.collapseWhitespace(textSoFar);
        return text.trim();
    }

    protected HtmlUnitDriver getParent() {
        return this.parent;
    }

    protected HtmlElement getElement() {
        return this.element;
    }

    private void getTextFromNode(DomNode node, StringBuffer toReturn, StringBuffer textSoFar, boolean isPreformatted) {
        if (node instanceof HtmlScript) {
            return;
        }
        if (isPreformatted) {
            this.getPreformattedText(node, toReturn);
        }
        for (DomNode child : node.getChildren()) {
            if (child instanceof HtmlPreformattedText) {
                if (child.isDisplayed()) {
                    toReturn.append(this.collapseWhitespace(textSoFar));
                    textSoFar.delete(0, textSoFar.length());
                }
                this.getTextFromNode(child, toReturn, textSoFar, true);
                continue;
            }
            if (child instanceof DomText) {
                if (!child.isDisplayed()) continue;
                String textToAdd = ((DomText)child).getData();
                textToAdd = textToAdd.replace('\u00a0', ' ');
                textSoFar.append(textToAdd);
                continue;
            }
            this.getTextFromNode(child, toReturn, textSoFar, false);
        }
        if (this.isBlockLevel(node)) {
            toReturn.append(this.collapseWhitespace(textSoFar)).append("\n");
            textSoFar.delete(0, textSoFar.length());
        }
    }

    private boolean isBlockLevel(DomNode node) {
        if (!(node instanceof HtmlElement)) {
            return false;
        }
        String tagName = ((HtmlElement)node).getTagName().toLowerCase();
        for (String blockLevelsTagName : blockLevelsTagNames) {
            if (!blockLevelsTagName.equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private String collapseWhitespace(StringBuffer textSoFar) {
        String textToAdd = textSoFar.toString();
        return textToAdd.replaceAll("\\p{javaWhitespace}+", " ").replaceAll("\r", "");
    }

    private void getPreformattedText(DomNode node, StringBuffer toReturn) {
        if (node.isDisplayed()) {
            String xmlText = node.asXml();
            toReturn.append(xmlText.replaceAll("^<pre.*?>", "").replaceAll("</pre.*>$", ""));
        }
    }

    public List<WebElement> getElementsByTagName(String tagName) {
        this.assertElementNotStale();
        List allChildren = this.element.getByXPath(".//" + tagName);
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object o : allChildren) {
            if (!(o instanceof HtmlElement)) continue;
            HtmlElement child = (HtmlElement)o;
            elements.add(this.getParent().newHtmlUnitWebElement(child));
        }
        return elements;
    }

    public WebElement findElement(By by) {
        this.assertElementNotStale();
        return this.parent.findElement(by, (SearchContext)this);
    }

    public List<WebElement> findElements(By by) {
        this.assertElementNotStale();
        return this.parent.findElements(by, (SearchContext)this);
    }

    public WebElement findElementById(String id) {
        this.assertElementNotStale();
        return this.findElementByXPath(".//*[@id = '" + id + "']");
    }

    public List<WebElement> findElementsById(String id) {
        this.assertElementNotStale();
        return this.findElementsByXPath(".//*[@id = '" + id + "']");
    }

    public List<WebElement> findElementsByCssSelector(String using) {
        List<WebElement> allElements = this.parent.findElementsByCssSelector(using);
        return this.findChildNodes(allElements);
    }

    public WebElement findElementByCssSelector(String using) {
        List<WebElement> allElements = this.parent.findElementsByCssSelector(using);
        if ((allElements = this.findChildNodes(allElements)).size() == 0) {
            throw new NoSuchElementException("Cannot find child element using css: " + using);
        }
        return allElements.get(0);
    }

    private List<WebElement> findChildNodes(List<WebElement> allElements) {
        LinkedList<WebElement> toReturn = new LinkedList<WebElement>();
        for (WebElement current : allElements) {
            if (!this.element.isAncestorOf((DomNode)((HtmlUnitWebElement)current).element)) continue;
            toReturn.add(current);
        }
        return toReturn;
    }

    public WebElement findElementByXPath(String xpathExpr) {
        this.assertElementNotStale();
        HtmlElement match = (HtmlElement)this.element.getFirstByXPath(xpathExpr);
        if (match == null) {
            throw new NoSuchElementException("Unable to find element with xpath " + xpathExpr);
        }
        return this.getParent().newHtmlUnitWebElement(match);
    }

    public List<WebElement> findElementsByXPath(String xpathExpr) {
        this.assertElementNotStale();
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        List htmlElements = this.element.getByXPath(xpathExpr);
        for (Object e : htmlElements) {
            webElements.add(this.getParent().newHtmlUnitWebElement((HtmlElement)e));
        }
        return webElements;
    }

    public WebElement findElementByLinkText(String linkText) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByLinkText(linkText);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.size() > 0 ? elements.get(0) : null;
    }

    public List<WebElement> findElementsByLinkText(String linkText) {
        this.assertElementNotStale();
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!e.getTextContent().equals(linkText) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    public WebElement findElementByPartialLinkText(String linkText) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByPartialLinkText(linkText);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Unable to find element with linkText " + linkText);
        }
        return elements.size() > 0 ? elements.get(0) : null;
    }

    public List<WebElement> findElementsByPartialLinkText(String linkText) {
        this.assertElementNotStale();
        List htmlElements = this.element.getHtmlElementsByTagName("a");
        ArrayList<WebElement> webElements = new ArrayList<WebElement>();
        for (HtmlElement e : htmlElements) {
            if (!e.getTextContent().contains(linkText) || e.getAttribute("href") == null) continue;
            webElements.add(this.getParent().newHtmlUnitWebElement(e));
        }
        return webElements;
    }

    public WebElement findElementByTagName(String name) {
        this.assertElementNotStale();
        List<WebElement> elements = this.findElementsByTagName(name);
        if (elements.size() == 0) {
            throw new NoSuchElementException("Cannot find element with tag name: " + name);
        }
        return elements.get(0);
    }

    public List<WebElement> findElementsByTagName(String name) {
        this.assertElementNotStale();
        List elements = this.element.getHtmlElementsByTagName(name);
        ArrayList<WebElement> toReturn = new ArrayList<WebElement>(elements.size());
        for (HtmlElement element : elements) {
            toReturn.add(this.parent.newHtmlUnitWebElement(element));
        }
        return toReturn;
    }

    private WebElement findParentForm() {
        HtmlElement current;
        for (current = this.element; current != null && !(current instanceof HtmlForm); current = current.getParentNode()) {
        }
        return this.getParent().newHtmlUnitWebElement((HtmlElement)((HtmlForm)current));
    }

    public String toString() {
        if (this.toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('<').append(this.element.getTagName());
            NamedNodeMap attributes = this.element.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr a = (Attr)attributes.item(i);
                sb.append(' ').append(a.getName()).append("=\"").append(a.getValue().replace("\"", "&quot;")).append("\"");
            }
            if (this.element.hasChildNodes()) {
                sb.append('>');
            } else {
                sb.append(" />");
            }
            this.toString = sb.toString();
        }
        return this.toString;
    }

    protected void assertElementNotStale() {
        HtmlElement parentElement;
        SgmlPage elementPage = this.element.getPage();
        Page currentPage = this.parent.lastPage();
        if (!currentPage.equals(elementPage)) {
            throw new StaleElementReferenceException("Element appears to be stale. Did you navigate away from the page that contained it?  And is the current window focussed the same as the one holding this element?");
        }
        for (parentElement = this.element; parentElement != null && !(parentElement instanceof HtmlHtml); parentElement = parentElement.getParentNode()) {
        }
        if (parentElement == null) {
            throw new StaleElementReferenceException("The element seems to be disconnected from the DOM.  This means that a user cannot interact with it.");
        }
    }

    public String getCssValue(String propertyName) {
        this.assertElementNotStale();
        return this.getEffectiveStyle(this.element, propertyName);
    }

    public String getValueOfCssProperty(String propertyName) {
        return this.getCssValue(propertyName);
    }

    private String getEffectiveStyle(HtmlElement htmlElement, String propertyName) {
        HtmlElement current = htmlElement;
        String value = "inherit";
        while (current instanceof HtmlElement && "inherit".equals(value)) {
            Object result = this.parent.executeScript("if (window.getComputedStyle) {     return window.getComputedStyle(arguments[0], null).getPropertyValue(arguments[1]); } if (arguments[0].currentStyle) {     return arguments[0].currentStyle[arguments[1]]; } if (window.document.defaultView && window.document.defaultView.getComputedStyle) {     return window.document.defaultView.getComputedStyle(arguments[0], null)[arguments[1]]; } ", current, propertyName);
            if (!(result instanceof Undefined)) {
                value = String.valueOf(result);
            }
            current = (HtmlElement)current.getParentNode();
        }
        if (value.startsWith("rgb")) {
            return this.rgbToHex(value);
        }
        return value;
    }

    private String rgbToHex(String value) {
        Pattern pattern = Pattern.compile("rgb\\((\\d{1,3}),\\s(\\d{1,3}),\\s(\\d{1,3})\\)");
        Matcher matcher = pattern.matcher(value);
        if (matcher.find()) {
            String hex = "#";
            for (int i = 1; i <= 3; ++i) {
                int colour = Integer.parseInt(matcher.group(i));
                String s = Integer.toHexString(colour);
                if (s.length() == 1) {
                    s = "0" + s;
                }
                hex = hex + s;
            }
            hex = hex.toLowerCase();
            return hex;
        }
        return value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        return other instanceof HtmlUnitWebElement && this.element.equals(((HtmlUnitWebElement)other).element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public WebDriver getWrappedDriver() {
        return this.parent;
    }

    public Point getLocationOnScreenOnceScrolledIntoView() {
        return this.getLocation();
    }

    public Coordinates getCoordinates() {
        return new Coordinates(){

            public Point getLocationOnScreen() {
                throw new UnsupportedOperationException("Not displayed, no screen location.");
            }

            public Point getLocationInViewPort() {
                return HtmlUnitWebElement.this.getLocation();
            }

            public Point getLocationInDOM() {
                return HtmlUnitWebElement.this.getLocation();
            }

            public Object getAuxiliry() {
                return HtmlUnitWebElement.this.getElement();
            }
        };
    }
}

