/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import com.google.common.io.FileBackedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import org.openqa.selenium.remote.http.Contents;

class FileBackedOutputStreamContentSupplier
implements Contents.Supplier {
    private final String description;
    private final FileBackedOutputStream buffer;
    private final long length;

    FileBackedOutputStreamContentSupplier(String description, FileBackedOutputStream buffer, long length) {
        this.description = description;
        this.buffer = buffer;
        this.length = length;
    }

    public InputStream get() {
        try {
            return this.buffer.asByteSource().openBufferedStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long length() {
        return this.length;
    }

    public void close() throws IOException {
        this.buffer.reset();
    }

    public String toString() {
        return String.format("Content for %s (%s bytes)", this.description, this.length);
    }

    public String contentAsString(Charset charset) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.buffer.asByteSource().copyTo((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toString(charset);
    }
}

