/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class ReverseProxyHandler
implements HttpHandler,
AutoCloseable {
    private static final Set<String> IGNORED_REQ_HEADERS = Set.of("connection", "http2-settings", "keep-alive", "proxy-authorization", "proxy-authenticate", "proxy-connection", "te", "trailer", "transfer-encoding", "upgrade");
    private final Tracer tracer;
    private final HttpClient upstream;

    public ReverseProxyHandler(Tracer tracer, HttpClient httpClient) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.upstream = (HttpClient)Require.nonNull((String)"HTTP client", (Object)httpClient);
    }

    public HttpResponse execute(HttpRequest req) throws UncheckedIOException {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"reverse_proxy");){
            Tags.HTTP_REQUEST.accept(span, req);
            HttpRequest toUpstream = new HttpRequest(req.getMethod(), req.getUri());
            for (String attributeName : req.getAttributeNames()) {
                toUpstream.setAttribute(attributeName, req.getAttribute(attributeName));
            }
            for (String name2 : req.getQueryParameterNames()) {
                for (String value2 : req.getQueryParameters(name2)) {
                    toUpstream.addQueryParameter(name2, value2);
                }
            }
            req.forEachHeader((name, value) -> {
                if (IGNORED_REQ_HEADERS.contains(name.toLowerCase(Locale.ENGLISH))) {
                    return;
                }
                toUpstream.addHeader(name, value);
            });
            toUpstream.setHeader("Connection", "keep-alive");
            toUpstream.setContent(req.getContent());
            HttpResponse resp = this.upstream.execute(toUpstream);
            Tags.HTTP_RESPONSE.accept(span, resp);
            resp.removeHeader("date");
            resp.removeHeader("server");
            IGNORED_REQ_HEADERS.forEach(x$0 -> {
                HttpResponse cfr_ignored_0 = (HttpResponse)resp.removeHeader(x$0);
            });
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
    }

    @Override
    public void close() {
        this.upstream.close();
    }
}

