/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.net.MediaType;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class CheckContentTypeHeader
implements Filter {
    private static final HttpResponse NO_HEADER = (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson(Map.of("value", Map.of("error", "unknown error", "message", "Content-Type header is missing", "stacktrace", ""))));
    private final Set<String> skipChecksOn;

    public CheckContentTypeHeader(Set<String> skipChecksOn) {
        this.skipChecksOn = Set.copyOf((Collection)Require.nonNull((String)"URLs where checks are skipped", skipChecksOn));
    }

    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull((String)"Next handler", (Object)httpHandler);
        return req -> {
            if (this.skipChecksOn.contains(req.getUri())) {
                return httpHandler.execute(req);
            }
            String type = req.getHeader("Content-Type");
            if (type == null) {
                return NO_HEADER;
            }
            try {
                if (!MediaType.JSON_UTF_8.equals((Object)MediaType.parse((String)type))) {
                    return this.badType(type);
                }
            }
            catch (IllegalArgumentException e) {
                return this.badType(type);
            }
            return httpHandler.execute(req);
        };
    }

    private HttpResponse badType(String type) {
        return (HttpResponse)new HttpResponse().setStatus(500).setContent(Contents.asJson(Map.of("value", Map.of("error", "unknown error", "message", "Content-Type header does not indicate utf-8 encoded json: " + type, "stacktrace", ""))));
    }
}

