/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.security;

import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;

public class RequiresSecretFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(RequiresSecretFilter.class.getName());
    private final Secret secret;

    public RequiresSecretFilter(Secret secret) {
        this.secret = (Secret)Require.nonNull((String)"Secret", (Object)secret);
    }

    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull((String)"HTTP handler", (Object)httpHandler);
        return req -> {
            if (!this.isSecretMatch(this.secret, req)) {
                return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(401).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson(Map.of("value", Map.of("error", "unknown error", "message", "Unauthorized access attempted to ", "stacktrace", ""))));
            }
            return httpHandler.execute(req);
        };
    }

    private boolean isSecretMatch(Secret secret, HttpRequest request) {
        String header = request.getHeader("X-REGISTRATION-SECRET");
        if (header == null) {
            if (secret != null) {
                LOG.warning("Unexpectedly received registration secret to " + String.valueOf(request));
                return false;
            }
            return true;
        }
        Secret requestSecret = new Secret(header);
        if (!secret.matches(requestSecret)) {
            LOG.warning("Unauthorized access attempted to " + String.valueOf(request));
            return false;
        }
        return true;
    }
}

