/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.node.remote;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.grid.data.Availability;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.node.HealthCheck;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteNode
extends Node
implements Closeable {
    public static final Json JSON = new Json();
    private final HttpHandler client;
    private final URI externalUri;
    private final Set<Capabilities> capabilities;
    private final HealthCheck healthCheck;
    private final Filter addSecret;

    public RemoteNode(Tracer tracer, HttpClient.Factory clientFactory, NodeId id, URI externalUri, Secret registrationSecret, Duration sessionTimeout, Collection<Capabilities> capabilities) {
        super(tracer, id, externalUri, registrationSecret, sessionTimeout);
        this.externalUri = (URI)Require.nonNull((String)"External URI", (Object)externalUri);
        this.capabilities = Set.copyOf(capabilities);
        ClientConfig clientConfig = ClientConfig.defaultConfig().readTimeout(this.getSessionTimeout()).baseUrl(Urls.fromUri((URI)externalUri));
        this.client = ((HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory)).createClient(clientConfig);
        this.healthCheck = new RemoteCheck();
        Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return this.capabilities.stream().anyMatch(caps -> caps.getCapabilityNames().stream().allMatch(name -> Objects.equals(caps.getCapability(name), capabilities.getCapability(name))));
    }

    @Override
    public Either<WebDriverException, CreateSessionResponse> newSession(CreateSessionRequest sessionRequest) {
        HttpResponse httpResponse;
        Require.nonNull((String)"Capabilities for session", (Object)sessionRequest);
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/session");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        req.setContent(Contents.asJson((Object)sessionRequest));
        try {
            httpResponse = this.client.with(this.addSecret).execute(req);
        }
        catch (TimeoutException e) {
            return Either.left((Object)new RetrySessionRequestException("Timeout while starting the session", (Throwable)e));
        }
        Optional<Map> maybeResponse = Optional.ofNullable((Map)Values.get(httpResponse, Map.class));
        if (maybeResponse.isPresent()) {
            Map response = maybeResponse.get();
            if (response.containsKey("sessionResponse")) {
                String rawResponse = JSON.toJson(response.get("sessionResponse"));
                CreateSessionResponse sessionResponse = (CreateSessionResponse)JSON.toType(rawResponse, CreateSessionResponse.class);
                return Either.right((Object)sessionResponse);
            }
            String rawException = JSON.toJson(response.get("exception"));
            Map exception = (Map)JSON.toType(rawException, Map.class);
            String errorType = (String)exception.get("error");
            String errorMessage = (String)exception.get("message");
            if (RetrySessionRequestException.class.getName().contentEquals(errorType)) {
                return Either.left((Object)new RetrySessionRequestException(errorMessage));
            }
            return Either.left((Object)((Object)new SessionNotCreatedException(errorMessage)));
        }
        return Either.left((Object)((Object)new SessionNotCreatedException("Error while mapping response from Node")));
    }

    @Override
    public boolean isSessionOwner(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/owner/" + String.valueOf(id));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        return Boolean.TRUE.equals(Values.get(res, Boolean.class));
    }

    @Override
    public boolean tryAcquireConnection(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/connection/" + String.valueOf(id));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        return Boolean.TRUE.equals(Values.get(res, Boolean.class));
    }

    @Override
    public void releaseConnection(SessionId id) {
        Require.nonNull((String)"Session ID", (Object)id);
        HttpRequest req = new HttpRequest(HttpMethod.DELETE, "/se/grid/node/connection/" + String.valueOf(id));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        Values.get(res, Void.class);
    }

    @Override
    public Session getSession(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        HttpRequest req = new HttpRequest(HttpMethod.GET, "/se/grid/node/session/" + String.valueOf(id));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        return (Session)Values.get(res, Session.class);
    }

    @Override
    public HttpResponse executeWebDriverCommand(HttpRequest req) {
        return this.client.execute(req);
    }

    @Override
    public HttpResponse uploadFile(HttpRequest req, SessionId id) {
        return this.client.execute(req);
    }

    @Override
    public HttpResponse downloadFile(HttpRequest req, SessionId id) {
        return this.client.execute(req);
    }

    @Override
    public void stop(SessionId id) throws NoSuchSessionException {
        Require.nonNull((String)"Session ID", (Object)id);
        HttpRequest req = new HttpRequest(HttpMethod.DELETE, "/se/grid/node/session/" + String.valueOf(id));
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        Values.get(res, Void.class);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public NodeStatus getStatus() {
        req = new HttpRequest(HttpMethod.GET, "/status");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        res = this.client.execute(req);
        try {
            block20: {
                reader = Contents.reader((HttpMessage)res);
                in = RemoteNode.JSON.newInput(reader);
                in.beginObject();
lbl10:
                // 2 sources

                while (true) {
                    if (in.hasNext() == false) throw new IllegalStateException("Unable to read status");
                    if ("value".equals(in.nextName())) {
                        in.beginObject();
                        break block20;
                    }
                    in.skipValue();
                    continue;
                    break;
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            while (in.hasNext()) {
                if ("node".equals(in.nextName())) {
                    var5_7 = (NodeStatus)in.read(NodeStatus.class);
                    return var5_7;
                }
                in.skipValue();
            }
            in.endObject();
            ** continue;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    @Override
    public void drain() {
        HttpRequest req = new HttpRequest(HttpMethod.POST, "/se/grid/node/drain");
        HttpTracing.inject((Tracer)this.tracer, (TraceContext)this.tracer.getCurrentContext(), (HttpRequest)req);
        HttpResponse res = this.client.with(this.addSecret).execute(req);
        if (res.getStatus() == 200) {
            this.draining.set(true);
        }
    }

    private Map<String, Object> toJson() {
        return Map.of("id", this.getId(), "uri", this.externalUri, "capabilities", this.capabilities);
    }

    @Override
    public void close() {
        ((HttpClient)this.client).close();
    }

    private class RemoteCheck
    implements HealthCheck {
        private RemoteCheck() {
        }

        @Override
        public HealthCheck.Result check() {
            try {
                NodeStatus status = RemoteNode.this.getStatus();
                if (status.getNodeId() != null && !Objects.equals(RemoteNode.this.getId(), status.getNodeId())) {
                    return new HealthCheck.Result(Availability.DOWN, String.valueOf(RemoteNode.this.externalUri) + " has unexpected node id");
                }
                switch (status.getAvailability()) {
                    case DOWN: {
                        return new HealthCheck.Result(Availability.DOWN, String.valueOf(RemoteNode.this.externalUri) + " is down");
                    }
                    case DRAINING: {
                        return new HealthCheck.Result(Availability.DRAINING, String.valueOf(RemoteNode.this.externalUri) + " is draining");
                    }
                    case UP: {
                        return new HealthCheck.Result(Availability.UP, String.valueOf(RemoteNode.this.externalUri) + " is ok");
                    }
                }
                throw new IllegalStateException("Unknown node availability: " + String.valueOf((Object)status.getAvailability()));
            }
            catch (RuntimeException e) {
                return new HealthCheck.Result(Availability.DOWN, "Unable to determine node status: " + e.getMessage());
            }
        }
    }
}

