/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.distributor.local;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.RetrySessionRequestException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.concurrent.ExecutorServices;
import org.openqa.selenium.concurrent.GuardedRunnable;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.CreateSessionRequest;
import org.openqa.selenium.grid.data.CreateSessionResponse;
import org.openqa.selenium.grid.data.DistributorStatus;
import org.openqa.selenium.grid.data.NodeId;
import org.openqa.selenium.grid.data.NodeStatus;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.data.SessionRequest;
import org.openqa.selenium.grid.data.SessionRequestCapability;
import org.openqa.selenium.grid.data.Slot;
import org.openqa.selenium.grid.data.SlotId;
import org.openqa.selenium.grid.data.SlotMatcher;
import org.openqa.selenium.grid.data.TraceSessionRequest;
import org.openqa.selenium.grid.distributor.Distributor;
import org.openqa.selenium.grid.distributor.NodeRegistry;
import org.openqa.selenium.grid.distributor.config.DistributorOptions;
import org.openqa.selenium.grid.distributor.local.LocalNodeRegistry;
import org.openqa.selenium.grid.distributor.selector.SlotSelector;
import org.openqa.selenium.grid.jmx.JMXHelper;
import org.openqa.selenium.grid.jmx.ManagedAttribute;
import org.openqa.selenium.grid.jmx.ManagedService;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.node.Node;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.grid.sessionmap.config.SessionMapOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.internal.Debug;
import org.openqa.selenium.internal.Either;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.AttributeMap;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Status;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.status.HasReadyState;

@ManagedService(objectName="org.seleniumhq.grid:type=Distributor,name=LocalDistributor", description="Grid 4 node distributor")
public class LocalDistributor
extends Distributor
implements Closeable {
    private static final Logger LOG = Logger.getLogger(LocalDistributor.class.getName());
    private final Tracer tracer;
    private final EventBus bus;
    private final HttpClient.Factory clientFactory;
    private final SessionMap sessions;
    private final SlotSelector slotSelector;
    private final Secret registrationSecret;
    private final Duration healthcheckInterval;
    private final NodeRegistry nodeRegistry;
    private final ReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final SlotMatcher slotMatcher;
    private final Duration purgeNodesInterval;
    private final ScheduledExecutorService newSessionService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Local Distributor - New Session Queue");
        return thread;
    });
    private final ScheduledExecutorService purgeDeadNodesService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Local Distributor - Purge Dead Nodes");
        return thread;
    });
    private final ScheduledExecutorService nodeHealthCheckService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName("Local Distributor - Node Health Check");
        return thread;
    });
    private final ExecutorService sessionCreatorExecutor;
    private final NewSessionQueue sessionQueue;
    private final boolean rejectUnsupportedCaps;

    public LocalDistributor(Tracer tracer, EventBus bus, HttpClient.Factory clientFactory, SessionMap sessions, NewSessionQueue sessionQueue, SlotSelector slotSelector, Secret registrationSecret, Duration healthcheckInterval, boolean rejectUnsupportedCaps, Duration sessionRequestRetryInterval, int newSessionThreadPoolSize, SlotMatcher slotMatcher, Duration purgeNodesInterval) {
        super(tracer, clientFactory, registrationSecret);
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.bus = (EventBus)Require.nonNull((String)"Event bus", (Object)bus);
        this.clientFactory = (HttpClient.Factory)Require.nonNull((String)"HTTP client factory", (Object)clientFactory);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.sessionQueue = (NewSessionQueue)Require.nonNull((String)"New Session Request Queue", (Object)sessionQueue);
        this.slotSelector = (SlotSelector)Require.nonNull((String)"Slot selector", (Object)slotSelector);
        this.registrationSecret = (Secret)Require.nonNull((String)"Registration secret", (Object)registrationSecret);
        this.healthcheckInterval = (Duration)Require.nonNull((String)"Health check interval", (Object)healthcheckInterval);
        this.rejectUnsupportedCaps = rejectUnsupportedCaps;
        this.slotMatcher = slotMatcher;
        this.purgeNodesInterval = purgeNodesInterval;
        Require.nonNull((String)"Session request interval", (Object)sessionRequestRetryInterval);
        this.nodeRegistry = new LocalNodeRegistry(tracer, bus, newSessionThreadPoolSize, this.clientFactory, this.registrationSecret, this.healthcheckInterval, this.nodeHealthCheckService, this.purgeNodesInterval, this.purgeDeadNodesService);
        this.sessionCreatorExecutor = Executors.newFixedThreadPool(newSessionThreadPoolSize, r -> {
            Thread thread = new Thread(r);
            thread.setName("Local Distributor - Session Creation");
            thread.setDaemon(true);
            return thread;
        });
        NewSessionRunnable newSessionRunnable = new NewSessionRunnable();
        long period = sessionRequestRetryInterval.isZero() ? 10L : sessionRequestRetryInterval.toMillis();
        this.newSessionService.scheduleAtFixedRate(GuardedRunnable.guard((Runnable)newSessionRunnable), sessionRequestRetryInterval.toMillis(), period, TimeUnit.MILLISECONDS);
        new JMXHelper().register(this);
    }

    public static Distributor create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        DistributorOptions distributorOptions = new DistributorOptions(config);
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SessionMap sessions = new SessionMapOptions(config).getSessionMap();
        SecretOptions secretOptions = new SecretOptions(config);
        NewSessionQueueOptions newSessionQueueOptions = new NewSessionQueueOptions(config);
        NewSessionQueue sessionQueue = newSessionQueueOptions.getSessionQueue("org.openqa.selenium.grid.sessionqueue.remote.RemoteNewSessionQueue");
        return new LocalDistributor(tracer, bus, clientFactory, sessions, sessionQueue, distributorOptions.getSlotSelector(), secretOptions.getRegistrationSecret(), distributorOptions.getHealthCheckInterval(), distributorOptions.shouldRejectUnsupportedCaps(), newSessionQueueOptions.getSessionRequestRetryInterval(), distributorOptions.getNewSessionThreadPoolSize(), distributorOptions.getSlotMatcher(), distributorOptions.getPurgeNodesInterval());
    }

    @Override
    public boolean isReady() {
        try {
            return Set.of(this.bus, this.sessions).parallelStream().map(HasReadyState::isReady).reduce(true, Boolean::logicalAnd);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    @Override
    public LocalDistributor add(Node node) {
        this.nodeRegistry.add(node);
        return this;
    }

    @Override
    public boolean drain(NodeId nodeId) {
        return this.nodeRegistry.drain(nodeId);
    }

    @Override
    public void remove(NodeId nodeId) {
        this.nodeRegistry.remove(nodeId);
    }

    @Override
    public DistributorStatus getStatus() {
        return this.nodeRegistry.getStatus();
    }

    @Beta
    public void refresh() {
        this.nodeRegistry.refresh();
    }

    protected Set<NodeStatus> getAvailableNodes() {
        return this.nodeRegistry.getAvailableNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<SessionNotCreatedException, CreateSessionResponse> newSession(SessionRequest request) throws SessionNotCreatedException {
        SessionNotCreatedException lastFailure;
        AttributeMap attributeMap;
        Span span;
        block16: {
            block15: {
                Require.nonNull((String)"Requests to process", (Object)request);
                span = this.tracer.getCurrentContext().createSpan("distributor.new_session");
                attributeMap = this.tracer.createAttributeMap();
                try {
                    attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
                    attributeMap.put("request.payload", request.getDesiredCapabilities().toString());
                    String sessionReceivedMessage = "Session request received by the Distributor";
                    span.addEvent(sessionReceivedMessage, attributeMap);
                    LOG.info(String.format("%s: %n %s", sessionReceivedMessage, request.getDesiredCapabilities()));
                    if (request.getDesiredCapabilities().isEmpty()) {
                        SessionNotCreatedException exception = new SessionNotCreatedException("No capabilities found in session request payload");
                        Tags.EXCEPTION.accept(attributeMap, exception);
                        attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to create session. No capabilities found: " + exception.getMessage());
                        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                        Either either = Either.left((Object)((Object)exception));
                        return either;
                    }
                    boolean retry = false;
                    lastFailure = new SessionNotCreatedException("Unable to create new session");
                    for (Capabilities caps : request.getDesiredCapabilities()) {
                        if (this.isNotSupported(caps)) {
                            lastFailure = new SessionNotCreatedException("Unable to find a node supporting the desired capabilities");
                            retry = true;
                            continue;
                        }
                        SlotId selectedSlot = this.reserveSlot(request.getRequestId(), caps);
                        if (selectedSlot == null) {
                            LOG.info(String.format("Unable to find a free slot for request %s. %n %s ", request.getRequestId(), caps));
                            retry = true;
                            continue;
                        }
                        CreateSessionRequest singleRequest = new CreateSessionRequest(request.getDownstreamDialects(), caps, request.getMetadata());
                        try {
                            CreateSessionResponse response = this.startSession(selectedSlot, singleRequest);
                            this.sessions.add(response.getSession());
                            this.nodeRegistry.setSession(selectedSlot, response.getSession());
                            SessionId sessionId = response.getSession().getId();
                            Capabilities sessionCaps = response.getSession().getCapabilities();
                            String sessionUri = response.getSession().getUri().toString();
                            RemoteTags.SESSION_ID.accept(span, sessionId);
                            RemoteTags.CAPABILITIES.accept(span, sessionCaps);
                            RemoteTags.SESSION_ID_EVENT.accept(attributeMap, sessionId);
                            RemoteTags.CAPABILITIES_EVENT.accept(attributeMap, sessionCaps);
                            span.setAttribute(AttributeKey.SESSION_URI.getKey(), sessionUri);
                            attributeMap.put(AttributeKey.SESSION_URI.getKey(), sessionUri);
                            String sessionCreatedMessage = "Session created by the Distributor";
                            span.addEvent(sessionCreatedMessage, attributeMap);
                            LOG.info(String.format("%s. Id: %s %n Caps: %s", sessionCreatedMessage, sessionId, sessionCaps));
                            Either either = Either.right((Object)response);
                            return either;
                        }
                        catch (SessionNotCreatedException e) {
                            this.nodeRegistry.setSession(selectedSlot, null);
                            lastFailure = e;
                        }
                    }
                    if (!retry) break block15;
                }
                catch (SessionNotCreatedException e) {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.ABORTED);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to create session: " + e.getMessage());
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either either = Either.left((Object)((Object)e));
                    return either;
                }
                catch (UncheckedIOException e) {
                    span.setAttribute(AttributeKey.ERROR.getKey(), true);
                    span.setStatus(Status.UNKNOWN);
                    Tags.EXCEPTION.accept(attributeMap, e);
                    attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unknown error in LocalDistributor while creating session: " + e.getMessage());
                    span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                    Either either = Either.left((Object)((Object)new SessionNotCreatedException(e.getMessage(), (Throwable)e)));
                    return either;
                }
                finally {
                    span.close();
                }
                lastFailure = new RetrySessionRequestException("Will re-attempt to find a node which can run this session", (Throwable)lastFailure);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Will retry session " + String.valueOf(request.getRequestId()));
                break block16;
            }
            Tags.EXCEPTION.accept(attributeMap, lastFailure);
            attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), "Unable to create session: " + lastFailure.getMessage());
        }
        span.setAttribute(AttributeKey.ERROR.getKey(), true);
        span.setStatus(Status.ABORTED);
        span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
        Either either = Either.left((Object)((Object)lastFailure));
        return either;
    }

    private CreateSessionResponse startSession(SlotId selectedSlot, CreateSessionRequest singleRequest) {
        Either result;
        Node node = this.nodeRegistry.getNode(selectedSlot.getOwningNodeId());
        if (node == null) {
            throw new SessionNotCreatedException("Unable to find owning node for slot");
        }
        try {
            result = node.newSession(singleRequest);
        }
        catch (SessionNotCreatedException e) {
            result = Either.left((Object)((Object)e));
        }
        catch (RuntimeException e) {
            result = Either.left((Object)((Object)new SessionNotCreatedException(e.getMessage(), (Throwable)e)));
        }
        if (result.isLeft()) {
            WebDriverException exception = (WebDriverException)result.left();
            if (exception instanceof SessionNotCreatedException) {
                throw exception;
            }
            throw new SessionNotCreatedException(exception.getMessage(), (Throwable)exception);
        }
        return (CreateSessionResponse)result.right();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SlotId reserveSlot(RequestId requestId, Capabilities caps) {
        Set<SlotId> slotIds;
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            slotIds = this.slotSelector.selectSlot(caps, this.getAvailableNodes(), this.slotMatcher);
        }
        finally {
            readLock.unlock();
        }
        if (slotIds.isEmpty()) {
            LOG.log(Debug.getDebugLogLevel(), String.format("No slots found for request %s and capabilities %s", requestId, caps));
            return null;
        }
        for (SlotId slotId : slotIds) {
            if (!this.reserve(slotId)) continue;
            return slotId;
        }
        return null;
    }

    private boolean isNotSupported(Capabilities caps) {
        return this.nodeRegistry.getUpNodes().stream().noneMatch(node -> node.hasCapability(caps, this.slotMatcher));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserve(SlotId id) {
        Require.nonNull((String)"Slot ID", (Object)id);
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            boolean bl = this.nodeRegistry.reserve(id);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    @ManagedAttribute(name="NodeUpCount")
    @VisibleForTesting
    public long getUpNodeCount() {
        return this.nodeRegistry.getUpNodeCount();
    }

    @ManagedAttribute(name="NodeDownCount")
    @VisibleForTesting
    public long getDownNodeCount() {
        return this.nodeRegistry.getDownNodeCount();
    }

    @ManagedAttribute(name="ActiveSlots")
    @VisibleForTesting
    public int getActiveSlots() {
        return this.nodeRegistry.getActiveSlots();
    }

    @ManagedAttribute(name="IdleSlots")
    @VisibleForTesting
    public int getIdleSlots() {
        return this.nodeRegistry.getIdleSlots();
    }

    @Override
    public void close() {
        LOG.info("Shutting down Distributor executor service");
        ExecutorServices.shutdownGracefully((String)"Local Distributor - Purge Dead Nodes", (ExecutorService)this.purgeDeadNodesService);
        ExecutorServices.shutdownGracefully((String)"Local Distributor - Node Health Check", (ExecutorService)this.nodeHealthCheckService);
        ExecutorServices.shutdownGracefully((String)"Local Distributor - New Session Queue", (ExecutorService)this.newSessionService);
        ExecutorServices.shutdownGracefully((String)"Local Distributor - Session Creation", (ExecutorService)this.sessionCreatorExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Node getNodeFromURI(URI uri) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set<NodeStatus> nodes = this.nodeRegistry.getAvailableNodes();
            Optional<NodeStatus> nodeStatus = nodes.stream().filter(node -> node.getExternalUri().equals(uri)).findFirst();
            Node node2 = nodeStatus.map(status -> this.nodeRegistry.getNode(status.getNodeId())).orElse(null);
            return node2;
        }
        finally {
            readLock.unlock();
        }
    }

    private class NewSessionRunnable
    implements Runnable {
        private NewSessionRunnable() {
        }

        @Override
        public void run() {
            Map<Capabilities, Long> stereotypes;
            boolean pollQueue;
            Set inQueue;
            if (LocalDistributor.this.rejectUnsupportedCaps) {
                inQueue = LocalDistributor.this.sessionQueue.getQueueContents().stream().map(SessionRequestCapability::getRequestId).collect(Collectors.toSet());
                pollQueue = !inQueue.isEmpty();
            } else {
                inQueue = null;
                boolean bl = pollQueue = !LocalDistributor.this.sessionQueue.peekEmpty();
            }
            if (pollQueue && !(stereotypes = LocalDistributor.this.getAvailableNodes().stream().filter(NodeStatus::hasCapacity).flatMap(node -> node.getSlots().stream().map(Slot::getStereotype)).collect(Collectors.groupingBy(ImmutableCapabilities::copyOf, Collectors.counting()))).isEmpty()) {
                List<SessionRequest> matchingRequests = LocalDistributor.this.sessionQueue.getNextAvailable(stereotypes);
                matchingRequests.forEach(req -> LocalDistributor.this.sessionCreatorExecutor.execute(() -> this.handleNewSessionRequest((SessionRequest)req)));
            }
            if (LocalDistributor.this.rejectUnsupportedCaps) {
                this.checkMatchingSlot(LocalDistributor.this.sessionQueue.getQueueContents().stream().filter(src -> inQueue.contains(src.getRequestId())).collect(Collectors.toList()));
            }
        }

        private void checkMatchingSlot(List<SessionRequestCapability> sessionRequests) {
            Set<NodeStatus> upNodes = LocalDistributor.this.nodeRegistry.getUpNodes();
            sessionRequests.stream().filter(request -> request.getDesiredCapabilities().stream().noneMatch(caps -> upNodes.stream().anyMatch(node -> node.hasCapability((Capabilities)caps, LocalDistributor.this.slotMatcher)))).forEach(request -> {
                LOG.info("No nodes support the capabilities in the request: " + String.valueOf(request.getDesiredCapabilities()));
                SessionNotCreatedException exception = new SessionNotCreatedException("No nodes support the capabilities in the request");
                LocalDistributor.this.sessionQueue.complete(request.getRequestId(), (Either<SessionNotCreatedException, CreateSessionResponse>)Either.left((Object)exception));
            });
        }

        private void handleNewSessionRequest(SessionRequest sessionRequest) {
            block21: {
                RequestId reqId = sessionRequest.getRequestId();
                try (Span span = TraceSessionRequest.extract(LocalDistributor.this.tracer, sessionRequest).createSpan("distributor.poll_queue");){
                    boolean deleted;
                    boolean isSessionValid;
                    AttributeMap attributeMap = LocalDistributor.this.tracer.createAttributeMap();
                    attributeMap.put(AttributeKey.LOGGER_CLASS.getKey(), this.getClass().getName());
                    span.setAttribute(AttributeKey.REQUEST_ID.getKey(), reqId.toString());
                    attributeMap.put(AttributeKey.REQUEST_ID.getKey(), reqId.toString());
                    attributeMap.put("request", sessionRequest.toString());
                    Either<SessionNotCreatedException, CreateSessionResponse> response = LocalDistributor.this.newSession(sessionRequest);
                    if (response.isLeft() && response.left() instanceof RetrySessionRequestException) {
                        try (Span childSpan = span.createSpan("distributor.retry");){
                            if (LOG.isLoggable(Debug.getDebugLogLevel())) {
                                LOG.log(Debug.getDebugLogLevel(), "Retrying {0}", sessionRequest.getDesiredCapabilities());
                            }
                            boolean retried = LocalDistributor.this.sessionQueue.retryAddToQueue(sessionRequest);
                            attributeMap.put("request.retry_add", retried);
                            childSpan.addEvent("Retry adding to front of queue. No slot available.", attributeMap);
                            if (retried) {
                                return;
                            }
                            childSpan.addEvent("retrying_request", attributeMap);
                        }
                    }
                    if ((isSessionValid = LocalDistributor.this.sessionQueue.complete(reqId, response)) || !response.isRight()) break block21;
                    LOG.log(Level.INFO, "Session for request {0} has been created but it has timed out or the connection dropped, stopping it to avoid stalled browser", reqId.toString());
                    Session session = ((CreateSessionResponse)response.right()).getSession();
                    Node node = LocalDistributor.this.nodeRegistry.getNode(session.getUri());
                    if (node == null) break block21;
                    try {
                        deleted = node.execute(new HttpRequest(HttpMethod.DELETE, "/session/" + String.valueOf(session.getId()))).getStatus() == 200;
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, String.format("Exception while trying to delete session %s", session.getId()), e);
                        deleted = false;
                    }
                    if (!deleted) {
                        node.stop(session.getId());
                    }
                }
            }
        }
    }
}

