/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.config;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.internal.Sets;

public class EnvConfig
implements Config {
    @Override
    public Optional<List<String>> getAll(String section, String option) {
        Require.nonNull((String)"Section name", (Object)section);
        Require.nonNull((String)"Option name", (Object)option);
        String key = String.format("%s_%s", section, option).toUpperCase(Locale.ENGLISH).replace("-", "_").replace(".", "_");
        String value = System.getenv().get(key);
        if (value == null) {
            return Optional.empty();
        }
        if (value.startsWith("$")) {
            value = System.getenv(value.substring(1));
        }
        return Optional.ofNullable(value).map(List::of);
    }

    @Override
    public Set<String> getSectionNames() {
        return (Set)System.getenv().keySet().stream().filter(key -> key.split("_").length > 1).map(key -> key.substring(0, key.indexOf(95))).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Sets.toSortedSet());
    }

    @Override
    public Set<String> getOptions(String section) {
        Require.nonNull((String)"Section name to get options for", (Object)section);
        String prefix = String.format("%s_", section).toUpperCase(Locale.ENGLISH);
        return (Set)System.getenv().keySet().stream().filter(key -> key.startsWith(prefix)).map(key -> key.substring(prefix.length())).map(key -> key.toLowerCase(Locale.ENGLISH)).collect(Sets.toSortedSet());
    }
}

