/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.events.zeromq;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zeromq.ZMQ;

class ZmqUtils {
    private static final Logger LOG = Logger.getLogger(ZmqUtils.class.getName());
    private static final long MIN_HEARTBEAT_MS = 1000L;
    private static final long MAX_HEARTBEAT_MS = 0x15555555L;

    private ZmqUtils() {
    }

    static void configureHeartbeat(ZMQ.Socket socket, Duration heartbeatPeriod, String socketType) {
        if (heartbeatPeriod != null && !heartbeatPeriod.isZero() && !heartbeatPeriod.isNegative()) {
            long heartbeatMs = heartbeatPeriod.toMillis();
            long clampedHeartbeatMs = ZmqUtils.clampHeartbeatInterval(heartbeatMs, socketType);
            int heartbeatIvl = (int)clampedHeartbeatMs;
            int heartbeatTimeout = heartbeatIvl * 3;
            int heartbeatTtl = heartbeatIvl * 6;
            socket.setHeartbeatIvl(heartbeatIvl);
            socket.setHeartbeatTimeout(heartbeatTimeout);
            socket.setHeartbeatTtl(heartbeatTtl);
            LOG.info(String.format("ZMQ %s socket heartbeat configured: interval=%ds, timeout=%ds, ttl=%ds", socketType, heartbeatIvl / 1000, heartbeatTimeout / 1000, heartbeatTtl / 1000));
        }
    }

    private static long clampHeartbeatInterval(long heartbeatMs, String socketType) {
        if (heartbeatMs < 1000L) {
            ZmqUtils.logHeartbeatClampWarning(socketType, heartbeatMs, 1000L, "below minimum");
            return 1000L;
        }
        if (heartbeatMs > 0x15555555L) {
            ZmqUtils.logHeartbeatClampWarning(socketType, heartbeatMs, 0x15555555L, "exceeds maximum");
            return 0x15555555L;
        }
        return heartbeatMs;
    }

    private static void logHeartbeatClampWarning(String socketType, long originalMs, long clampedMs, String reason) {
        LOG.log(Level.WARNING, String.format("ZMQ %s socket heartbeat interval %ds is %s, clamping to %ds", socketType, originalMs / 1000L, reason, clampedMs / 1000L));
    }
}

