/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.netty.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.util.function.Consumer;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Message;

class WebSocketMessageHandler
extends SimpleChannelInboundHandler<Message> {
    private final AttributeKey<Consumer<Message>> key;

    public WebSocketMessageHandler(AttributeKey<Consumer<Message>> key) {
        this.key = (AttributeKey)Require.nonNull((String)"Attribute key", key);
    }

    protected void channelRead0(ChannelHandlerContext ctx, Message msg) {
        if (!ctx.channel().hasAttr(this.key)) {
            return;
        }
        Consumer handler = (Consumer)ctx.channel().attr(this.key).get();
        ctx.executor().execute(() -> {
            try {
                handler.accept(msg);
                ctx.flush();
            }
            catch (Throwable t) {
                ctx.fireExceptionCaught(t);
            }
        });
    }
}

