/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.web;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpResponse;

public class CheckOriginHeader
implements Filter {
    private final Set<String> allowedHosts;
    private final Set<String> skipChecksOn;

    public CheckOriginHeader(Collection<String> allowedOriginHosts, Set<String> skipChecksOn) {
        Require.nonNull((String)"Allowed origins list", allowedOriginHosts);
        this.allowedHosts = ImmutableSet.copyOf(allowedOriginHosts);
        this.skipChecksOn = ImmutableSet.copyOf((Collection)((Collection)Require.nonNull((String)"URLs where checks are skipped", skipChecksOn)));
    }

    public HttpHandler apply(HttpHandler httpHandler) {
        Require.nonNull((String)"Next handler", (Object)httpHandler);
        return req -> {
            if (this.skipChecksOn.contains(req.getUri())) {
                return httpHandler.execute(req);
            }
            String origin = req.getHeader("Origin");
            if (origin != null && !this.allowedHosts.contains(origin)) {
                return (HttpResponse)((HttpResponse)new HttpResponse().setStatus(500).addHeader("Content-Type", "application/json; charset=utf-8")).setContent(Contents.asJson((Object)ImmutableMap.of((Object)"value", (Object)ImmutableMap.of((Object)"error", (Object)"unknown error", (Object)"message", (Object)("Origin not allowed: " + origin), (Object)"stacktrace", (Object)""))));
            }
            return httpHandler.execute(req);
        };
    }
}

