/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class RemoveFromSession
implements HttpHandler {
    private final Tracer tracer;
    private final SessionMap sessions;
    private final SessionId id;

    RemoveFromSession(Tracer tracer, SessionMap sessions, SessionId id) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
        this.id = (SessionId)Require.nonNull((String)"Session id", (Object)id);
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessions.remove_session");){
            Tags.HTTP_REQUEST.accept(span, req);
            RemoteTags.SESSION_ID.accept(span, this.id);
            this.sessions.remove(this.id);
            HttpResponse httpResponse = new HttpResponse();
            return httpResponse;
        }
    }
}

