/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v142.heapprofiler.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.json.JsonInput;

public class ReportHeapSnapshotProgress {
    private final Integer done;
    private final Integer total;
    private final Optional<Boolean> finished;

    public ReportHeapSnapshotProgress(Integer done, Integer total, Optional<Boolean> finished) {
        this.done = Objects.requireNonNull(done, "done is required");
        this.total = Objects.requireNonNull(total, "total is required");
        this.finished = finished;
    }

    public Integer getDone() {
        return this.done;
    }

    public Integer getTotal() {
        return this.total;
    }

    public Optional<Boolean> getFinished() {
        return this.finished;
    }

    private static ReportHeapSnapshotProgress fromJson(JsonInput input) {
        Integer done = 0;
        Integer total = 0;
        Optional<Boolean> finished = Optional.empty();
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "done": {
                    done = input.nextNumber().intValue();
                    continue block10;
                }
                case "total": {
                    total = input.nextNumber().intValue();
                    continue block10;
                }
                case "finished": {
                    finished = Optional.ofNullable(input.nextBoolean());
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ReportHeapSnapshotProgress(done, total, finished);
    }
}

