/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriverService
extends DriverService {
    public static final String CHROME_DRIVER_EXE_PROPERTY = "webdriver.chrome.driver";

    private ChromeDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static ChromeDriverService createDefaultService() {
        File exe = ChromeDriverService.findExecutable((String)"chromedriver", (String)CHROME_DRIVER_EXE_PROPERTY, (String)"http://code.google.com/p/selenium/wiki/ChromeDriver", (String)"http://code.google.com/p/chromedriver/downloads/list");
        return new Builder().usingDriverExecutable(exe).usingAnyFreePort().build();
    }

    public static class Builder {
        private int port = 0;
        private File exe = null;
        private ImmutableMap<String, String> environment = ImmutableMap.of();
        private File logFile;

        public Builder usingChromeDriverExecutable(File file) {
            return this.usingDriverExecutable(file);
        }

        public Builder usingDriverExecutable(File file) {
            Preconditions.checkNotNull((Object)file);
            ChromeDriverService.checkExecutable((File)file);
            this.exe = file;
            return this;
        }

        public Builder usingPort(int port) {
            Preconditions.checkArgument((port >= 0 ? 1 : 0) != 0, (String)"Invalid port number: %d", (Object[])new Object[]{port});
            this.port = port;
            return this;
        }

        public Builder usingAnyFreePort() {
            this.port = 0;
            return this;
        }

        @Beta
        public Builder withEnvironment(Map<String, String> environment) {
            this.environment = ImmutableMap.copyOf(environment);
            return this;
        }

        public Builder withLogFile(File logFile) {
            this.logFile = logFile;
            return this;
        }

        public ChromeDriverService build() {
            if (this.port == 0) {
                this.port = PortProber.findFreePort();
            }
            Preconditions.checkState((this.exe != null ? 1 : 0) != 0, (Object)"Path to the driver executable not specified");
            try {
                ImmutableList.Builder argsBuilder = ImmutableList.builder();
                argsBuilder.add((Object)String.format("--port=%d", this.port));
                if (this.logFile != null) {
                    argsBuilder.add((Object)String.format("--log-path=%s", this.logFile.getAbsolutePath()));
                }
                return new ChromeDriverService(this.exe, this.port, argsBuilder.build(), this.environment);
            }
            catch (IOException e) {
                throw new WebDriverException((Throwable)e);
            }
        }
    }
}

