/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.chrome;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.service.DriverCommandExecutor;
import org.openqa.selenium.remote.service.DriverService;

public class ChromeDriver
extends RemoteWebDriver
implements TakesScreenshot {
    public ChromeDriver() {
        this(ChromeDriverService.createDefaultService(), new ChromeOptions());
    }

    public ChromeDriver(ChromeDriverService service) {
        this(service, new ChromeOptions());
    }

    public ChromeDriver(Capabilities capabilities) {
        this(ChromeDriverService.createDefaultService(), capabilities);
    }

    public ChromeDriver(ChromeOptions options) {
        this(ChromeDriverService.createDefaultService(), options);
    }

    public ChromeDriver(ChromeDriverService service, Capabilities capabilities) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), capabilities);
    }

    public ChromeDriver(ChromeDriverService service, ChromeOptions options) {
        super((CommandExecutor)new DriverCommandExecutor((DriverService)service), (Capabilities)options.toCapabilities());
    }

    public void setFileDetector(FileDetector detector) {
        throw new WebDriverException("Setting the file detector only works on remote webdriver instances obtained via RemoteWebDriver");
    }

    public <X> X getScreenshotAs(OutputType<X> target) {
        String base64 = (String)this.execute("screenshot").getValue();
        return (X)target.convertFromBase64Png(base64);
    }
}

