/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.os.SystemClock;
import android.view.MotionEvent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.Point;
import org.openqa.selenium.TouchScreen;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.EventSender;
import org.openqa.selenium.interactions.internal.Coordinates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AndroidTouchScreen
implements TouchScreen {
    private final AndroidWebDriver driver;

    AndroidTouchScreen(AndroidWebDriver driver) {
        this.driver = driver;
    }

    public void singleTap(Coordinates where) {
        Point toTap = where.getLocationOnScreen();
        ArrayList motionEvents = Lists.newArrayList();
        long downTime = SystemClock.uptimeMillis();
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, toTap));
        motionEvents.add(this.getMotionEvent(downTime, downTime, 1, toTap));
        this.sendMotionEvents(motionEvents);
    }

    public void down(int x, int y) {
        ArrayList event = Lists.newArrayList();
        long downTime = SystemClock.uptimeMillis();
        Point coords = new Point(x, y);
        event.add(this.getMotionEvent(downTime, downTime, 0, coords));
        this.sendMotionEvents(event);
    }

    public void up(int x, int y) {
        ArrayList event = Lists.newArrayList();
        long downTime = SystemClock.uptimeMillis();
        Point coords = new Point(x, y);
        event.add(this.getMotionEvent(downTime, downTime, 1, coords));
        this.sendMotionEvents(event);
    }

    public void move(int x, int y) {
        ArrayList event = Lists.newArrayList();
        long downTime = SystemClock.uptimeMillis();
        Point coords = new Point(x, y);
        event.add(this.getMotionEvent(downTime, downTime, 2, coords));
        this.sendMotionEvents(event);
    }

    public void scroll(Coordinates where, int xOffset, int yOffset) {
        long downTime = SystemClock.uptimeMillis();
        ArrayList motionEvents = Lists.newArrayList();
        Point origin = where.getLocationOnScreen();
        Point destination = new Point(origin.x + xOffset, origin.y + yOffset);
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, origin));
        Scroll scroll = new Scroll(origin, destination, downTime);
        motionEvents.addAll(this.getMoveEvents(downTime, downTime, origin, scroll.getDecelerationPoint(), 10, scroll.TIME_BETWEEN_EVENTS));
        motionEvents.addAll(this.getMoveEvents(downTime, scroll.getEventTimeForReferencePoint(), scroll.getDecelerationPoint(), destination, 5, scroll.TIME_BETWEEN_EVENTS));
        motionEvents.add(this.getMotionEvent(downTime, downTime + scroll.getEventTimeForDestinationPoint(), 1, destination));
        this.sendMotionEvents(motionEvents);
    }

    public void doubleTap(Coordinates where) {
        Point toDoubleTap = where.getLocationOnScreen();
        ArrayList motionEvents = Lists.newArrayList();
        long downTime = SystemClock.uptimeMillis();
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, toDoubleTap));
        motionEvents.add(this.getMotionEvent(downTime, downTime, 1, toDoubleTap));
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, toDoubleTap));
        motionEvents.add(this.getMotionEvent(downTime, downTime, 1, toDoubleTap));
        this.sendMotionEvents(motionEvents);
    }

    public void longPress(Coordinates where) {
        long downTime = SystemClock.uptimeMillis();
        ArrayList motionEvents = Lists.newArrayList();
        Point point = where.getLocationOnScreen();
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, point));
        motionEvents.add(this.getMotionEvent(downTime, downTime + 3000L, 1, point));
        this.sendMotionEvents(motionEvents);
    }

    public void scroll(final int xOffset, final int yOffset) {
        this.driver.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                AndroidTouchScreen.this.driver.getWebView().scrollBy(xOffset, yOffset);
            }
        });
    }

    public void flick(final int speedX, final int speedY) {
        this.driver.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                AndroidTouchScreen.this.driver.getWebView().flingScroll(speedX, speedY);
            }
        });
    }

    public void flick(Coordinates where, int xOffset, int yOffset, int speed) {
        long downTime = SystemClock.uptimeMillis();
        ArrayList motionEvents = Lists.newArrayList();
        Point origin = where.getLocationOnScreen();
        Point destination = new Point(origin.x + xOffset, origin.y + yOffset);
        Flick flick = new Flick(speed);
        motionEvents.add(this.getMotionEvent(downTime, downTime, 0, origin));
        motionEvents.addAll(this.getMoveEvents(downTime, downTime, origin, destination, 4, flick.getTimeBetweenEvents()));
        motionEvents.add(this.getMotionEvent(downTime, flick.getTimeForDestinationPoint(downTime), 1, destination));
        this.sendMotionEvents(motionEvents);
    }

    private MotionEvent getMotionEvent(long start, long eventTime, int action, Point coords) {
        return MotionEvent.obtain((long)start, (long)eventTime, (int)action, (float)coords.x, (float)coords.y, (int)0);
    }

    private List<MotionEvent> getMoveEvents(long downTime, long startingEVentTime, Point origin, Point destination, int steps, long timeBetweenEvents) {
        ArrayList move = Lists.newArrayList();
        MotionEvent event = null;
        float xStep = (destination.x - origin.x) / steps;
        float yStep = (destination.y - origin.y) / steps;
        float x = origin.x;
        float y = origin.y;
        long eventTime = startingEVentTime;
        for (int i = 0; i < steps - 1; ++i) {
            event = MotionEvent.obtain((long)downTime, (long)(eventTime += timeBetweenEvents), (int)2, (float)(x += xStep), (float)(y += yStep), (int)0);
            move.add(event);
        }
        move.add(this.getMotionEvent(downTime, eventTime += timeBetweenEvents, 2, destination));
        return move;
    }

    private void sendMotionEvents(List<MotionEvent> eventsToSend) {
        this.driver.setEditAreaHasFocus(false);
        EventSender.sendMotion(eventsToSend, this.driver.getWebView(), this.driver.getActivity());
        this.driver.waitForPageToLoad();
    }

    final class Flick {
        private final int SPEED_NORMAL = 0;
        private final int SPEED_FAST = 1;
        private static final int STEPS = 4;
        private int speed;

        public Flick(int speed) {
            this.speed = speed;
        }

        private long getTimeBetweenEvents() {
            if (this.speed == 0) {
                return 25L;
            }
            if (this.speed == 1) {
                return 9L;
            }
            return 0L;
        }

        private long getTimeForDestinationPoint(long downTime) {
            return downTime + 4L * this.getTimeBetweenEvents();
        }
    }

    final class Scroll {
        private Point origin;
        private Point destination;
        private long downTime;
        static final int INITIAL_STEPS = 10;
        static final int DECELERATION_STEPS = 5;
        final int TOTAL_STEPS = 15;
        final long TIME_BETWEEN_EVENTS = 50L;

        public Scroll(Point origin, Point destination, long downTime) {
            this.origin = origin;
            this.destination = destination;
            this.downTime = downTime;
        }

        private Point getDecelerationPoint() {
            int deltaX = this.destination.x - this.origin.x;
            int deltaY = this.destination.y - this.origin.y;
            int xRef = (int)((double)deltaX * 0.8);
            int yRef = (int)((double)deltaY * 0.8);
            return new Point(this.origin.x + xRef, this.origin.y + yRef);
        }

        private long getEventTimeForReferencePoint() {
            return this.downTime + 500L;
        }

        private long getEventTimeForDestinationPoint() {
            return this.downTime + 750L;
        }
    }
}

