/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.icepdf;

import org.sejda.common.ComponentsUtility;
import org.sejda.core.writer.context.ImageWriterContext;
import org.sejda.core.writer.model.ImageWriter;
import org.sejda.model.exception.TaskExecutionException;
import org.sejda.model.parameter.image.AbstractPdfToImageParameters;
import org.sejda.model.task.BaseTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BasePdfToImageTask<T extends AbstractPdfToImageParameters>
extends BaseTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(BasePdfToImageTask.class);
    private ImageWriter<T> writer;

    BasePdfToImageTask() {
    }

    public void before(T parameters) throws TaskExecutionException {
        this.writer = ImageWriterContext.getContext().getImageWriterFactory().createImageWriter(parameters);
        if (this.writer == null) {
            LOG.info("Unable to create an ImageWriter using the provided factory, falling back on default factory.");
            this.writer = ImageWriterContext.getContext().getDefaultImageWriterFactory().createImageWriter(parameters);
        }
        if (this.writer == null) {
            throw new TaskExecutionException(String.format("No suitable ImageWriter found for %s.", parameters));
        }
        LOG.trace("Found image writer {}", this.writer);
    }

    public void after() {
        ComponentsUtility.nullSafeCloseQuietly(this.writer);
    }

    ImageWriter<T> getWriter() {
        return this.writer;
    }
}

