/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.content.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.content.ContentItem;
import com.sun.syndication.feed.module.content.ContentModuleImpl;
import com.sun.syndication.io.ModuleParser;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class ContentModuleParser
implements ModuleParser {
    private static final Namespace CONTENT_NS = Namespace.getNamespace((String)"content", (String)"http://purl.org/rss/1.0/modules/content/");
    private static final Namespace RDF_NS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");

    public String getNamespaceUri() {
        return "http://purl.org/rss/1.0/modules/content/";
    }

    public Module parse(Element element) {
        boolean foundSomething = false;
        ContentModuleImpl cm = new ContentModuleImpl();
        List encodeds = element.getChildren("encoded", CONTENT_NS);
        ArrayList<String> contentStrings = new ArrayList<String>();
        ArrayList<String> encodedStrings = new ArrayList<String>();
        if (encodeds.size() > 0) {
            foundSomething = true;
            for (int i = 0; i < encodeds.size(); ++i) {
                Element encodedElement = (Element)encodeds.get(i);
                encodedStrings.add(encodedElement.getText());
                contentStrings.add(encodedElement.getText());
            }
        }
        ArrayList<ContentItem> contentItems = new ArrayList<ContentItem>();
        List items = element.getChildren("items", CONTENT_NS);
        for (int i = 0; i < items.size(); ++i) {
            foundSomething = true;
            List lis = ((Element)items.get(i)).getChild("Bag", RDF_NS).getChildren("li", RDF_NS);
            for (int j = 0; j < lis.size(); ++j) {
                Attribute about;
                ContentItem ci = new ContentItem();
                Element li = (Element)lis.get(j);
                Element item = li.getChild("item", CONTENT_NS);
                Element format = item.getChild("format", CONTENT_NS);
                Element encoding = item.getChild("encoding", CONTENT_NS);
                Element value = item.getChild("value", RDF_NS);
                if (value != null) {
                    if (value.getAttributeValue("parseType", RDF_NS) != null) {
                        ci.setContentValueParseType(value.getAttributeValue("parseType", RDF_NS));
                    }
                    if (ci.getContentValueParseType() != null && ci.getContentValueParseType().equals("Literal")) {
                        ci.setContentValue(this.getXmlInnerText(value));
                        contentStrings.add(this.getXmlInnerText(value));
                        ci.setContentValueNamespaces(value.getAdditionalNamespaces());
                    } else {
                        ci.setContentValue(value.getText());
                        contentStrings.add(value.getText());
                    }
                    ci.setContentValueDOM(((Element)value.clone()).getContent());
                }
                if (format != null) {
                    ci.setContentFormat(format.getAttribute("resource", RDF_NS).getValue());
                }
                if (encoding != null) {
                    ci.setContentEncoding(encoding.getAttribute("resource", RDF_NS).getValue());
                }
                if (item != null && (about = item.getAttribute("about", RDF_NS)) != null) {
                    ci.setContentAbout(about.getValue());
                }
                contentItems.add(ci);
            }
        }
        cm.setEncodeds(encodedStrings);
        cm.setContentItems(contentItems);
        cm.setContents(contentStrings);
        return foundSomething ? cm : null;
    }

    protected String getXmlInnerText(Element e) {
        StringBuffer sb = new StringBuffer();
        XMLOutputter xo = new XMLOutputter();
        List children = e.getContent();
        sb.append(xo.outputString(children));
        return sb.toString();
    }
}

