/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.feed.module.cc.io;

import com.sun.syndication.feed.module.Module;
import com.sun.syndication.feed.module.cc.CreativeCommons;
import com.sun.syndication.feed.module.cc.types.License;
import com.sun.syndication.io.ModuleGenerator;
import java.util.HashSet;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class CCModuleGenerator
implements ModuleGenerator {
    private static final Namespace RSS1 = Namespace.getNamespace((String)"cc", (String)"http://web.resource.org/cc/");
    private static final Namespace RSS2 = Namespace.getNamespace((String)"creativeCommons", (String)"http://backend.userland.com/creativeCommonsRssModule");
    private static final Namespace RSS = Namespace.getNamespace((String)"http://purl.org/rss/1.0/");
    private static final Namespace RDF = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final HashSet NAMESPACES = new HashSet();

    public void generate(Module module, Element element) {
        Element root = element;
        while (root.getParentElement() != null) {
            root = root.getParentElement();
        }
        if (root.getNamespace().equals((Object)RDF) || root.getNamespace().equals((Object)RSS)) {
            this.generateRSS1((CreativeCommons)module, element);
        } else {
            this.generateRSS2((CreativeCommons)module, element);
        }
    }

    public Set getNamespaces() {
        return NAMESPACES;
    }

    public String getNamespaceUri() {
        return "rome:CreativeCommons";
    }

    private void generateRSS1(CreativeCommons module, Element element) {
        Element license;
        int i;
        System.out.println(element.getName());
        if (element.getName().equals("channel")) {
            License[] all = module.getAllLicenses();
            for (i = 0; i < all.length; ++i) {
                license = new Element("License", RSS1);
                license.setAttribute("about", all[i].getValue(), RDF);
                License.Behaviour[] permits = all[i].getPermits();
                for (int j = 0; permits != null && j < permits.length; ++j) {
                    Element permit = new Element("permits", RSS1);
                    permit.setAttribute("resource", permits[j].toString(), RDF);
                    license.addContent((Content)permit);
                }
                License.Behaviour[] requires = all[i].getPermits();
                for (int j = 0; requires != null && j < requires.length; ++j) {
                    Element permit = new Element("requires", RSS1);
                    permit.setAttribute("resource", permits[j].toString(), RDF);
                    license.addContent((Content)permit);
                }
                System.out.println("Is Root?" + element.getParentElement());
                element.getParentElement().addContent((Content)license);
            }
        }
        License[] licenses = module.getLicenses();
        for (i = 0; i < licenses.length; ++i) {
            license = new Element("license", RSS1);
            license.setAttribute("resource", licenses[i].getValue(), RDF);
            element.addContent((Content)license);
        }
    }

    private void generateRSS2(CreativeCommons module, Element element) {
        License[] licenses = module.getLicenses();
        for (int i = 0; licenses != null && i < licenses.length; ++i) {
            Element license = new Element("license", RSS2);
            license.setText(licenses[i].getValue());
            element.addContent((Content)license);
        }
    }

    static {
        NAMESPACES.add(RSS1);
        NAMESPACES.add(RSS2);
        NAMESPACES.add(RDF);
    }
}

