/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableRunContainer;

final class RawReverseMappeableRunContainerShortIterator
implements ShortIterator {
    int pos;
    int le;
    int maxlength;
    int base;
    MappeableRunContainer parent;
    short[] vl;

    RawReverseMappeableRunContainerShortIterator(MappeableRunContainer p) {
        this.wrap(p);
    }

    void wrap(MappeableRunContainer p) {
        this.parent = p;
        if (!this.parent.isArrayBacked()) {
            throw new RuntimeException("internal error");
        }
        this.vl = this.parent.valueslength.array();
        this.pos = this.parent.nbrruns - 1;
        this.le = 0;
        if (this.pos >= 0) {
            this.maxlength = BufferUtil.toIntUnsigned(this.getLength(this.pos));
            this.base = BufferUtil.toIntUnsigned(this.getValue(this.pos));
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos >= 0;
    }

    @Override
    public ShortIterator clone() {
        try {
            return (ShortIterator)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public short next() {
        short ans = (short)(this.base + this.maxlength - this.le);
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = BufferUtil.toIntUnsigned(this.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.getValue(this.pos));
            }
        }
        return ans;
    }

    @Override
    public int nextAsInt() {
        int ans = this.base + this.maxlength - this.le;
        ++this.le;
        if (this.le > this.maxlength) {
            --this.pos;
            this.le = 0;
            if (this.pos >= 0) {
                this.maxlength = BufferUtil.toIntUnsigned(this.getLength(this.pos));
                this.base = BufferUtil.toIntUnsigned(this.getValue(this.pos));
            }
        }
        return ans;
    }

    short getValue(int index) {
        return this.vl[2 * index];
    }

    short getLength(int index) {
        return this.vl[2 * index + 1];
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

