/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.hibernate.validator.ClassValidator;
import org.hibernate.validator.InvalidValue;
import org.hibernate.validator.MessageInterpolator;
import org.hibernate.validator.Validator;
import org.richfaces.validator.ObjectValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidator
extends ObjectValidator {
    static final String DEFAULT_VALIDATOR_MESSAGES = "org.hibernate.validator.resources.DefaultValidatorMessages";
    static final String VALIDATOR_MESSAGES = "ValidatorMessages";
    private Map<ObjectValidator.ValidatorKey, ClassValidator<? extends Object>> classValidators = new ConcurrentHashMap<ObjectValidator.ValidatorKey, ClassValidator<? extends Object>>();

    HibernateValidator() {
        ClassValidator.class.getName();
    }

    @Override
    public String[] validateGraph(FacesContext context, Object value, Set<String> profiles) {
        InvalidValue[] invalidValues;
        ClassValidator<? extends Object> validator;
        if (null == context) {
            throw new FacesException("Input parameters is not correct.");
        }
        String[] validationMessages = null;
        if (null != value && (validator = this.getValidator(context, value.getClass())).hasValidationRules() && null != (invalidValues = validator.getInvalidValues(value)) && invalidValues.length > 0) {
            validationMessages = new String[invalidValues.length];
            for (int i = 0; i < invalidValues.length; ++i) {
                InvalidValue invalidValue = invalidValues[i];
                validationMessages[i] = invalidValue.getMessage();
            }
        }
        return validationMessages;
    }

    protected InvalidValue[] validateClass(FacesContext facesContext, Class<? extends Object> beanClass, String property, Object value) {
        ClassValidator<? extends Object> classValidator = this.getValidator(facesContext, beanClass);
        InvalidValue[] invalidValues = classValidator.getPotentialInvalidValues(property, value);
        return invalidValues;
    }

    protected ClassValidator<? extends Object> getValidator(FacesContext facesContext, Class<? extends Object> beanClass) {
        ObjectValidator.ValidatorKey key = new ObjectValidator.ValidatorKey(beanClass, this.calculateLocale(facesContext));
        ClassValidator<? extends Object> result = this.classValidators.get(key);
        if (null == result) {
            result = this.createValidator(facesContext, beanClass);
            this.classValidators.put(key, result);
        }
        return result;
    }

    protected ClassValidator<? extends Object> createValidator(FacesContext facesContext, Class<? extends Object> beanClass) {
        ResourceBundle bundle = this.createHibernateMessages(facesContext);
        return bundle == null ? new ClassValidator(beanClass) : new ClassValidator(beanClass, bundle);
    }

    protected ResourceBundle createHibernateMessages(FacesContext facesContext) {
        ResourceBundle bundle = this.getResourceBundle(facesContext, VALIDATOR_MESSAGES);
        ResourceBundle defaultMessagesBundle = this.getResourceBundle(facesContext, DEFAULT_VALIDATOR_MESSAGES);
        if (null != bundle && defaultMessagesBundle != null) {
            bundle = new ResourceBundleChain(bundle, defaultMessagesBundle);
        } else if (null != defaultMessagesBundle) {
            bundle = defaultMessagesBundle;
        }
        return bundle;
    }

    @Override
    protected String[] validate(FacesContext facesContext, Object base, String property, Object value, Set<String> profiles) {
        InvalidValue[] invalidValues = this.validateBean(facesContext, base, property, value);
        if (null == invalidValues) {
            return null;
        }
        String[] result = new String[invalidValues.length];
        for (int i = 0; i < invalidValues.length; ++i) {
            InvalidValue invalidValue = invalidValues[i];
            result[i] = invalidValue.getMessage();
        }
        return result;
    }

    protected InvalidValue[] validateBean(FacesContext facesContext, Object base, String property, Object value) {
        Class<?> beanClass = base.getClass();
        InvalidValue[] invalidValues = this.validateClass(facesContext, beanClass, property, value);
        return invalidValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResourceBundleChain
    extends ResourceBundle {
        private final ResourceBundle delegate;

        public ResourceBundleChain(ResourceBundle delegate, ResourceBundle parent) {
            this.delegate = delegate;
            this.setParent(parent);
        }

        @Override
        public Enumeration<String> getKeys() {
            return null != this.delegate ? this.delegate.getKeys() : Collections.enumeration(Collections.emptyList());
        }

        @Override
        protected Object handleGetObject(String key) {
            try {
                return null != this.delegate ? this.delegate.getObject(key) : null;
            }
            catch (MissingResourceException e) {
                return null;
            }
        }

        @Override
        public Locale getLocale() {
            return null != this.delegate ? this.delegate.getLocale() : null;
        }
    }

    private static class JsfMessageInterpolator
    implements MessageInterpolator {
        private Locale locale;
        private MessageInterpolator delegate;

        public JsfMessageInterpolator(Locale locale, MessageInterpolator delegate) {
            this.locale = locale;
            this.delegate = delegate;
        }

        public String interpolate(String message, Validator validator, MessageInterpolator defaultInterpolator) {
            return this.delegate.interpolate(message, validator, defaultInterpolator);
        }
    }
}

