/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.model.SelectItem;
import org.ajax4jsf.javascript.ScriptString;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.ajax4jsf.util.SelectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceSelect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceSelectBaseRenderer
extends HeaderResourcesRendererBase {
    private static Log logger = LogFactory.getLog(InplaceSelectBaseRenderer.class);
    private static final String RICH_INPLACE_SELECT_CLASSES = "rich-inplace-select-item rich-inplace-select-font";
    private static final String CONTROLS_FACET = "controls";
    private static final String EMPTY_DEFAULT_LABEL = "\u00a0\u00a0\u00a0";

    protected void doDecode(FacesContext context, UIComponent component) {
        UIInplaceSelect inplaceSelect = null;
        if (!(component instanceof UIInplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceSelect"));
            }
            return;
        }
        inplaceSelect = (UIInplaceSelect)component;
        String clientId = inplaceSelect.getClientId(context);
        if (clientId == null) {
            throw new NullPointerException("component client id is NULL");
        }
        if (InputUtils.isDisabled((UIComponent)inplaceSelect) || InputUtils.isReadOnly((UIComponent)inplaceSelect)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
            }
            return;
        }
        Map request = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)request.get(clientId);
        if (newValue != null) {
            inplaceSelect.setSubmittedValue(newValue);
        } else {
            inplaceSelect.setSubmittedValue(null);
        }
    }

    protected boolean isAcceptableComponent(UIComponent component) {
        return component != null && this.getComponentClass().isAssignableFrom(component.getClass());
    }

    protected String getConvertedStringValue(FacesContext context, UIComponent component, Object value) {
        return InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)value);
    }

    protected void encodeSuggestion(FacesContext context, UIComponent component, String value, String classes) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            writer.startElement("span", component);
            writer.writeAttribute("class", (Object)classes, null);
            if (value != null && value.trim().length() > 0) {
                writer.writeText((Object)value, null);
            } else {
                writer.write("\u00a0");
            }
            writer.endElement("span");
        }
    }

    public List<PreparedSelectItem> prepareItems(FacesContext context, UIComponent component) {
        if (!this.isAcceptableComponent(component)) {
            return null;
        }
        ArrayList<PreparedSelectItem> itemsList = new ArrayList<PreparedSelectItem>();
        UIInplaceSelect inplaceSelect = (UIInplaceSelect)component;
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)inplaceSelect);
        for (SelectItem selectItem : selectItems) {
            String convertedValue = this.getConvertedStringValue(context, (UIComponent)inplaceSelect, selectItem.getValue());
            String label = selectItem.getLabel().trim();
            itemsList.add(new PreparedSelectItem(convertedValue, label));
        }
        return itemsList;
    }

    public void encodeItems(FacesContext context, UIComponent component, List<PreparedSelectItem> items) throws IOException, IllegalArgumentException {
        if (items != null) {
            UIInplaceSelect inplaceSelect = (UIInplaceSelect)component;
            for (PreparedSelectItem preparedSelectItem : items) {
                this.encodeSuggestion(context, (UIComponent)inplaceSelect, preparedSelectItem.getLabel(), RICH_INPLACE_SELECT_CLASSES);
            }
        }
    }

    public String getDefaultLabel(FacesContext context, UIComponent component) {
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.trim().equals("")) {
            defaultLabel = EMPTY_DEFAULT_LABEL;
        }
        return defaultLabel;
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if ("".equals(submittedValue)) {
            return null;
        }
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected Class<? extends UIComponent> getComponentClass() {
        return UIInplaceSelect.class;
    }

    protected String getItemLabel(FacesContext context, UIInplaceSelect component, Object value) {
        String itemLabel = null;
        List selectItems = SelectUtils.getSelectItems((FacesContext)context, (UIComponent)component);
        if (!selectItems.isEmpty()) {
            for (SelectItem item : selectItems) {
                boolean equivValues;
                if (value != null) {
                    equivValues = value.equals(item.getValue());
                } else {
                    boolean bl = equivValues = item.getValue() == null;
                }
                if (!equivValues) continue;
                itemLabel = component.isShowValueInView() ? this.getConvertedStringValue(context, (UIComponent)component, item.getValue()) : item.getLabel();
                break;
            }
        }
        return itemLabel;
    }

    protected String createDefaultLabel(UIComponent component) {
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.trim().equals("")) {
            defaultLabel = EMPTY_DEFAULT_LABEL;
        }
        return defaultLabel;
    }

    protected boolean isEmptyDefaultLabel(String defaultLabel) {
        return EMPTY_DEFAULT_LABEL.equals(defaultLabel);
    }

    protected static final class PreparedSelectItem
    implements ScriptString {
        private String label;
        private String convertedValue;

        public PreparedSelectItem(String convertedValue, String label) {
            this.convertedValue = convertedValue;
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public String getConvertedValue() {
            return this.convertedValue;
        }

        public void appendScript(StringBuffer functionString) {
            functionString.append(this.toScript());
        }

        public String toScript() {
            return "[" + ScriptUtils.toScript((Object)this.label) + ", " + ScriptUtils.toScript((Object)this.convertedValue) + "]";
        }
    }
}

