/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.faces.event.PreRenderComponentEvent;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.ExtendedDataModel;
import org.ajax4jsf.model.Range;
import org.richfaces.cdk.annotations.Attribute;
import org.richfaces.cdk.annotations.EventName;
import org.richfaces.cdk.annotations.Facet;
import org.richfaces.component.AbstractColumn;
import org.richfaces.component.DataTableColumnsIterator;
import org.richfaces.component.DataTableDataChilderIterator;
import org.richfaces.component.DataTableFixedChildrenIterator;
import org.richfaces.component.MetaComponentEncoder;
import org.richfaces.component.MetaComponentResolver;
import org.richfaces.component.Row;
import org.richfaces.component.UISequence;
import org.richfaces.context.ExtendedVisitContext;
import org.richfaces.context.ExtendedVisitContextMode;
import org.richfaces.event.FilteringEvent;
import org.richfaces.event.FilteringListener;
import org.richfaces.event.SortingEvent;
import org.richfaces.event.SortingListener;
import org.richfaces.log.Logger;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.model.Arrangeable;
import org.richfaces.model.ArrangeableModel;
import org.richfaces.model.ArrangeableState;
import org.richfaces.model.ArrangeableStateDefaultImpl;
import org.richfaces.model.FilterField;
import org.richfaces.model.SortField;
import org.richfaces.model.SortMode;
import org.richfaces.renderkit.MetaComponentRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UIDataTableBase
extends UISequence
implements Row,
MetaComponentResolver,
MetaComponentEncoder {
    public static final String COMPONENT_FAMILY = "org.richfaces.Data";
    public static final String HEADER_FACET_NAME = "header";
    public static final String FOOTER_FACET_NAME = "footer";
    public static final String NODATA_FACET_NAME = "noData";
    public static final String HEADER = "header";
    public static final String FOOTER = "footer";
    public static final String BODY = "body";
    private static final Logger RENDERKIT_LOG = RichfacesLogger.RENDERKIT.getLogger();
    private static final Set<String> SUPPORTED_META_COMPONENTS = new HashSet<String>();

    @Facet
    public abstract UIComponent getHeader();

    @Facet
    public abstract UIComponent getFooter();

    @Facet
    public abstract UIComponent getNoData();

    @Attribute
    public abstract String getNoDataLabel();

    @Attribute
    public abstract String getFilterVar();

    @Attribute
    public abstract String getRowClass();

    @Attribute
    public abstract String getHeaderClass();

    @Attribute
    public abstract String getFooterClass();

    @Attribute
    public abstract String getColumnClasses();

    @Attribute
    public abstract String getRowClasses();

    @Attribute
    public abstract String getStyle();

    @Attribute
    public abstract Collection<Object> getSortPriority();

    @Attribute
    public abstract SortMode getSortMode();

    @Attribute(events={@EventName(value="rowclick")})
    public abstract String getOnrowclick();

    @Attribute(events={@EventName(value="rowdblclick")})
    public abstract String getOnrowdblclick();

    @Attribute(events={@EventName(value="rowmousedown")})
    public abstract String getOnrowmousedown();

    @Attribute(events={@EventName(value="rowmouseup")})
    public abstract String getOnrowmouseup();

    @Attribute(events={@EventName(value="rowmouseover")})
    public abstract String getOnrowmouseover();

    @Attribute(events={@EventName(value="rowmousemove")})
    public abstract String getOnrowmousemove();

    @Attribute(events={@EventName(value="rowmouseout")})
    public abstract String getOnrowmouseout();

    @Attribute(events={@EventName(value="rowkeypress")})
    public abstract String getOnrowkeypress();

    @Attribute(events={@EventName(value="rowkeydown")})
    public abstract String getOnrowkeydown();

    @Attribute(events={@EventName(value="rowkeyup")})
    public abstract String getOnrowkeyup();

    public Iterator<UIComponent> columns() {
        return new DataTableColumnsIterator((UIComponent)this);
    }

    @Override
    protected Iterator<UIComponent> fixedChildren() {
        return new DataTableFixedChildrenIterator((UIComponent)this);
    }

    @Override
    protected Iterator<UIComponent> dataChildren() {
        return new DataTableDataChilderIterator((UIComponent)this);
    }

    public boolean isColumnFacetPresent(String facetName) {
        Iterator<UIComponent> columns = this.columns();
        boolean result = false;
        while (columns.hasNext() && !result) {
            UIComponent component = columns.next();
            if (!(component instanceof UIColumn) || !component.isRendered()) continue;
            UIComponent facet = component.getFacet(facetName);
            result = facet != null && facet.isRendered();
        }
        return result;
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected ExtendedDataModel<?> createExtendedDataModel() {
        ArrangeableModel dataModel = super.createExtendedDataModel();
        Arrangeable arrangeable = null;
        FacesContext context = this.getFacesContext();
        ArrangeableState state = this.createArrangeableState(context);
        if (dataModel instanceof Arrangeable) {
            arrangeable = dataModel;
        } else if (state != null) {
            ArrangeableModel arrangebleModel;
            dataModel = arrangebleModel = new ArrangeableModel(dataModel, this.getVar(), this.getFilterVar());
            arrangeable = arrangebleModel;
        }
        if (arrangeable != null) {
            arrangeable.arrange(context, state);
        }
        return dataModel;
    }

    private ArrangeableState createArrangeableState(FacesContext context) {
        SortField sortField;
        ArrangeableStateDefaultImpl state = null;
        LinkedList<FilterField> filterFields = new LinkedList<FilterField>();
        LinkedHashMap<String, SortField> sortFieldsMap = new LinkedHashMap<String, SortField>();
        Iterator<UIComponent> iterator = this.columns();
        while (iterator.hasNext()) {
            UIComponent component = iterator.next();
            if (!(component instanceof AbstractColumn) || !component.isRendered()) continue;
            AbstractColumn column = (AbstractColumn)component;
            FilterField filterField = column.getFilterField();
            if (filterField != null) {
                filterFields.add(filterField);
            }
            if ((sortField = column.getSortField()) == null) continue;
            sortFieldsMap.put(component.getId(), sortField);
        }
        LinkedList<SortField> sortFields = new LinkedList<SortField>();
        Collection<Object> sortPriority = this.getSortPriority();
        if (sortPriority != null) {
            for (Object object : sortPriority) {
                sortField = (SortField)sortFieldsMap.get(object);
                if (sortField == null) continue;
                sortFields.add(sortField);
                sortFieldsMap.remove(object);
            }
        }
        sortFields.addAll(sortFieldsMap.values());
        if (!filterFields.isEmpty() || !sortFields.isEmpty()) {
            state = new ArrangeableStateDefaultImpl(filterFields, sortFields, context.getViewRoot().getLocale());
        }
        return state;
    }

    public void walk(FacesContext faces, DataVisitor visitor, Range range, Object argument) {
        Object key = this.getRowKey();
        this.captureOrigValue(faces);
        this.getExtendedDataModel().walk(faces, visitor, range, argument);
        this.setRowKey(faces, key);
        this.restoreOrigValue(faces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolveClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        if (SUPPORTED_META_COMPONENTS.contains(metaComponentId)) {
            Object oldRowKey = this.getRowKey();
            try {
                this.setRowKey(facesContext, null);
                String string = this.getClientId(facesContext) + '@' + metaComponentId;
                return string;
            }
            finally {
                try {
                    this.setRowKey(facesContext, oldRowKey);
                }
                catch (Exception e) {
                    RENDERKIT_LOG.error((CharSequence)e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }

    public String substituteUnresolvedClientId(FacesContext facesContext, UIComponent contextComponent, String metaComponentId) {
        return null;
    }

    public void encodeMetaComponent(FacesContext context, String metaComponentId) throws IOException {
        context.getApplication().publishEvent(context, PreRenderComponentEvent.class, (Object)this);
        MetaComponentRenderer renderer = (MetaComponentRenderer)this.getRenderer(context);
        renderer.encodeMetaComponent(context, (UIComponent)this, metaComponentId);
    }

    @Override
    protected boolean visitFixedChildren(VisitContext visitContext, VisitCallback callback) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            VisitResult visitResult = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, "header");
            if (visitResult != VisitResult.ACCEPT && visitResult == VisitResult.COMPLETE) {
                return true;
            }
            visitResult = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, "footer");
            if (visitResult != VisitResult.ACCEPT && visitResult == VisitResult.COMPLETE) {
                return true;
            }
            if (visitResult == VisitResult.REJECT) {
                return false;
            }
        }
        return super.visitFixedChildren(visitContext, callback);
    }

    @Override
    protected void restoreChildState(FacesContext facesContext) {
        for (UIComponent child : this.getChildren()) {
            child.setId(child.getId());
        }
        super.restoreChildState(facesContext);
    }

    @Override
    protected boolean visitDataChildren(VisitContext visitContext, VisitCallback callback, boolean visitRows) {
        ExtendedVisitContext extendedVisitContext;
        if (visitContext instanceof ExtendedVisitContext && visitRows && (extendedVisitContext = (ExtendedVisitContext)visitContext).getVisitMode() == ExtendedVisitContextMode.RENDER) {
            this.setRowKey(visitContext.getFacesContext(), null);
            VisitResult result = extendedVisitContext.invokeMetaComponentVisitCallback((UIComponent)this, callback, BODY);
            if (result != VisitResult.ACCEPT) {
                return result == VisitResult.COMPLETE;
            }
        }
        return super.visitDataChildren(visitContext, callback, visitRows);
    }

    public void addSortingListener(SortingListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeSortingListener(SortingListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public void addFilteringListener(FilteringListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public void removeFilteringListener(FilteringListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public FilteringListener[] getFilteringListeners() {
        return (FilteringListener[])this.getFacesListeners(FilteringListener.class);
    }

    public SortingListener[] getSortingListeners() {
        return (SortingListener[])this.getFacesListeners(SortingListener.class);
    }

    @Override
    public void queueEvent(FacesEvent event) {
        if (event instanceof SortingEvent) {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
        if (event instanceof FilteringEvent) {
            event.setPhaseId(PhaseId.UPDATE_MODEL_VALUES);
        }
        super.queueEvent(event);
    }

    public static Set<String> getSupportedMetaComponents() {
        return SUPPORTED_META_COMPONENTS;
    }

    static {
        SUPPORTED_META_COMPONENTS.add("header");
        SUPPORTED_META_COMPONENTS.add("footer");
        SUPPORTED_META_COMPONENTS.add(BODY);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum PropertyKeys {
        filterVar,
        sortPriority,
        sortMode,
        first,
        rows,
        noDataLabel,
        selection,
        header;

    }
}

