/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.application;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import org.ajax4jsf.application.AjaxStateHolder;
import org.ajax4jsf.application.ComponentsLoader;
import org.ajax4jsf.application.ComponentsLoaderImpl;
import org.ajax4jsf.application.StateHolder;
import org.ajax4jsf.application.TreeStructureNode;
import org.ajax4jsf.context.AjaxContext;
import org.ajax4jsf.context.ContextInitParameters;
import org.ajax4jsf.model.KeepAlive;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AjaxStateManager
extends StateManager {
    public static final String CAPTURED_VIEW_STATE = "org.ajax4jsf.captured_view_state";
    private static final Class<StateManager> STATE_MANAGER_ARGUMENTS = StateManager.class;
    public static final int DEFAULT_NUMBER_OF_VIEWS = 16;
    public static final String AJAX_VIEW_SEQUENCE = AjaxStateManager.class.getName() + ".AJAX_VIEW_SEQUENCE";
    public static final String VIEW_SEQUENCE = AjaxStateManager.class.getName() + ".VIEW_SEQUENCE";
    private final StateManager parent;
    private StateManager seamStateManager;
    private final ComponentsLoader componentLoader;
    private static final Log _log = LogFactory.getLog(AjaxStateManager.class);
    public static final String VIEW_SEQUENCE_ATTRIBUTE = AjaxStateManager.class.getName() + ".view_sequence";
    private static final Pattern PATTERN = Pattern.compile(".*<input.*(?:\\svalue=[\"'](.*)[\"']\\s).*name=[\"']javax.faces.ViewState[\"'].*>");
    private static final Pattern PATTERN2 = Pattern.compile(".*<input .*name=[\"']javax.faces.ViewState[\"'].*(?:\\svalue=[\"'](.*)[\"']\\s).*>");
    private static final Map<String, Class<?>> PRIMITIVE_CLASSES = new HashMap(9, 1.0f);

    public AjaxStateManager(StateManager parent) {
        block4: {
            this.parent = parent;
            this.componentLoader = new ComponentsLoaderImpl();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (null == classLoader) {
                classLoader = AjaxStateManager.class.getClassLoader();
            }
            try {
                Class<StateManager> seamStateManagerClass = classLoader.loadClass("org.jboss.seam.jsf.SeamStateManager").asSubclass(StateManager.class);
                Constructor<StateManager> constructor = seamStateManagerClass.getConstructor(STATE_MANAGER_ARGUMENTS);
                this.seamStateManager = constructor.newInstance(new Object[]{new SeamStateManagerWrapper()});
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Create instance of the SeamStateManager");
                }
            }
            catch (Exception e) {
                this.seamStateManager = null;
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"SeamStateManager is not present");
            }
        }
    }

    protected Object getComponentStateToSave(FacesContext context) {
        Object treeState = context.getViewRoot().processSaveState(context);
        Object[] state = new Object[]{treeState, this.getAdditionalState(context)};
        return state;
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        TreeStructureNode treeStructure = new TreeStructureNode();
        treeStructure.apply(context, (UIComponent)context.getViewRoot(), new HashSet<String>());
        return treeStructure;
    }

    protected void restoreComponentState(FacesContext context, UIViewRoot viewRoot, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    protected UIViewRoot restoreTreeStructure(FacesContext context, String viewId, String renderKitId) {
        throw new UnsupportedOperationException();
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        RenderKit renderKit = this.getRenderKit(context);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        Object[] stateArray = this.getStateArray(state);
        if (null == stateArray[0] && null == stateArray[1]) {
            stateArray = new Object[]{this.getLogicalViewId(context), null};
        }
        this.writeState(context, responseStateManager, stateArray);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Write view state to the response");
        }
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        RenderKit renderKit = this.getRenderKit(context);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        Object[] stateArray = null == state.getState() && null == state.getStructure() ? new Object[]{this.getLogicalViewId(context), null} : new Object[]{state.getStructure(), state.getState()};
        this.writeState(context, responseStateManager, stateArray);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Write view state to the response");
        }
    }

    private Object[] getStateArray(Object state) throws IOException, FacesException {
        if (null != state && state.getClass().isArray() && state.getClass().getComponentType().equals(Object.class)) {
            Object[] stateArray = (Object[])state;
            if (2 == stateArray.length) {
                return stateArray;
            }
            throw new FacesException("Unexpected length of the state object array " + stateArray.length);
        }
        throw new FacesException("Unexpected type of the state " + state.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeState(FacesContext context, ResponseStateManager responseStateManager, Object[] stateArray) throws IOException {
        ResponseWriter originalWriter = context.getResponseWriter();
        StringWriter buff = new StringWriter(128);
        try {
            ResponseWriter stateResponseWriter = originalWriter.cloneWithWriter((Writer)buff);
            context.setResponseWriter(stateResponseWriter);
            responseStateManager.writeState(context, (Object)stateArray);
            stateResponseWriter.flush();
            String stateString = buff.toString();
            originalWriter.write(stateString);
            String stateValue = this.getStateValue(stateString);
            context.getExternalContext().getRequestMap().put(CAPTURED_VIEW_STATE, stateValue);
            if (null != stateValue) {
                // empty if block
            }
        }
        finally {
            context.setResponseWriter(originalWriter);
        }
    }

    private String getStateValue(String input) {
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches() && !(matcher = PATTERN2.matcher(input)).matches()) {
            return null;
        }
        return matcher.group(1);
    }

    private static final Object handleRestoreState(FacesContext context, Object state) {
        if (ContextInitParameters.isSerializeServerState(context)) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(new ByteArrayInputStream((byte[])state)){

                    @Override
                    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                        String name = desc.getName();
                        try {
                            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (ClassNotFoundException cnfe) {
                            Class clazz = (Class)PRIMITIVE_CLASSES.get(name);
                            if (clazz != null) {
                                return clazz;
                            }
                            throw cnfe;
                        }
                    }
                };
                Object object = ois.readObject();
                return object;
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (IOException ignored) {}
                }
            }
        }
        return state;
    }

    private static final Object handleSaveState(FacesContext context, Object state) {
        if (ContextInitParameters.isSerializeServerState(context)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ObjectOutputStream oas = null;
            try {
                oas = new ObjectOutputStream(baos);
                oas.writeObject(state);
                oas.flush();
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
            finally {
                if (oas != null) {
                    try {
                        oas.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return baos.toByteArray();
        }
        return state;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot = null;
        ResponseStateManager responseStateManager = this.getRenderKit(context, renderKitId).getResponseStateManager();
        TreeStructureNode treeStructure = null;
        Object[] state = null;
        Object[] serializedView = null;
        if (this.isSavingStateInClient(context)) {
            serializedView = (Object[])responseStateManager.getState(context, viewId);
            if (null != serializedView) {
                treeStructure = (TreeStructureNode)serializedView[0];
                state = (Object[])serializedView[1];
            }
        } else {
            serializedView = this.restoreStateFromSession(context, viewId, renderKitId);
            if (null != serializedView) {
                treeStructure = (TreeStructureNode)serializedView[0];
                state = (Object[])AjaxStateManager.handleRestoreState(context, serializedView[1]);
            }
        }
        if (null != treeStructure && null != (viewRoot = (UIViewRoot)treeStructure.restore(this.componentLoader)) && null != state) {
            viewRoot.processRestoreState(context, state[0]);
            this.restoreAdditionalState(context, state[1]);
        }
        return viewRoot;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        Object[] stateViewArray = null == this.seamStateManager ? this.buildViewState(context) : (Object[])this.seamStateManager.saveView(context);
        return new StateManager.SerializedView((StateManager)this, stateViewArray[0], stateViewArray[1]);
    }

    public Object saveView(FacesContext context) {
        if (null == this.seamStateManager) {
            return this.buildViewState(context);
        }
        return this.seamStateManager.saveView(context);
    }

    public boolean isSavingStateInClient(FacesContext context) {
        return this.parent.isSavingStateInClient(context);
    }

    protected Object[] restoreStateFromSession(FacesContext context, String viewId, String renderKitId) {
        String id = this.restoreLogicalViewId(context, viewId, renderKitId);
        StateHolder stateHolder = this.getStateHolder(context);
        Object[] restoredState = stateHolder.getState(context, viewId, id);
        if (restoredState != null && id != null) {
            context.getExternalContext().getRequestMap().put(AJAX_VIEW_SEQUENCE, id);
        }
        return restoredState;
    }

    protected Object[] buildViewState(FacesContext context) {
        Object[] viewStateArray = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot && !viewRoot.isTransient()) {
            TreeStructureNode treeStructure = (TreeStructureNode)this.getTreeStructureToSave(context);
            Object state = this.getComponentStateToSave(context);
            viewStateArray = this.isSavingStateInClient(context) ? new Object[]{treeStructure, state} : this.saveStateInSession(context, treeStructure, AjaxStateManager.handleSaveState(context, state));
        }
        return viewStateArray;
    }

    protected Object[] saveStateInSession(FacesContext context, Object treeStructure, Object state) {
        UIViewRoot viewRoot = context.getViewRoot();
        StateHolder stateHolder = this.getStateHolder(context);
        String id = this.getLogicalViewId(context);
        stateHolder.saveState(context, viewRoot.getViewId(), id, new Object[]{treeStructure, state});
        Object[] serializedView = new Object[]{id, null};
        return serializedView;
    }

    protected StateHolder getStateHolder(FacesContext context) {
        return AjaxStateHolder.getInstance(context);
    }

    protected Object getAdditionalState(FacesContext context) {
        HashMap keepAliveBeans = new HashMap();
        Map requestMap = context.getExternalContext().getRequestMap();
        for (Map.Entry requestEntry : requestMap.entrySet()) {
            Object bean = requestEntry.getValue();
            if (null == bean || !bean.getClass().isAnnotationPresent(KeepAlive.class)) continue;
            keepAliveBeans.put(requestEntry.getKey(), bean);
        }
        if (keepAliveBeans.size() > 0) {
            return UIComponentBase.saveAttachedState((FacesContext)context, keepAliveBeans);
        }
        return null;
    }

    protected void restoreAdditionalState(FacesContext context, Object state) {
        if (null != state) {
            boolean isAjax = AjaxContext.getCurrentInstance((FacesContext)context).isAjaxRequest();
            Map beansMap = (Map)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)state);
            Map requestMap = context.getExternalContext().getRequestMap();
            for (Object key : beansMap.keySet()) {
                KeepAlive annotation;
                Object bean = beansMap.get(key);
                if (bean != null && (annotation = bean.getClass().getAnnotation(KeepAlive.class)) != null && !isAjax && annotation.ajaxOnly()) continue;
                requestMap.put((String)key, bean);
            }
        }
    }

    protected String restoreLogicalViewId(FacesContext context, String viewId, String renderKitId) {
        String id = (String)this.getRenderKit(context, renderKitId).getResponseStateManager().getTreeStructureToRestore(context, viewId);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getLogicalViewId(FacesContext context) {
        int viewSequence;
        Object session;
        AjaxContext ajaxContext = AjaxContext.getCurrentInstance((FacesContext)context);
        ExternalContext externalContext = context.getExternalContext();
        Object id = null;
        Map requestMap = externalContext.getRequestMap();
        id = requestMap.get(ajaxContext.isAjaxRequest() ? AJAX_VIEW_SEQUENCE : VIEW_SEQUENCE);
        if (null != id) {
            return id.toString();
        }
        Object object = session = externalContext.getSession(true);
        synchronized (object) {
            Map sessionMap = externalContext.getSessionMap();
            Integer sequence = (Integer)sessionMap.get(VIEW_SEQUENCE_ATTRIBUTE);
            viewSequence = null != sequence ? sequence : 0;
            if (viewSequence++ == 65535) {
                viewSequence = 0;
            }
            sessionMap.put(VIEW_SEQUENCE_ATTRIBUTE, new Integer(viewSequence));
        }
        String logicalViewId = "j_id" + viewSequence;
        requestMap.put(VIEW_SEQUENCE, logicalViewId);
        return logicalViewId;
    }

    protected RenderKit getRenderKit(FacesContext context) {
        String renderKitId = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (null != viewRoot) {
            renderKitId = viewRoot.getRenderKitId();
        }
        if (null == renderKitId) {
            renderKitId = context.getApplication().getViewHandler().calculateRenderKitId(context);
        }
        return this.getRenderKit(context, renderKitId);
    }

    protected RenderKit getRenderKit(FacesContext context, String renderKitId) {
        RenderKit renderKit = context.getRenderKit();
        if (null == renderKit) {
            RenderKitFactory factory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            renderKit = factory.getRenderKit(context, renderKitId);
        }
        return renderKit;
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        PRIMITIVE_CLASSES.put("void", Void.TYPE);
    }

    private final class SeamStateManagerWrapper
    extends StateManager {
        private SeamStateManagerWrapper() {
        }

        protected Object getComponentStateToSave(FacesContext arg0) {
            return null;
        }

        protected Object getTreeStructureToSave(FacesContext arg0) {
            return null;
        }

        protected void restoreComponentState(FacesContext arg0, UIViewRoot arg1, String arg2) {
        }

        protected UIViewRoot restoreTreeStructure(FacesContext arg0, String arg1, String arg2) {
            return null;
        }

        public UIViewRoot restoreView(FacesContext arg0, String arg1, String arg2) {
            return null;
        }

        public StateManager.SerializedView saveSerializedView(FacesContext context) {
            Object[] viewState = AjaxStateManager.this.buildViewState(context);
            return new StateManager.SerializedView((StateManager)this, viewState[0], viewState[1]);
        }

        public Object saveView(FacesContext context) {
            return AjaxStateManager.this.buildViewState(context);
        }

        public void writeState(FacesContext arg0, StateManager.SerializedView arg1) throws IOException {
        }
    }
}

