/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.pipeline.component.sax;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.cocoon.pipeline.component.sax.ProcessingException;
import org.apache.cocoon.pipeline.component.sax.SAXConsumer;
import org.apache.cocoon.pipeline.component.xpointer.XPointer;
import org.apache.cocoon.pipeline.component.xpointer.XPointerContext;
import org.apache.cocoon.pipeline.component.xpointer.parser.ParseException;
import org.apache.cocoon.pipeline.component.xpointer.parser.XPointerFrameworkParser;
import org.richfaces.cdk.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XIncludeTransformer
implements SAXConsumer {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String HTTP_ACCEPT = "Accept";
    private static final String HTTP_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String UNKNOWN_LOCATION = "unknow location";
    private static final String XINCLUDE_ACCEPT = "accept";
    private static final String XINCLUDE_ACCEPT_LANGUAGE = "accept-language";
    private static final String XINCLUDE_ENCODING = "encoding";
    private static final String XINCLUDE_FALLBACK = "fallback";
    private static final String XINCLUDE_HREF = "href";
    private static final String XINCLUDE_INCLUDE = "include";
    private static final String XINCLUDE_NAMESPACE_URI = "http://www.w3.org/2001/XInclude";
    private static final String XINCLUDE_PARSE = "parse";
    private static final String XINCLUDE_PARSE_TEXT = "text";
    private static final String XINCLUDE_PARSE_XML = "xml";
    private static final String XINCLUDE_XPOINTER = "xpointer";
    private final Logger log;
    private int useFallbackLevel = 0;
    private int xIncludeElementLevel = 0;
    private final Map<String, String> namespaces = new HashMap<String, String>();
    private URI baseUri;
    private ContentHandler contentHandler;
    private int fallbackElementLevel;
    private LexicalHandler lexicalHandler;
    private Locator locator;
    private EntityResolver2 resolver;

    public XIncludeTransformer(Logger log) {
        this.log = log;
    }

    public XIncludeTransformer(URI baseUri, Logger log) {
        this(log);
        this.setBaseUri(baseUri);
    }

    public EntityResolver2 getResolver() {
        return this.resolver;
    }

    public void setResolver(EntityResolver2 resolver) {
        this.resolver = resolver;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public LexicalHandler getLexicalHandler() {
        if (this.lexicalHandler == null) {
            this.lexicalHandler = new DummyLexicalHandler();
        }
        return this.lexicalHandler;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void setContentHandler(ContentHandler delegateHandler) {
        this.contentHandler = delegateHandler;
        if (delegateHandler instanceof LexicalHandler) {
            this.lexicalHandler = (LexicalHandler)((Object)delegateHandler);
        }
        this.xIncludeElementLevel = 0;
        this.fallbackElementLevel = 0;
        this.useFallbackLevel = 0;
    }

    private boolean isEvaluatingContent() {
        return this.xIncludeElementLevel == 0 || this.fallbackElementLevel > 0 && this.fallbackElementLevel == this.useFallbackLevel;
    }

    private String getLocation() {
        if (this.locator == null) {
            return UNKNOWN_LOCATION;
        }
        return this.locator.getSystemId() + ":" + this.locator.getColumnNumber() + ":" + this.locator.getLineNumber();
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.xIncludeElementLevel == 0) {
            this.getContentHandler().startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.xIncludeElementLevel == 0) {
            this.getContentHandler().endDocument();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (XINCLUDE_NAMESPACE_URI.equals(uri)) {
            if (XINCLUDE_INCLUDE.equals(localName)) {
                if (this.isEvaluatingContent()) {
                    String href = atts.getValue("", XINCLUDE_HREF);
                    String parse = atts.getValue("", XINCLUDE_PARSE);
                    if (parse == null) {
                        parse = XINCLUDE_PARSE_XML;
                    }
                    String xpointer = atts.getValue("", XINCLUDE_XPOINTER);
                    String encoding = atts.getValue("", XINCLUDE_ENCODING);
                    String accept = atts.getValue("", XINCLUDE_ACCEPT);
                    String acceptLanguage = atts.getValue("", XINCLUDE_ACCEPT_LANGUAGE);
                    this.processXIncludeElement(href, parse, xpointer, encoding, accept, acceptLanguage);
                }
                ++this.xIncludeElementLevel;
                return;
            } else {
                if (!XINCLUDE_FALLBACK.equals(localName)) throw new SAXException("Unknown XInclude element " + localName + " at " + this.getLocation());
                ++this.fallbackElementLevel;
            }
            return;
        } else {
            if (!this.isEvaluatingContent()) return;
            this.getContentHandler().startElement(uri, localName, name, atts);
        }
    }

    private void processXIncludeElement(String href, String parse, String xpointer, String encoding, String accept, String acceptLanguage) throws SAXException {
        block17: {
            int fragmentIdentifierPos;
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Processing XInclude element: href=" + href + ", parse=" + parse + ", xpointer=" + xpointer + ", encoding=" + encoding + ", accept=" + accept + ", acceptLanguage=" + acceptLanguage));
            }
            if ((fragmentIdentifierPos = href.indexOf(35)) != -1) {
                this.log.warn((CharSequence)("Fragment identifer found in 'href' attribute: " + href + "\nFragment identifiers are forbidden by the XInclude specification. " + "They are still handled by XIncludeTransformer for backward " + "compatibility, but their use is deprecated and will be prohibited " + "in a future release.  Use the 'xpointer' attribute instead."));
                if (xpointer == null) {
                    xpointer = href.substring(fragmentIdentifierPos + 1);
                }
                href = href.substring(0, fragmentIdentifierPos);
            }
            if (href == null || href.length() == 0) {
                throw new SAXException("XIncludeTransformer: encountered empty href (= href pointing to the current document).");
            }
            InputSource source = this.createSource(href);
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Parse type=" + parse));
            }
            if (XINCLUDE_PARSE_XML.equals(parse)) {
                try {
                    if (xpointer != null && xpointer.length() > 0) {
                        XPointer xPointer = XPointerFrameworkParser.parse(xpointer);
                        XPointerContext xPointerContext = new XPointerContext(xpointer, source, this, this.resolver, this.log);
                        for (Map.Entry<String, String> namespace : this.namespaces.entrySet()) {
                            xPointerContext.addPrefix(namespace.getKey(), namespace.getValue());
                        }
                        xPointer.process(xPointerContext);
                        break block17;
                    }
                    XMLReader xmlReader = XMLReaderFactory.createXMLReader();
                    xmlReader.setContentHandler(this);
                    xmlReader.setEntityResolver(this.resolver);
                    xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                    xmlReader.parse(source);
                }
                catch (ParseException e) {
                    ++this.useFallbackLevel;
                    this.log.info((CharSequence)("Error parsing XPointer expression: " + e.getMessage() + " , will try to use fallback."));
                }
                catch (IOException e) {
                    ++this.useFallbackLevel;
                    this.log.info((CharSequence)("Error processing an xInclude: " + e.getMessage() + "  will try to use fallback."));
                }
                catch (SAXException e) {
                    ++this.useFallbackLevel;
                    this.log.info((CharSequence)("Error processing an xInclude: " + e.getMessage() + "  will try to use fallback."));
                }
            } else if (XINCLUDE_PARSE_TEXT.equals(parse)) {
                if (xpointer != null) {
                    throw new SAXException("xpointer attribute must not be present when parse='text': " + this.getLocation());
                }
                if (null == source.getCharacterStream() && null == source.getByteStream() && null == source.getSystemId()) {
                    ++this.useFallbackLevel;
                    this.log.error((CharSequence)("Can't read XInclude href " + href + " at " + this.getLocation()));
                }
            } else {
                throw new SAXException("Found 'parse' attribute with unknown value " + parse + " at " + this.getLocation());
            }
        }
    }

    private InputSource createSource(String sourceAtt) throws SAXException {
        try {
            InputSource source = null;
            URI sourceURI = URI.create(sourceAtt);
            if (!sourceURI.isAbsolute() && null != this.baseUri) {
                sourceAtt = this.baseUri.resolve(sourceURI).toString();
            }
            if (null != this.resolver) {
                source = this.resolver.resolveEntity(null, sourceAtt);
            }
            if (null == source) {
                source = new InputSource(sourceAtt);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)("Including source: " + sourceAtt));
            }
            return source;
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid xinclude URI " + sourceAtt;
            this.log.error((CharSequence)message, (Throwable)e);
            throw new ProcessingException(message, e);
        }
        catch (IOException e) {
            String message = "Can't resolve URL " + sourceAtt;
            this.log.error((CharSequence)message, (Throwable)e);
            throw new ProcessingException(message, e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (XINCLUDE_NAMESPACE_URI.equals(uri)) {
            if (XINCLUDE_INCLUDE.equals(localName)) {
                --this.xIncludeElementLevel;
                if (this.useFallbackLevel > this.xIncludeElementLevel) {
                    this.useFallbackLevel = this.xIncludeElementLevel;
                }
            } else if (XINCLUDE_FALLBACK.equals(localName)) {
                --this.fallbackElementLevel;
            }
        } else if (this.isEvaluatingContent()) {
            this.getContentHandler().endElement(uri, localName, name);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.isEvaluatingContent()) {
            if (!uri.equals(XINCLUDE_NAMESPACE_URI)) {
                this.getContentHandler().startPrefixMapping(prefix, uri);
            }
            this.namespaces.put(prefix, uri);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        String uri;
        if (this.isEvaluatingContent() && !XINCLUDE_NAMESPACE_URI.equals(uri = this.namespaces.remove(prefix))) {
            this.getContentHandler().endPrefixMapping(prefix);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getLexicalHandler().startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getLexicalHandler().startCDATA();
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getLexicalHandler().startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getLexicalHandler().endEntity(name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getContentHandler().characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getContentHandler().ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getContentHandler().processingInstruction(target, data);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("setDocumentLocator called " + locator.getSystemId()));
        }
        this.locator = locator;
        this.getContentHandler().setDocumentLocator(locator);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.isEvaluatingContent()) {
            this.getContentHandler().skippedEntity(name);
        }
    }

    private static final class DummyLexicalHandler
    implements LexicalHandler {
        private DummyLexicalHandler() {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

