/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.build.shade.resource;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.xpath.XPath;
import org.richfaces.build.shade.resource.BaseFacesResourceTransformer;
import org.richfaces.build.shade.resource.ElementsComparator;
import org.richfaces.build.shade.resource.Taglib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaglibXmlResourceTransformer
extends BaseFacesResourceTransformer {
    private static final String ID = "id";
    private static final String CURRENT_VERSION = "2.0";
    private static final String VERSION = "version";
    private static final String NAMESPACE = "namespace";
    private static final String FUNCTION = "function";
    private static final String TAG = "tag";
    private static final String FUNCTION_NAME = "function-name";
    private static final String TAG_NAME = "tag-name";
    private static final String FACELET_TAGLIB = "facelet-taglib";
    private static final String TAGLIB_XML_FILE_EXTENSION = ".taglib.xml";
    private static final String NAMESPACE_EXPRESSION = MessageFormat.format("/{0}:{1}/{0}:{2}|/{1}/{2}", "javaee", "facelet-taglib", "namespace");
    private Map<String, List<Document>> tagLibraries = new HashMap<String, List<Document>>();
    private Map<String, Document> passThroughLibraries = new HashMap<String, Document>();
    private Taglib[] taglibs = new Taglib[0];

    private Comparator<Element> createElementsComparator() throws JDOMException {
        List<String> elements = Arrays.asList("description", "display-name", "icon", "library-class", NAMESPACE, "composite-library-name", TAG, FUNCTION, "taglib-extension");
        HashMap<String, XPath> elementNameExpressions = new HashMap<String, XPath>();
        String tagPathExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", TAG_NAME);
        elementNameExpressions.put(TAG, TaglibXmlResourceTransformer.createXPath(tagPathExpr));
        String fnPathExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", FUNCTION_NAME);
        elementNameExpressions.put(FUNCTION, TaglibXmlResourceTransformer.createXPath(fnPathExpr));
        return new ElementsComparator("http://java.sun.com/xml/ns/javaee", elements, elementNameExpressions);
    }

    private String getShortName(String namespaceUri) {
        int idx = namespaceUri.lastIndexOf(47);
        if (idx < 0) {
            return namespaceUri;
        }
        return namespaceUri.substring(idx + 1);
    }

    private String getFileName(String shortName) {
        return "META-INF/" + shortName + TAGLIB_XML_FILE_EXTENSION;
    }

    public boolean canTransformResource(String resource) {
        String name = this.getMetaInfResourceName(resource);
        return name != null && name.endsWith(TAGLIB_XML_FILE_EXTENSION);
    }

    private void checkRootElement(Element element) {
        if (!FACELET_TAGLIB.equals(element.getName())) {
            throw new IllegalArgumentException("Root element name: " + element.getName());
        }
        if (!this.isJavaEEOrDefaultNamespace(element)) {
            throw new IllegalArgumentException("Root element namespace: " + element.getNamespaceURI());
        }
    }

    public boolean hasTransformedResource() {
        return !this.tagLibraries.isEmpty() || !this.passThroughLibraries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyOutputStream(JarOutputStream os) throws IOException {
        block9: {
            try {
                Comparator<Element> elementsComparator;
                for (Map.Entry<String, Document> entry : this.passThroughLibraries.entrySet()) {
                    String resourceName = entry.getKey();
                    Document document = entry.getValue();
                    this.appendToStream(resourceName, document, os);
                }
                if (this.tagLibraries.isEmpty()) break block9;
                try {
                    elementsComparator = this.createElementsComparator();
                }
                catch (JDOMException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                Namespace javaEENamespace = this.getJavaEENamespace();
                Filter filter = new ElementFilter().and(new ElementFilter(NAMESPACE, javaEENamespace).negate());
                for (Map.Entry<String, List<Document>> entry : this.tagLibraries.entrySet()) {
                    String namespaceUri = entry.getKey();
                    String shortName = this.getShortName(namespaceUri);
                    List<Document> sourceDocuments = entry.getValue();
                    Document document = new Document();
                    Element rootElement = new Element(FACELET_TAGLIB, javaEENamespace);
                    rootElement.setAttribute(VERSION, CURRENT_VERSION);
                    this.addSchemaLocation(rootElement, "http://java.sun.com/xml/ns/javaee/web-facelettaglibrary_2_0.xsd");
                    rootElement.setAttribute(ID, shortName);
                    document.addContent((Content)rootElement);
                    ArrayList<Element> elements = new ArrayList<Element>();
                    Element nsElement = new Element(NAMESPACE, javaEENamespace);
                    nsElement.setText(namespaceUri);
                    elements.add(nsElement);
                    for (Document sourceDocument : sourceDocuments) {
                        Element sourceRootElement = sourceDocument.getRootElement();
                        this.checkRootElement(sourceRootElement);
                        List<Element> tagsContent = this.checkedList(sourceRootElement.getContent(filter), Element.class);
                        for (Element tagElement : tagsContent) {
                            Element clonedElement = this.cloneAndImportElement(tagElement);
                            elements.add(clonedElement);
                        }
                    }
                    Collections.sort(elements, elementsComparator);
                    rootElement.addContent(elements);
                    String fileName = this.getFileName(shortName);
                    this.appendToStream(fileName, document, os);
                }
            }
            finally {
                this.resetTransformer();
            }
        }
    }

    @Override
    protected void resetTransformer() {
        super.resetTransformer();
        this.passThroughLibraries.clear();
        this.tagLibraries.clear();
    }

    @Override
    protected void processDocument(String resource, Document document, List relocators) throws JDOMException {
        String namespaceUri = TaglibXmlResourceTransformer.createXPath(NAMESPACE_EXPRESSION).valueOf((Object)document);
        if (namespaceUri == null || namespaceUri.length() == 0) {
            this.passThroughLibraries.put(resource, document);
        } else {
            List<Document> documents;
            for (Taglib taglib : this.taglibs) {
                if (!taglib.matches(namespaceUri)) continue;
                namespaceUri = taglib.getTargetNamespace();
                break;
            }
            if ((documents = this.tagLibraries.get(namespaceUri)) == null) {
                documents = new ArrayList<Document>();
                this.tagLibraries.put(namespaceUri, documents);
            }
            documents.add(document);
        }
    }

    public Taglib[] getTaglibs() {
        return this.taglibs;
    }

    public void setTaglibs(Taglib[] taglibs) {
        this.taglibs = taglibs;
    }
}

