/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.build.shade.resource;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarOutputStream;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.xpath.XPath;
import org.richfaces.build.shade.resource.BaseFacesResourceTransformer;
import org.richfaces.build.shade.resource.ElementsComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesConfigXmlResourceTransformer
extends BaseFacesResourceTransformer {
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDER_KIT_EXTENSION = "render-kit-extension";
    private static final String CLIENT_BEHAVIOR_RENDERER = "client-behavior-renderer";
    private static final String ICON = "icon";
    private static final String DISPLAY_NAME = "display-name";
    private static final String DESCRIPTION = "description";
    private static final String LIFECYCLE_EXTENSION = "lifecycle-extension";
    private static final String PHASE_LISTENER = "phase-listener";
    private static final String FACES_CONFIG_EXTENSION = "faces-config-extension";
    private static final String BEHAVIOR = "behavior";
    private static final String VALIDATOR = "validator";
    private static final String LIFECYCLE = "lifecycle";
    private static final String REFERENCED_BEAN = "referenced-bean";
    private static final String NAVIGATION_RULE = "navigation-rule";
    private static final String NAME = "name";
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String CONVERTER = "converter";
    private static final String COMPONENT = "component";
    private static final String FACTORY = "factory";
    private static final String ABSOLUTE_ORDERING = "absolute-ordering";
    private static final String ORDERING = "ordering";
    private static final String APPLICATION = "application";
    private static final String RENDERER = "renderer";
    private static final String RENDER_KIT_CLASS = "render-kit-class";
    private static final String RENDER_KIT_ID = "render-kit-id";
    private static final String RENDER_KIT = "render-kit";
    private static final String FACES_CONFIG = "faces-config";
    private static final String METADATA_COMPLETE = "metadata-complete";
    private static final String CURRENT_VERSION = "2.0";
    private static final String VERSION = "version";
    private static final String FACES_CONFIG_FILE_NAME = "faces-config.xml";
    private static final String DOT_FACES_CONFIG_FILE_NAME = ".faces-config.xml";
    private static final Set<String> AGGREGATOR_ELEMENTS_NAME_SET = new HashSet<String>(Arrays.asList("application", "factory", "lifecycle"));
    private static final Set<String> UNHANDLED_ELEMENTS_NAME_SET = new HashSet<String>(Arrays.asList("ordering", "absolute-ordering"));
    private static final String RENDER_KIT_ID_EXPRESSION = MessageFormat.format("./{0}:{1}|./{1}", "javaee", "render-kit-id");
    private static final String FACES_CONFIG_FILE_PATH = "META-INF/faces-config.xml";
    private Map<String, List<Element>> aggregatorElements = new HashMap<String, List<Element>>();
    private Map<String, List<Element>> renderkitElements = new HashMap<String, List<Element>>();
    private List<Element> simpleElements = new ArrayList<Element>();
    private String configName = null;
    private boolean hasProcessedConfigFiles;
    private ThreeState metadataComplete = ThreeState.UNDEFINED;

    private Comparator<Element> createElementsComparator() throws JDOMException {
        List<String> elements = Arrays.asList(APPLICATION, ORDERING, ABSOLUTE_ORDERING, FACTORY, COMPONENT, CONVERTER, MANAGED_BEAN, NAME, NAVIGATION_RULE, REFERENCED_BEAN, RENDER_KIT, LIFECYCLE, VALIDATOR, BEHAVIOR, FACES_CONFIG_EXTENSION, PHASE_LISTENER, LIFECYCLE_EXTENSION, DESCRIPTION, DISPLAY_NAME, ICON, RENDER_KIT_ID, RENDER_KIT_CLASS, RENDERER, CLIENT_BEHAVIOR_RENDERER, RENDER_KIT_EXTENSION);
        HashMap<String, XPath> elementNameExpressions = new HashMap<String, XPath>();
        String componentTypeExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", COMPONENT_TYPE);
        elementNameExpressions.put(COMPONENT, FacesConfigXmlResourceTransformer.createXPath(componentTypeExpr));
        String converterIdExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", CONVERTER_ID);
        elementNameExpressions.put(CONVERTER, FacesConfigXmlResourceTransformer.createXPath(converterIdExpr));
        String validatorIdExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", VALIDATOR_ID);
        elementNameExpressions.put(VALIDATOR, FacesConfigXmlResourceTransformer.createXPath(validatorIdExpr));
        String behaviorIdExpr = MessageFormat.format("./{0}:{1}|./{1}", "javaee", BEHAVIOR_ID);
        elementNameExpressions.put(BEHAVIOR, FacesConfigXmlResourceTransformer.createXPath(behaviorIdExpr));
        return new ElementsComparator("http://java.sun.com/xml/ns/javaee", elements, elementNameExpressions);
    }

    private void checkRootElement(Element element) {
        if (!FACES_CONFIG.equals(element.getName())) {
            throw new IllegalArgumentException("Root element name: " + element.getName());
        }
        if (!this.isJavaEEOrDefaultNamespace(element)) {
            throw new IllegalArgumentException("Root element namespace: " + element.getNamespaceURI());
        }
    }

    @Override
    protected void processDocument(String resource, Document document, List relocators) throws JDOMException {
        String metadataCompleteString;
        this.hasProcessedConfigFiles = true;
        Element rootElement = document.getRootElement();
        this.checkRootElement(rootElement);
        if ((this.metadataComplete == ThreeState.UNDEFINED || Boolean.TRUE.equals((Object)this.metadataComplete)) && !"true".equals(metadataCompleteString = rootElement.getAttributeValue(METADATA_COMPLETE))) {
            this.metadataComplete = ThreeState.FALSE;
        }
        Filter renderkitIdFilter = new ElementFilter().and(new ElementFilter(RENDER_KIT_ID, this.getJavaEENamespace()).negate());
        XPath renderKitIdXPath = FacesConfigXmlResourceTransformer.createXPath(RENDER_KIT_ID_EXPRESSION);
        List<Element> children = this.checkedList(rootElement.getChildren(), Element.class);
        for (Element child : children) {
            if (!"http://java.sun.com/xml/ns/javaee".equals(child.getNamespaceURI())) {
                this.simpleElements.add(child);
                continue;
            }
            String name = child.getName();
            if (UNHANDLED_ELEMENTS_NAME_SET.contains(name)) continue;
            if (NAME.equals(name)) {
                String childConfigName = child.getTextTrim();
                if (childConfigName.length() == 0) continue;
                if (this.configName != null && !this.configName.equals(childConfigName)) {
                    throw new IllegalArgumentException(MessageFormat.format("Conflicting <name> elements detected in faces-config.xml files: ''{0}'' & ''{1}''", this.configName, childConfigName));
                }
                if (this.configName != null) continue;
                this.configName = childConfigName;
                continue;
            }
            if (AGGREGATOR_ELEMENTS_NAME_SET.contains(name)) {
                List<Element> elementsList = this.aggregatorElements.get(name);
                if (elementsList == null) {
                    elementsList = new ArrayList<Element>();
                    this.aggregatorElements.put(name, elementsList);
                }
                List<Element> aggregatorChildren = this.checkedList(child.getChildren(), Element.class);
                elementsList.addAll(this.cloneAndImportElements(aggregatorChildren));
                continue;
            }
            if (RENDER_KIT.equals(name)) {
                List<Element> elementsList;
                String renderkitId = renderKitIdXPath.valueOf((Object)child);
                if (renderkitId == null) {
                    renderkitId = "";
                }
                if ((elementsList = this.renderkitElements.get(renderkitId)) == null) {
                    elementsList = new ArrayList<Element>();
                    this.renderkitElements.put(renderkitId, elementsList);
                }
                List<Element> renderkitChildren = this.checkedList(child.getContent(renderkitIdFilter), Element.class);
                elementsList.addAll(this.cloneAndImportElements(renderkitChildren));
                continue;
            }
            this.simpleElements.add(this.cloneAndImportElement(child));
        }
    }

    public boolean canTransformResource(String resource) {
        String name = this.getMetaInfResourceName(resource);
        if (name == null) {
            return false;
        }
        return name.equals(FACES_CONFIG_FILE_NAME) || name.endsWith(DOT_FACES_CONFIG_FILE_NAME);
    }

    public boolean hasTransformedResource() {
        return this.hasProcessedConfigFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyOutputStream(JarOutputStream os) throws IOException {
        try {
            Comparator<Element> comparator;
            try {
                comparator = this.createElementsComparator();
            }
            catch (JDOMException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Document document = new Document();
            Namespace javaEENamespace = this.getJavaEENamespace();
            Element rootElement = new Element(FACES_CONFIG, javaEENamespace);
            rootElement.setAttribute(VERSION, CURRENT_VERSION);
            if (this.metadataComplete != ThreeState.UNDEFINED) {
                rootElement.setAttribute(METADATA_COMPLETE, String.valueOf(this.metadataComplete == ThreeState.TRUE));
            }
            this.addSchemaLocation(rootElement, "http://java.sun.com/xml/ns/javaee/web-facesconfig_2_0.xsd");
            document.addContent((Content)rootElement);
            ArrayList<Element> rootElementChildren = new ArrayList<Element>();
            if (this.configName != null) {
                Element nameElement = new Element(NAME, javaEENamespace);
                nameElement.setText(this.configName);
                rootElementChildren.add(nameElement);
            }
            rootElementChildren.addAll(this.simpleElements);
            for (Map.Entry<String, List<Element>> entry : this.aggregatorElements.entrySet()) {
                String elementName = entry.getKey();
                List<Element> aggregatorElementChildren = entry.getValue();
                Element aggregatorElement = new Element(elementName, javaEENamespace);
                rootElementChildren.add(aggregatorElement);
                Collections.sort(aggregatorElementChildren, comparator);
                aggregatorElement.addContent(aggregatorElementChildren);
            }
            for (Map.Entry<String, List<Element>> entry : this.renderkitElements.entrySet()) {
                String renderkitId = entry.getKey();
                List<Element> renderkitElementChildren = entry.getValue();
                Element renderkitElement = new Element(RENDER_KIT, javaEENamespace);
                rootElementChildren.add(renderkitElement);
                if (renderkitId.length() != 0) {
                    Element renderkitIdElement = new Element(RENDER_KIT_ID, javaEENamespace);
                    renderkitIdElement.setText(renderkitId);
                    renderkitElementChildren.add(renderkitIdElement);
                }
                Collections.sort(renderkitElementChildren, comparator);
                renderkitElement.addContent(renderkitElementChildren);
            }
            Collections.sort(rootElementChildren, comparator);
            rootElement.addContent(rootElementChildren);
            this.appendToStream(FACES_CONFIG_FILE_PATH, document, os);
        }
        finally {
            this.resetTransformer();
        }
    }

    @Override
    protected void resetTransformer() {
        super.resetTransformer();
        this.hasProcessedConfigFiles = false;
        this.metadataComplete = ThreeState.UNDEFINED;
        this.simpleElements.clear();
        this.aggregatorElements.clear();
        this.renderkitElements.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ThreeState {
        UNDEFINED,
        FALSE,
        TRUE;

    }
}

