/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.build.shade.resource;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ElementsComparator
implements Comparator<Element> {
    private String namespaceUri;
    private List<String> orderedElementNames;
    private Map<String, XPath> comparisonPaths;

    public ElementsComparator(String namespaceUri, List<String> orderedElementNames, Map<String, XPath> comparisonPaths) {
        this.namespaceUri = namespaceUri;
        this.orderedElementNames = orderedElementNames;
        this.comparisonPaths = comparisonPaths;
    }

    private String maskNullString(String s) {
        return s != null ? s : "";
    }

    @Override
    public int compare(Element o1, Element o2) {
        int secondNameIdx;
        String secondName;
        if (!this.namespaceUri.equals(o1.getNamespaceURI()) || !this.namespaceUri.equals(o2.getNamespaceURI())) {
            return 0;
        }
        String firstName = o1.getName();
        if (firstName.equals(secondName = o2.getName())) {
            XPath comparisonPath = this.comparisonPaths.get(firstName);
            if (comparisonPath != null) {
                try {
                    String firstEltValue = this.maskNullString(comparisonPath.valueOf((Object)o1));
                    String secondEltValue = this.maskNullString(comparisonPath.valueOf((Object)o2));
                    return firstEltValue.compareToIgnoreCase(secondEltValue);
                }
                catch (JDOMException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return 0;
        }
        int firstNameIdx = this.orderedElementNames.indexOf(firstName);
        if (firstNameIdx < (secondNameIdx = this.orderedElementNames.indexOf(secondName))) {
            return -1;
        }
        if (firstNameIdx == secondNameIdx) {
            return 0;
        }
        return 1;
    }
}

