/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.encoder;

import java.io.Serializable;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.codec.CharCodecs;
import org.rcsb.mmtf.codec.FloatCodecs;
import org.rcsb.mmtf.codec.IntCodecs;
import org.rcsb.mmtf.codec.StringCodecs;
import org.rcsb.mmtf.dataholders.MmtfStructure;
import org.rcsb.mmtf.encoder.EncoderInterface;
import org.rcsb.mmtf.encoder.EncoderUtils;

public class GenericEncoder
implements EncoderInterface,
Serializable {
    private static final long serialVersionUID = 4128892132322015448L;
    private MmtfStructure mmtfBean;
    private int coordDivider = 1000;
    private int bfactorOccDivider = 100;

    public GenericEncoder(StructureDataInterface structureDataInterface) {
        this.encode(structureDataInterface);
    }

    public GenericEncoder(StructureDataInterface structureDataInterface, int precision) {
        this.coordDivider = precision;
        this.bfactorOccDivider = precision;
        this.encode(structureDataInterface);
    }

    private void encode(StructureDataInterface structureDataInterface) {
        this.mmtfBean = new MmtfStructure();
        this.mmtfBean.setxCoordList(EncoderUtils.encodeByteArr(FloatCodecs.INT_DELTA_RECURSIVE, structureDataInterface.getxCoords(), this.coordDivider));
        this.mmtfBean.setyCoordList(EncoderUtils.encodeByteArr(FloatCodecs.INT_DELTA_RECURSIVE, structureDataInterface.getyCoords(), this.coordDivider));
        this.mmtfBean.setzCoordList(EncoderUtils.encodeByteArr(FloatCodecs.INT_DELTA_RECURSIVE, structureDataInterface.getzCoords(), this.coordDivider));
        this.mmtfBean.setbFactorList(EncoderUtils.encodeByteArr(FloatCodecs.INT_DELTA_RECURSIVE, structureDataInterface.getbFactors(), this.bfactorOccDivider));
        this.mmtfBean.setOccupancyList(EncoderUtils.encodeByteArr(FloatCodecs.INT_RUNLENGTH, structureDataInterface.getOccupancies(), this.bfactorOccDivider));
        this.mmtfBean.setAtomIdList(EncoderUtils.encodeByteArr(IntCodecs.RUN_LENGTH_DELTA, structureDataInterface.getAtomIds(), 0));
        this.mmtfBean.setAltLocList(EncoderUtils.encodeByteArr(CharCodecs.RUN_LENGTH, structureDataInterface.getAltLocIds(), 0));
        this.mmtfBean.setInsCodeList(EncoderUtils.encodeByteArr(CharCodecs.RUN_LENGTH, structureDataInterface.getInsCodes(), 0));
        this.mmtfBean.setGroupIdList(EncoderUtils.encodeByteArr(IntCodecs.RUN_LENGTH_DELTA, structureDataInterface.getGroupIds(), 0));
        this.mmtfBean.setSequenceIndexList(EncoderUtils.encodeByteArr(IntCodecs.RUN_LENGTH_DELTA, structureDataInterface.getGroupSequenceIndices(), 0));
        this.mmtfBean.setChainNameList(EncoderUtils.encodeByteArr(StringCodecs.ENCOODE_CHAINS, structureDataInterface.getChainNames(), 4));
        this.mmtfBean.setChainIdList(EncoderUtils.encodeByteArr(StringCodecs.ENCOODE_CHAINS, structureDataInterface.getChainIds(), 4));
        this.mmtfBean.setBondAtomList(EncoderUtils.encodeByteArr(IntCodecs.CONVERT_4_BYTE, structureDataInterface.getInterGroupBondIndices(), 0));
        this.mmtfBean.setGroupTypeList(EncoderUtils.encodeByteArr(IntCodecs.CONVERT_4_BYTE, structureDataInterface.getGroupTypeIndices(), 0));
        this.mmtfBean.setSecStructList(EncoderUtils.encodeByteArr(IntCodecs.CONVERT_BYTE, structureDataInterface.getSecStructList(), 0));
        this.mmtfBean.setBondOrderList(EncoderUtils.encodeByteArr(IntCodecs.CONVERT_BYTE, structureDataInterface.getInterGroupBondOrders(), 0));
        this.mmtfBean.setGroupList(EncoderUtils.generateGroupList(structureDataInterface));
        this.mmtfBean.setBioAssemblyList(EncoderUtils.generateBioassemblies(structureDataInterface));
        this.mmtfBean.setEntityList(EncoderUtils.generateEntityList(structureDataInterface));
        this.mmtfBean.setChainsPerModel(structureDataInterface.getChainsPerModel());
        this.mmtfBean.setGroupsPerChain(structureDataInterface.getGroupsPerChain());
        this.mmtfBean.setSpaceGroup(structureDataInterface.getSpaceGroup());
        this.mmtfBean.setUnitCell(structureDataInterface.getUnitCell());
        this.mmtfBean.setMmtfProducer(structureDataInterface.getMmtfProducer());
        this.mmtfBean.setStructureId(structureDataInterface.getStructureId());
        this.mmtfBean.setNumAtoms(structureDataInterface.getNumAtoms());
        this.mmtfBean.setNumBonds(structureDataInterface.getNumBonds());
        this.mmtfBean.setNumChains(structureDataInterface.getNumChains());
        this.mmtfBean.setNumGroups(structureDataInterface.getNumGroups());
        this.mmtfBean.setNumModels(structureDataInterface.getNumModels());
        this.mmtfBean.setrFree(structureDataInterface.getRfree());
        this.mmtfBean.setrWork(structureDataInterface.getRwork());
        this.mmtfBean.setResolution(structureDataInterface.getResolution());
        this.mmtfBean.setTitle(structureDataInterface.getTitle());
        this.mmtfBean.setExperimentalMethods(structureDataInterface.getExperimentalMethods());
        this.mmtfBean.setDepositionDate(structureDataInterface.getDepositionDate());
        this.mmtfBean.setReleaseDate(structureDataInterface.getReleaseDate());
        this.mmtfBean.setNcsOperatorList(structureDataInterface.getNcsOperatorList());
    }

    @Override
    public MmtfStructure getMmtfEncodedStructure() {
        return this.mmtfBean;
    }
}

