/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.decoder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.rcsb.mmtf.api.StructureDataInterface;
import org.rcsb.mmtf.codec.CharCodecs;
import org.rcsb.mmtf.codec.FloatCodecs;
import org.rcsb.mmtf.codec.IntCodecs;
import org.rcsb.mmtf.codec.StringCodecs;
import org.rcsb.mmtf.dataholders.BioAssemblyData;
import org.rcsb.mmtf.dataholders.BioAssemblyTransformation;
import org.rcsb.mmtf.dataholders.Entity;
import org.rcsb.mmtf.dataholders.Group;
import org.rcsb.mmtf.dataholders.MmtfStructure;

public class GenericDecoder
implements StructureDataInterface,
Serializable {
    private static final long serialVersionUID = 1109812420718081496L;
    private float[] cartnX;
    private float[] cartnY;
    private float[] cartnZ;
    private float[] bFactor;
    private float[] occupancy;
    private int[] atomId;
    private char[] altId;
    private char[] insertionCodeList;
    private int[] groupNum;
    private Group[] groupMap;
    private int[] groupList;
    private int[] seqResGroupList;
    private String[] publicChainIds;
    private int[] chainsPerModel;
    private int[] groupsPerChain;
    private String spaceGroup;
    private float[] unitCell;
    private List<BioAssemblyData> bioAssembly;
    private int[] interGroupBondIndices;
    private int[] interGroupBondOrders;
    private String[] chainList;
    private String mmtfVersion;
    private String mmtfProducer;
    List<String> nucAcidList = new ArrayList<String>();
    private Entity[] entityList;
    private String pdbId;
    private Float resolution;
    private Float rFree;
    private Float rWork;
    private String title;
    private String[] experimentalMethods;
    private String depositionDate;
    private String releaseDate;
    private int[] secStructInfo;
    private int numModels;
    private int numChains;
    private int numGroups;
    private int numIntergroupBonds;
    private double[][] ncsOperMatrixList;

    public GenericDecoder(MmtfStructure inputData) {
        this.cartnX = FloatCodecs.decodeArr(inputData.getxCoordList());
        this.cartnY = FloatCodecs.decodeArr(inputData.getyCoordList());
        this.cartnZ = FloatCodecs.decodeArr(inputData.getzCoordList());
        this.bFactor = FloatCodecs.decodeArr(inputData.getbFactorList());
        this.occupancy = FloatCodecs.decodeArr(inputData.getOccupancyList());
        this.atomId = IntCodecs.decodeArr(inputData.getAtomIdList());
        this.altId = CharCodecs.decodeArr(inputData.getAltLocList());
        this.insertionCodeList = CharCodecs.decodeArr(inputData.getInsCodeList());
        this.groupNum = IntCodecs.decodeArr(inputData.getGroupIdList());
        this.groupMap = inputData.getGroupList();
        this.seqResGroupList = IntCodecs.decodeArr(inputData.getSequenceIndexList());
        this.groupList = IntCodecs.decodeArr(inputData.getGroupTypeList());
        this.publicChainIds = StringCodecs.decodeArr(inputData.getChainNameList());
        this.chainList = StringCodecs.decodeArr(inputData.getChainIdList());
        this.interGroupBondIndices = IntCodecs.decodeArr(inputData.getBondAtomList());
        this.interGroupBondOrders = IntCodecs.decodeArr(inputData.getBondOrderList());
        this.secStructInfo = IntCodecs.decodeArr(inputData.getSecStructList());
        this.chainsPerModel = inputData.getChainsPerModel();
        this.groupsPerChain = inputData.getGroupsPerChain();
        this.spaceGroup = inputData.getSpaceGroup();
        this.unitCell = inputData.getUnitCell();
        this.bioAssembly = inputData.getBioAssemblyList();
        this.mmtfVersion = inputData.getMmtfVersion();
        this.mmtfProducer = inputData.getMmtfProducer();
        this.entityList = inputData.getEntityList();
        this.pdbId = inputData.getStructureId();
        this.rFree = inputData.getrFree();
        this.rWork = inputData.getrWork();
        this.resolution = inputData.getResolution();
        this.title = inputData.getTitle();
        this.experimentalMethods = inputData.getExperimentalMethods();
        this.depositionDate = inputData.getDepositionDate();
        this.releaseDate = inputData.getReleaseDate();
        this.numGroups = inputData.getNumGroups();
        this.numChains = inputData.getNumChains();
        this.numModels = inputData.getNumModels();
        this.numIntergroupBonds = this.interGroupBondOrders.length;
        for (int groupIndex : this.groupList) {
            this.numIntergroupBonds += this.groupMap[groupIndex].getBondOrderList().length;
        }
        this.ncsOperMatrixList = inputData.getNcsOperatorList();
    }

    public float[] getxCoords() {
        return this.cartnX;
    }

    public float[] getyCoords() {
        return this.cartnY;
    }

    public float[] getzCoords() {
        return this.cartnZ;
    }

    public float[] getbFactors() {
        return this.bFactor;
    }

    public float[] getOccupancies() {
        return this.occupancy;
    }

    public int[] getAtomIds() {
        return this.atomId;
    }

    public char[] getAltLocIds() {
        return this.altId;
    }

    public char[] getInsCodes() {
        return this.insertionCodeList;
    }

    public int[] getGroupIds() {
        return this.groupNum;
    }

    public int[] getGroupTypeIndices() {
        return this.groupList;
    }

    public int[] getGroupSequenceIndices() {
        return this.seqResGroupList;
    }

    public String[] getChainNames() {
        return this.publicChainIds;
    }

    public int[] getChainsPerModel() {
        return this.chainsPerModel;
    }

    public int[] getGroupsPerChain() {
        return this.groupsPerChain;
    }

    public String getSpaceGroup() {
        return this.spaceGroup;
    }

    public float[] getUnitCell() {
        return this.unitCell;
    }

    public int[] getInterGroupBondIndices() {
        return this.interGroupBondIndices;
    }

    public int[] getInterGroupBondOrders() {
        return this.interGroupBondOrders;
    }

    public String[] getChainIds() {
        return this.chainList;
    }

    public String getMmtfVersion() {
        return this.mmtfVersion;
    }

    public String getMmtfProducer() {
        return this.mmtfProducer;
    }

    public String getStructureId() {
        return this.pdbId;
    }

    public int getNumGroups() {
        return this.numGroups;
    }

    public int getNumChains() {
        return this.numChains;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getNumAtoms() {
        return this.cartnX.length;
    }

    public float getRfree() {
        if (this.rFree == null || this.rFree.floatValue() == 0.0f) {
            return 1.0f;
        }
        return this.rFree.floatValue();
    }

    public float getResolution() {
        if (this.resolution == null || this.resolution.floatValue() == 0.0f) {
            return 99.0f;
        }
        return this.resolution.floatValue();
    }

    public float getRwork() {
        if (this.rWork == null || this.rWork.floatValue() == 0.0f) {
            return 1.0f;
        }
        return this.rWork.floatValue();
    }

    public String getTitle() {
        return this.title;
    }

    public String[] getExperimentalMethods() {
        return this.experimentalMethods;
    }

    public String getGroupName(int groupInd) {
        return this.groupMap[groupInd].getGroupName();
    }

    public int getNumAtomsInGroup(int groupInd) {
        return this.groupMap[groupInd].getFormalChargeList().length;
    }

    public String[] getGroupAtomNames(int groupInd) {
        return this.groupMap[groupInd].getAtomNameList();
    }

    public String[] getGroupElementNames(int groupInd) {
        return this.groupMap[groupInd].getElementList();
    }

    public int[] getGroupBondOrders(int groupInd) {
        return this.groupMap[groupInd].getBondOrderList();
    }

    public int[] getGroupBondIndices(int groupInd) {
        return this.groupMap[groupInd].getBondAtomList();
    }

    public int[] getGroupAtomCharges(int groupInd) {
        return this.groupMap[groupInd].getFormalChargeList();
    }

    public char getGroupSingleLetterCode(int groupInd) {
        return this.groupMap[groupInd].getSingleLetterCode();
    }

    public String getGroupChemCompType(int groupInd) {
        return this.groupMap[groupInd].getChemCompType();
    }

    public String getEntityDescription(int entityInd) {
        return this.entityList[entityInd].getDescription();
    }

    public String getEntityType(int entityInd) {
        return this.entityList[entityInd].getType();
    }

    public int[] getEntityChainIndexList(int entityInd) {
        return this.entityList[entityInd].getChainIndexList();
    }

    public String getEntitySequence(int entityInd) {
        return this.entityList[entityInd].getSequence();
    }

    public int getNumEntities() {
        return this.entityList.length;
    }

    public int getNumBioassemblies() {
        return this.bioAssembly.size();
    }

    public int getNumTransInBioassembly(int bioassemblyIndex) {
        return this.bioAssembly.get(bioassemblyIndex).getTransformList().size();
    }

    public int[] getChainIndexListForTransform(int bioassemblyIndex, int transformationIndex) {
        return ((BioAssemblyTransformation)this.bioAssembly.get(bioassemblyIndex).getTransformList().get(transformationIndex)).getChainIndexList();
    }

    public double[] getMatrixForTransform(int bioassemblyIndex, int transformationIndex) {
        return ((BioAssemblyTransformation)this.bioAssembly.get(bioassemblyIndex).getTransformList().get(transformationIndex)).getMatrix();
    }

    public String getDepositionDate() {
        return this.depositionDate;
    }

    public int getNumBonds() {
        return this.numIntergroupBonds;
    }

    public int[] getSecStructList() {
        return this.secStructInfo;
    }

    public String getReleaseDate() {
        return this.releaseDate;
    }

    public double[][] getNcsOperatorList() {
        return this.ncsOperMatrixList;
    }

    public String getBioassemblyName(int bioassemblyIndex) {
        return this.bioAssembly.get(bioassemblyIndex).getName();
    }
}

