/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import org.rcsb.mmtf.codec.ArrayConverters;
import org.rcsb.mmtf.codec.CodecInterface;
import org.rcsb.mmtf.codec.OptionParser;
import org.rcsb.mmtf.codec.StringCodecsInterface;

public enum StringCodecs implements StringCodecsInterface,
CodecInterface
{
    ENCOODE_CHAINS(5, "Encode chains"){

        @Override
        public byte[] encode(String[] inputData, int param) {
            return ArrayConverters.encodeChainList(inputData, param);
        }

        @Override
        public String[] decode(byte[] inputData, int param) {
            return ArrayConverters.decodeChainList(inputData, param);
        }
    };

    private final int codecId;
    private final String codecName;

    private StringCodecs(int inputId, String name) {
        this.codecId = inputId;
        this.codecName = name;
    }

    public static StringCodecs getCodec(int codecId) {
        for (StringCodecs codecs : StringCodecs.values()) {
            if (codecId != codecs.codecId) continue;
            return codecs;
        }
        throw new IllegalArgumentException(codecId + " not recognised as codec strategy.");
    }

    public static String[] decodeArr(byte[] inputData) {
        OptionParser optionParser = new OptionParser(inputData);
        StringCodecs codecs = StringCodecs.getCodec(optionParser.methodNumber);
        return codecs.decode(optionParser.data, optionParser.param);
    }

    @Override
    public String getCodecName() {
        return this.codecName;
    }

    @Override
    public int getCodecId() {
        return this.codecId;
    }
}

