/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.mmtf.codec;

import java.nio.ByteBuffer;

public class OptionParser {
    public byte[] data;
    public Integer methodNumber;
    public Integer outputLength;
    public Integer param;
    private static final int offset = 12;

    public OptionParser(byte[] inputData) {
        ByteBuffer buffer = ByteBuffer.wrap(inputData);
        this.methodNumber = buffer.getInt();
        this.outputLength = buffer.getInt();
        this.param = buffer.getInt();
        this.data = new byte[inputData.length - 12];
        buffer.get(this.data, 0, inputData.length - 12);
    }

    public OptionParser(Integer methodNumber, Integer outputLength, Integer param) {
        this.methodNumber = methodNumber;
        this.outputLength = outputLength;
        this.param = param;
    }

    public byte[] getHeader() {
        ByteBuffer buffer = ByteBuffer.allocate(12);
        if (this.methodNumber == null) {
            throw new NullPointerException("Method number cannot be null");
        }
        buffer.putInt(this.methodNumber);
        if (this.outputLength == null) {
            throw new NullPointerException("Outputlength cannot be null");
        }
        buffer.putInt(this.outputLength);
        if (this.param == null) {
            throw new NullPointerException("Param cannot be null");
        }
        buffer.putInt(this.param);
        return buffer.array();
    }
}

