/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.text;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.rcsb.cif.CifOptions;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.ValueKind;

public class TextCifWriter {
    private final CifOptions options;
    private static final List<String> PADDING_SPACES = IntStream.range(0, 80).mapToObj(TextCifWriter::whitespaceString).collect(Collectors.toList());

    public TextCifWriter(CifOptions options) {
        this.options = options;
    }

    public byte[] write(CifFile cifFile) {
        StringBuilder output = new StringBuilder();
        for (Block block : cifFile.getBlocks()) {
            String blockHeader = block.getBlockHeader();
            String header = blockHeader != null ? blockHeader.replaceAll("[ \n\t]", "").toUpperCase() : "UNKNOWN";
            output.append("data_").append(header).append("\n#\n");
            for (String categoryName : block.getCategoryNames()) {
                List<Column> columns;
                Category cifCategory;
                int rowCount;
                if (!this.options.filterCategory(categoryName) || (rowCount = (cifCategory = block.getCategory(categoryName)).getRowCount()) == 0 || (columns = cifCategory.getColumnNames().stream().filter(columnName -> this.options.filterColumn(categoryName, (String)columnName)).map(cifCategory::getColumn).collect(Collectors.toList())).isEmpty()) continue;
                if (rowCount == 1) {
                    this.writeCifSingleRecord(output, cifCategory, columns);
                    continue;
                }
                this.writeCifLoop(output, cifCategory, columns);
            }
        }
        output.append("\n");
        return output.toString().getBytes(StandardCharsets.UTF_8);
    }

    private void writeCifSingleRecord(StringBuilder output, Category cifCategory, List<Column> columns) {
        int width = columns.stream().map(Column::getColumnName).mapToInt(String::length).max().orElseThrow(() -> new NoSuchElementException("not able to determine column width")) + 6 + cifCategory.getCategoryName().length();
        for (Column cifField : columns) {
            this.writePadRight(output, "_" + cifCategory.getCategoryName() + "." + cifField.getColumnName(), width);
            for (int row = 0; row < cifField.getRowCount(); ++row) {
                boolean multiline = this.writeValue(output, cifField, row);
                if (multiline) continue;
                output.append("\n");
            }
        }
        output.append("#\n");
    }

    private void writeCifLoop(StringBuilder output, Category cifCategory, List<Column> columns) {
        output.append("loop_").append("\n");
        for (Column cifField : columns) {
            output.append("_").append(cifCategory.getCategoryName()).append(".").append(cifField.getColumnName()).append("\n");
        }
        for (int row = 0; row < columns.get(0).getRowCount(); ++row) {
            boolean multiline = false;
            for (Column cifField : columns) {
                multiline = this.writeValue(output, cifField, row);
            }
            if (multiline) continue;
            output.append("\n");
        }
        output.append("#\n");
    }

    private boolean writeValue(StringBuilder output, Column cifField, int row) {
        ValueKind kind = cifField.getValueKind(row);
        if (kind != ValueKind.PRESENT) {
            if (kind == ValueKind.NOT_PRESENT) {
                this.writeNotPresent(output);
            } else {
                this.writeUnknown(output);
            }
        } else if (cifField instanceof IntColumn) {
            this.writeInteger(output, ((IntColumn)cifField).get(row));
        } else if (cifField instanceof FloatColumn) {
            this.writeFloat(output, cifField.getStringData(row));
        } else {
            String val = cifField.getStringData(row);
            if (this.isMultiline(val)) {
                this.writeMultiline(output, val);
                return true;
            }
            return this.writeChecked(output, val);
        }
        return false;
    }

    private boolean writeChecked(StringBuilder output, String val) {
        if (val == null || val.isEmpty()) {
            output.append(". ");
            return false;
        }
        boolean escape = val.charAt(0) == '_';
        String escapeCharStart = "'";
        String escapeCharEnd = "' ";
        boolean hasWhitespace = false;
        boolean hasSingle = false;
        boolean hasDouble = false;
        block6: for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            switch (c) {
                case '\t': 
                case ' ': {
                    hasWhitespace = true;
                    continue block6;
                }
                case '\n': {
                    this.writeMultiline(output, val);
                    return true;
                }
                case '\"': {
                    if (hasSingle) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    hasDouble = true;
                    escape = true;
                    escapeCharStart = "'";
                    escapeCharEnd = "' ";
                    continue block6;
                }
                case '\'': {
                    if (hasDouble) {
                        this.writeMultiline(output, val);
                        return true;
                    }
                    escape = true;
                    hasSingle = true;
                    escapeCharStart = "\"";
                    escapeCharEnd = "\" ";
                }
            }
        }
        char fst = val.charAt(0);
        if (!escape && (fst == '#' || fst == '$' || fst == ';' || fst == '[' || fst == ']' || hasWhitespace)) {
            escapeCharStart = "'";
            escapeCharEnd = "' ";
            escape = true;
        }
        if (escape) {
            output.append(escapeCharStart).append(val).append(escapeCharEnd);
        } else {
            output.append(val).append(" ");
        }
        return false;
    }

    private void writeMultiline(StringBuilder output, String val) {
        output.append("\n;").append(val).append("\n;\n");
    }

    private boolean isMultiline(String val) {
        return val.contains("\n");
    }

    private void writeInteger(StringBuilder output, int val) {
        output.append(val);
        output.append(" ");
    }

    private void writeFloat(StringBuilder output, String val) {
        output.append(val).append(" ");
    }

    private void writeNotPresent(StringBuilder output) {
        output.append(". ");
    }

    private void writeUnknown(StringBuilder output) {
        output.append("? ");
    }

    private void writePadRight(StringBuilder output, String val, int width) {
        if (val == null || val.isEmpty()) {
            this.whitespace(output, width);
            return;
        }
        int padding = width - val.length();
        output.append(val);
        this.whitespace(output, padding);
    }

    private static String whitespaceString(int width) {
        return IntStream.range(0, width).mapToObj(i -> " ").collect(Collectors.joining());
    }

    private static String getPaddingSpaces(int width) {
        try {
            return PADDING_SPACES.get(width);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return TextCifWriter.whitespaceString(width);
        }
    }

    private void whitespace(StringBuilder output, int width) {
        if (width > 0) {
            output.append(TextCifWriter.getPaddingSpaces(width));
        }
    }
}

