/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.CategoryBuilder;
import org.rcsb.cif.model.builder.ColumnBuilder;

public class StrColumnBuilder<P extends CategoryBuilder>
extends ColumnBuilder<P> {
    private final List<String> values = new ArrayList<String>();

    public StrColumnBuilder(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    List<String> getValues() {
        return this.values;
    }

    @Override
    public StrColumnBuilder<P> markNextNotPresent() {
        this.values.add(".");
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public StrColumnBuilder<P> markNextUnknown() {
        this.values.add("?");
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public StrColumn build() {
        return (StrColumn)CategoryBuilder.createColumnText(this.getCategoryName(), this.getColumnName(), this.values, this.mask, StrColumn.class);
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        return this.parent.digest(this);
    }

    public StrColumnBuilder<P> add(String ... value) {
        for (String s : value) {
            if (".".equals(s)) {
                this.markNextNotPresent();
                continue;
            }
            if ("?".equals(s)) {
                this.markNextUnknown();
                continue;
            }
            this.values.add(s);
            this.mask.add(ValueKind.PRESENT);
        }
        return this;
    }
}

