/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.CategoryBuilder;
import org.rcsb.cif.model.builder.ColumnBuilder;

public class IntColumnBuilder<P extends CategoryBuilder>
extends ColumnBuilder<P> {
    private final List<Integer> values = new ArrayList<Integer>();

    public IntColumnBuilder(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    List<Integer> getValues() {
        return this.values;
    }

    @Override
    public IntColumnBuilder<P> markNextNotPresent() {
        this.values.add(0);
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public IntColumnBuilder<P> markNextUnknown() {
        this.values.add(0);
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public IntColumn build() {
        return (IntColumn)CategoryBuilder.createColumnText(this.getCategoryName(), this.getColumnName(), this.values, this.mask, IntColumn.class);
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        return this.parent.digest(this);
    }

    public IntColumnBuilder<P> add(int ... value) {
        IntStream.of(value).forEach(this.values::add);
        IntStream.range(0, value.length).mapToObj(i -> ValueKind.PRESENT).forEach(this.mask::add);
        return this;
    }
}

