/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.CategoryBuilder;
import org.rcsb.cif.model.builder.ColumnBuilder;

public class FloatColumnBuilder<P extends CategoryBuilder>
extends ColumnBuilder<P> {
    private final List<Double> values = new ArrayList<Double>();

    public FloatColumnBuilder(String categoryName, String columnName, P parent) {
        super(categoryName, columnName, parent);
    }

    List<Double> getValues() {
        return this.values;
    }

    @Override
    public FloatColumnBuilder<P> markNextNotPresent() {
        this.values.add(0.0);
        this.mask.add(ValueKind.NOT_PRESENT);
        return this;
    }

    @Override
    public FloatColumnBuilder<P> markNextUnknown() {
        this.values.add(0.0);
        this.mask.add(ValueKind.UNKNOWN);
        return this;
    }

    @Override
    public FloatColumn build() {
        return (FloatColumn)CategoryBuilder.createColumnText(this.getCategoryName(), this.getColumnName(), this.values, this.mask, FloatColumn.class);
    }

    @Override
    public P leaveColumn() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave column with undefined parent category");
        }
        return this.parent.digest(this);
    }

    public FloatColumnBuilder<P> add(double ... value) {
        DoubleStream.of(value).forEach(this.values::add);
        IntStream.range(0, value.length).mapToObj(i -> ValueKind.PRESENT).forEach(this.mask::add);
        return this;
    }
}

