/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.CategoryBuilder;

public abstract class ColumnBuilder<P extends CategoryBuilder> {
    private final String categoryName;
    private final String columnName;
    final List<ValueKind> mask;
    final P parent;

    ColumnBuilder(String categoryName, String columnName, P parent) {
        this.categoryName = categoryName;
        this.columnName = columnName;
        this.mask = new ArrayList<ValueKind>();
        this.parent = parent;
        if (parent != null) {
            ((CategoryBuilder)this.parent).registerChild(this);
        }
    }

    String getCategoryName() {
        return this.categoryName;
    }

    String getColumnName() {
        return this.columnName;
    }

    List<ValueKind> getMask() {
        return this.mask;
    }

    public abstract ColumnBuilder<P> markNextNotPresent();

    public abstract ColumnBuilder<P> markNextUnknown();

    public abstract Column build();

    public abstract P leaveColumn();
}

