/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.rcsb.cif.model.BaseBlock;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.TextFile;
import org.rcsb.cif.model.builder.BlockBuilder;

public class CifBuilder {
    private final CifFile cifFile;
    private final List<Block> blocks = new ArrayList<Block>();

    public CifBuilder() {
        this.cifFile = new TextFile(this.blocks);
    }

    public BlockBuilder enterBlock(String blockName) {
        return new BlockBuilder(blockName, this);
    }

    CifBuilder digest(BlockBuilder blockBuilder) {
        BaseBlock block = new BaseBlock(blockBuilder.getCategories(), blockBuilder.getBlockName());
        this.blocks.add(block);
        return this;
    }

    public CifFile leaveFile() {
        return this.build();
    }

    public CifFile build() {
        return this.cifFile;
    }

    public CifBuilder addBlock(Block block) {
        this.blocks.add(block);
        return this;
    }
}

