/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model.builder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.ModelFactory;
import org.rcsb.cif.model.StrColumn;
import org.rcsb.cif.model.ValueKind;
import org.rcsb.cif.model.builder.BlockBuilder;
import org.rcsb.cif.model.builder.ColumnBuilder;
import org.rcsb.cif.model.builder.FloatColumnBuilder;
import org.rcsb.cif.model.builder.IntColumnBuilder;
import org.rcsb.cif.model.builder.StrColumnBuilder;

public class CategoryBuilder {
    private final String categoryName;
    private final Map<String, Column> columns;
    private final BlockBuilder parent;
    private final List<ColumnBuilder<?>> pendingDigests;
    private final List<ColumnBuilder<?>> finishedDigests;

    public CategoryBuilder(String categoryName, BlockBuilder parent) {
        this.categoryName = categoryName;
        this.columns = new LinkedHashMap<String, Column>();
        this.parent = parent;
        this.pendingDigests = new ArrayList();
        this.finishedDigests = new ArrayList();
    }

    String getCategoryName() {
        return this.categoryName;
    }

    Map<String, Column> getColumns() {
        return this.columns;
    }

    public BlockBuilder leaveCategory() {
        if (this.parent == null) {
            throw new IllegalStateException("cannot leave category with undefined parent block");
        }
        this.pendingDigests.stream().filter(child -> !this.finishedDigests.contains(child)).forEach(child -> {
            if (child instanceof IntColumnBuilder) {
                this.digest((IntColumnBuilder)child);
            } else if (child instanceof FloatColumnBuilder) {
                this.digest((FloatColumnBuilder)child);
            } else {
                this.digest((StrColumnBuilder)child);
            }
        });
        return this.parent.digest(this);
    }

    public Category build() {
        return ModelFactory.createCategoryText(this.categoryName, this.columns);
    }

    public CategoryBuilder addColumn(Column column) {
        this.columns.put(column.getColumnName(), column);
        return this;
    }

    static Column createColumnText(String categoryName, String columnName, List<?> values, List<ValueKind> mask, Class<? extends Column> hint) {
        int length = values.size();
        int[] startToken = new int[length];
        int[] endToken = new int[length];
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            startToken[i] = builder.length();
            String value = String.valueOf(values.get(i));
            if (mask.get(i) == ValueKind.NOT_PRESENT) {
                value = ".";
            } else if (mask.get(i) == ValueKind.UNKNOWN) {
                value = "?";
            }
            builder.append(value);
            endToken[i] = builder.length();
        }
        return ModelFactory.createColumnText(categoryName, columnName, builder.toString(), startToken, endToken, hint);
    }

    <P extends CategoryBuilder> P digest(IntColumnBuilder<P> intColumnBuilder) {
        this.columns.put(intColumnBuilder.getColumnName(), CategoryBuilder.createColumnText(this.categoryName, intColumnBuilder.getColumnName(), intColumnBuilder.getValues(), intColumnBuilder.getMask(), IntColumn.class));
        this.finishedDigests.add(intColumnBuilder);
        return (P)this;
    }

    <P extends CategoryBuilder> P digest(FloatColumnBuilder<P> floatColumnBuilder) {
        this.columns.put(floatColumnBuilder.getColumnName(), CategoryBuilder.createColumnText(this.categoryName, floatColumnBuilder.getColumnName(), floatColumnBuilder.getValues(), floatColumnBuilder.getMask(), FloatColumn.class));
        this.finishedDigests.add(floatColumnBuilder);
        return (P)this;
    }

    <P extends CategoryBuilder> P digest(StrColumnBuilder<P> strColumnBuilder) {
        this.columns.put(strColumnBuilder.getColumnName(), CategoryBuilder.createColumnText(this.categoryName, strColumnBuilder.getColumnName(), strColumnBuilder.getValues(), strColumnBuilder.getMask(), StrColumn.class));
        this.finishedDigests.add(strColumnBuilder);
        return (P)this;
    }

    public IntColumnBuilder<CategoryBuilder> enterIntColumn(String columnName) {
        return new IntColumnBuilder<CategoryBuilder>(this.getCategoryName(), columnName, this);
    }

    public FloatColumnBuilder<CategoryBuilder> enterFloatColumn(String columnName) {
        return new FloatColumnBuilder<CategoryBuilder>(this.getCategoryName(), columnName, this);
    }

    public StrColumnBuilder<CategoryBuilder> enterStrColumn(String columnName) {
        return new StrColumnBuilder<CategoryBuilder>(this.getCategoryName(), columnName, this);
    }

    void registerChild(ColumnBuilder<?> childColumnBuilder) {
        this.pendingDigests.add(childColumnBuilder);
    }

    public static class IhmGeometricObjectDistanceRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_distance_restraint";

        public IhmGeometricObjectDistanceRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterId() {
            return new IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterObjectCharacteristic() {
            return new StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "object_characteristic", this);
        }

        public StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterRestraintType() {
            return new StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "restraint_type", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterHarmonicForceConstant() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "harmonic_force_constant", this);
        }

        public StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterGroupConditionality() {
            return new StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "group_conditionality", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDistanceLowerLimit() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "distance_lower_limit", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDistanceUpperLimit() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "distance_upper_limit", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDistanceLowerLimitEsd() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "distance_lower_limit_esd", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDistanceUpperLimitEsd() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "distance_upper_limit_esd", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDistanceProbability() {
            return new FloatColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "distance_probability", this);
        }

        public IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder> enterOtherDetails() {
            return new StrColumnBuilder<IhmGeometricObjectDistanceRestraintBuilder>(CATEGORY_NAME, "other_details", this);
        }
    }

    public static class IhmGeometricObjectPlaneBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_plane";

        public IhmGeometricObjectPlaneBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectPlaneBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectPlaneBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public StrColumnBuilder<IhmGeometricObjectPlaneBuilder> enterPlaneType() {
            return new StrColumnBuilder<IhmGeometricObjectPlaneBuilder>(CATEGORY_NAME, "plane_type", this);
        }

        public IntColumnBuilder<IhmGeometricObjectPlaneBuilder> enterTransformationId() {
            return new IntColumnBuilder<IhmGeometricObjectPlaneBuilder>(CATEGORY_NAME, "transformation_id", this);
        }
    }

    public static class IhmGeometricObjectAxisBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_axis";

        public IhmGeometricObjectAxisBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectAxisBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectAxisBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public StrColumnBuilder<IhmGeometricObjectAxisBuilder> enterAxisType() {
            return new StrColumnBuilder<IhmGeometricObjectAxisBuilder>(CATEGORY_NAME, "axis_type", this);
        }

        public IntColumnBuilder<IhmGeometricObjectAxisBuilder> enterTransformationId() {
            return new IntColumnBuilder<IhmGeometricObjectAxisBuilder>(CATEGORY_NAME, "transformation_id", this);
        }
    }

    public static class IhmGeometricObjectHalfTorusBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_half_torus";

        public IhmGeometricObjectHalfTorusBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectHalfTorusBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectHalfTorusBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectHalfTorusBuilder> enterThicknessTh() {
            return new FloatColumnBuilder<IhmGeometricObjectHalfTorusBuilder>(CATEGORY_NAME, "thickness_th", this);
        }

        public StrColumnBuilder<IhmGeometricObjectHalfTorusBuilder> enterSection() {
            return new StrColumnBuilder<IhmGeometricObjectHalfTorusBuilder>(CATEGORY_NAME, "section", this);
        }
    }

    public static class IhmGeometricObjectTorusBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_torus";

        public IhmGeometricObjectTorusBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectTorusBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectTorusBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectTorusBuilder> enterCenterId() {
            return new IntColumnBuilder<IhmGeometricObjectTorusBuilder>(CATEGORY_NAME, "center_id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectTorusBuilder> enterTransformationId() {
            return new IntColumnBuilder<IhmGeometricObjectTorusBuilder>(CATEGORY_NAME, "transformation_id", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTorusBuilder> enterMajorRadiusR() {
            return new FloatColumnBuilder<IhmGeometricObjectTorusBuilder>(CATEGORY_NAME, "major_radius_R", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTorusBuilder> enterMinorRadiusR() {
            return new FloatColumnBuilder<IhmGeometricObjectTorusBuilder>(CATEGORY_NAME, "minor_radius_r", this);
        }
    }

    public static class IhmGeometricObjectSphereBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_sphere";

        public IhmGeometricObjectSphereBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectSphereBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectSphereBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectSphereBuilder> enterCenterId() {
            return new IntColumnBuilder<IhmGeometricObjectSphereBuilder>(CATEGORY_NAME, "center_id", this);
        }

        public IntColumnBuilder<IhmGeometricObjectSphereBuilder> enterTransformationId() {
            return new IntColumnBuilder<IhmGeometricObjectSphereBuilder>(CATEGORY_NAME, "transformation_id", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectSphereBuilder> enterRadiusR() {
            return new FloatColumnBuilder<IhmGeometricObjectSphereBuilder>(CATEGORY_NAME, "radius_r", this);
        }
    }

    public static class IhmGeometricObjectTransformationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_transformation";

        public IhmGeometricObjectTransformationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectTransformationBuilder> enterId() {
            return new IntColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix11() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[1][1]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix21() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[2][1]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix31() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[3][1]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix12() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[1][2]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix22() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[2][2]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix32() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[3][2]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix13() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[1][3]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix23() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[2][3]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterRotMatrix33() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "rot_matrix[3][3]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterTrVector1() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "tr_vector[1]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterTrVector2() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "tr_vector[2]", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectTransformationBuilder> enterTrVector3() {
            return new FloatColumnBuilder<IhmGeometricObjectTransformationBuilder>(CATEGORY_NAME, "tr_vector[3]", this);
        }
    }

    public static class IhmGeometricObjectCenterBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_center";

        public IhmGeometricObjectCenterBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectCenterBuilder> enterId() {
            return new IntColumnBuilder<IhmGeometricObjectCenterBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectCenterBuilder> enterXcoord() {
            return new FloatColumnBuilder<IhmGeometricObjectCenterBuilder>(CATEGORY_NAME, "xcoord", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectCenterBuilder> enterYcoord() {
            return new FloatColumnBuilder<IhmGeometricObjectCenterBuilder>(CATEGORY_NAME, "ycoord", this);
        }

        public FloatColumnBuilder<IhmGeometricObjectCenterBuilder> enterZcoord() {
            return new FloatColumnBuilder<IhmGeometricObjectCenterBuilder>(CATEGORY_NAME, "zcoord", this);
        }
    }

    public static class IhmGeometricObjectListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_geometric_object_list";

        public IhmGeometricObjectListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGeometricObjectListBuilder> enterObjectId() {
            return new IntColumnBuilder<IhmGeometricObjectListBuilder>(CATEGORY_NAME, "object_id", this);
        }

        public StrColumnBuilder<IhmGeometricObjectListBuilder> enterObjectType() {
            return new StrColumnBuilder<IhmGeometricObjectListBuilder>(CATEGORY_NAME, "object_type", this);
        }

        public StrColumnBuilder<IhmGeometricObjectListBuilder> enterObjectName() {
            return new StrColumnBuilder<IhmGeometricObjectListBuilder>(CATEGORY_NAME, "object_name", this);
        }

        public StrColumnBuilder<IhmGeometricObjectListBuilder> enterObjectDescription() {
            return new StrColumnBuilder<IhmGeometricObjectListBuilder>(CATEGORY_NAME, "object_description", this);
        }

        public StrColumnBuilder<IhmGeometricObjectListBuilder> enterOtherDetails() {
            return new StrColumnBuilder<IhmGeometricObjectListBuilder>(CATEGORY_NAME, "other_details", this);
        }
    }

    public static class IhmDerivedDistanceRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_derived_distance_restraint";

        public IhmDerivedDistanceRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterId() {
            return new IntColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public IntColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterFeatureId1() {
            return new IntColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "feature_id_1", this);
        }

        public IntColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterFeatureId2() {
            return new IntColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "feature_id_2", this);
        }

        public StrColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterGroupConditionality() {
            return new StrColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "group_conditionality", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterRandomExclusionFraction() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "random_exclusion_fraction", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterDistanceLowerLimit() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "distance_lower_limit", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterDistanceUpperLimit() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "distance_upper_limit", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterDistanceLowerLimitEsd() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "distance_lower_limit_esd", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterDistanceUpperLimitEsd() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "distance_upper_limit_esd", this);
        }

        public FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterProbability() {
            return new FloatColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "probability", this);
        }

        public StrColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterRestraintType() {
            return new StrColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "restraint_type", this);
        }

        public IntColumnBuilder<IhmDerivedDistanceRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmDerivedDistanceRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }
    }

    public static class IhmInterfaceResidueFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_interface_residue_feature";

        public IhmInterfaceResidueFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterBindingPartnerEntityId() {
            return new StrColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "binding_partner_entity_id", this);
        }

        public StrColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterBindingPartnerAsymId() {
            return new StrColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "binding_partner_asym_id", this);
        }

        public IntColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public StrColumnBuilder<IhmInterfaceResidueFeatureBuilder> enterDetails() {
            return new StrColumnBuilder<IhmInterfaceResidueFeatureBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmNonPolyFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_non_poly_feature";

        public IhmNonPolyFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmNonPolyFeatureBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmNonPolyFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmNonPolyFeatureBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmNonPolyFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<IhmNonPolyFeatureBuilder> enterCompId() {
            return new StrColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<IhmNonPolyFeatureBuilder> enterAtomId() {
            return new StrColumnBuilder<IhmNonPolyFeatureBuilder>(CATEGORY_NAME, "atom_id", this);
        }
    }

    public static class IhmPolyResidueFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_poly_residue_feature";

        public IhmPolyResidueFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmPolyResidueFeatureBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmPolyResidueFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterCompIdBegin() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "comp_id_begin", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterCompIdEnd() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "comp_id_end", this);
        }

        public IntColumnBuilder<IhmPolyResidueFeatureBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmPolyResidueFeatureBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterResidueRangeGranularity() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "residue_range_granularity", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterRepAtom() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "rep_atom", this);
        }

        public StrColumnBuilder<IhmPolyResidueFeatureBuilder> enterInterfaceResidueFlag() {
            return new StrColumnBuilder<IhmPolyResidueFeatureBuilder>(CATEGORY_NAME, "interface_residue_flag", this);
        }
    }

    public static class IhmPolyAtomFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_poly_atom_feature";

        public IhmPolyAtomFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmPolyAtomFeatureBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmPolyAtomFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmPolyAtomFeatureBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmPolyAtomFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<IhmPolyAtomFeatureBuilder> enterCompId() {
            return new StrColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<IhmPolyAtomFeatureBuilder> enterSeqId() {
            return new IntColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<IhmPolyAtomFeatureBuilder> enterAtomId() {
            return new StrColumnBuilder<IhmPolyAtomFeatureBuilder>(CATEGORY_NAME, "atom_id", this);
        }
    }

    public static class IhmPseudoSiteFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_pseudo_site_feature";

        public IhmPseudoSiteFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmPseudoSiteFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public FloatColumnBuilder<IhmPseudoSiteFeatureBuilder> enterCartnX() {
            return new FloatColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<IhmPseudoSiteFeatureBuilder> enterCartnY() {
            return new FloatColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<IhmPseudoSiteFeatureBuilder> enterCartnZ() {
            return new FloatColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<IhmPseudoSiteFeatureBuilder> enterRadius() {
            return new FloatColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "radius", this);
        }

        public StrColumnBuilder<IhmPseudoSiteFeatureBuilder> enterDescription() {
            return new StrColumnBuilder<IhmPseudoSiteFeatureBuilder>(CATEGORY_NAME, "description", this);
        }
    }

    public static class IhmFeatureListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_feature_list";

        public IhmFeatureListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmFeatureListBuilder> enterFeatureId() {
            return new IntColumnBuilder<IhmFeatureListBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<IhmFeatureListBuilder> enterFeatureType() {
            return new StrColumnBuilder<IhmFeatureListBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<IhmFeatureListBuilder> enterEntityType() {
            return new StrColumnBuilder<IhmFeatureListBuilder>(CATEGORY_NAME, "entity_type", this);
        }
    }

    public static class IhmResiduesNotModeledBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_residues_not_modeled";

        public IhmResiduesNotModeledBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmResiduesNotModeledBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmResiduesNotModeledBuilder> enterModelId() {
            return new IntColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<IhmResiduesNotModeledBuilder> enterEntityDescription() {
            return new StrColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "entity_description", this);
        }

        public StrColumnBuilder<IhmResiduesNotModeledBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmResiduesNotModeledBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public IntColumnBuilder<IhmResiduesNotModeledBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmResiduesNotModeledBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmResiduesNotModeledBuilder> enterReason() {
            return new StrColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "reason", this);
        }

        public StrColumnBuilder<IhmResiduesNotModeledBuilder> enterDetails() {
            return new StrColumnBuilder<IhmResiduesNotModeledBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmGaussianObjEnsembleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_gaussian_obj_ensemble";

        public IhmGaussianObjEnsembleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGaussianObjEnsembleBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmGaussianObjEnsembleBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<IhmGaussianObjEnsembleBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmGaussianObjEnsembleBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmGaussianObjEnsembleBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterMeanCartnX() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "mean_Cartn_x", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterMeanCartnY() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "mean_Cartn_y", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterMeanCartnZ() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "mean_Cartn_z", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterWeight() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "weight", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix11() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[1][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix12() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[1][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix13() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[1][3]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix21() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[2][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix22() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[2][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix23() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[2][3]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix31() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[3][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix32() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[3][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjEnsembleBuilder> enterCovarianceMatrix33() {
            return new FloatColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "covariance_matrix[3][3]", this);
        }

        public IntColumnBuilder<IhmGaussianObjEnsembleBuilder> enterEnsembleId() {
            return new IntColumnBuilder<IhmGaussianObjEnsembleBuilder>(CATEGORY_NAME, "ensemble_id", this);
        }
    }

    public static class IhmGaussianObjSiteBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_gaussian_obj_site";

        public IhmGaussianObjSiteBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmGaussianObjSiteBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmGaussianObjSiteBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<IhmGaussianObjSiteBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmGaussianObjSiteBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmGaussianObjSiteBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterMeanCartnX() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "mean_Cartn_x", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterMeanCartnY() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "mean_Cartn_y", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterMeanCartnZ() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "mean_Cartn_z", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterWeight() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "weight", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix11() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[1][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix12() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[1][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix13() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[1][3]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix21() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[2][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix22() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[2][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix23() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[2][3]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix31() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[3][1]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix32() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[3][2]", this);
        }

        public FloatColumnBuilder<IhmGaussianObjSiteBuilder> enterCovarianceMatrix33() {
            return new FloatColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "covariance_matrix[3][3]", this);
        }

        public IntColumnBuilder<IhmGaussianObjSiteBuilder> enterModelId() {
            return new IntColumnBuilder<IhmGaussianObjSiteBuilder>(CATEGORY_NAME, "model_id", this);
        }
    }

    public static class IhmSphereObjSiteBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_sphere_obj_site";

        public IhmSphereObjSiteBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmSphereObjSiteBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmSphereObjSiteBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<IhmSphereObjSiteBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmSphereObjSiteBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmSphereObjSiteBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public FloatColumnBuilder<IhmSphereObjSiteBuilder> enterCartnX() {
            return new FloatColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<IhmSphereObjSiteBuilder> enterCartnY() {
            return new FloatColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<IhmSphereObjSiteBuilder> enterCartnZ() {
            return new FloatColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<IhmSphereObjSiteBuilder> enterObjectRadius() {
            return new FloatColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "object_radius", this);
        }

        public FloatColumnBuilder<IhmSphereObjSiteBuilder> enterRmsf() {
            return new FloatColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "rmsf", this);
        }

        public IntColumnBuilder<IhmSphereObjSiteBuilder> enterModelId() {
            return new IntColumnBuilder<IhmSphereObjSiteBuilder>(CATEGORY_NAME, "model_id", this);
        }
    }

    public static class IhmStartingModelCoordBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_starting_model_coord";

        public IhmStartingModelCoordBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStartingModelCoordBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterGroupPDB() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "group_PDB", this);
        }

        public IntColumnBuilder<IhmStartingModelCoordBuilder> enterId() {
            return new IntColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterTypeSymbol() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "type_symbol", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterAtomId() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterCompId() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<IhmStartingModelCoordBuilder> enterSeqId() {
            return new IntColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<IhmStartingModelCoordBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public FloatColumnBuilder<IhmStartingModelCoordBuilder> enterCartnX() {
            return new FloatColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<IhmStartingModelCoordBuilder> enterCartnY() {
            return new FloatColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<IhmStartingModelCoordBuilder> enterCartnZ() {
            return new FloatColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<IhmStartingModelCoordBuilder> enterBIsoOrEquiv() {
            return new FloatColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "B_iso_or_equiv", this);
        }

        public IntColumnBuilder<IhmStartingModelCoordBuilder> enterFormalCharge() {
            return new IntColumnBuilder<IhmStartingModelCoordBuilder>(CATEGORY_NAME, "formal_charge", this);
        }
    }

    public static class IhmSasRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_sas_restraint";

        public IhmSasRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmSasRestraintBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmSasRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<IhmSasRestraintBuilder> enterModelId() {
            return new IntColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public IntColumnBuilder<IhmSasRestraintBuilder> enterStructAssemblyId() {
            return new IntColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "struct_assembly_id", this);
        }

        public StrColumnBuilder<IhmSasRestraintBuilder> enterProfileSegmentFlag() {
            return new StrColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "profile_segment_flag", this);
        }

        public StrColumnBuilder<IhmSasRestraintBuilder> enterFittingAtomType() {
            return new StrColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "fitting_atom_type", this);
        }

        public StrColumnBuilder<IhmSasRestraintBuilder> enterFittingMethod() {
            return new StrColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "fitting_method", this);
        }

        public StrColumnBuilder<IhmSasRestraintBuilder> enterFittingState() {
            return new StrColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "fitting_state", this);
        }

        public FloatColumnBuilder<IhmSasRestraintBuilder> enterRadiusOfGyration() {
            return new FloatColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "radius_of_gyration", this);
        }

        public FloatColumnBuilder<IhmSasRestraintBuilder> enterChiValue() {
            return new FloatColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "chi_value", this);
        }

        public StrColumnBuilder<IhmSasRestraintBuilder> enterDetails() {
            return new StrColumnBuilder<IhmSasRestraintBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class Ihm3demRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_3dem_restraint";

        public Ihm3demRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<Ihm3demRestraintBuilder> enterOrdinalId() {
            return new IntColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<Ihm3demRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<Ihm3demRestraintBuilder> enterModelId() {
            return new IntColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public IntColumnBuilder<Ihm3demRestraintBuilder> enterStructAssemblyId() {
            return new IntColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "struct_assembly_id", this);
        }

        public StrColumnBuilder<Ihm3demRestraintBuilder> enterFittingMethod() {
            return new StrColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "fitting_method", this);
        }

        public IntColumnBuilder<Ihm3demRestraintBuilder> enterNumberOfGaussians() {
            return new IntColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "number_of_gaussians", this);
        }

        public StrColumnBuilder<Ihm3demRestraintBuilder> enterMapSegmentFlag() {
            return new StrColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "map_segment_flag", this);
        }

        public FloatColumnBuilder<Ihm3demRestraintBuilder> enterCrossCorrelationCoefficient() {
            return new FloatColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "cross_correlation_coefficient", this);
        }

        public StrColumnBuilder<Ihm3demRestraintBuilder> enterFittingMethodCitationId() {
            return new StrColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "fitting_method_citation_id", this);
        }

        public StrColumnBuilder<Ihm3demRestraintBuilder> enterDetails() {
            return new StrColumnBuilder<Ihm3demRestraintBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class Ihm2demClassAverageFittingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_2dem_class_average_fitting";

        public Ihm2demClassAverageFittingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<Ihm2demClassAverageFittingBuilder> enterOrdinalId() {
            return new IntColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRestraintId() {
            return new IntColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "restraint_id", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageFittingBuilder> enterModelId() {
            return new IntColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterCrossCorrelationCoefficient() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "cross_correlation_coefficient", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix11() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[1][1]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix21() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[2][1]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix31() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[3][1]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix12() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[1][2]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix22() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[2][2]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix32() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[3][2]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix13() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[1][3]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix23() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[2][3]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterRotMatrix33() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "rot_matrix[3][3]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterTrVector1() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "tr_vector[1]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterTrVector2() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "tr_vector[2]", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageFittingBuilder> enterTrVector3() {
            return new FloatColumnBuilder<Ihm2demClassAverageFittingBuilder>(CATEGORY_NAME, "tr_vector[3]", this);
        }
    }

    public static class Ihm2demClassAverageRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_2dem_class_average_restraint";

        public Ihm2demClassAverageRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterId() {
            return new IntColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterNumberRawMicrographs() {
            return new IntColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "number_raw_micrographs", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterPixelSizeWidth() {
            return new FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "pixel_size_width", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterPixelSizeHeight() {
            return new FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "pixel_size_height", this);
        }

        public FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterImageResolution() {
            return new FloatColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "image_resolution", this);
        }

        public StrColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterImageSegmentFlag() {
            return new StrColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "image_segment_flag", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterNumberOfProjections() {
            return new IntColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "number_of_projections", this);
        }

        public IntColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterStructAssemblyId() {
            return new IntColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "struct_assembly_id", this);
        }

        public StrColumnBuilder<Ihm2demClassAverageRestraintBuilder> enterDetails() {
            return new StrColumnBuilder<Ihm2demClassAverageRestraintBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmCrossLinkResultParametersBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_cross_link_result_parameters";

        public IhmCrossLinkResultParametersBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmCrossLinkResultParametersBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmCrossLinkResultParametersBuilder> enterRestraintId() {
            return new IntColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "restraint_id", this);
        }

        public IntColumnBuilder<IhmCrossLinkResultParametersBuilder> enterModelId() {
            return new IntColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public FloatColumnBuilder<IhmCrossLinkResultParametersBuilder> enterPsi() {
            return new FloatColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "psi", this);
        }

        public FloatColumnBuilder<IhmCrossLinkResultParametersBuilder> enterSigma1() {
            return new FloatColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "sigma_1", this);
        }

        public FloatColumnBuilder<IhmCrossLinkResultParametersBuilder> enterSigma2() {
            return new FloatColumnBuilder<IhmCrossLinkResultParametersBuilder>(CATEGORY_NAME, "sigma_2", this);
        }
    }

    public static class IhmCrossLinkResultBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_cross_link_result";

        public IhmCrossLinkResultBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmCrossLinkResultBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmCrossLinkResultBuilder> enterRestraintId() {
            return new IntColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "restraint_id", this);
        }

        public IntColumnBuilder<IhmCrossLinkResultBuilder> enterEnsembleId() {
            return new IntColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "ensemble_id", this);
        }

        public IntColumnBuilder<IhmCrossLinkResultBuilder> enterNumModels() {
            return new IntColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "num_models", this);
        }

        public FloatColumnBuilder<IhmCrossLinkResultBuilder> enterDistanceThreshold() {
            return new FloatColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "distance_threshold", this);
        }

        public FloatColumnBuilder<IhmCrossLinkResultBuilder> enterMedianDistance() {
            return new FloatColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "median_distance", this);
        }

        public StrColumnBuilder<IhmCrossLinkResultBuilder> enterDetails() {
            return new StrColumnBuilder<IhmCrossLinkResultBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmCrossLinkRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_cross_link_restraint";

        public IhmCrossLinkRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmCrossLinkRestraintBuilder> enterId() {
            return new IntColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmCrossLinkRestraintBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterEntityId1() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "entity_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterEntityId2() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "entity_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterAsymId1() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "asym_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterAsymId2() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "asym_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterCompId1() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterCompId2() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public IntColumnBuilder<IhmCrossLinkRestraintBuilder> enterSeqId1() {
            return new IntColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "seq_id_1", this);
        }

        public IntColumnBuilder<IhmCrossLinkRestraintBuilder> enterSeqId2() {
            return new IntColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "seq_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterAtomId1() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterAtomId2() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterRestraintType() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "restraint_type", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterConditionalCrosslinkFlag() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "conditional_crosslink_flag", this);
        }

        public StrColumnBuilder<IhmCrossLinkRestraintBuilder> enterModelGranularity() {
            return new StrColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "model_granularity", this);
        }

        public FloatColumnBuilder<IhmCrossLinkRestraintBuilder> enterDistanceThreshold() {
            return new FloatColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "distance_threshold", this);
        }

        public FloatColumnBuilder<IhmCrossLinkRestraintBuilder> enterPsi() {
            return new FloatColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "psi", this);
        }

        public FloatColumnBuilder<IhmCrossLinkRestraintBuilder> enterSigma1() {
            return new FloatColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "sigma_1", this);
        }

        public FloatColumnBuilder<IhmCrossLinkRestraintBuilder> enterSigma2() {
            return new FloatColumnBuilder<IhmCrossLinkRestraintBuilder>(CATEGORY_NAME, "sigma_2", this);
        }
    }

    public static class IhmCrossLinkListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_cross_link_list";

        public IhmCrossLinkListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmCrossLinkListBuilder> enterId() {
            return new IntColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmCrossLinkListBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterEntityDescription1() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "entity_description_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterEntityDescription2() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "entity_description_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterEntityId1() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "entity_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterEntityId2() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "entity_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterCompId1() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterCompId2() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public IntColumnBuilder<IhmCrossLinkListBuilder> enterSeqId1() {
            return new IntColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "seq_id_1", this);
        }

        public IntColumnBuilder<IhmCrossLinkListBuilder> enterSeqId2() {
            return new IntColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "seq_id_2", this);
        }

        public StrColumnBuilder<IhmCrossLinkListBuilder> enterLinkerType() {
            return new StrColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "linker_type", this);
        }

        public IntColumnBuilder<IhmCrossLinkListBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmCrossLinkListBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }
    }

    public static class IhmHydroxylRadicalFpRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_hydroxyl_radical_fp_restraint";

        public IhmHydroxylRadicalFpRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterId() {
            return new IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterEntityDescription() {
            return new StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "entity_description", this);
        }

        public StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterCompId() {
            return new StrColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterSeqId() {
            return new IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterFpRate() {
            return new FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "fp_rate", this);
        }

        public FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterFpRateError() {
            return new FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "fp_rate_error", this);
        }

        public FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterLogPf() {
            return new FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "log_pf", this);
        }

        public FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterLogPfError() {
            return new FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "log_pf_error", this);
        }

        public FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterPredictedSasa() {
            return new FloatColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "predicted_sasa", this);
        }

        public IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder> enterSoftwareId() {
            return new IntColumnBuilder<IhmHydroxylRadicalFpRestraintBuilder>(CATEGORY_NAME, "software_id", this);
        }
    }

    public static class IhmPredictedContactRestraintBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_predicted_contact_restraint";

        public IhmPredictedContactRestraintBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterId() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterEntityDescription1() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "entity_description_1", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterEntityDescription2() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "entity_description_2", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterEntityId1() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "entity_id_1", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterEntityId2() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "entity_id_2", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterAsymId1() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "asym_id_1", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterAsymId2() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "asym_id_2", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterCompId1() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterCompId2() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterSeqId1() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "seq_id_1", this);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterSeqId2() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "seq_id_2", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterAtomId1() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterAtomId2() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public FloatColumnBuilder<IhmPredictedContactRestraintBuilder> enterDistanceLowerLimit() {
            return new FloatColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "distance_lower_limit", this);
        }

        public FloatColumnBuilder<IhmPredictedContactRestraintBuilder> enterDistanceUpperLimit() {
            return new FloatColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "distance_upper_limit", this);
        }

        public FloatColumnBuilder<IhmPredictedContactRestraintBuilder> enterProbability() {
            return new FloatColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "probability", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterRestraintType() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "restraint_type", this);
        }

        public StrColumnBuilder<IhmPredictedContactRestraintBuilder> enterModelGranularity() {
            return new StrColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "model_granularity", this);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<IhmPredictedContactRestraintBuilder> enterSoftwareId() {
            return new IntColumnBuilder<IhmPredictedContactRestraintBuilder>(CATEGORY_NAME, "software_id", this);
        }
    }

    public static class IhmLocalizationDensityFilesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_localization_density_files";

        public IhmLocalizationDensityFilesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmLocalizationDensityFilesBuilder> enterId() {
            return new IntColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmLocalizationDensityFilesBuilder> enterFileId() {
            return new IntColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "file_id", this);
        }

        public IntColumnBuilder<IhmLocalizationDensityFilesBuilder> enterEnsembleId() {
            return new IntColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "ensemble_id", this);
        }

        public StrColumnBuilder<IhmLocalizationDensityFilesBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<IhmLocalizationDensityFilesBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmLocalizationDensityFilesBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmLocalizationDensityFilesBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmLocalizationDensityFilesBuilder>(CATEGORY_NAME, "asym_id", this);
        }
    }

    public static class IhmDatasetExternalReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_dataset_external_reference";

        public IhmDatasetExternalReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmDatasetExternalReferenceBuilder> enterId() {
            return new IntColumnBuilder<IhmDatasetExternalReferenceBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmDatasetExternalReferenceBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmDatasetExternalReferenceBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public IntColumnBuilder<IhmDatasetExternalReferenceBuilder> enterFileId() {
            return new IntColumnBuilder<IhmDatasetExternalReferenceBuilder>(CATEGORY_NAME, "file_id", this);
        }
    }

    public static class IhmExternalFilesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_external_files";

        public IhmExternalFilesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmExternalFilesBuilder> enterId() {
            return new IntColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmExternalFilesBuilder> enterReferenceId() {
            return new IntColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "reference_id", this);
        }

        public StrColumnBuilder<IhmExternalFilesBuilder> enterFilePath() {
            return new StrColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "file_path", this);
        }

        public StrColumnBuilder<IhmExternalFilesBuilder> enterFileFormat() {
            return new StrColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "file_format", this);
        }

        public StrColumnBuilder<IhmExternalFilesBuilder> enterContentType() {
            return new StrColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "content_type", this);
        }

        public FloatColumnBuilder<IhmExternalFilesBuilder> enterFileSizeBytes() {
            return new FloatColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "file_size_bytes", this);
        }

        public StrColumnBuilder<IhmExternalFilesBuilder> enterDetails() {
            return new StrColumnBuilder<IhmExternalFilesBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmExternalReferenceInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_external_reference_info";

        public IhmExternalReferenceInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmExternalReferenceInfoBuilder> enterReferenceId() {
            return new IntColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "reference_id", this);
        }

        public StrColumnBuilder<IhmExternalReferenceInfoBuilder> enterReferenceProvider() {
            return new StrColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "reference_provider", this);
        }

        public StrColumnBuilder<IhmExternalReferenceInfoBuilder> enterReferenceType() {
            return new StrColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "reference_type", this);
        }

        public StrColumnBuilder<IhmExternalReferenceInfoBuilder> enterReference() {
            return new StrColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "reference", this);
        }

        public StrColumnBuilder<IhmExternalReferenceInfoBuilder> enterRefersTo() {
            return new StrColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "refers_to", this);
        }

        public StrColumnBuilder<IhmExternalReferenceInfoBuilder> enterAssociatedUrl() {
            return new StrColumnBuilder<IhmExternalReferenceInfoBuilder>(CATEGORY_NAME, "associated_url", this);
        }
    }

    public static class IhmDatasetRelatedDbReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_dataset_related_db_reference";

        public IhmDatasetRelatedDbReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterId() {
            return new IntColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterDbName() {
            return new StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterAccessionCode() {
            return new StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "accession_code", this);
        }

        public StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterVersion() {
            return new StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "version", this);
        }

        public StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder> enterDetails() {
            return new StrColumnBuilder<IhmDatasetRelatedDbReferenceBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmRelatedDatasetsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_related_datasets";

        public IhmRelatedDatasetsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmRelatedDatasetsBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmRelatedDatasetsBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmRelatedDatasetsBuilder> enterDatasetListIdDerived() {
            return new IntColumnBuilder<IhmRelatedDatasetsBuilder>(CATEGORY_NAME, "dataset_list_id_derived", this);
        }

        public IntColumnBuilder<IhmRelatedDatasetsBuilder> enterDatasetListIdPrimary() {
            return new IntColumnBuilder<IhmRelatedDatasetsBuilder>(CATEGORY_NAME, "dataset_list_id_primary", this);
        }
    }

    public static class IhmDatasetGroupBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_dataset_group";

        public IhmDatasetGroupBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmDatasetGroupBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmDatasetGroupBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmDatasetGroupBuilder> enterGroupId() {
            return new IntColumnBuilder<IhmDatasetGroupBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public IntColumnBuilder<IhmDatasetGroupBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmDatasetGroupBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }

        public StrColumnBuilder<IhmDatasetGroupBuilder> enterApplication() {
            return new StrColumnBuilder<IhmDatasetGroupBuilder>(CATEGORY_NAME, "application", this);
        }

        public StrColumnBuilder<IhmDatasetGroupBuilder> enterDetails() {
            return new StrColumnBuilder<IhmDatasetGroupBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmDatasetListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_dataset_list";

        public IhmDatasetListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmDatasetListBuilder> enterId() {
            return new IntColumnBuilder<IhmDatasetListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<IhmDatasetListBuilder> enterDataType() {
            return new StrColumnBuilder<IhmDatasetListBuilder>(CATEGORY_NAME, "data_type", this);
        }

        public StrColumnBuilder<IhmDatasetListBuilder> enterDetails() {
            return new StrColumnBuilder<IhmDatasetListBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<IhmDatasetListBuilder> enterDatabaseHosted() {
            return new StrColumnBuilder<IhmDatasetListBuilder>(CATEGORY_NAME, "database_hosted", this);
        }
    }

    public static class IhmModelRepresentativeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_model_representative";

        public IhmModelRepresentativeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmModelRepresentativeBuilder> enterId() {
            return new IntColumnBuilder<IhmModelRepresentativeBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmModelRepresentativeBuilder> enterModelGroupId() {
            return new IntColumnBuilder<IhmModelRepresentativeBuilder>(CATEGORY_NAME, "model_group_id", this);
        }

        public IntColumnBuilder<IhmModelRepresentativeBuilder> enterModelId() {
            return new IntColumnBuilder<IhmModelRepresentativeBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<IhmModelRepresentativeBuilder> enterSelectionCriteria() {
            return new StrColumnBuilder<IhmModelRepresentativeBuilder>(CATEGORY_NAME, "selection_criteria", this);
        }
    }

    public static class IhmModelListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_model_list";

        public IhmModelListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterModelId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterModelGroupId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "model_group_id", this);
        }

        public StrColumnBuilder<IhmModelListBuilder> enterModelName() {
            return new StrColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "model_name", this);
        }

        public StrColumnBuilder<IhmModelListBuilder> enterModelGroupName() {
            return new StrColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "model_group_name", this);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterAssemblyId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterProtocolId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "protocol_id", this);
        }

        public IntColumnBuilder<IhmModelListBuilder> enterRepresentationId() {
            return new IntColumnBuilder<IhmModelListBuilder>(CATEGORY_NAME, "representation_id", this);
        }
    }

    public static class IhmEnsembleInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_ensemble_info";

        public IhmEnsembleInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterEnsembleId() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_id", this);
        }

        public StrColumnBuilder<IhmEnsembleInfoBuilder> enterEnsembleName() {
            return new StrColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_name", this);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterPostProcessId() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "post_process_id", this);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterModelGroupId() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "model_group_id", this);
        }

        public StrColumnBuilder<IhmEnsembleInfoBuilder> enterEnsembleClusteringMethod() {
            return new StrColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_clustering_method", this);
        }

        public StrColumnBuilder<IhmEnsembleInfoBuilder> enterEnsembleClusteringFeature() {
            return new StrColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_clustering_feature", this);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterNumEnsembleModels() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "num_ensemble_models", this);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterNumEnsembleModelsDeposited() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "num_ensemble_models_deposited", this);
        }

        public FloatColumnBuilder<IhmEnsembleInfoBuilder> enterEnsemblePrecisionValue() {
            return new FloatColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_precision_value", this);
        }

        public IntColumnBuilder<IhmEnsembleInfoBuilder> enterEnsembleFileId() {
            return new IntColumnBuilder<IhmEnsembleInfoBuilder>(CATEGORY_NAME, "ensemble_file_id", this);
        }
    }

    public static class IhmModelingPostProcessBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_modeling_post_process";

        public IhmModelingPostProcessBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterProtocolId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "protocol_id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterAnalysisId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "analysis_id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterStepId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterStructAssemblyId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "struct_assembly_id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterDatasetGroupId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "dataset_group_id", this);
        }

        public StrColumnBuilder<IhmModelingPostProcessBuilder> enterType() {
            return new StrColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<IhmModelingPostProcessBuilder> enterFeature() {
            return new StrColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<IhmModelingPostProcessBuilder> enterFeatureName() {
            return new StrColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterNumModelsBegin() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "num_models_begin", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterNumModelsEnd() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "num_models_end", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterScriptFileId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "script_file_id", this);
        }

        public IntColumnBuilder<IhmModelingPostProcessBuilder> enterSoftwareId() {
            return new IntColumnBuilder<IhmModelingPostProcessBuilder>(CATEGORY_NAME, "software_id", this);
        }
    }

    public static class IhmOrderedEnsembleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_ordered_ensemble";

        public IhmOrderedEnsembleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmOrderedEnsembleBuilder> enterProcessId() {
            return new IntColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "process_id", this);
        }

        public StrColumnBuilder<IhmOrderedEnsembleBuilder> enterProcessDescription() {
            return new StrColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "process_description", this);
        }

        public IntColumnBuilder<IhmOrderedEnsembleBuilder> enterEdgeId() {
            return new IntColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "edge_id", this);
        }

        public StrColumnBuilder<IhmOrderedEnsembleBuilder> enterEdgeDescription() {
            return new StrColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "edge_description", this);
        }

        public IntColumnBuilder<IhmOrderedEnsembleBuilder> enterStepId() {
            return new IntColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<IhmOrderedEnsembleBuilder> enterStepDescription() {
            return new StrColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "step_description", this);
        }

        public StrColumnBuilder<IhmOrderedEnsembleBuilder> enterOrderedBy() {
            return new StrColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "ordered_by", this);
        }

        public IntColumnBuilder<IhmOrderedEnsembleBuilder> enterModelGroupIdBegin() {
            return new IntColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "model_group_id_begin", this);
        }

        public IntColumnBuilder<IhmOrderedEnsembleBuilder> enterModelGroupIdEnd() {
            return new IntColumnBuilder<IhmOrderedEnsembleBuilder>(CATEGORY_NAME, "model_group_id_end", this);
        }
    }

    public static class IhmMultiStateModelingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_multi_state_modeling";

        public IhmMultiStateModelingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmMultiStateModelingBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmMultiStateModelingBuilder> enterStateId() {
            return new IntColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "state_id", this);
        }

        public IntColumnBuilder<IhmMultiStateModelingBuilder> enterStateGroupId() {
            return new IntColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "state_group_id", this);
        }

        public FloatColumnBuilder<IhmMultiStateModelingBuilder> enterPopulationFraction() {
            return new FloatColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "population_fraction", this);
        }

        public FloatColumnBuilder<IhmMultiStateModelingBuilder> enterPopulationFractionSd() {
            return new FloatColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "population_fraction_sd", this);
        }

        public StrColumnBuilder<IhmMultiStateModelingBuilder> enterStateType() {
            return new StrColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "state_type", this);
        }

        public StrColumnBuilder<IhmMultiStateModelingBuilder> enterStateName() {
            return new StrColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "state_name", this);
        }

        public IntColumnBuilder<IhmMultiStateModelingBuilder> enterModelGroupId() {
            return new IntColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "model_group_id", this);
        }

        public StrColumnBuilder<IhmMultiStateModelingBuilder> enterExperimentType() {
            return new StrColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "experiment_type", this);
        }

        public StrColumnBuilder<IhmMultiStateModelingBuilder> enterDetails() {
            return new StrColumnBuilder<IhmMultiStateModelingBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmModelingProtocolBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_modeling_protocol";

        public IhmModelingProtocolBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterProtocolId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "protocol_id", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterStepId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterStructAssemblyId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "struct_assembly_id", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterDatasetGroupId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "dataset_group_id", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterStructAssemblyDescription() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "struct_assembly_description", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterProtocolName() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "protocol_name", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterStepName() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "step_name", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterStepMethod() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "step_method", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterNumModelsBegin() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "num_models_begin", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterNumModelsEnd() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "num_models_end", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterMultiScaleFlag() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "multi_scale_flag", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterMultiStateFlag() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "multi_state_flag", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterOrderedFlag() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "ordered_flag", this);
        }

        public StrColumnBuilder<IhmModelingProtocolBuilder> enterEnsembleFlag() {
            return new StrColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "ensemble_flag", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterScriptFileId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "script_file_id", this);
        }

        public IntColumnBuilder<IhmModelingProtocolBuilder> enterSoftwareId() {
            return new IntColumnBuilder<IhmModelingProtocolBuilder>(CATEGORY_NAME, "software_id", this);
        }
    }

    public static class IhmStructAssemblyClassBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_struct_assembly_class";

        public IhmStructAssemblyClassBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStructAssemblyClassBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmStructAssemblyClassBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmStructAssemblyClassBuilder> enterClassId() {
            return new IntColumnBuilder<IhmStructAssemblyClassBuilder>(CATEGORY_NAME, "class_id", this);
        }

        public IntColumnBuilder<IhmStructAssemblyClassBuilder> enterAssemblyId() {
            return new IntColumnBuilder<IhmStructAssemblyClassBuilder>(CATEGORY_NAME, "assembly_id", this);
        }
    }

    public static class IhmStructAssemblyClassListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_struct_assembly_class_list";

        public IhmStructAssemblyClassListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStructAssemblyClassListBuilder> enterClassId() {
            return new IntColumnBuilder<IhmStructAssemblyClassListBuilder>(CATEGORY_NAME, "class_id", this);
        }

        public StrColumnBuilder<IhmStructAssemblyClassListBuilder> enterName() {
            return new StrColumnBuilder<IhmStructAssemblyClassListBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<IhmStructAssemblyClassListBuilder> enterType() {
            return new StrColumnBuilder<IhmStructAssemblyClassListBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<IhmStructAssemblyClassListBuilder> enterDescription() {
            return new StrColumnBuilder<IhmStructAssemblyClassListBuilder>(CATEGORY_NAME, "description", this);
        }
    }

    public static class IhmStructAssemblyDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_struct_assembly_details";

        public IhmStructAssemblyDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStructAssemblyDetailsBuilder> enterAssemblyId() {
            return new IntColumnBuilder<IhmStructAssemblyDetailsBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<IhmStructAssemblyDetailsBuilder> enterAssemblyName() {
            return new StrColumnBuilder<IhmStructAssemblyDetailsBuilder>(CATEGORY_NAME, "assembly_name", this);
        }

        public StrColumnBuilder<IhmStructAssemblyDetailsBuilder> enterAssemblyDescription() {
            return new StrColumnBuilder<IhmStructAssemblyDetailsBuilder>(CATEGORY_NAME, "assembly_description", this);
        }
    }

    public static class IhmStructAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_struct_assembly";

        public IhmStructAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStructAssemblyBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmStructAssemblyBuilder> enterAssemblyId() {
            return new IntColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public IntColumnBuilder<IhmStructAssemblyBuilder> enterParentAssemblyId() {
            return new IntColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "parent_assembly_id", this);
        }

        public StrColumnBuilder<IhmStructAssemblyBuilder> enterEntityDescription() {
            return new StrColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "entity_description", this);
        }

        public StrColumnBuilder<IhmStructAssemblyBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmStructAssemblyBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public IntColumnBuilder<IhmStructAssemblyBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmStructAssemblyBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmStructAssemblyBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }
    }

    public static class IhmModelRepresentationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_model_representation";

        public IhmModelRepresentationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterRepresentationId() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "representation_id", this);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterSegmentId() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "segment_id", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterEntityDescription() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "entity_description", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterEntityAsymId() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "entity_asym_id", this);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterModelObjectPrimitive() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "model_object_primitive", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterModelMode() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "model_mode", this);
        }

        public StrColumnBuilder<IhmModelRepresentationBuilder> enterModelGranularity() {
            return new StrColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "model_granularity", this);
        }

        public IntColumnBuilder<IhmModelRepresentationBuilder> enterModelObjectCount() {
            return new IntColumnBuilder<IhmModelRepresentationBuilder>(CATEGORY_NAME, "model_object_count", this);
        }
    }

    public static class IhmStartingModelSeqDifBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_starting_model_seq_dif";

        public IhmStartingModelSeqDifBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStartingModelSeqDifBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public IntColumnBuilder<IhmStartingModelSeqDifBuilder> enterSeqId() {
            return new IntColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterCompId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterDbEntityId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "db_entity_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterDbAsymId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "db_asym_id", this);
        }

        public IntColumnBuilder<IhmStartingModelSeqDifBuilder> enterDbSeqId() {
            return new IntColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "db_seq_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterDbCompId() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "db_comp_id", this);
        }

        public StrColumnBuilder<IhmStartingModelSeqDifBuilder> enterDetails() {
            return new StrColumnBuilder<IhmStartingModelSeqDifBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class IhmStartingComputationalModelsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_starting_computational_models";

        public IhmStartingComputationalModelsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<IhmStartingComputationalModelsBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmStartingComputationalModelsBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public IntColumnBuilder<IhmStartingComputationalModelsBuilder> enterScriptFileId() {
            return new IntColumnBuilder<IhmStartingComputationalModelsBuilder>(CATEGORY_NAME, "script_file_id", this);
        }

        public IntColumnBuilder<IhmStartingComputationalModelsBuilder> enterSoftwareId() {
            return new IntColumnBuilder<IhmStartingComputationalModelsBuilder>(CATEGORY_NAME, "software_id", this);
        }
    }

    public static class IhmStartingComparativeModelsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_starting_comparative_models";

        public IhmStartingComparativeModelsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterOrdinalId() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<IhmStartingComparativeModelsBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public StrColumnBuilder<IhmStartingComparativeModelsBuilder> enterStartingModelAuthAsymId() {
            return new StrColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "starting_model_auth_asym_id", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterStartingModelSeqIdBegin() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "starting_model_seq_id_begin", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterStartingModelSeqIdEnd() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "starting_model_seq_id_end", this);
        }

        public StrColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateAuthAsymId() {
            return new StrColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_auth_asym_id", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateSeqIdBegin() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_seq_id_begin", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateSeqIdEnd() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_seq_id_end", this);
        }

        public FloatColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateSequenceIdentity() {
            return new FloatColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_sequence_identity", this);
        }

        public StrColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateSequenceIdentityDenominator() {
            return new StrColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_sequence_identity_denominator", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterTemplateDatasetListId() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "template_dataset_list_id", this);
        }

        public IntColumnBuilder<IhmStartingComparativeModelsBuilder> enterAlignmentFileId() {
            return new IntColumnBuilder<IhmStartingComparativeModelsBuilder>(CATEGORY_NAME, "alignment_file_id", this);
        }
    }

    public static class IhmStartingModelDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ihm_starting_model_details";

        public IhmStartingModelDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterStartingModelId() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "starting_model_id", this);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterEntityId() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterEntityDescription() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "entity_description", this);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterAsymId() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public IntColumnBuilder<IhmStartingModelDetailsBuilder> enterSeqIdBegin() {
            return new IntColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "seq_id_begin", this);
        }

        public IntColumnBuilder<IhmStartingModelDetailsBuilder> enterSeqIdEnd() {
            return new IntColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "seq_id_end", this);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterStartingModelSource() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "starting_model_source", this);
        }

        public StrColumnBuilder<IhmStartingModelDetailsBuilder> enterStartingModelAuthAsymId() {
            return new StrColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "starting_model_auth_asym_id", this);
        }

        public IntColumnBuilder<IhmStartingModelDetailsBuilder> enterStartingModelSequenceOffset() {
            return new IntColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "starting_model_sequence_offset", this);
        }

        public IntColumnBuilder<IhmStartingModelDetailsBuilder> enterDatasetListId() {
            return new IntColumnBuilder<IhmStartingModelDetailsBuilder>(CATEGORY_NAME, "dataset_list_id", this);
        }
    }

    public static class PdbxBranchSchemeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_branch_scheme";

        public PdbxBranchSchemeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterHetero() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "hetero", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterMonId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "mon_id", this);
        }

        public IntColumnBuilder<PdbxBranchSchemeBuilder> enterNum() {
            return new IntColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "num", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterPdbAsymId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "pdb_asym_id", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterPdbSeqNum() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "pdb_seq_num", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterPdbMonId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "pdb_mon_id", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterAuthSeqNum() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public StrColumnBuilder<PdbxBranchSchemeBuilder> enterAuthMonId() {
            return new StrColumnBuilder<PdbxBranchSchemeBuilder>(CATEGORY_NAME, "auth_mon_id", this);
        }
    }

    public static class PdbxEntityBranchBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_branch";

        public PdbxEntityBranchBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityBranchBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityBranchBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityBranchBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityBranchBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxEntityBranchLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_branch_link";

        public PdbxEntityBranchLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxEntityBranchLinkBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntityBranchLinkBuilder> enterEntityBranchListNum1() {
            return new IntColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "entity_branch_list_num_1", this);
        }

        public IntColumnBuilder<PdbxEntityBranchLinkBuilder> enterEntityBranchListNum2() {
            return new IntColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "entity_branch_list_num_2", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterLeavingAtomId1() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "leaving_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterAtomStereoConfig1() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "atom_stereo_config_1", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterLeavingAtomId2() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "leaving_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterAtomStereoConfig2() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "atom_stereo_config_2", this);
        }

        public StrColumnBuilder<PdbxEntityBranchLinkBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxEntityBranchLinkBuilder>(CATEGORY_NAME, "value_order", this);
        }
    }

    public static class PdbxEntityBranchListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_branch_list";

        public PdbxEntityBranchListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityBranchListBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityBranchListBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityBranchListBuilder> enterHetero() {
            return new StrColumnBuilder<PdbxEntityBranchListBuilder>(CATEGORY_NAME, "hetero", this);
        }

        public StrColumnBuilder<PdbxEntityBranchListBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxEntityBranchListBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<PdbxEntityBranchListBuilder> enterNum() {
            return new IntColumnBuilder<PdbxEntityBranchListBuilder>(CATEGORY_NAME, "num", this);
        }
    }

    public static class PdbxChemCompAtomRelatedBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_atom_related";

        public PdbxChemCompAtomRelatedBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterRelatedCompId() {
            return new StrColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "related_comp_id", this);
        }

        public IntColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterAtomId() {
            return new StrColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterRelatedAtomId() {
            return new StrColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "related_atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomRelatedBuilder> enterRelatedType() {
            return new StrColumnBuilder<PdbxChemCompAtomRelatedBuilder>(CATEGORY_NAME, "related_type", this);
        }
    }

    public static class PdbxChemCompRelatedBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_related";

        public PdbxChemCompRelatedBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompRelatedBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompRelatedBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompRelatedBuilder> enterRelatedCompId() {
            return new StrColumnBuilder<PdbxChemCompRelatedBuilder>(CATEGORY_NAME, "related_comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompRelatedBuilder> enterRelationshipType() {
            return new StrColumnBuilder<PdbxChemCompRelatedBuilder>(CATEGORY_NAME, "relationship_type", this);
        }

        public StrColumnBuilder<PdbxChemCompRelatedBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxChemCompRelatedBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxChemCompSynonymsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_synonyms";

        public PdbxChemCompSynonymsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder> enterName() {
            return new StrColumnBuilder<PdbxChemCompSynonymsBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompSynonymsBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompSynonymsBuilder> enterProvenance() {
            return new StrColumnBuilder<PdbxChemCompSynonymsBuilder>(CATEGORY_NAME, "provenance", this);
        }
    }

    public static class PdbxSerialCrystallographyDataReductionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_serial_crystallography_data_reduction";

        public PdbxSerialCrystallographyDataReductionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterFramesTotal() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "frames_total", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterXfelPulseEvents() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "xfel_pulse_events", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterFrameHits() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "frame_hits", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterCrystalHits() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "crystal_hits", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterDropletHits() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "droplet_hits", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterFramesFailedIndex() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "frames_failed_index", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterFramesIndexed() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "frames_indexed", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterLatticesIndexed() {
            return new IntColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "lattices_indexed", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder> enterXfelRunNumbers() {
            return new StrColumnBuilder<PdbxSerialCrystallographyDataReductionBuilder>(CATEGORY_NAME, "xfel_run_numbers", this);
        }
    }

    public static class PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_serial_crystallography_sample_delivery_fixed_target";

        public PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterSampleHolding() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "sample_holding", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterSupportBase() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "support_base", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterSampleUnitSize() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "sample_unit_size", this);
        }

        public IntColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterCrystalsPerUnit() {
            return new IntColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "crystals_per_unit", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterSampleSolvent() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "sample_solvent", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterSampleDehydrationPrevention() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "sample_dehydration_prevention", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterMotionControl() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "motion_control", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterVelocityHorizontal() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "velocity_horizontal", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterVelocityVertical() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "velocity_vertical", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryFixedTargetBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxSerialCrystallographySampleDeliveryInjectionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_serial_crystallography_sample_delivery_injection";

        public PdbxSerialCrystallographySampleDeliveryInjectionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "description", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterInjectorDiameter() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "injector_diameter", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterInjectorTemperature() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "injector_temperature", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterInjectorPressure() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "injector_pressure", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterFlowRate() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "flow_rate", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterCarrierSolvent() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "carrier_solvent", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterCrystalConcentration() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "crystal_concentration", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterPreparation() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "preparation", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterPowerBy() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "power_by", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterInjectorNozzle() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "injector_nozzle", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterJetDiameter() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "jet_diameter", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder> enterFilterSize() {
            return new FloatColumnBuilder<PdbxSerialCrystallographySampleDeliveryInjectionBuilder>(CATEGORY_NAME, "filter_size", this);
        }
    }

    public static class PdbxSerialCrystallographySampleDeliveryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_serial_crystallography_sample_delivery";

        public PdbxSerialCrystallographySampleDeliveryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxSerialCrystallographySampleDeliveryBuilder>(CATEGORY_NAME, "method", this);
        }
    }

    public static class PdbxSerialCrystallographyMeasurementBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_serial_crystallography_measurement";

        public PdbxSerialCrystallographyMeasurementBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterPulseEnergy() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "pulse_energy", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterPulseDuration() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "pulse_duration", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterXfelPulseRepetitionRate() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "xfel_pulse_repetition_rate", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterPulsePhotonEnergy() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "pulse_photon_energy", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterPhotonsPerPulse() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "photons_per_pulse", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterSourceSize() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "source_size", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterSourceDistance() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "source_distance", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterFocalSpotSize() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "focal_spot_size", this);
        }

        public StrColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterCollimation() {
            return new StrColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "collimation", this);
        }

        public FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder> enterCollectionTimeTotal() {
            return new FloatColumnBuilder<PdbxSerialCrystallographyMeasurementBuilder>(CATEGORY_NAME, "collection_time_total", this);
        }
    }

    public static class PdbxSupportingExpDataSetBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_supporting_exp_data_set";

        public PdbxSupportingExpDataSetBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxSupportingExpDataSetBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxSupportingExpDataSetBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxSupportingExpDataSetBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxSupportingExpDataSetBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public IntColumnBuilder<PdbxSupportingExpDataSetBuilder> enterDataVersionMajor() {
            return new IntColumnBuilder<PdbxSupportingExpDataSetBuilder>(CATEGORY_NAME, "data_version_major", this);
        }

        public IntColumnBuilder<PdbxSupportingExpDataSetBuilder> enterDataVersionMinor() {
            return new IntColumnBuilder<PdbxSupportingExpDataSetBuilder>(CATEGORY_NAME, "data_version_minor", this);
        }

        public StrColumnBuilder<PdbxSupportingExpDataSetBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxSupportingExpDataSetBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxAuditRevisionItemBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_revision_item";

        public PdbxAuditRevisionItemBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxAuditRevisionItemBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionItemBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionItemBuilder> enterRevisionOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionItemBuilder>(CATEGORY_NAME, "revision_ordinal", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionItemBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxAuditRevisionItemBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionItemBuilder> enterItem() {
            return new StrColumnBuilder<PdbxAuditRevisionItemBuilder>(CATEGORY_NAME, "item", this);
        }
    }

    public static class PdbxAuditRevisionDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_revision_details";

        public PdbxAuditRevisionDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterRevisionOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "revision_ordinal", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterProvider() {
            return new StrColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "provider", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterType() {
            return new StrColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionDetailsBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxAuditRevisionDetailsBuilder>(CATEGORY_NAME, "description", this);
        }
    }

    public static class PdbxAuditRevisionCategoryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_revision_category";

        public PdbxAuditRevisionCategoryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxAuditRevisionCategoryBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionCategoryBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionCategoryBuilder> enterRevisionOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionCategoryBuilder>(CATEGORY_NAME, "revision_ordinal", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionCategoryBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxAuditRevisionCategoryBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionCategoryBuilder> enterCategory() {
            return new StrColumnBuilder<PdbxAuditRevisionCategoryBuilder>(CATEGORY_NAME, "category", this);
        }
    }

    public static class PdbxAuditRevisionGroupBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_revision_group";

        public PdbxAuditRevisionGroupBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxAuditRevisionGroupBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionGroupBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionGroupBuilder> enterRevisionOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionGroupBuilder>(CATEGORY_NAME, "revision_ordinal", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionGroupBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxAuditRevisionGroupBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionGroupBuilder> enterGroup() {
            return new StrColumnBuilder<PdbxAuditRevisionGroupBuilder>(CATEGORY_NAME, "group", this);
        }
    }

    public static class PdbxAuditRevisionHistoryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_revision_history";

        public PdbxAuditRevisionHistoryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterDataContentType() {
            return new StrColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "data_content_type", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterMajorRevision() {
            return new IntColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "major_revision", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterMinorRevision() {
            return new IntColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "minor_revision", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterRevisionDate() {
            return new StrColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "revision_date", this);
        }

        public IntColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterInternalVersion() {
            return new IntColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "internal_version", this);
        }

        public StrColumnBuilder<PdbxAuditRevisionHistoryBuilder> enterInternalDepositionId() {
            return new StrColumnBuilder<PdbxAuditRevisionHistoryBuilder>(CATEGORY_NAME, "internal_deposition_id", this);
        }
    }

    public static class PdbxCrystalAlignmentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_crystal_alignment";

        public PdbxCrystalAlignmentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrystalId() {
            return new StrColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crystal_id", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterOscillationRange() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "oscillation_range", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterOscillationStart() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "oscillation_start", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterOscillationEnd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "oscillation_end", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterXbeam() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "xbeam", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterXbeamEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "xbeam_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterYbeam() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "ybeam", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterYbeamEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "ybeam_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrysxSpindle() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysx_spindle", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrysxSpindleEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysx_spindle_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrysyVertical() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysy_vertical", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrysyVerticalEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysy_vertical_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCryszBeam() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysz_beam", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCryszBeamEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crysz_beam_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrystalToDetectorDistance() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crystal_to_detector_distance", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrystalToDetectorDistanceEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crystal_to_detector_distance_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireX() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_x", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireXEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_x_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireY() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_y", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireYEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_y_esd", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireXy() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_xy", this);
        }

        public FloatColumnBuilder<PdbxCrystalAlignmentBuilder> enterCrossfireXyEsd() {
            return new FloatColumnBuilder<PdbxCrystalAlignmentBuilder>(CATEGORY_NAME, "crossfire_xy_esd", this);
        }
    }

    public static class PdbxStructAssemblyAuthClassificationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_auth_classification";

        public PdbxStructAssemblyAuthClassificationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthClassificationBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthClassificationBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthClassificationBuilder> enterReasonForInterest() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthClassificationBuilder>(CATEGORY_NAME, "reason_for_interest", this);
        }
    }

    public static class PdbxStructAssemblyAuthEvidenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_auth_evidence";

        public PdbxStructAssemblyAuthEvidenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder> enterExperimentalSupport() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder>(CATEGORY_NAME, "experimental_support", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxDepositGroupIndexBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_deposit_group_index";

        public PdbxDepositGroupIndexBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterGroupId() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public IntColumnBuilder<PdbxDepositGroupIndexBuilder> enterOrdinalId() {
            return new IntColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterDepSetId() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "dep_set_id", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterPdbIdCode() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "pdb_id_code", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterGroupFileName() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "group_file_name", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterGroupFileTimestamp() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "group_file_timestamp", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterAuthFileLabel() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "auth_file_label", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterAuthFileContentType() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "auth_file_content_type", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterAuthFileFormatType() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "auth_file_format_type", this);
        }

        public StrColumnBuilder<PdbxDepositGroupIndexBuilder> enterAuthFileName() {
            return new StrColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "auth_file_name", this);
        }

        public IntColumnBuilder<PdbxDepositGroupIndexBuilder> enterAuthFileSize() {
            return new IntColumnBuilder<PdbxDepositGroupIndexBuilder>(CATEGORY_NAME, "auth_file_size", this);
        }
    }

    public static class PdbxDepositGroupBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_deposit_group";

        public PdbxDepositGroupBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepositGroupBuilder> enterGroupId() {
            return new StrColumnBuilder<PdbxDepositGroupBuilder>(CATEGORY_NAME, "group_id", this);
        }

        public StrColumnBuilder<PdbxDepositGroupBuilder> enterGroupTitle() {
            return new StrColumnBuilder<PdbxDepositGroupBuilder>(CATEGORY_NAME, "group_title", this);
        }

        public StrColumnBuilder<PdbxDepositGroupBuilder> enterGroupDescription() {
            return new StrColumnBuilder<PdbxDepositGroupBuilder>(CATEGORY_NAME, "group_description", this);
        }

        public StrColumnBuilder<PdbxDepositGroupBuilder> enterGroupType() {
            return new StrColumnBuilder<PdbxDepositGroupBuilder>(CATEGORY_NAME, "group_type", this);
        }
    }

    public static class PdbxDccMapBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_map";

        public PdbxDccMapBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDccMapBuilder> enterId() {
            return new IntColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterPdbId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "pdb_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterLabelInsCode() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "label_ins_code", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSCC() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSCC", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSR() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSR", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWeightedRSR() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "weighted_RSR", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRZ() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSRZ", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWeightedRSRZ() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "weighted_RSRZ", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterBisoMean() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "Biso_mean", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterOccupancyMean() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "occupancy_mean", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSCCMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSCC_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSR_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSR_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRZMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSRZ_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRZMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSRZ_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterBisoMeanMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "Biso_mean_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterOccupancyMeanMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "occupancy_mean_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSCCSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSCC_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSR_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSR_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRZSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSRZ_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRZSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSRZ_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterBisoMeanSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "Biso_mean_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterOccupancyMeanSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "occupancy_mean_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSCCPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSCC_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSR_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSR_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSRZPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSRZ_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterWRSRZPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "wRSRZ_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterBisoMeanPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "Biso_mean_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterOccupancyMeanPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "occupancy_mean_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterShift() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "shift", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterShiftMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "shift_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterShiftSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "shift_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterDensityConnectivity() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "density_connectivity", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterDensityIndexMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "density_index_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterDensityIndexSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "density_index_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZD() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZD", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZO() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZO", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZOZscore() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZO_Zscore", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterLLDF() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "LLDF", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZDMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZD_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZOMainChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZO_main_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZDSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZD_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZOSideChain() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZO_side_chain", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZDPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZD_phosphate_group", this);
        }

        public FloatColumnBuilder<PdbxDccMapBuilder> enterRSZOPhosphateGroup() {
            return new FloatColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "RSZO_phosphate_group", this);
        }

        public StrColumnBuilder<PdbxDccMapBuilder> enterQualityIndicator() {
            return new StrColumnBuilder<PdbxDccMapBuilder>(CATEGORY_NAME, "quality_indicator", this);
        }
    }

    public static class PdbxDccDensityCorrBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_density_corr";

        public PdbxDccDensityCorrBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDccDensityCorrBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxDccDensityCorrBuilder> enterProgram() {
            return new StrColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "program", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsDResHigh() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_d_res_high", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsDResLow() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_d_res_low", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsRFactorRAll() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_R_factor_R_all", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsRFactorRWork() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_R_factor_R_work", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsRFactorRFree() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_R_factor_R_free", this);
        }

        public IntColumnBuilder<PdbxDccDensityCorrBuilder> enterLsNumberReflnsObs() {
            return new IntColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_number_reflns_obs", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterLsPercentReflnsObs() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_percent_reflns_obs", this);
        }

        public IntColumnBuilder<PdbxDccDensityCorrBuilder> enterLsNumberReflnsRFree() {
            return new IntColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "ls_number_reflns_R_free", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterCorrelationCoeffFoToFc() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterRealSpaceR() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "real_space_R", this);
        }

        public FloatColumnBuilder<PdbxDccDensityCorrBuilder> enterCorrelation() {
            return new FloatColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "correlation", this);
        }

        public StrColumnBuilder<PdbxDccDensityCorrBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxDccDensityCorrBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxDccGeometryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_geometry";

        public PdbxDccGeometryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDccGeometryBuilder> enterPdbid() {
            return new StrColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "pdbid", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranOutlierPercent() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_outlier_percent", this);
        }

        public IntColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranOutlierNumber() {
            return new IntColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_outlier_number", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranAllowedPercent() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_allowed_percent", this);
        }

        public IntColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranAllowedNumber() {
            return new IntColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_allowed_number", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranFavoredPercent() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_favored_percent", this);
        }

        public IntColumnBuilder<PdbxDccGeometryBuilder> enterRamachandranFavoredNumber() {
            return new IntColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "Ramachandran_favored_number", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterRotamerOutliersPercent() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "rotamer_outliers_percent", this);
        }

        public IntColumnBuilder<PdbxDccGeometryBuilder> enterRotamerOutliersNumber() {
            return new IntColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "rotamer_outliers_number", this);
        }

        public IntColumnBuilder<PdbxDccGeometryBuilder> enterCbetaDeviations() {
            return new IntColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "cbeta_deviations", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterAllAtomClashscore() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "all_atom_clashscore", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterOverallScore() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "overall_score", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterBondOverallRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "bond_overall_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterBondOverallMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "bond_overall_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterBondLigandRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "bond_ligand_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterBondLigandMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "bond_ligand_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterAngleOverallRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "angle_overall_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterAngleOverallMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "angle_overall_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterAngleLigandRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "angle_ligand_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterAngleLigandMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "angle_ligand_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterDihedralOverallRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "dihedral_overall_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterDihedralOverallMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "dihedral_overall_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterChiralityOverallRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "chirality_overall_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterChiralityOverallMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "chirality_overall_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterPlanarityOverallRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "planarity_overall_rms", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterPlanarityOverallMax() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "planarity_overall_max", this);
        }

        public FloatColumnBuilder<PdbxDccGeometryBuilder> enterNon_bondedRms() {
            return new FloatColumnBuilder<PdbxDccGeometryBuilder>(CATEGORY_NAME, "non-bonded_rms", this);
        }
    }

    public static class PdbxDccDensityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_density";

        public PdbxDccDensityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterDCCVersion() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "DCC_version", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterPdbid() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "pdbid", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterPdbtype() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "pdbtype", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterUnitCell() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "unit_cell", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterSpaceGroupNameH_M() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "space_group_name_H-M", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterSpaceGroupPointless() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "space_group_pointless", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterLsDResHigh() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "ls_d_res_high", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterLsDResHighSf() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "ls_d_res_high_sf", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterLsDResLowSf() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "ls_d_res_low_sf", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterRValueRWork() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "R_value_R_work", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterRValueRFree() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "R_value_R_free", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterWorkingSetCount() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "working_set_count", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterFreeSetCount() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "free_set_count", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterOccupancyMin() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "occupancy_min", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterOccupancyMax() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "occupancy_max", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterOccupancyMean() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "occupancy_mean", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBisoMin() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Biso_min", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBisoMax() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Biso_max", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBisoMean() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Biso_mean", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBWilson() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "B_wilson", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBWilsonScale() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "B_wilson_scale", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterMeanI2OverMeanISquare() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mean_I2_over_mean_I_square", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterMeanFSquareOverMeanF2() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mean_F_square_over_mean_F2", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterMeanE21Abs() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mean_E2_1_abs", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterPadilla_YeatesLMean() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Padilla-Yeates_L_mean", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterPadilla_YeatesL2Mean() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Padilla-Yeates_L2_mean", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterPadilla_YeatesL2MeanPointless() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Padilla-Yeates_L2_mean_pointless", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterZScoreLTest() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Z_score_L_test", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTwinType() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_type", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTwinOperatorXtriage() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_operator_xtriage", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterTwinFractionXtriage() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_fraction_xtriage", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterTwinRfactor() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_Rfactor", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterIOverSigIResh() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "I_over_sigI_resh", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterIOverSigIDiff() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "I_over_sigI_diff", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterIOverSigIMean() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "I_over_sigI_mean", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterIceRing() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "ice_ring", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterAnisotropy() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "anisotropy", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterZ_score() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Z-score", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterProbPeakValue() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "prob_peak_value", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTranslationalPseudoSymmetry() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "translational_pseudo_symmetry", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterWavelength() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "wavelength", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBSolvent() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "B_solvent", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterKSolvent() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "K_solvent", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTLSRefinementReported() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "TLS_refinement_reported", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterPartialBValueCorrectionAttempted() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "partial_B_value_correction_attempted", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterPartialBValueCorrectionSuccess() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "partial_B_value_correction_success", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterReflectionStatusArchived() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "reflection_status_archived", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterReflectionStatusUsed() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "reflection_status_used", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterIsoBValueType() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "iso_B_value_type", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterReflnsTwin() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "reflns_twin", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTwinByXtriage() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_by_xtriage", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTwinOperator() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_operator", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterTwinFraction() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "twin_fraction", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterTlsGroupNumber() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "tls_group_number", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterNcsGroupNumber() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "ncs_group_number", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterMtrixNumber() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mtrix_number", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterMatthewCoeff() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Matthew_coeff", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterSolventContent() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "solvent_content", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterCruickshankDpiXyz() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Cruickshank_dpi_xyz", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterDpiFreeR() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "dpi_free_R", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterCorrelationOverall() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "correlation_overall", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterRealSpaceROverall() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "real_space_R_overall", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterMFo_DFc_3sigmaPositive() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mFo-DFc-3sigma_positive", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterMFo_DFc_6sigmaPositive() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mFo-DFc-6sigma_positive", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterMFo_DFc_3sigmaNegative() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mFo-DFc-3sigma_negative", this);
        }

        public IntColumnBuilder<PdbxDccDensityBuilder> enterMFo_DFc_6sigmaNegative() {
            return new IntColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "mFo-DFc-6sigma_negative", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterBmean_Bwilson() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Bmean-Bwilson", this);
        }

        public FloatColumnBuilder<PdbxDccDensityBuilder> enterRfree_Rwork() {
            return new FloatColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "Rfree-Rwork", this);
        }

        public StrColumnBuilder<PdbxDccDensityBuilder> enterError() {
            return new StrColumnBuilder<PdbxDccDensityBuilder>(CATEGORY_NAME, "error", this);
        }
    }

    public static class PdbxDccRsccMapmanOverallBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_rscc_mapman_overall";

        public PdbxDccRsccMapmanOverallBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanOverallBuilder> enterPdbid() {
            return new StrColumnBuilder<PdbxDccRsccMapmanOverallBuilder>(CATEGORY_NAME, "pdbid", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder> enterCorrelation() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder>(CATEGORY_NAME, "correlation", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder> enterCorrelationSigma() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder>(CATEGORY_NAME, "correlation_sigma", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder> enterRealSpaceR() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder>(CATEGORY_NAME, "real_space_R", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder> enterRealSpaceRSigma() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanOverallBuilder>(CATEGORY_NAME, "real_space_R_sigma", this);
        }
    }

    public static class PdbxDccRsccMapmanBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_rscc_mapman";

        public PdbxDccRsccMapmanBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDccRsccMapmanBuilder> enterId() {
            return new IntColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterPdbId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "pdb_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterLabelInsCode() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "label_ins_code", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterCorrelation() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "correlation", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterRealSpaceR() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "real_space_R", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterWeightedRealSpaceR() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "weighted_real_space_R", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterRealSpaceZscore() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "real_space_Zscore", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterBisoMean() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "Biso_mean", this);
        }

        public FloatColumnBuilder<PdbxDccRsccMapmanBuilder> enterOccupancyMean() {
            return new FloatColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "occupancy_mean", this);
        }

        public StrColumnBuilder<PdbxDccRsccMapmanBuilder> enterFlag() {
            return new StrColumnBuilder<PdbxDccRsccMapmanBuilder>(CATEGORY_NAME, "flag", this);
        }
    }

    public static class PdbxDccMapmanBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dcc_mapman";

        public PdbxDccMapmanBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDccMapmanBuilder> enterPdbid() {
            return new StrColumnBuilder<PdbxDccMapmanBuilder>(CATEGORY_NAME, "pdbid", this);
        }

        public StrColumnBuilder<PdbxDccMapmanBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxDccMapmanBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxAuditConformExtensionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_conform_extension";

        public PdbxAuditConformExtensionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAuditConformExtensionBuilder> enterExtensionDictLocation() {
            return new StrColumnBuilder<PdbxAuditConformExtensionBuilder>(CATEGORY_NAME, "extension_dict_location", this);
        }

        public StrColumnBuilder<PdbxAuditConformExtensionBuilder> enterExtensionDictName() {
            return new StrColumnBuilder<PdbxAuditConformExtensionBuilder>(CATEGORY_NAME, "extension_dict_name", this);
        }

        public StrColumnBuilder<PdbxAuditConformExtensionBuilder> enterExtensionDictVersion() {
            return new StrColumnBuilder<PdbxAuditConformExtensionBuilder>(CATEGORY_NAME, "extension_dict_version", this);
        }
    }

    public static class PdbxNmrComputingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_computing";

        public PdbxNmrComputingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterCollection() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "collection", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterCollectionVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "collection_version", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterProcessing() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "processing", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterProcessingVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "processing_version", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterDataAnalysis() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "data_analysis", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterDataAnalysisVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "data_analysis_version", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterStructureSolution() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "structure_solution", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterStructureSolutionVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "structure_solution_version", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterRefinement() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "refinement", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterRefinementVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "refinement_version", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterIterativeRelaxationMatrix() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "iterative_relaxation_matrix", this);
        }

        public StrColumnBuilder<PdbxNmrComputingBuilder> enterIterativeRelaxationMatrixVersion() {
            return new StrColumnBuilder<PdbxNmrComputingBuilder>(CATEGORY_NAME, "iterative_relaxation_matrix_version", this);
        }
    }

    public static class PdbxSugarPhosphateGeometryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_sugar_phosphate_geometry";

        public PdbxSugarPhosphateGeometryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterId() {
            return new IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNeighborCompId5prime() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "neighbor_comp_id_5prime", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNeighborCompId3prime() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "neighbor_comp_id_3prime", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO3PO5C5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o3_p_o5_c5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPO5C5C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "p_o5_c5_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO5C5C4C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o5_c5_c4_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC5C4C3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c5_c4_c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4C3O3P() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_c3_o3_p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3O3PO5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_o3_p_o5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4O4C1N19() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_o4_c1_n1_9", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1N19C24() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1_n1_9_c2_4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1N19C68() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1_n1_9_c6_8", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4O4C1C2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_o4_c1_c2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1C2C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1_c2_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1C2C3C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_c2_c3_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC2C3C4O4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c2_c3_c4_o4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3C4O4C1() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_c4_o4_c1", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC5C4C3C2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c5_c4_c3_c2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C4C3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c4_c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO3C3C2O2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o3_c3_c2_o2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO5C5C4O4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o5_c5_c4_o4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPseudorot() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "pseudorot", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterMaxtorsion() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "maxtorsion", this);
        }

        public StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextLabelCompId() {
            return new StrColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextLabelSeqId() {
            return new IntColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextO3PO5C5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_o3_p_o5_c5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextPO5C5C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_p_o5_c5_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextO5C5C4C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_o5_c5_c4_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextC5C4C3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_c5_c4_c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextC4C3O3P() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_c4_c3_o3_p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextC3O3PO5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_c3_o3_p_o5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextC4O4C1N19() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_c4_o4_c1_n1_9", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterNextO4C1N19C24() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "next_o4_c1_n1_9_c2_4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1C2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_c2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC2C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c2_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4O4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_o4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPO5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "p_o5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO5C5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o5_c5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC5C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c5_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO3P() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o3_p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPO1p() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "p_o1p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPO2p() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "p_o2p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1N91() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_n9_1", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterN1C2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "n1_c2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterN1C6() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "n1_c6", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterN9C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "n9_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterN9C8() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "n9_c8", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1C2C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_c2_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC2C3C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c2_c3_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3C4O4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_c4_o4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4O4C1() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_o4_c1", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1C2() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1_c2", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterPO5C5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "p_o5_c5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO5C5C4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o5_c5_c4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC5C4C3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c5_c4_c3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC4C3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c4_c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC3O3P() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c3_o3_p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO3PO5() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o3_p_o5", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO4C1N19() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o4_c1_n1_9", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1N19C24() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_n1_9_c2_4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC5C4O4() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c5_c4_o4", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC2C3O3() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c2_c3_o3", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterO1pPO2p() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "o1p_p_o2p", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC2C1N19() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c2_c1_n1_9", this);
        }

        public FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder> enterC1N19C68() {
            return new FloatColumnBuilder<PdbxSugarPhosphateGeometryBuilder>(CATEGORY_NAME, "c1_n1_9_c6_8", this);
        }
    }

    public static class PdbxRmsDevsCovByMonomerBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_rms_devs_cov_by_monomer";

        public PdbxRmsDevsCovByMonomerBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterId() {
            return new IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterRmsBonds() {
            return new FloatColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "rms_bonds", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterNumBonds() {
            return new IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "num_bonds", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterRmsAngles() {
            return new FloatColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "rms_angles", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder> enterNumAngles() {
            return new IntColumnBuilder<PdbxRmsDevsCovByMonomerBuilder>(CATEGORY_NAME, "num_angles", this);
        }
    }

    public static class PdbxRmsDevsCovalentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_rms_devs_covalent";

        public PdbxRmsDevsCovalentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRmsDevsCovalentBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsBonds() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_bonds", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumBonds() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_bonds", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsBondsBase() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_bonds_base", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumBondsBase() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_bonds_base", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsBondsSugar() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_bonds_sugar", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumBondsSugar() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_bonds_sugar", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsBondsPhosphate() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_bonds_phosphate", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumBondsPhosphate() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_bonds_phosphate", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsAngles() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_angles", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumAngles() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_angles", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsAnglesBase() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_angles_base", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumAnglesBase() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_angles_base", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsAnglesSugar() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_angles_sugar", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumAnglesSugar() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_angles_sugar", this);
        }

        public FloatColumnBuilder<PdbxRmsDevsCovalentBuilder> enterRmsAnglesPhosphate() {
            return new FloatColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "rms_angles_phosphate", this);
        }

        public IntColumnBuilder<PdbxRmsDevsCovalentBuilder> enterNumAnglesPhosphate() {
            return new IntColumnBuilder<PdbxRmsDevsCovalentBuilder>(CATEGORY_NAME, "num_angles_phosphate", this);
        }
    }

    public static class PdbxStereochemistryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_stereochemistry";

        public PdbxStereochemistryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStereochemistryBuilder> enterId() {
            return new IntColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxStereochemistryBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStereochemistryBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAtomIdU() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_atom_id_u", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAltIdU() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_alt_id_u", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAtomIdV() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_atom_id_v", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAltIdV() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_alt_id_v", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAtomIdW() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_atom_id_w", this);
        }

        public StrColumnBuilder<PdbxStereochemistryBuilder> enterLabelAltIdW() {
            return new StrColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "label_alt_id_w", this);
        }

        public FloatColumnBuilder<PdbxStereochemistryBuilder> enterVolume3() {
            return new FloatColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "volume3", this);
        }

        public FloatColumnBuilder<PdbxStereochemistryBuilder> enterAngleOutOfPlane() {
            return new FloatColumnBuilder<PdbxStereochemistryBuilder>(CATEGORY_NAME, "angle_out_of_plane", this);
        }
    }

    public static class PdbxSequencePatternBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_sequence_pattern";

        public PdbxSequencePatternBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSequencePatternBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxSequencePatternBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequencePatternBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxSequencePatternBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public IntColumnBuilder<PdbxSequencePatternBuilder> enterPatternCount() {
            return new IntColumnBuilder<PdbxSequencePatternBuilder>(CATEGORY_NAME, "pattern_count", this);
        }

        public StrColumnBuilder<PdbxSequencePatternBuilder> enterSequencePattern() {
            return new StrColumnBuilder<PdbxSequencePatternBuilder>(CATEGORY_NAME, "sequence_pattern", this);
        }
    }

    public static class PdbxVirtualTorsionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_virtual_torsion";

        public PdbxVirtualTorsionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxVirtualTorsionBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAltId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAtomId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelCompId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_3", this);
        }

        public IntColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelSeqId3() {
            return new IntColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAsymId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAltId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAtomId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelCompId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_4", this);
        }

        public IntColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelSeqId4() {
            return new IntColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteLabelAsymId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAtomId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAsymId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthCompId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthSeqId3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAtomId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthAsymId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthCompId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterAtomSiteAuthSeqId4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_4", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterSiteSymmetry3() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "site_symmetry_3", this);
        }

        public StrColumnBuilder<PdbxVirtualTorsionBuilder> enterSiteSymmetry4() {
            return new StrColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "site_symmetry_4", this);
        }

        public FloatColumnBuilder<PdbxVirtualTorsionBuilder> enterValue() {
            return new FloatColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<PdbxVirtualTorsionBuilder> enterValueEsd() {
            return new FloatColumnBuilder<PdbxVirtualTorsionBuilder>(CATEGORY_NAME, "value_esd", this);
        }
    }

    public static class PdbxVirtualBondBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_virtual_bond";

        public PdbxVirtualBondBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxVirtualBondBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxVirtualBondBuilder> enterAtomSiteAuthSeqId2() {
            return new IntColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public FloatColumnBuilder<PdbxVirtualBondBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "dist", this);
        }

        public FloatColumnBuilder<PdbxVirtualBondBuilder> enterDistEsd() {
            return new FloatColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "dist_esd", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxVirtualBondBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilder<PdbxVirtualBondBuilder>(CATEGORY_NAME, "site_symmetry_2", this);
        }
    }

    public static class PdbxVirtualAngleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_virtual_angle";

        public PdbxVirtualAngleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxVirtualAngleBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAltId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAtomId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelCompId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelSeqId1() {
            return new IntColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAsymId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAltId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAtomId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelCompId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelSeqId2() {
            return new IntColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAsymId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAltId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_alt_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAtomId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelCompId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_comp_id_3", this);
        }

        public IntColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelSeqId3() {
            return new IntColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteLabelAsymId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_label_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAsymId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAtomId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthCompId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthSeqId1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAtomId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAsymId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthCompId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthSeqId2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAtomId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthAsymId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthCompId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_comp_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterAtomSiteAuthSeqId3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "atom_site_auth_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public StrColumnBuilder<PdbxVirtualAngleBuilder> enterSiteSymmetry3() {
            return new StrColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "site_symmetry_3", this);
        }

        public FloatColumnBuilder<PdbxVirtualAngleBuilder> enterValue() {
            return new FloatColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<PdbxVirtualAngleBuilder> enterValueEsd() {
            return new FloatColumnBuilder<PdbxVirtualAngleBuilder>(CATEGORY_NAME, "value_esd", this);
        }
    }

    public static class PdbxEntityPolyNaNonstandardBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_poly_na_nonstandard";

        public PdbxEntityPolyNaNonstandardBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityPolyNaNonstandardBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityPolyNaNonstandardBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyNaNonstandardBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxEntityPolyNaNonstandardBuilder>(CATEGORY_NAME, "feature", this);
        }
    }

    public static class PdbxEntityPolyNaTypeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_poly_na_type";

        public PdbxEntityPolyNaTypeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityPolyNaTypeBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityPolyNaTypeBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyNaTypeBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityPolyNaTypeBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxNaStructKeywdsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_na_struct_keywds";

        public PdbxNaStructKeywdsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNaStructKeywdsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNaStructKeywdsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNaStructKeywdsBuilder> enterConformationType() {
            return new StrColumnBuilder<PdbxNaStructKeywdsBuilder>(CATEGORY_NAME, "conformation_type", this);
        }

        public StrColumnBuilder<PdbxNaStructKeywdsBuilder> enterStrandDescription() {
            return new StrColumnBuilder<PdbxNaStructKeywdsBuilder>(CATEGORY_NAME, "strand_description", this);
        }

        public StrColumnBuilder<PdbxNaStructKeywdsBuilder> enterSpecialFeature() {
            return new StrColumnBuilder<PdbxNaStructKeywdsBuilder>(CATEGORY_NAME, "special_feature", this);
        }
    }

    public static class PdbxEntityPolyDomainBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_poly_domain";

        public PdbxEntityPolyDomainBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityPolyDomainBuilder> enterId() {
            return new StrColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyDomainBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyDomainBuilder> enterBeginMonId() {
            return new StrColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "begin_mon_id", this);
        }

        public IntColumnBuilder<PdbxEntityPolyDomainBuilder> enterBeginSeqNum() {
            return new IntColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "begin_seq_num", this);
        }

        public StrColumnBuilder<PdbxEntityPolyDomainBuilder> enterEndMonId() {
            return new StrColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "end_mon_id", this);
        }

        public IntColumnBuilder<PdbxEntityPolyDomainBuilder> enterEndSeqNum() {
            return new IntColumnBuilder<PdbxEntityPolyDomainBuilder>(CATEGORY_NAME, "end_seq_num", this);
        }
    }

    public static class PdbxEntityFuncOtherBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_func_other";

        public PdbxEntityFuncOtherBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityFuncOtherBuilder> enterBindModeId() {
            return new StrColumnBuilder<PdbxEntityFuncOtherBuilder>(CATEGORY_NAME, "bind_mode_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncOtherBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityFuncOtherBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxEntityFuncStructuralBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_func_structural";

        public PdbxEntityFuncStructuralBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityFuncStructuralBuilder> enterBindModeId() {
            return new StrColumnBuilder<PdbxEntityFuncStructuralBuilder>(CATEGORY_NAME, "bind_mode_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncStructuralBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityFuncStructuralBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxEntityFuncRegulatoryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_func_regulatory";

        public PdbxEntityFuncRegulatoryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityFuncRegulatoryBuilder> enterBindModeId() {
            return new StrColumnBuilder<PdbxEntityFuncRegulatoryBuilder>(CATEGORY_NAME, "bind_mode_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncRegulatoryBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityFuncRegulatoryBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxEntityFuncEnzymeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_func_enzyme";

        public PdbxEntityFuncEnzymeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityFuncEnzymeBuilder> enterBindModeId() {
            return new StrColumnBuilder<PdbxEntityFuncEnzymeBuilder>(CATEGORY_NAME, "bind_mode_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncEnzymeBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityFuncEnzymeBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxEntityFuncBindModeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_func_bind_mode";

        public PdbxEntityFuncBindModeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityFuncBindModeBuilder> enterId() {
            return new StrColumnBuilder<PdbxEntityFuncBindModeBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncBindModeBuilder> enterDomainId() {
            return new StrColumnBuilder<PdbxEntityFuncBindModeBuilder>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncBindModeBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityFuncBindModeBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityFuncBindModeBuilder> enterProteinBindsTo() {
            return new StrColumnBuilder<PdbxEntityFuncBindModeBuilder>(CATEGORY_NAME, "protein_binds_to", this);
        }

        public StrColumnBuilder<PdbxEntityFuncBindModeBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityFuncBindModeBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxSummaryFlagsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_summary_flags";

        public PdbxSummaryFlagsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSummaryFlagsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxSummaryFlagsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxSummaryFlagsBuilder> enterFlagId() {
            return new StrColumnBuilder<PdbxSummaryFlagsBuilder>(CATEGORY_NAME, "flag_id", this);
        }

        public StrColumnBuilder<PdbxSummaryFlagsBuilder> enterFlagValue() {
            return new StrColumnBuilder<PdbxSummaryFlagsBuilder>(CATEGORY_NAME, "flag_value", this);
        }
    }

    public static class PdbxAtlasBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_atlas";

        public PdbxAtlasBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAtlasBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxAtlasBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxAtlasBuilder> enterPageId() {
            return new IntColumnBuilder<PdbxAtlasBuilder>(CATEGORY_NAME, "page_id", this);
        }

        public StrColumnBuilder<PdbxAtlasBuilder> enterPageName() {
            return new StrColumnBuilder<PdbxAtlasBuilder>(CATEGORY_NAME, "page_name", this);
        }
    }

    public static class PdbxValChiralBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_val_chiral";

        public PdbxValChiralBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValChiralBuilder> enterId() {
            return new IntColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValChiralBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterAuthPDBInsertId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "auth_PDB_insert_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxValChiralBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterChiralCenterAtomName() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "chiral_center_atom_name", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterChiralNeighborAtomName() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "chiral_neighbor_atom_name", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterChiralCenterAtomAltId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "chiral_center_atom_alt_id", this);
        }

        public StrColumnBuilder<PdbxValChiralBuilder> enterChiralNeighborAtomAltId() {
            return new StrColumnBuilder<PdbxValChiralBuilder>(CATEGORY_NAME, "chiral_neighbor_atom_alt_id", this);
        }
    }

    public static class PdbxMissingAtomNonpolyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_missing_atom_nonpoly";

        public PdbxMissingAtomNonpolyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterId() {
            return new IntColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterAuthPDBInsertId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "auth_PDB_insert_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomNonpolyBuilder> enterAtomName() {
            return new StrColumnBuilder<PdbxMissingAtomNonpolyBuilder>(CATEGORY_NAME, "atom_name", this);
        }
    }

    public static class PdbxMissingAtomPolyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_missing_atom_poly";

        public PdbxMissingAtomPolyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxMissingAtomPolyBuilder> enterId() {
            return new IntColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxMissingAtomPolyBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterAuthPDBInsertId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "auth_PDB_insert_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxMissingAtomPolyBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxMissingAtomPolyBuilder> enterAtomName() {
            return new StrColumnBuilder<PdbxMissingAtomPolyBuilder>(CATEGORY_NAME, "atom_name", this);
        }
    }

    public static class PdbxRmchOutlierBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_rmch_outlier";

        public PdbxRmchOutlierBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxRmchOutlierBuilder> enterId() {
            return new IntColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxRmchOutlierBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterAuthPDBInsertId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "auth_PDB_insert_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRmchOutlierBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxRmchOutlierBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxRmchOutlierBuilder> enterPhi() {
            return new FloatColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "phi", this);
        }

        public FloatColumnBuilder<PdbxRmchOutlierBuilder> enterPsi() {
            return new FloatColumnBuilder<PdbxRmchOutlierBuilder>(CATEGORY_NAME, "psi", this);
        }
    }

    public static class PdbxValSymContactBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_val_sym_contact";

        public PdbxValSymContactBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValSymContactBuilder> enterId() {
            return new IntColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValSymContactBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthPDBInsertId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterAuthPDBInsertId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAsymId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAtomId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelCompId1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxValSymContactBuilder> enterLabelSeqId1() {
            return new IntColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAsymId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelAtomId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterLabelCompId2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxValSymContactBuilder> enterLabelSeqId2() {
            return new IntColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "label_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxValSymContactBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public FloatColumnBuilder<PdbxValSymContactBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxValSymContactBuilder>(CATEGORY_NAME, "dist", this);
        }
    }

    public static class PdbxValContactBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_val_contact";

        public PdbxValContactBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValContactBuilder> enterId() {
            return new IntColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValContactBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthPDBInsertId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterAuthPDBInsertId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAsymId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAtomId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelCompId1() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxValContactBuilder> enterLabelSeqId1() {
            return new IntColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAsymId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelAtomId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValContactBuilder> enterLabelCompId2() {
            return new StrColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxValContactBuilder> enterLabelSeqId2() {
            return new IntColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "label_seq_id_2", this);
        }

        public FloatColumnBuilder<PdbxValContactBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxValContactBuilder>(CATEGORY_NAME, "dist", this);
        }
    }

    public static class PdbxValBondBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_val_bond";

        public PdbxValBondBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValBondBuilder> enterId() {
            return new IntColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValBondBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthPDBInsertId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterAuthPDBInsertId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAsymId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAtomId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelCompId1() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxValBondBuilder> enterLabelSeqId1() {
            return new IntColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAsymId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelAtomId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValBondBuilder> enterLabelCompId2() {
            return new StrColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxValBondBuilder> enterLabelSeqId2() {
            return new IntColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "label_seq_id_2", this);
        }

        public FloatColumnBuilder<PdbxValBondBuilder> enterBond() {
            return new FloatColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "bond", this);
        }

        public FloatColumnBuilder<PdbxValBondBuilder> enterBondDeviation() {
            return new FloatColumnBuilder<PdbxValBondBuilder>(CATEGORY_NAME, "bond_deviation", this);
        }
    }

    public static class PdbxValAngleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_val_angle";

        public PdbxValAngleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValAngleBuilder> enterId() {
            return new IntColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValAngleBuilder> enterModelId() {
            return new IntColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAtomId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthAsymId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthCompId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_comp_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthSeqId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthPDBInsertId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthPDBInsertId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterAuthPDBInsertId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "auth_PDB_insert_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAsymId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAtomId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelCompId1() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_comp_id_1", this);
        }

        public IntColumnBuilder<PdbxValAngleBuilder> enterLabelSeqId1() {
            return new IntColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAsymId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAtomId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelCompId2() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_comp_id_2", this);
        }

        public IntColumnBuilder<PdbxValAngleBuilder> enterLabelSeqId2() {
            return new IntColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAltId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_alt_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAsymId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelAtomId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxValAngleBuilder> enterLabelCompId3() {
            return new StrColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_comp_id_3", this);
        }

        public IntColumnBuilder<PdbxValAngleBuilder> enterLabelSeqId3() {
            return new IntColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "label_seq_id_3", this);
        }

        public FloatColumnBuilder<PdbxValAngleBuilder> enterAngle() {
            return new FloatColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "angle", this);
        }

        public FloatColumnBuilder<PdbxValAngleBuilder> enterAngleDeviation() {
            return new FloatColumnBuilder<PdbxValAngleBuilder>(CATEGORY_NAME, "angle_deviation", this);
        }
    }

    public static class PdbxColumninfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_columninfo";

        public PdbxColumninfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxColumninfoBuilder> enterColumnname() {
            return new StrColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "columnname", this);
        }

        public StrColumnBuilder<PdbxColumninfoBuilder> enterTablename() {
            return new StrColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "tablename", this);
        }

        public StrColumnBuilder<PdbxColumninfoBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxColumninfoBuilder> enterExample() {
            return new StrColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "example", this);
        }

        public IntColumnBuilder<PdbxColumninfoBuilder> enterType() {
            return new IntColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxColumninfoBuilder> enterTableSerialNo() {
            return new IntColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "table_serial_no", this);
        }

        public IntColumnBuilder<PdbxColumninfoBuilder> enterColumnSerialNo() {
            return new IntColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "column_serial_no", this);
        }

        public IntColumnBuilder<PdbxColumninfoBuilder> enterWWWSelectionCriteria() {
            return new IntColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "WWW_Selection_Criteria", this);
        }

        public IntColumnBuilder<PdbxColumninfoBuilder> enterWWWReportCriteria() {
            return new IntColumnBuilder<PdbxColumninfoBuilder>(CATEGORY_NAME, "WWW_Report_Criteria", this);
        }
    }

    public static class PdbxTableinfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_tableinfo";

        public PdbxTableinfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxTableinfoBuilder> enterTablename() {
            return new StrColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "tablename", this);
        }

        public StrColumnBuilder<PdbxTableinfoBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "description", this);
        }

        public IntColumnBuilder<PdbxTableinfoBuilder> enterType() {
            return new IntColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxTableinfoBuilder> enterTableSerialNo() {
            return new IntColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "table_serial_no", this);
        }

        public StrColumnBuilder<PdbxTableinfoBuilder> enterGroupName() {
            return new StrColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "group_name", this);
        }

        public IntColumnBuilder<PdbxTableinfoBuilder> enterWWWSelectionCriteria() {
            return new IntColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "WWW_Selection_Criteria", this);
        }

        public IntColumnBuilder<PdbxTableinfoBuilder> enterWWWReportCriteria() {
            return new IntColumnBuilder<PdbxTableinfoBuilder>(CATEGORY_NAME, "WWW_Report_Criteria", this);
        }
    }

    public static class PdbxEntityNameInstanceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_name_instance";

        public PdbxEntityNameInstanceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterName() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterPdbId() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "pdb_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterRcsbId() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "rcsb_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterPdbChainId() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "pdb_chain_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameInstanceBuilder> enterPdbMolId() {
            return new StrColumnBuilder<PdbxEntityNameInstanceBuilder>(CATEGORY_NAME, "pdb_mol_id", this);
        }
    }

    public static class PdbxEntityNameTaxonomyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_name_taxonomy";

        public PdbxEntityNameTaxonomyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNameTaxonomyBuilder> enterId() {
            return new StrColumnBuilder<PdbxEntityNameTaxonomyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityNameTaxonomyBuilder> enterName() {
            return new StrColumnBuilder<PdbxEntityNameTaxonomyBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxEntityNameTaxonomyBuilder> enterNameType() {
            return new StrColumnBuilder<PdbxEntityNameTaxonomyBuilder>(CATEGORY_NAME, "name_type", this);
        }
    }

    public static class PdbxEntityNameTaxonomyTreeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_name_taxonomy_tree";

        public PdbxEntityNameTaxonomyTreeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNameTaxonomyTreeBuilder> enterId() {
            return new StrColumnBuilder<PdbxEntityNameTaxonomyTreeBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityNameTaxonomyTreeBuilder> enterParentId() {
            return new StrColumnBuilder<PdbxEntityNameTaxonomyTreeBuilder>(CATEGORY_NAME, "parent_id", this);
        }
    }

    public static class PdbxEntityPolyProteinClassBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_poly_protein_class";

        public PdbxEntityPolyProteinClassBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityPolyProteinClassBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityPolyProteinClassBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyProteinClassBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxEntityPolyProteinClassBuilder>(CATEGORY_NAME, "class", this);
        }
    }

    public static class PdbxChemCompNonstandardBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_nonstandard";

        public PdbxChemCompNonstandardBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompNonstandardBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompNonstandardBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompNonstandardBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompNonstandardBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxDataProcessingDetectorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_data_processing_detector";

        public PdbxDataProcessingDetectorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterName() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "name", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterWavelength() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "wavelength", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterPolarization() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "polarization", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterBeamPositionX() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "beam_position_x", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterBeamPositionY() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "beam_position_y", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCassetteRotX() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "cassette_rot_x", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCassetteRotY() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "cassette_rot_y", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCassetteRotZ() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "cassette_rot_z", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterScaleY() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "scale_y", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterSkew() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "skew", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCrossfireX() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "crossfire_x", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCrossfireY() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "crossfire_y", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCrossfireXy() {
            return new FloatColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "crossfire_xy", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterDate() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterExperimentor() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "experimentor", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterCrystalDataId() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "crystal_data_id", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterProcessingPath() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "processing_path", this);
        }

        public StrColumnBuilder<PdbxDataProcessingDetectorBuilder> enterProcessingFiles() {
            return new StrColumnBuilder<PdbxDataProcessingDetectorBuilder>(CATEGORY_NAME, "processing_files", this);
        }
    }

    public static class PdbxDataProcessingReflnsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_data_processing_reflns";

        public PdbxDataProcessingReflnsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDataProcessingReflnsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxDataProcessingReflnsBuilder> enterNumberAll() {
            return new IntColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "number_all", this);
        }

        public IntColumnBuilder<PdbxDataProcessingReflnsBuilder> enterNumberMarkedReject() {
            return new IntColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "number_marked_reject", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingReflnsBuilder> enterPercentMarkedReject() {
            return new FloatColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "percent_marked_reject", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingReflnsBuilder> enterPercentRejected() {
            return new FloatColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "percent_rejected", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingReflnsBuilder> enterRFactorAllLinear() {
            return new FloatColumnBuilder<PdbxDataProcessingReflnsBuilder>(CATEGORY_NAME, "R_factor_all_linear", this);
        }
    }

    public static class PdbxDataProcessingCellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_data_processing_cell";

        public PdbxDataProcessingCellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDataProcessingCellBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterA() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "a", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterATolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "a_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterB() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "b", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterBTolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "b_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterC() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "c", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterCTolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "c_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterAlpha() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "alpha", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterAlphaTolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "alpha_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterBeta() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "beta", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterBetaTolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "beta_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterGamma() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "gamma", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterGammaTolerance() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "gamma_tolerance", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterVolume() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "volume", this);
        }

        public FloatColumnBuilder<PdbxDataProcessingCellBuilder> enterMosaicity() {
            return new FloatColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "mosaicity", this);
        }

        public StrColumnBuilder<PdbxDataProcessingCellBuilder> enterResolutionRange() {
            return new StrColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "resolution_range", this);
        }

        public StrColumnBuilder<PdbxDataProcessingCellBuilder> enterSpaceGroup() {
            return new StrColumnBuilder<PdbxDataProcessingCellBuilder>(CATEGORY_NAME, "space_group", this);
        }
    }

    public static class PdbxMissingResidueListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_missing_residue_list";

        public PdbxMissingResidueListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxMissingResidueListBuilder> enterPdbModelId() {
            return new IntColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "pdb_model_id", this);
        }

        public StrColumnBuilder<PdbxMissingResidueListBuilder> enterPdbChainId() {
            return new StrColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "pdb_chain_id", this);
        }

        public StrColumnBuilder<PdbxMissingResidueListBuilder> enterPdbResidueName() {
            return new StrColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "pdb_residue_name", this);
        }

        public StrColumnBuilder<PdbxMissingResidueListBuilder> enterPdbResidueNumber() {
            return new StrColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "pdb_residue_number", this);
        }

        public StrColumnBuilder<PdbxMissingResidueListBuilder> enterPdbInsertionCode() {
            return new StrColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "pdb_insertion_code", this);
        }

        public IntColumnBuilder<PdbxMissingResidueListBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxMissingResidueListBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }
    }

    public static class PdbxStructLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_link";

        public PdbxStructLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelAltId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelAsymId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelAtomId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelCompId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelSeqId() {
            return new IntColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1LabelInsCode() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_label_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr1Symmetry() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr1_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelAltId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelAsymId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelAtomId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelCompId() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelSeqId() {
            return new IntColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2LabelInsCode() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_label_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterPtnr2Symmetry() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "ptnr2_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<PdbxStructLinkBuilder> enterPdbxDistValue() {
            return new FloatColumnBuilder<PdbxStructLinkBuilder>(CATEGORY_NAME, "pdbx_dist_value", this);
        }
    }

    public static class PdbxPostProcessStatusBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_post_process_status";

        public PdbxPostProcessStatusBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterCycleId() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "cycle_id", this);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterDateBegin() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "date_begin", this);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterDateEnd() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "date_end", this);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxPostProcessStatusBuilder> enterAnnotator() {
            return new StrColumnBuilder<PdbxPostProcessStatusBuilder>(CATEGORY_NAME, "annotator", this);
        }
    }

    public static class PdbxPostProcessDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_post_process_details";

        public PdbxPostProcessDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPostProcessDetailsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPostProcessDetailsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPostProcessDetailsBuilder> enterText() {
            return new StrColumnBuilder<PdbxPostProcessDetailsBuilder>(CATEGORY_NAME, "text", this);
        }

        public StrColumnBuilder<PdbxPostProcessDetailsBuilder> enterSeqDetails() {
            return new StrColumnBuilder<PdbxPostProcessDetailsBuilder>(CATEGORY_NAME, "seq_details", this);
        }
    }

    public static class PdbxSequenceAnnotationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_sequence_annotation";

        public PdbxSequenceAnnotationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSequenceAnnotationBuilder> enterPdbChainId() {
            return new StrColumnBuilder<PdbxSequenceAnnotationBuilder>(CATEGORY_NAME, "pdb_chain_id", this);
        }

        public StrColumnBuilder<PdbxSequenceAnnotationBuilder> enterNcbiTaxid() {
            return new StrColumnBuilder<PdbxSequenceAnnotationBuilder>(CATEGORY_NAME, "ncbi_taxid", this);
        }
    }

    public static class PdbxStructNcsVirusGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ncs_virus_gen";

        public PdbxStructNcsVirusGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructNcsVirusGenBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructNcsVirusGenBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructNcsVirusGenBuilder> enterOperId() {
            return new StrColumnBuilder<PdbxStructNcsVirusGenBuilder>(CATEGORY_NAME, "oper_id", this);
        }

        public StrColumnBuilder<PdbxStructNcsVirusGenBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructNcsVirusGenBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructNcsVirusGenBuilder> enterPdbChainId() {
            return new StrColumnBuilder<PdbxStructNcsVirusGenBuilder>(CATEGORY_NAME, "pdb_chain_id", this);
        }
    }

    public static class PdbxRefineLsRestrNcsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_ls_restr_ncs";

        public PdbxRefineLsRestrNcsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineLsRestrNcsBuilder> enterDomId() {
            return new StrColumnBuilder<PdbxRefineLsRestrNcsBuilder>(CATEGORY_NAME, "dom_id", this);
        }

        public StrColumnBuilder<PdbxRefineLsRestrNcsBuilder> enterType() {
            return new StrColumnBuilder<PdbxRefineLsRestrNcsBuilder>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxRefineLsRestrNcsBuilder> enterNumber() {
            return new IntColumnBuilder<PdbxRefineLsRestrNcsBuilder>(CATEGORY_NAME, "number", this);
        }

        public FloatColumnBuilder<PdbxRefineLsRestrNcsBuilder> enterRmsDev() {
            return new FloatColumnBuilder<PdbxRefineLsRestrNcsBuilder>(CATEGORY_NAME, "rms_dev", this);
        }

        public FloatColumnBuilder<PdbxRefineLsRestrNcsBuilder> enterWeight() {
            return new FloatColumnBuilder<PdbxRefineLsRestrNcsBuilder>(CATEGORY_NAME, "weight", this);
        }
    }

    public static class PdbxUnpairBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_unpair";

        public PdbxUnpairBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxUnpairBuilder> enterChainId() {
            return new StrColumnBuilder<PdbxUnpairBuilder>(CATEGORY_NAME, "chain_id", this);
        }

        public StrColumnBuilder<PdbxUnpairBuilder> enterResidueName() {
            return new StrColumnBuilder<PdbxUnpairBuilder>(CATEGORY_NAME, "residue_name", this);
        }

        public StrColumnBuilder<PdbxUnpairBuilder> enterResidueNumber() {
            return new StrColumnBuilder<PdbxUnpairBuilder>(CATEGORY_NAME, "residue_number", this);
        }
    }

    public static class PdbxTrnaInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_trna_info";

        public PdbxTrnaInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxTrnaInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxTrnaInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxTrnaInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxTrnaInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxTrnaInfoBuilder> enterNumPerAsymUnit() {
            return new IntColumnBuilder<PdbxTrnaInfoBuilder>(CATEGORY_NAME, "num_per_asym_unit", this);
        }
    }

    public static class PdbxStructPackGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_pack_gen";

        public PdbxStructPackGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructPackGenBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructPackGenBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructPackGenBuilder> enterSymmetry() {
            return new StrColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "symmetry", this);
        }

        public FloatColumnBuilder<PdbxStructPackGenBuilder> enterColorRed() {
            return new FloatColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "color_red", this);
        }

        public FloatColumnBuilder<PdbxStructPackGenBuilder> enterColorGreen() {
            return new FloatColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "color_green", this);
        }

        public FloatColumnBuilder<PdbxStructPackGenBuilder> enterColorBlue() {
            return new FloatColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "color_blue", this);
        }

        public IntColumnBuilder<PdbxStructPackGenBuilder> enterCrystalType() {
            return new IntColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "crystal_type", this);
        }

        public IntColumnBuilder<PdbxStructPackGenBuilder> enterPackingType() {
            return new IntColumnBuilder<PdbxStructPackGenBuilder>(CATEGORY_NAME, "packing_type", this);
        }
    }

    public static class PdbxStructBiolFuncBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_biol_func";

        public PdbxStructBiolFuncBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructBiolFuncBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructBiolFuncBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructBiolFuncBuilder> enterBiolId() {
            return new StrColumnBuilder<PdbxStructBiolFuncBuilder>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<PdbxStructBiolFuncBuilder> enterFunction() {
            return new StrColumnBuilder<PdbxStructBiolFuncBuilder>(CATEGORY_NAME, "function", this);
        }
    }

    public static class PdbxSourceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_source";

        public PdbxSourceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSourceBuilder> enterSrcMethod() {
            return new StrColumnBuilder<PdbxSourceBuilder>(CATEGORY_NAME, "src_method", this);
        }
    }

    public static class PdbxSolventInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_solvent_info";

        public PdbxSolventInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolventInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxSolventInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolventInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxSolventInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxSolventInfoBuilder> enterNumbPerAsymUnit() {
            return new IntColumnBuilder<PdbxSolventInfoBuilder>(CATEGORY_NAME, "numb_per_asym_unit", this);
        }
    }

    public static class PdbxProteinInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_protein_info";

        public PdbxProteinInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxProteinInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxProteinInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxProteinInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxProteinInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxProteinInfoBuilder> enterNumPerAsymUnit() {
            return new IntColumnBuilder<PdbxProteinInfoBuilder>(CATEGORY_NAME, "num_per_asym_unit", this);
        }
    }

    public static class PdbxPdbSourceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_pdb_source";

        public PdbxPdbSourceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPdbSourceBuilder> enterId() {
            return new StrColumnBuilder<PdbxPdbSourceBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxPdbSourceBuilder> enterText() {
            return new StrColumnBuilder<PdbxPdbSourceBuilder>(CATEGORY_NAME, "text", this);
        }
    }

    public static class PdbxPdbCompndBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_pdb_compnd";

        public PdbxPdbCompndBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPdbCompndBuilder> enterId() {
            return new StrColumnBuilder<PdbxPdbCompndBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxPdbCompndBuilder> enterText() {
            return new StrColumnBuilder<PdbxPdbCompndBuilder>(CATEGORY_NAME, "text", this);
        }
    }

    public static class PdbxNonstandardListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nonstandard_list";

        public PdbxNonstandardListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterId() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterLabelSeqNum() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "label_seq_num", this);
        }

        public IntColumnBuilder<PdbxNonstandardListBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxNonstandardListBuilder> enterInsCode() {
            return new StrColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "ins_code", this);
        }

        public IntColumnBuilder<PdbxNonstandardListBuilder> enterNumberAtomsNh() {
            return new IntColumnBuilder<PdbxNonstandardListBuilder>(CATEGORY_NAME, "number_atoms_nh", this);
        }
    }

    public static class PdbxNaStrandInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_na_strand_info";

        public PdbxNaStrandInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNaStrandInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxNaStrandInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxNaStrandInfoBuilder> enterNumOfNAStrandsPerAsymUnit() {
            return new IntColumnBuilder<PdbxNaStrandInfoBuilder>(CATEGORY_NAME, "num_of_NA_strands_per_asym_unit", this);
        }

        public IntColumnBuilder<PdbxNaStrandInfoBuilder> enterNumOfNAStrandsPerBiolUnit() {
            return new IntColumnBuilder<PdbxNaStrandInfoBuilder>(CATEGORY_NAME, "num_of_NA_strands_per_biol_unit", this);
        }

        public StrColumnBuilder<PdbxNaStrandInfoBuilder> enterFractNAStrandPerAsymUnit() {
            return new StrColumnBuilder<PdbxNaStrandInfoBuilder>(CATEGORY_NAME, "fract_NA_strand_per_asym_unit", this);
        }
    }

    public static class PdbxHybridBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_hybrid";

        public PdbxHybridBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxHybridBuilder> enterId() {
            return new StrColumnBuilder<PdbxHybridBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxHybridBuilder> enterSugarName() {
            return new StrColumnBuilder<PdbxHybridBuilder>(CATEGORY_NAME, "sugar_name", this);
        }

        public StrColumnBuilder<PdbxHybridBuilder> enterStrandId() {
            return new StrColumnBuilder<PdbxHybridBuilder>(CATEGORY_NAME, "strand_id", this);
        }

        public StrColumnBuilder<PdbxHybridBuilder> enterResidueNames() {
            return new StrColumnBuilder<PdbxHybridBuilder>(CATEGORY_NAME, "residue_names", this);
        }
    }

    public static class PdbxIonInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_ion_info";

        public PdbxIonInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxIonInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxIonInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxIonInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxIonInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxIonInfoBuilder> enterNumbPerAsymUnit() {
            return new IntColumnBuilder<PdbxIonInfoBuilder>(CATEGORY_NAME, "numb_per_asym_unit", this);
        }
    }

    public static class PdbxInhibitorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_inhibitor_info";

        public PdbxInhibitorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxInhibitorInfoBuilder> enterId() {
            return new IntColumnBuilder<PdbxInhibitorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxInhibitorInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxInhibitorInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxInhibitorInfoBuilder> enterNumPerAsymUnit() {
            return new IntColumnBuilder<PdbxInhibitorInfoBuilder>(CATEGORY_NAME, "num_per_asym_unit", this);
        }
    }

    public static class PdbxDrugInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_drug_info";

        public PdbxDrugInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDrugInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxDrugInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxDrugInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxDrugInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<PdbxDrugInfoBuilder> enterNumPerAsymUnit() {
            return new IntColumnBuilder<PdbxDrugInfoBuilder>(CATEGORY_NAME, "num_per_asym_unit", this);
        }

        public IntColumnBuilder<PdbxDrugInfoBuilder> enterNumOfWholeMolecule() {
            return new IntColumnBuilder<PdbxDrugInfoBuilder>(CATEGORY_NAME, "num_of_whole_molecule", this);
        }

        public StrColumnBuilder<PdbxDrugInfoBuilder> enterSizeOfMoleculePerAsymUnit() {
            return new StrColumnBuilder<PdbxDrugInfoBuilder>(CATEGORY_NAME, "size_of_molecule_per_asym_unit", this);
        }
    }

    public static class PdbxDbrefBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_dbref";

        public PdbxDbrefBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterPdbIdCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "pdb_id_code", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterChainId() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "chain_id", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterBeginResNumber() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "begin_res_number", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterBeginInsCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "begin_ins_code", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterEndResNumber() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "end_res_number", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterEndInsCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "end_ins_code", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseName() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_name", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseAccession() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_accession", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseIdCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_id_code", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseBeginResNumber() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_begin_res_number", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseBeginInsCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_begin_ins_code", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseEndResNumber() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_end_res_number", this);
        }

        public StrColumnBuilder<PdbxDbrefBuilder> enterDatabaseEndInsCode() {
            return new StrColumnBuilder<PdbxDbrefBuilder>(CATEGORY_NAME, "database_end_ins_code", this);
        }
    }

    public static class PdbxDatabasePdbOmitBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_pdb_omit";

        public PdbxDatabasePdbOmitBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabasePdbOmitBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDatabasePdbOmitBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabasePdbOmitBuilder> enterRecordName() {
            return new StrColumnBuilder<PdbxDatabasePdbOmitBuilder>(CATEGORY_NAME, "record_name", this);
        }
    }

    public static class PdbxDatabasePDBMasterBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_PDB_master";

        public PdbxDatabasePDBMasterBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabasePDBMasterBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumRemark() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_remark", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumFtnote() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_ftnote", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumHet() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_het", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumHelix() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_helix", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumSheet() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_sheet", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumTurn() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_turn", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumSite() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_site", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumTrans() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_trans", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumCoord() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_coord", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumTer() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_ter", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumConect() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_conect", this);
        }

        public IntColumnBuilder<PdbxDatabasePDBMasterBuilder> enterNumSeqres() {
            return new IntColumnBuilder<PdbxDatabasePDBMasterBuilder>(CATEGORY_NAME, "num_seqres", this);
        }
    }

    public static class PdbxConnectAtomBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_connect_atom";

        public PdbxConnectAtomBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConnectAtomBuilder> enterResName() {
            return new StrColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "res_name", this);
        }

        public StrColumnBuilder<PdbxConnectAtomBuilder> enterAtomName() {
            return new StrColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "atom_name", this);
        }

        public StrColumnBuilder<PdbxConnectAtomBuilder> enterConnectTo() {
            return new StrColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "connect_to", this);
        }

        public StrColumnBuilder<PdbxConnectAtomBuilder> enterTypeSymbol() {
            return new StrColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "type_symbol", this);
        }

        public IntColumnBuilder<PdbxConnectAtomBuilder> enterCharge() {
            return new IntColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "charge", this);
        }

        public StrColumnBuilder<PdbxConnectAtomBuilder> enterBondType() {
            return new StrColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "bond_type", this);
        }

        public IntColumnBuilder<PdbxConnectAtomBuilder> enterAlignPos() {
            return new IntColumnBuilder<PdbxConnectAtomBuilder>(CATEGORY_NAME, "align_pos", this);
        }
    }

    public static class PdbxConnectModificationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_connect_modification";

        public PdbxConnectModificationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConnectModificationBuilder> enterResName() {
            return new StrColumnBuilder<PdbxConnectModificationBuilder>(CATEGORY_NAME, "res_name", this);
        }

        public StrColumnBuilder<PdbxConnectModificationBuilder> enterModification() {
            return new StrColumnBuilder<PdbxConnectModificationBuilder>(CATEGORY_NAME, "modification", this);
        }
    }

    public static class PdbxConnectTypeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_connect_type";

        public PdbxConnectTypeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConnectTypeBuilder> enterResName() {
            return new StrColumnBuilder<PdbxConnectTypeBuilder>(CATEGORY_NAME, "res_name", this);
        }

        public StrColumnBuilder<PdbxConnectTypeBuilder> enterNdbTokenType() {
            return new StrColumnBuilder<PdbxConnectTypeBuilder>(CATEGORY_NAME, "ndbTokenType", this);
        }

        public StrColumnBuilder<PdbxConnectTypeBuilder> enterModified() {
            return new StrColumnBuilder<PdbxConnectTypeBuilder>(CATEGORY_NAME, "modified", this);
        }
    }

    public static class PdbxConnectBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_connect";

        public PdbxConnectBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterResName() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "res_name", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterHetgroupName() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "hetgroup_name", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterFormul() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "formul", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterHetgroupChemicalName() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "hetgroup_chemical_name", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterParentResidue() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "parent_residue", this);
        }

        public IntColumnBuilder<PdbxConnectBuilder> enterFormalCharge() {
            return new IntColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "formal_charge", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterClass1() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "class_1", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterClass2() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "class_2", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterType() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterStatus() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "status", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterDate() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxConnectBuilder> enterModifiedDate() {
            return new StrColumnBuilder<PdbxConnectBuilder>(CATEGORY_NAME, "modified_date", this);
        }
    }

    public static class PdbxCoordBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_coord";

        public PdbxCoordBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxCoordBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxCoordBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxCoordBuilder> enterChainAtomsYP() {
            return new StrColumnBuilder<PdbxCoordBuilder>(CATEGORY_NAME, "chain_atoms_Y_P", this);
        }

        public StrColumnBuilder<PdbxCoordBuilder> enterHydrogenAtomsYN() {
            return new StrColumnBuilder<PdbxCoordBuilder>(CATEGORY_NAME, "hydrogen_atoms_Y_N", this);
        }

        public StrColumnBuilder<PdbxCoordBuilder> enterSolventAtomsYN() {
            return new StrColumnBuilder<PdbxCoordBuilder>(CATEGORY_NAME, "solvent_atoms_Y_N", this);
        }

        public StrColumnBuilder<PdbxCoordBuilder> enterStructureFactorsYN() {
            return new StrColumnBuilder<PdbxCoordBuilder>(CATEGORY_NAME, "structure_factors_Y_N", this);
        }
    }

    public static class PdbxViewItemBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_view_item";

        public PdbxViewItemBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxViewItemBuilder> enterItemName() {
            return new StrColumnBuilder<PdbxViewItemBuilder>(CATEGORY_NAME, "item_name", this);
        }

        public StrColumnBuilder<PdbxViewItemBuilder> enterCategoryId() {
            return new StrColumnBuilder<PdbxViewItemBuilder>(CATEGORY_NAME, "category_id", this);
        }

        public StrColumnBuilder<PdbxViewItemBuilder> enterItemViewName() {
            return new StrColumnBuilder<PdbxViewItemBuilder>(CATEGORY_NAME, "item_view_name", this);
        }

        public StrColumnBuilder<PdbxViewItemBuilder> enterItemViewMandatoryCode() {
            return new StrColumnBuilder<PdbxViewItemBuilder>(CATEGORY_NAME, "item_view_mandatory_code", this);
        }

        public StrColumnBuilder<PdbxViewItemBuilder> enterItemViewAllowAlternateValue() {
            return new StrColumnBuilder<PdbxViewItemBuilder>(CATEGORY_NAME, "item_view_allow_alternate_value", this);
        }
    }

    public static class PdbxViewCategoryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_view_category";

        public PdbxViewCategoryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxViewCategoryBuilder> enterViewGroupId() {
            return new StrColumnBuilder<PdbxViewCategoryBuilder>(CATEGORY_NAME, "view_group_id", this);
        }

        public StrColumnBuilder<PdbxViewCategoryBuilder> enterCategoryId() {
            return new StrColumnBuilder<PdbxViewCategoryBuilder>(CATEGORY_NAME, "category_id", this);
        }

        public StrColumnBuilder<PdbxViewCategoryBuilder> enterCategoryViewName() {
            return new StrColumnBuilder<PdbxViewCategoryBuilder>(CATEGORY_NAME, "category_view_name", this);
        }
    }

    public static class PdbxViewCategoryGroupBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_view_category_group";

        public PdbxViewCategoryGroupBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxViewCategoryGroupBuilder> enterViewGroupId() {
            return new StrColumnBuilder<PdbxViewCategoryGroupBuilder>(CATEGORY_NAME, "view_group_id", this);
        }

        public StrColumnBuilder<PdbxViewCategoryGroupBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxViewCategoryGroupBuilder>(CATEGORY_NAME, "description", this);
        }
    }

    public static class PdbxChemCompModelReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_reference";

        public PdbxChemCompModelReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelReferenceBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelReferenceBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelReferenceBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxChemCompModelReferenceBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxChemCompModelReferenceBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxChemCompModelReferenceBuilder>(CATEGORY_NAME, "db_code", this);
        }
    }

    public static class PdbxChemCompModelAuditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_audit";

        public PdbxChemCompModelAuditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterDate() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterAnnotator() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterProcessingSite() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAuditBuilder> enterActionType() {
            return new StrColumnBuilder<PdbxChemCompModelAuditBuilder>(CATEGORY_NAME, "action_type", this);
        }
    }

    public static class PdbxChemCompModelDescriptorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_descriptor";

        public PdbxChemCompModelDescriptorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelDescriptorBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelDescriptorBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelDescriptorBuilder> enterDescriptor() {
            return new StrColumnBuilder<PdbxChemCompModelDescriptorBuilder>(CATEGORY_NAME, "descriptor", this);
        }

        public StrColumnBuilder<PdbxChemCompModelDescriptorBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompModelDescriptorBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxChemCompModelFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_feature";

        public PdbxChemCompModelFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelFeatureBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelFeatureBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelFeatureBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxChemCompModelFeatureBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxChemCompModelFeatureBuilder> enterFeatureValue() {
            return new StrColumnBuilder<PdbxChemCompModelFeatureBuilder>(CATEGORY_NAME, "feature_value", this);
        }
    }

    public static class PdbxChemCompModelBondBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_bond";

        public PdbxChemCompModelBondBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelBondBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxChemCompModelBondBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxChemCompModelBondBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxChemCompModelBondBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxChemCompModelBondBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelBondBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelBondBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxChemCompModelBondBuilder>(CATEGORY_NAME, "value_order", this);
        }

        public IntColumnBuilder<PdbxChemCompModelBondBuilder> enterOrdinalId() {
            return new IntColumnBuilder<PdbxChemCompModelBondBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }
    }

    public static class PdbxChemCompModelAtomBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model_atom";

        public PdbxChemCompModelAtomBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelAtomBuilder> enterAtomId() {
            return new StrColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "atom_id", this);
        }

        public IntColumnBuilder<PdbxChemCompModelAtomBuilder> enterOrdinalId() {
            return new IntColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "ordinal_id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAtomBuilder> enterModelId() {
            return new StrColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "model_id", this);
        }

        public IntColumnBuilder<PdbxChemCompModelAtomBuilder> enterCharge() {
            return new IntColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "charge", this);
        }

        public FloatColumnBuilder<PdbxChemCompModelAtomBuilder> enterModelCartnX() {
            return new FloatColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "model_Cartn_x", this);
        }

        public FloatColumnBuilder<PdbxChemCompModelAtomBuilder> enterModelCartnY() {
            return new FloatColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "model_Cartn_y", this);
        }

        public FloatColumnBuilder<PdbxChemCompModelAtomBuilder> enterModelCartnZ() {
            return new FloatColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "model_Cartn_z", this);
        }

        public StrColumnBuilder<PdbxChemCompModelAtomBuilder> enterTypeSymbol() {
            return new StrColumnBuilder<PdbxChemCompModelAtomBuilder>(CATEGORY_NAME, "type_symbol", this);
        }
    }

    public static class PdbxChemCompModelBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_model";

        public PdbxChemCompModelBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompModelBuilder> enterId() {
            return new StrColumnBuilder<PdbxChemCompModelBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxChemCompModelBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompModelBuilder>(CATEGORY_NAME, "comp_id", this);
        }
    }

    public static class PdbxEntitySrcGenDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_depositor_info";

        public PdbxEntitySrcGenDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterSrcId() {
            return new IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "src_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterSeqType() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "seq_type", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterBegSeqNum() {
            return new IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "beg_seq_num", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterEndSeqNum() {
            return new IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "end_seq_num", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterGeneSrcGene() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "gene_src_gene", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterGeneSrcScientificName() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "gene_src_scientific_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterHostOrgGene() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "host_org_gene", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterHostOrgScientificName() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "host_org_scientific_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterHostOrgStrain() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "host_org_strain", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterGeneSrcNcbiTaxonomyId() {
            return new IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "gene_src_ncbi_taxonomy_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterHostOrgNcbiTaxonomyId() {
            return new IntColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "host_org_ncbi_taxonomy_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterHostOrgVectorType() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "host_org_vector_type", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder> enterPlasmidName() {
            return new StrColumnBuilder<PdbxEntitySrcGenDepositorInfoBuilder>(CATEGORY_NAME, "plasmid_name", this);
        }
    }

    public static class PdbxEntityInstanceFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_instance_feature";

        public PdbxEntityInstanceFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterAuthSeqNum() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public IntColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterSeqNum() {
            return new IntColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public IntColumnBuilder<PdbxEntityInstanceFeatureBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxEntityInstanceFeatureBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxDataProcessingStatusBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_data_processing_status";

        public PdbxDataProcessingStatusBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDataProcessingStatusBuilder> enterTaskName() {
            return new StrColumnBuilder<PdbxDataProcessingStatusBuilder>(CATEGORY_NAME, "task_name", this);
        }

        public StrColumnBuilder<PdbxDataProcessingStatusBuilder> enterStatus() {
            return new StrColumnBuilder<PdbxDataProcessingStatusBuilder>(CATEGORY_NAME, "status", this);
        }
    }

    public static class PdbxDepuiEntryDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_entry_details";

        public PdbxDepuiEntryDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterDepDatasetId() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "dep_dataset_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterWwpdbSiteId() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "wwpdb_site_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterExperimentalMethods() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "experimental_methods", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterRequestedAccessionTypes() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "requested_accession_types", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterValidatedContactEmail() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "validated_contact_email", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterCountry() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterStructuralGenomicsFlag() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "structural_genomics_flag", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterRelatedDatabaseName() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "related_database_name", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterRelatedDatabaseCode() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "related_database_code", this);
        }

        public StrColumnBuilder<PdbxDepuiEntryDetailsBuilder> enterReplacePdbId() {
            return new StrColumnBuilder<PdbxDepuiEntryDetailsBuilder>(CATEGORY_NAME, "replace_pdb_id", this);
        }
    }

    public static class PdbxDepositionMessageFileReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_deposition_message_file_reference";

        public PdbxDepositionMessageFileReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterDepositionDataSetId() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "deposition_data_set_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterMessageId() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "message_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterContentType() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "content_type", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterContentFormat() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "content_format", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterPartitionNumber() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "partition_number", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterVersionId() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "version_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder> enterStorageType() {
            return new StrColumnBuilder<PdbxDepositionMessageFileReferenceBuilder>(CATEGORY_NAME, "storage_type", this);
        }
    }

    public static class PdbxDepositionMessageInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_deposition_message_info";

        public PdbxDepositionMessageInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDepositionMessageInfoBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterDepositionDataSetId() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "deposition_data_set_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterMessageId() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "message_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterTimestamp() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "timestamp", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterSender() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "sender", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterContentType() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "content_type", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterContentValue() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "content_value", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterParentMessageId() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "parent_message_id", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterMessageSubject() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "message_subject", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterMessageText() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "message_text", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterMessageType() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "message_type", this);
        }

        public StrColumnBuilder<PdbxDepositionMessageInfoBuilder> enterSendStatus() {
            return new StrColumnBuilder<PdbxDepositionMessageInfoBuilder>(CATEGORY_NAME, "send_status", this);
        }
    }

    public static class PdbxDepuiEntityFeaturesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_entity_features";

        public PdbxDepuiEntityFeaturesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder> enterDepDatasetId() {
            return new StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder>(CATEGORY_NAME, "dep_dataset_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder> enterType() {
            return new StrColumnBuilder<PdbxDepuiEntityFeaturesBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxDepuiEntityStatusFlagsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_entity_status_flags";

        public PdbxDepuiEntityStatusFlagsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder> enterDepDatasetId() {
            return new StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder>(CATEGORY_NAME, "dep_dataset_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder> enterHasMutation() {
            return new StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder>(CATEGORY_NAME, "has_mutation", this);
        }

        public StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder> enterSampleXyzSequenceAlignmentsValid() {
            return new StrColumnBuilder<PdbxDepuiEntityStatusFlagsBuilder>(CATEGORY_NAME, "sample_xyz_sequence_alignments_valid", this);
        }
    }

    public static class PdbxChemCompUploadDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_upload_depositor_info";

        public PdbxChemCompUploadDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder> enterUploadFileType() {
            return new StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_type", this);
        }

        public StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<PdbxChemCompUploadDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }
    }

    public static class PdbxDepuiValidationStatusFlagsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_validation_status_flags";

        public PdbxDepuiValidationStatusFlagsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterDepDatasetId() {
            return new StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "dep_dataset_id", this);
        }

        public StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterResidualBFactorsFlag() {
            return new StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "residual_B_factors_flag", this);
        }

        public IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterOccupancyOutliersLow() {
            return new IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "occupancy_outliers_low", this);
        }

        public IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterOccupancyOutliersHigh() {
            return new IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "occupancy_outliers_high", this);
        }

        public IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterAdpOutliersLow() {
            return new IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "adp_outliers_low", this);
        }

        public IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterSolventOutliers() {
            return new IntColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "solvent_outliers", this);
        }

        public StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterTlsNoAniso() {
            return new StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "tls_no_aniso", this);
        }

        public StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder> enterAdpOutliersZero() {
            return new StrColumnBuilder<PdbxDepuiValidationStatusFlagsBuilder>(CATEGORY_NAME, "adp_outliers_zero", this);
        }
    }

    public static class PdbxDepuiUploadBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_upload";

        public PdbxDepuiUploadBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDepuiUploadBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterFileContentType() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "file_content_type", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterFileType() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "file_type", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterFileName() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "file_name", this);
        }

        public IntColumnBuilder<PdbxDepuiUploadBuilder> enterFileSize() {
            return new IntColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "file_size", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterValidFlag() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "valid_flag", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterDiagnosticMessage() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "diagnostic_message", this);
        }

        public StrColumnBuilder<PdbxDepuiUploadBuilder> enterSequenceAlign() {
            return new StrColumnBuilder<PdbxDepuiUploadBuilder>(CATEGORY_NAME, "sequence_align", this);
        }
    }

    public static class PdbxDepuiStatusFlagsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_depui_status_flags";

        public PdbxDepuiStatusFlagsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterDepDatasetId() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "dep_dataset_id", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterPrimaryCitationStatus() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "primary_citation_status", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterCorrespondingAuthorStatus() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "corresponding_author_status", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterReferenceCitationStatus() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "reference_citation_status", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterIsGrantFunded() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "is_grant_funded", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasNcsData() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_ncs_data", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterPredictionTarget() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "prediction_target", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasHelicalSymmetry() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_helical_symmetry", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasPointSymmetry() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_point_symmetry", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasCyclicSymmetry() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_cyclic_symmetry", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasAcceptedTermsAndConditions() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_accepted_terms_and_conditions", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasViewedValidationReport() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_viewed_validation_report", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterValidatedModelFileName() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "validated_model_file_name", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterMergePriorModelFileName() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "merge_prior_model_file_name", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterMergeReplaceModelFileName() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "merge_replace_model_file_name", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterMergeOutputModelFileName() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "merge_output_model_file_name", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterIsLigandProcessingComplete() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "is_ligand_processing_complete", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterSampleXyzSequenceAlignmentsValid() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "sample_xyz_sequence_alignments_valid", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterHasSasData() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "has_sas_data", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterIsSasDeposited() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "is_sas_deposited", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterUseSasRefine() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "use_sas_refine", this);
        }

        public StrColumnBuilder<PdbxDepuiStatusFlagsBuilder> enterMergedFail() {
            return new StrColumnBuilder<PdbxDepuiStatusFlagsBuilder>(CATEGORY_NAME, "merged_fail", this);
        }
    }

    public static class PdbxChemCompInstanceDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_instance_depositor_info";

        public PdbxChemCompInstanceDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterInPolymerFlag() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "in_polymer_flag", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterAuthorProvidedFlag() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "author_provided_flag", this);
        }

        public StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder> enterFormula() {
            return new StrColumnBuilder<PdbxChemCompInstanceDepositorInfoBuilder>(CATEGORY_NAME, "formula", this);
        }
    }

    public static class PdbxMoleculeFeaturesDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_molecule_features_depositor_info";

        public PdbxMoleculeFeaturesDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder> enterType() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxSolventAtomSiteMappingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_solvent_atom_site_mapping";

        public PdbxSolventAtomSiteMappingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreAuthAsymId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreAuthAtomId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreAuthCompId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreAuthSeqId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPrePDBInsCode() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreAuthAltId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterAuthAltId() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_alt_id", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterOccupancy() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterCartnX() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterCartnY() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterCartnZ() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreCartnX() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_Cartn_x", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreCartnY() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_Cartn_y", this);
        }

        public FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterPreCartnZ() {
            return new FloatColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_Cartn_z", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterSymmetry() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "symmetry", this);
        }

        public StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder> enterSymmetryAsXyz() {
            return new StrColumnBuilder<PdbxSolventAtomSiteMappingBuilder>(CATEGORY_NAME, "symmetry_as_xyz", this);
        }
    }

    public static class PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_auth_evidence_depositor_info";

        public PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder> enterExperimentalSupport() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder>(CATEGORY_NAME, "experimental_support", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyAuthEvidenceDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxHelicalSymmetryDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_helical_symmetry_depositor_info";

        public PdbxHelicalSymmetryDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterNumberOfOperations() {
            return new IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "number_of_operations", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterRotationPerNSubunits() {
            return new FloatColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "rotation_per_n_subunits", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterRisePerNSubunits() {
            return new FloatColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "rise_per_n_subunits", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterNSubunitsDivisor() {
            return new IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "n_subunits_divisor", this);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterDyadAxis() {
            return new StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "dyad_axis", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterCircularSymmetry() {
            return new IntColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "circular_symmetry", this);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder> enterStatusFlag() {
            return new StrColumnBuilder<PdbxHelicalSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "status_flag", this);
        }
    }

    public static class PdbxPointSymmetryDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_point_symmetry_depositor_info";

        public PdbxPointSymmetryDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder> enterSchoenfliesSymbol() {
            return new StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "Schoenflies_symbol", this);
        }

        public IntColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder> enterCircularSymmetry() {
            return new IntColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "circular_symmetry", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder> enterH_MNotation() {
            return new StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "H-M_notation", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder> enterStatusFlag() {
            return new StrColumnBuilder<PdbxPointSymmetryDepositorInfoBuilder>(CATEGORY_NAME, "status_flag", this);
        }
    }

    public static class PdbxStructOperListDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_oper_list_depositor_info";

        public PdbxStructOperListDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterSymmetryOperation() {
            return new StrColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "symmetry_operation", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix11() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix12() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix13() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix21() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix22() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix23() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix31() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix32() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterMatrix33() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterVector1() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterVector2() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder> enterVector3() {
            return new FloatColumnBuilder<PdbxStructOperListDepositorInfoBuilder>(CATEGORY_NAME, "vector[3]", this);
        }
    }

    public static class PdbxStructAssemblyGenDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_gen_depositor_info";

        public PdbxStructAssemblyGenDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterAsymIdList() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "asym_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterOperExpression() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "oper_expression", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterFullMatrices() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "full_matrices", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterSymmetryOperation() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "symmetry_operation", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterAtUnitMatrix() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "at_unit_matrix", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterChainIdList() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "chain_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterAllChains() {
            return new StrColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "all_chains", this);
        }

        public FloatColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterHelicalRotation() {
            return new FloatColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "helical_rotation", this);
        }

        public FloatColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder> enterHelicalRise() {
            return new FloatColumnBuilder<PdbxStructAssemblyGenDepositorInfoBuilder>(CATEGORY_NAME, "helical_rise", this);
        }
    }

    public static class PdbxStructAssemblyDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_depositor_info";

        public PdbxStructAssemblyDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterMethodDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "method_details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterOligomericDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "oligomeric_details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterOligomericCount() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "oligomeric_count", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterMatrixFlag() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "matrix_flag", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<PdbxStructAssemblyDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }
    }

    public static class PdbxStructAssemblyPropDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_prop_depositor_info";

        public PdbxStructAssemblyPropDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder> enterBiolId() {
            return new StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder> enterValue() {
            return new StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyPropDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxStructRefSeqDifDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_dif_depositor_info";

        public PdbxStructRefSeqDifDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterRefId() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "ref_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDbMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "db_mon_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDbSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "db_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterAuthMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "auth_mon_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterAuthSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDbAccession() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "db_accession", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder> enterAnnotation() {
            return new StrColumnBuilder<PdbxStructRefSeqDifDepositorInfoBuilder>(CATEGORY_NAME, "annotation", this);
        }
    }

    public static class PdbxStructRefSeqDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_depositor_info";

        public PdbxStructRefSeqDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterRefId() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "ref_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbAlignBeg() {
            return new IntColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_align_beg", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbAlignEnd() {
            return new IntColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_align_end", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbAccession() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_accession", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterDbSeqOneLetterCode() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "db_seq_one_letter_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterSeqAlignBegin() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "seq_align_begin", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder> enterSeqAlignEnd() {
            return new StrColumnBuilder<PdbxStructRefSeqDepositorInfoBuilder>(CATEGORY_NAME, "seq_align_end", this);
        }
    }

    public static class PdbxChemCompDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_depositor_info";

        public PdbxChemCompDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterAltCompId() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "alt_comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterName() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterFormula() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterDescriptor() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "descriptor", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterDescriptorType() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "descriptor_type", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterInDictionaryFlag() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "in_dictionary_flag", this);
        }

        public StrColumnBuilder<PdbxChemCompDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxChemCompDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxSeqMapDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_seq_map_depositor_info";

        public PdbxSeqMapDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder> enterOneLetterCode() {
            return new StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder>(CATEGORY_NAME, "one_letter_code", this);
        }

        public StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder> enterOneLetterCodeMod() {
            return new StrColumnBuilder<PdbxSeqMapDepositorInfoBuilder>(CATEGORY_NAME, "one_letter_code_mod", this);
        }
    }

    public static class EmStructureFactorsDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_structure_factors_depositor_info";

        public EmStructureFactorsDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }

        public StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<EmStructureFactorsDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmLayerLinesDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_layer_lines_depositor_info";

        public EmLayerLinesDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmLayerLinesDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<EmLayerLinesDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmLayerLinesDepositorInfoBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmLayerLinesDepositorInfoBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmLayerLinesDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<EmLayerLinesDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }

        public StrColumnBuilder<EmLayerLinesDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<EmLayerLinesDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmFigureDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_figure_depositor_info";

        public EmFigureDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmFigureDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<EmFigureDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmFigureDepositorInfoBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmFigureDepositorInfoBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmFigureDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<EmFigureDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }

        public StrColumnBuilder<EmFigureDepositorInfoBuilder> enterDetails() {
            return new StrColumnBuilder<EmFigureDepositorInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmMaskDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_mask_depositor_info";

        public EmMaskDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmMaskDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmMaskDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }

        public StrColumnBuilder<EmMaskDepositorInfoBuilder> enterUploadFormat() {
            return new StrColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "upload_format", this);
        }

        public FloatColumnBuilder<EmMaskDepositorInfoBuilder> enterContourLevel() {
            return new FloatColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "contour_level", this);
        }

        public StrColumnBuilder<EmMaskDepositorInfoBuilder> enterAnnotationDetails() {
            return new StrColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "annotation_details", this);
        }

        public FloatColumnBuilder<EmMaskDepositorInfoBuilder> enterPixelSpacingX() {
            return new FloatColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_x", this);
        }

        public FloatColumnBuilder<EmMaskDepositorInfoBuilder> enterPixelSpacingY() {
            return new FloatColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_y", this);
        }

        public FloatColumnBuilder<EmMaskDepositorInfoBuilder> enterPixelSpacingZ() {
            return new FloatColumnBuilder<EmMaskDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_z", this);
        }
    }

    public static class EmMapDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_map_depositor_info";

        public EmMapDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterEntryId() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterId() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterMapType() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "map_type", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterUploadFileName() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "upload_file_name", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterUploadFormat() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "upload_format", this);
        }

        public FloatColumnBuilder<EmMapDepositorInfoBuilder> enterContourLevel() {
            return new FloatColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "contour_level", this);
        }

        public StrColumnBuilder<EmMapDepositorInfoBuilder> enterAnnotationDetails() {
            return new StrColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "annotation_details", this);
        }

        public FloatColumnBuilder<EmMapDepositorInfoBuilder> enterPixelSpacingX() {
            return new FloatColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_x", this);
        }

        public FloatColumnBuilder<EmMapDepositorInfoBuilder> enterPixelSpacingY() {
            return new FloatColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_y", this);
        }

        public FloatColumnBuilder<EmMapDepositorInfoBuilder> enterPixelSpacingZ() {
            return new FloatColumnBuilder<EmMapDepositorInfoBuilder>(CATEGORY_NAME, "pixel_spacing_z", this);
        }
    }

    public static class EmDepositorInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_depositor_info";

        public EmDepositorInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDepositorInfoBuilder> enterEntryId() {
            return new StrColumnBuilder<EmDepositorInfoBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmDepositorInfoBuilder> enterEmMethodSelection() {
            return new StrColumnBuilder<EmDepositorInfoBuilder>(CATEGORY_NAME, "em_method_selection", this);
        }

        public StrColumnBuilder<EmDepositorInfoBuilder> enterMolecularDescriptionFlag() {
            return new StrColumnBuilder<EmDepositorInfoBuilder>(CATEGORY_NAME, "molecular_description_flag", this);
        }
    }

    public static class EmStructureFactorsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_structure_factors";

        public EmStructureFactorsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmStructureFactorsBuilder> enterDetails() {
            return new StrColumnBuilder<EmStructureFactorsBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmStructureFactorsBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmStructureFactorsBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmStructureFactorsBuilder> enterFile() {
            return new StrColumnBuilder<EmStructureFactorsBuilder>(CATEGORY_NAME, "file", this);
        }

        public StrColumnBuilder<EmStructureFactorsBuilder> enterId() {
            return new StrColumnBuilder<EmStructureFactorsBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmLayerLinesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_layer_lines";

        public EmLayerLinesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmLayerLinesBuilder> enterDetails() {
            return new StrColumnBuilder<EmLayerLinesBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmLayerLinesBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmLayerLinesBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmLayerLinesBuilder> enterFile() {
            return new StrColumnBuilder<EmLayerLinesBuilder>(CATEGORY_NAME, "file", this);
        }

        public StrColumnBuilder<EmLayerLinesBuilder> enterId() {
            return new StrColumnBuilder<EmLayerLinesBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmInterpretFigureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_interpret_figure";

        public EmInterpretFigureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmInterpretFigureBuilder> enterDetails() {
            return new StrColumnBuilder<EmInterpretFigureBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmInterpretFigureBuilder> enterFile() {
            return new StrColumnBuilder<EmInterpretFigureBuilder>(CATEGORY_NAME, "file", this);
        }

        public StrColumnBuilder<EmInterpretFigureBuilder> enterId() {
            return new StrColumnBuilder<EmInterpretFigureBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmFscCurveBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_fsc_curve";

        public EmFscCurveBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmFscCurveBuilder> enterDetails() {
            return new StrColumnBuilder<EmFscCurveBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmFscCurveBuilder> enterFile() {
            return new StrColumnBuilder<EmFscCurveBuilder>(CATEGORY_NAME, "file", this);
        }

        public StrColumnBuilder<EmFscCurveBuilder> enterId() {
            return new StrColumnBuilder<EmFscCurveBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmMapBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_map";

        public EmMapBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmMapBuilder> enterAnnotationDetails() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "annotation_details", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterAxisOrderFast() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "axis_order_fast", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterAxisOrderMedium() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "axis_order_medium", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterAxisOrderSlow() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "axis_order_slow", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellA() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_a", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellB() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_b", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellC() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_c", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellAlpha() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_alpha", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellBeta() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_beta", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterCellGamma() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "cell_gamma", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterContourLevel() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "contour_level", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterContourLevelSource() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "contour_level_source", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterDataType() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "data_type", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterDimensionsCol() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "dimensions_col", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterDimensionsRow() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "dimensions_row", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterDimensionsSec() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "dimensions_sec", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterEndianType() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "endian_type", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterFile() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "file", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterFormat() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "format", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterId() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterPartition() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "partition", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterEntryId() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterLabel() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "label", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterLimitCol() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "limit_col", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterLimitRow() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "limit_row", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterLimitSec() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "limit_sec", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterOriginCol() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "origin_col", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterOriginRow() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "origin_row", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterOriginSec() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "origin_sec", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterPixelSpacingX() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "pixel_spacing_x", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterPixelSpacingY() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "pixel_spacing_y", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterPixelSpacingZ() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "pixel_spacing_z", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterSizeKb() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "size_kb", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterSpacingX() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "spacing_x", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterSpacingY() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "spacing_y", this);
        }

        public IntColumnBuilder<EmMapBuilder> enterSpacingZ() {
            return new IntColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "spacing_z", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterStatisticsAverage() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "statistics_average", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterStatisticsMaximum() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "statistics_maximum", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterStatisticsMinimum() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "statistics_minimum", this);
        }

        public FloatColumnBuilder<EmMapBuilder> enterStatisticsStd() {
            return new FloatColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "statistics_std", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterSymmetrySpaceGroup() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "symmetry_space_group", this);
        }

        public StrColumnBuilder<EmMapBuilder> enterType() {
            return new StrColumnBuilder<EmMapBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmParticleSelectionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_particle_selection";

        public EmParticleSelectionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmParticleSelectionBuilder> enterDetails() {
            return new StrColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmParticleSelectionBuilder> enterId() {
            return new StrColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmParticleSelectionBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmParticleSelectionBuilder> enterMethod() {
            return new StrColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "method", this);
        }

        public IntColumnBuilder<EmParticleSelectionBuilder> enterNumParticlesSelected() {
            return new IntColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "num_particles_selected", this);
        }

        public StrColumnBuilder<EmParticleSelectionBuilder> enterReferenceModel() {
            return new StrColumnBuilder<EmParticleSelectionBuilder>(CATEGORY_NAME, "reference_model", this);
        }
    }

    public static class EmImageProcessingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_image_processing";

        public EmImageProcessingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmImageProcessingBuilder> enterDetails() {
            return new StrColumnBuilder<EmImageProcessingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmImageProcessingBuilder> enterId() {
            return new StrColumnBuilder<EmImageProcessingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmImageProcessingBuilder> enterImageRecordingId() {
            return new StrColumnBuilder<EmImageProcessingBuilder>(CATEGORY_NAME, "image_recording_id", this);
        }
    }

    public static class Em2dCrystalEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_2d_crystal_entity";

        public Em2dCrystalEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<Em2dCrystalEntityBuilder> enterAngleGamma() {
            return new FloatColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "angle_gamma", this);
        }

        public FloatColumnBuilder<Em2dCrystalEntityBuilder> enterCSamplingLength() {
            return new FloatColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "c_sampling_length", this);
        }

        public StrColumnBuilder<Em2dCrystalEntityBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<Em2dCrystalEntityBuilder> enterId() {
            return new StrColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<Em2dCrystalEntityBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public FloatColumnBuilder<Em2dCrystalEntityBuilder> enterLengthA() {
            return new FloatColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "length_a", this);
        }

        public FloatColumnBuilder<Em2dCrystalEntityBuilder> enterLengthB() {
            return new FloatColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "length_b", this);
        }

        public FloatColumnBuilder<Em2dCrystalEntityBuilder> enterLengthC() {
            return new FloatColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "length_c", this);
        }

        public StrColumnBuilder<Em2dCrystalEntityBuilder> enterSpaceGroupNameH_M() {
            return new StrColumnBuilder<Em2dCrystalEntityBuilder>(CATEGORY_NAME, "space_group_name_H-M", this);
        }
    }

    public static class Em3dCrystalEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_3d_crystal_entity";

        public Em3dCrystalEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterAngleAlpha() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "angle_alpha", this);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterAngleBeta() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "angle_beta", this);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterAngleGamma() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "angle_gamma", this);
        }

        public StrColumnBuilder<Em3dCrystalEntityBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<Em3dCrystalEntityBuilder> enterId() {
            return new StrColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterLengthA() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "length_a", this);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterLengthB() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "length_b", this);
        }

        public FloatColumnBuilder<Em3dCrystalEntityBuilder> enterLengthC() {
            return new FloatColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "length_c", this);
        }

        public StrColumnBuilder<Em3dCrystalEntityBuilder> enterSpaceGroupName() {
            return new StrColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "space_group_name", this);
        }

        public IntColumnBuilder<Em3dCrystalEntityBuilder> enterSpaceGroupNum() {
            return new IntColumnBuilder<Em3dCrystalEntityBuilder>(CATEGORY_NAME, "space_group_num", this);
        }
    }

    public static class EmVolumeSelectionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_volume_selection";

        public EmVolumeSelectionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmVolumeSelectionBuilder> enterDetails() {
            return new StrColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmVolumeSelectionBuilder> enterId() {
            return new StrColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmVolumeSelectionBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmVolumeSelectionBuilder> enterMethod() {
            return new StrColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "method", this);
        }

        public IntColumnBuilder<EmVolumeSelectionBuilder> enterNumTomograms() {
            return new IntColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "num_tomograms", this);
        }

        public IntColumnBuilder<EmVolumeSelectionBuilder> enterNumVolumesExtracted() {
            return new IntColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "num_volumes_extracted", this);
        }

        public StrColumnBuilder<EmVolumeSelectionBuilder> enterReferenceModel() {
            return new StrColumnBuilder<EmVolumeSelectionBuilder>(CATEGORY_NAME, "reference_model", this);
        }
    }

    public static class EmCtfCorrectionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_ctf_correction";

        public EmCtfCorrectionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterAmplitudeCorrection() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "amplitude_correction", this);
        }

        public FloatColumnBuilder<EmCtfCorrectionBuilder> enterAmplitudeCorrectionFactor() {
            return new FloatColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "amplitude_correction_factor", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterAmplitudeCorrectionSpace() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "amplitude_correction_space", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterCorrectionOperation() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "correction_operation", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterDetails() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterEmImageProcessingId() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "em_image_processing_id", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterId() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterPhaseReversal() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "phase_reversal", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterPhaseReversalAnisotropic() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "phase_reversal_anisotropic", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterPhaseReversalCorrectionSpace() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "phase_reversal_correction_space", this);
        }

        public StrColumnBuilder<EmCtfCorrectionBuilder> enterType() {
            return new StrColumnBuilder<EmCtfCorrectionBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmEulerAngleAssignmentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_euler_angle_assignment";

        public EmEulerAngleAssignmentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterDetails() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterId() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterOrder() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "order", this);
        }

        public FloatColumnBuilder<EmEulerAngleAssignmentBuilder> enterProjMatchingAngularSampling() {
            return new FloatColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "proj_matching_angular_sampling", this);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterProjMatchingMeritFunction() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "proj_matching_merit_function", this);
        }

        public IntColumnBuilder<EmEulerAngleAssignmentBuilder> enterProjMatchingNumProjections() {
            return new IntColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "proj_matching_num_projections", this);
        }

        public StrColumnBuilder<EmEulerAngleAssignmentBuilder> enterType() {
            return new StrColumnBuilder<EmEulerAngleAssignmentBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmSoftwareBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_software";

        public EmSoftwareBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterCategory() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "category", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterDetails() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterId() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterFittingId() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "fitting_id", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterImagingId() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "imaging_id", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterName() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EmSoftwareBuilder> enterVersion() {
            return new StrColumnBuilder<EmSoftwareBuilder>(CATEGORY_NAME, "version", this);
        }
    }

    public static class EmStartModelBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_start_model";

        public EmStartModelBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterDetails() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterEmdbId() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "emdb_id", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterId() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterInsilicoModel() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "insilico_model", this);
        }

        public FloatColumnBuilder<EmStartModelBuilder> enterOrthogonalTiltAngle1() {
            return new FloatColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "orthogonal_tilt_angle1", this);
        }

        public FloatColumnBuilder<EmStartModelBuilder> enterOrthogonalTiltAngle2() {
            return new FloatColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "orthogonal_tilt_angle2", this);
        }

        public IntColumnBuilder<EmStartModelBuilder> enterOrthogonalTiltNumImages() {
            return new IntColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "orthogonal_tilt_num_images", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterOther() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "other", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterPdbId() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "pdb_id", this);
        }

        public FloatColumnBuilder<EmStartModelBuilder> enterRandomConicalTiltAngle() {
            return new FloatColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "random_conical_tilt_angle", this);
        }

        public IntColumnBuilder<EmStartModelBuilder> enterRandomConicalTiltNumImages() {
            return new IntColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "random_conical_tilt_num_images", this);
        }

        public StrColumnBuilder<EmStartModelBuilder> enterType() {
            return new StrColumnBuilder<EmStartModelBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmFinalClassificationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_final_classification";

        public EmFinalClassificationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<EmFinalClassificationBuilder> enterAvgNumImagesPerClass() {
            return new IntColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "avg_num_images_per_class", this);
        }

        public StrColumnBuilder<EmFinalClassificationBuilder> enterDetails() {
            return new StrColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmFinalClassificationBuilder> enterId() {
            return new StrColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmFinalClassificationBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public IntColumnBuilder<EmFinalClassificationBuilder> enterNumClasses() {
            return new IntColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "num_classes", this);
        }

        public StrColumnBuilder<EmFinalClassificationBuilder> enterType() {
            return new StrColumnBuilder<EmFinalClassificationBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmImagingOpticsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_imaging_optics";

        public EmImagingOpticsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterChrAberrationCorrector() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "chr_aberration_corrector", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterEnergyfilterLower() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "energyfilter_lower", this);
        }

        public FloatColumnBuilder<EmImagingOpticsBuilder> enterEnergyfilterSlitWidth() {
            return new FloatColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "energyfilter_slit_width", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterEnergyfilterName() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "energyfilter_name", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterEnergyfilterUpper() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "energyfilter_upper", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterId() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterImagingId() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "imaging_id", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterPhasePlate() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "phase_plate", this);
        }

        public StrColumnBuilder<EmImagingOpticsBuilder> enterSphAberrationCorrector() {
            return new StrColumnBuilder<EmImagingOpticsBuilder>(CATEGORY_NAME, "sph_aberration_corrector", this);
        }
    }

    public static class EmImageRecordingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_image_recording";

        public EmImageRecordingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmImageRecordingBuilder> enterAverageExposureTime() {
            return new FloatColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "average_exposure_time", this);
        }

        public FloatColumnBuilder<EmImageRecordingBuilder> enterAvgElectronDosePerImage() {
            return new FloatColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "avg_electron_dose_per_image", this);
        }

        public StrColumnBuilder<EmImageRecordingBuilder> enterDetails() {
            return new StrColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmImageRecordingBuilder> enterDetectorMode() {
            return new StrColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "detector_mode", this);
        }

        public StrColumnBuilder<EmImageRecordingBuilder> enterFilmOrDetectorModel() {
            return new StrColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "film_or_detector_model", this);
        }

        public StrColumnBuilder<EmImageRecordingBuilder> enterId() {
            return new StrColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmImageRecordingBuilder> enterImagingId() {
            return new StrColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "imaging_id", this);
        }

        public IntColumnBuilder<EmImageRecordingBuilder> enterNumDiffractionImages() {
            return new IntColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "num_diffraction_images", this);
        }

        public IntColumnBuilder<EmImageRecordingBuilder> enterNumGridsImaged() {
            return new IntColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "num_grids_imaged", this);
        }

        public IntColumnBuilder<EmImageRecordingBuilder> enterNumRealImages() {
            return new IntColumnBuilder<EmImageRecordingBuilder>(CATEGORY_NAME, "num_real_images", this);
        }
    }

    public static class EmTomographyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_tomography";

        public EmTomographyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis1AngleIncrement() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis1_angle_increment", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis1MaxAngle() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis1_max_angle", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis1MinAngle() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis1_min_angle", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis2AngleIncrement() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis2_angle_increment", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis2MaxAngle() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis2_max_angle", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterAxis2MinAngle() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "axis2_min_angle", this);
        }

        public FloatColumnBuilder<EmTomographyBuilder> enterDualTiltAxisRotation() {
            return new FloatColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "dual_tilt_axis_rotation", this);
        }

        public StrColumnBuilder<EmTomographyBuilder> enterId() {
            return new StrColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmTomographyBuilder> enterImagingId() {
            return new StrColumnBuilder<EmTomographyBuilder>(CATEGORY_NAME, "imaging_id", this);
        }
    }

    public static class EmDiffractionStatsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_diffraction_stats";

        public EmDiffractionStatsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDiffractionStatsBuilder> enterDetails() {
            return new StrColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterFourierSpaceCoverage() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "fourier_space_coverage", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterHighResolution() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "high_resolution", this);
        }

        public StrColumnBuilder<EmDiffractionStatsBuilder> enterId() {
            return new StrColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmDiffractionStatsBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public IntColumnBuilder<EmDiffractionStatsBuilder> enterNumIntensitiesMeasured() {
            return new IntColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "num_intensities_measured", this);
        }

        public IntColumnBuilder<EmDiffractionStatsBuilder> enterNumStructureFactors() {
            return new IntColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "num_structure_factors", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterOverallPhaseError() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "overall_phase_error", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterOverallPhaseResidual() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "overall_phase_residual", this);
        }

        public StrColumnBuilder<EmDiffractionStatsBuilder> enterPhaseErrorRejectionCriteria() {
            return new StrColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "phase_error_rejection_criteria", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterRMerge() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "r_merge", this);
        }

        public FloatColumnBuilder<EmDiffractionStatsBuilder> enterRSym() {
            return new FloatColumnBuilder<EmDiffractionStatsBuilder>(CATEGORY_NAME, "r_sym", this);
        }
    }

    public static class EmDiffractionShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_diffraction_shell";

        public EmDiffractionShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDiffractionShellBuilder> enterEmDiffractionStatsId() {
            return new StrColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "em_diffraction_stats_id", this);
        }

        public FloatColumnBuilder<EmDiffractionShellBuilder> enterFourierSpaceCoverage() {
            return new FloatColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "fourier_space_coverage", this);
        }

        public FloatColumnBuilder<EmDiffractionShellBuilder> enterHighResolution() {
            return new FloatColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "high_resolution", this);
        }

        public StrColumnBuilder<EmDiffractionShellBuilder> enterId() {
            return new StrColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<EmDiffractionShellBuilder> enterLowResolution() {
            return new FloatColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "low_resolution", this);
        }

        public FloatColumnBuilder<EmDiffractionShellBuilder> enterMultiplicity() {
            return new FloatColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "multiplicity", this);
        }

        public IntColumnBuilder<EmDiffractionShellBuilder> enterNumStructureFactors() {
            return new IntColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "num_structure_factors", this);
        }

        public FloatColumnBuilder<EmDiffractionShellBuilder> enterPhaseResidual() {
            return new FloatColumnBuilder<EmDiffractionShellBuilder>(CATEGORY_NAME, "phase_residual", this);
        }
    }

    public static class EmDiffractionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_diffraction";

        public EmDiffractionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmDiffractionBuilder> enterCameraLength() {
            return new FloatColumnBuilder<EmDiffractionBuilder>(CATEGORY_NAME, "camera_length", this);
        }

        public StrColumnBuilder<EmDiffractionBuilder> enterId() {
            return new StrColumnBuilder<EmDiffractionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmDiffractionBuilder> enterImagingId() {
            return new StrColumnBuilder<EmDiffractionBuilder>(CATEGORY_NAME, "imaging_id", this);
        }

        public StrColumnBuilder<EmDiffractionBuilder> enterTiltAngleList() {
            return new StrColumnBuilder<EmDiffractionBuilder>(CATEGORY_NAME, "tilt_angle_list", this);
        }
    }

    public static class EmBufferComponentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_buffer_component";

        public EmBufferComponentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmBufferComponentBuilder> enterBufferId() {
            return new StrColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "buffer_id", this);
        }

        public FloatColumnBuilder<EmBufferComponentBuilder> enterConcentration() {
            return new FloatColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "concentration", this);
        }

        public StrColumnBuilder<EmBufferComponentBuilder> enterConcentrationUnits() {
            return new StrColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "concentration_units", this);
        }

        public StrColumnBuilder<EmBufferComponentBuilder> enterFormula() {
            return new StrColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<EmBufferComponentBuilder> enterId() {
            return new StrColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmBufferComponentBuilder> enterName() {
            return new StrColumnBuilder<EmBufferComponentBuilder>(CATEGORY_NAME, "name", this);
        }
    }

    public static class EmSupportFilmBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_support_film";

        public EmSupportFilmBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSupportFilmBuilder> enterId() {
            return new StrColumnBuilder<EmSupportFilmBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmSupportFilmBuilder> enterMaterial() {
            return new StrColumnBuilder<EmSupportFilmBuilder>(CATEGORY_NAME, "material", this);
        }

        public StrColumnBuilder<EmSupportFilmBuilder> enterSampleSupportId() {
            return new StrColumnBuilder<EmSupportFilmBuilder>(CATEGORY_NAME, "sample_support_id", this);
        }

        public FloatColumnBuilder<EmSupportFilmBuilder> enterThickness() {
            return new FloatColumnBuilder<EmSupportFilmBuilder>(CATEGORY_NAME, "thickness", this);
        }

        public StrColumnBuilder<EmSupportFilmBuilder> enterTopology() {
            return new StrColumnBuilder<EmSupportFilmBuilder>(CATEGORY_NAME, "topology", this);
        }
    }

    public static class EmStainingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_staining";

        public EmStainingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmStainingBuilder> enterDetails() {
            return new StrColumnBuilder<EmStainingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmStainingBuilder> enterId() {
            return new StrColumnBuilder<EmStainingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmStainingBuilder> enterMaterial() {
            return new StrColumnBuilder<EmStainingBuilder>(CATEGORY_NAME, "material", this);
        }

        public StrColumnBuilder<EmStainingBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmStainingBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public StrColumnBuilder<EmStainingBuilder> enterType() {
            return new StrColumnBuilder<EmStainingBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmCrystalFormationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_crystal_formation";

        public EmCrystalFormationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterAtmosphere() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "atmosphere", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterDetails() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterId() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterInstrument() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "instrument", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterLipidMixture() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "lipid_mixture", this);
        }

        public FloatColumnBuilder<EmCrystalFormationBuilder> enterLipidProteinRatio() {
            return new FloatColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "lipid_protein_ratio", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public IntColumnBuilder<EmCrystalFormationBuilder> enterTemperature() {
            return new IntColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public IntColumnBuilder<EmCrystalFormationBuilder> enterTime() {
            return new IntColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<EmCrystalFormationBuilder> enterTimeUnit() {
            return new StrColumnBuilder<EmCrystalFormationBuilder>(CATEGORY_NAME, "time_unit", this);
        }
    }

    public static class EmTomographySpecimenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_tomography_specimen";

        public EmTomographySpecimenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterCryoProtectant() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "cryo_protectant", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterDetails() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterFiducialMarkers() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "fiducial_markers", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterHighPressureFreezing() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "high_pressure_freezing", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterId() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterSectioning() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "sectioning", this);
        }

        public StrColumnBuilder<EmTomographySpecimenBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmTomographySpecimenBuilder>(CATEGORY_NAME, "specimen_id", this);
        }
    }

    public static class EmShadowingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_shadowing";

        public EmShadowingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmShadowingBuilder> enterAngle() {
            return new FloatColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "angle", this);
        }

        public StrColumnBuilder<EmShadowingBuilder> enterDetails() {
            return new StrColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmShadowingBuilder> enterId() {
            return new StrColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmShadowingBuilder> enterMaterial() {
            return new StrColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "material", this);
        }

        public StrColumnBuilder<EmShadowingBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public FloatColumnBuilder<EmShadowingBuilder> enterThickness() {
            return new FloatColumnBuilder<EmShadowingBuilder>(CATEGORY_NAME, "thickness", this);
        }
    }

    public static class EmHighPressureFreezingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_high_pressure_freezing";

        public EmHighPressureFreezingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmHighPressureFreezingBuilder> enterDetails() {
            return new StrColumnBuilder<EmHighPressureFreezingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmHighPressureFreezingBuilder> enterEmTomographySpecimenId() {
            return new StrColumnBuilder<EmHighPressureFreezingBuilder>(CATEGORY_NAME, "em_tomography_specimen_id", this);
        }

        public StrColumnBuilder<EmHighPressureFreezingBuilder> enterId() {
            return new StrColumnBuilder<EmHighPressureFreezingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmHighPressureFreezingBuilder> enterInstrument() {
            return new StrColumnBuilder<EmHighPressureFreezingBuilder>(CATEGORY_NAME, "instrument", this);
        }
    }

    public static class EmUltramicrotomyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_ultramicrotomy";

        public EmUltramicrotomyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmUltramicrotomyBuilder> enterDetails() {
            return new StrColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmUltramicrotomyBuilder> enterEmTomographySpecimenId() {
            return new StrColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "em_tomography_specimen_id", this);
        }

        public IntColumnBuilder<EmUltramicrotomyBuilder> enterFinalThickness() {
            return new IntColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "final_thickness", this);
        }

        public StrColumnBuilder<EmUltramicrotomyBuilder> enterId() {
            return new StrColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmUltramicrotomyBuilder> enterInstrument() {
            return new StrColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "instrument", this);
        }

        public IntColumnBuilder<EmUltramicrotomyBuilder> enterTemperature() {
            return new IntColumnBuilder<EmUltramicrotomyBuilder>(CATEGORY_NAME, "temperature", this);
        }
    }

    public static class EmGridPretreatmentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_grid_pretreatment";

        public EmGridPretreatmentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmGridPretreatmentBuilder> enterAtmosphere() {
            return new StrColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "atmosphere", this);
        }

        public StrColumnBuilder<EmGridPretreatmentBuilder> enterId() {
            return new StrColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<EmGridPretreatmentBuilder> enterPressure() {
            return new FloatColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "pressure", this);
        }

        public StrColumnBuilder<EmGridPretreatmentBuilder> enterSampleSupportId() {
            return new StrColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "sample_support_id", this);
        }

        public IntColumnBuilder<EmGridPretreatmentBuilder> enterTime() {
            return new IntColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<EmGridPretreatmentBuilder> enterType() {
            return new StrColumnBuilder<EmGridPretreatmentBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class EmFocusedIonBeamBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_focused_ion_beam";

        public EmFocusedIonBeamBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmFocusedIonBeamBuilder> enterCurrent() {
            return new FloatColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "current", this);
        }

        public StrColumnBuilder<EmFocusedIonBeamBuilder> enterDetails() {
            return new StrColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterDoseRate() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "dose_rate", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterDuration() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "duration", this);
        }

        public StrColumnBuilder<EmFocusedIonBeamBuilder> enterEmTomographySpecimenId() {
            return new StrColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "em_tomography_specimen_id", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterFinalThickness() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "final_thickness", this);
        }

        public StrColumnBuilder<EmFocusedIonBeamBuilder> enterId() {
            return new StrColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterInitialThickness() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "initial_thickness", this);
        }

        public StrColumnBuilder<EmFocusedIonBeamBuilder> enterInstrument() {
            return new StrColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "instrument", this);
        }

        public StrColumnBuilder<EmFocusedIonBeamBuilder> enterIon() {
            return new StrColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "ion", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterTemperature() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public IntColumnBuilder<EmFocusedIonBeamBuilder> enterVoltage() {
            return new IntColumnBuilder<EmFocusedIonBeamBuilder>(CATEGORY_NAME, "voltage", this);
        }
    }

    public static class EmFiducialMarkersBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_fiducial_markers";

        public EmFiducialMarkersBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmFiducialMarkersBuilder> enterDiameter() {
            return new FloatColumnBuilder<EmFiducialMarkersBuilder>(CATEGORY_NAME, "diameter", this);
        }

        public StrColumnBuilder<EmFiducialMarkersBuilder> enterEmTomographySpecimenId() {
            return new StrColumnBuilder<EmFiducialMarkersBuilder>(CATEGORY_NAME, "em_tomography_specimen_id", this);
        }

        public StrColumnBuilder<EmFiducialMarkersBuilder> enterId() {
            return new StrColumnBuilder<EmFiducialMarkersBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmFiducialMarkersBuilder> enterManufacturer() {
            return new StrColumnBuilder<EmFiducialMarkersBuilder>(CATEGORY_NAME, "manufacturer", this);
        }
    }

    public static class EmEmbeddingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_embedding";

        public EmEmbeddingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEmbeddingBuilder> enterDetails() {
            return new StrColumnBuilder<EmEmbeddingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmEmbeddingBuilder> enterId() {
            return new StrColumnBuilder<EmEmbeddingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmEmbeddingBuilder> enterMaterial() {
            return new StrColumnBuilder<EmEmbeddingBuilder>(CATEGORY_NAME, "material", this);
        }

        public StrColumnBuilder<EmEmbeddingBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmEmbeddingBuilder>(CATEGORY_NAME, "specimen_id", this);
        }
    }

    public static class EmSpecimenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_specimen";

        public EmSpecimenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmSpecimenBuilder> enterConcentration() {
            return new FloatColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "concentration", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterDetails() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterEmbeddingApplied() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "embedding_applied", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterExperimentId() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterId() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterShadowingApplied() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "shadowing_applied", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterStainingApplied() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "staining_applied", this);
        }

        public StrColumnBuilder<EmSpecimenBuilder> enterVitrificationApplied() {
            return new StrColumnBuilder<EmSpecimenBuilder>(CATEGORY_NAME, "vitrification_applied", this);
        }
    }

    public static class EmVirusShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_virus_shell";

        public EmVirusShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<EmVirusShellBuilder> enterDiameter() {
            return new FloatColumnBuilder<EmVirusShellBuilder>(CATEGORY_NAME, "diameter", this);
        }

        public StrColumnBuilder<EmVirusShellBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmVirusShellBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmVirusShellBuilder> enterId() {
            return new StrColumnBuilder<EmVirusShellBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmVirusShellBuilder> enterName() {
            return new StrColumnBuilder<EmVirusShellBuilder>(CATEGORY_NAME, "name", this);
        }

        public IntColumnBuilder<EmVirusShellBuilder> enterTriangulation() {
            return new IntColumnBuilder<EmVirusShellBuilder>(CATEGORY_NAME, "triangulation", this);
        }
    }

    public static class EmVirusNaturalHostBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_virus_natural_host";

        public EmVirusNaturalHostBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmVirusNaturalHostBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmVirusNaturalHostBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmVirusNaturalHostBuilder> enterId() {
            return new StrColumnBuilder<EmVirusNaturalHostBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmVirusNaturalHostBuilder> enterNcbiTaxId() {
            return new IntColumnBuilder<EmVirusNaturalHostBuilder>(CATEGORY_NAME, "ncbi_tax_id", this);
        }

        public StrColumnBuilder<EmVirusNaturalHostBuilder> enterOrganism() {
            return new StrColumnBuilder<EmVirusNaturalHostBuilder>(CATEGORY_NAME, "organism", this);
        }

        public StrColumnBuilder<EmVirusNaturalHostBuilder> enterStrain() {
            return new StrColumnBuilder<EmVirusNaturalHostBuilder>(CATEGORY_NAME, "strain", this);
        }
    }

    public static class EmEntityAssemblyRecombinantBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_entity_assembly_recombinant";

        public EmEntityAssemblyRecombinantBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterCell() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "cell", this);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterId() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterNcbiTaxId() {
            return new IntColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "ncbi_tax_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterOrganism() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "organism", this);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterPlasmid() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "plasmid", this);
        }

        public StrColumnBuilder<EmEntityAssemblyRecombinantBuilder> enterStrain() {
            return new StrColumnBuilder<EmEntityAssemblyRecombinantBuilder>(CATEGORY_NAME, "strain", this);
        }
    }

    public static class EmEntityAssemblyNaturalsourceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_entity_assembly_naturalsource";

        public EmEntityAssemblyNaturalsourceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterCell() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "cell", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterCellularLocation() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "cellular_location", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterId() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterNcbiTaxId() {
            return new IntColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "ncbi_tax_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterOrganism() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "organism", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterOrganelle() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "organelle", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterOrgan() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "organ", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterStrain() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "strain", this);
        }

        public StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder> enterTissue() {
            return new StrColumnBuilder<EmEntityAssemblyNaturalsourceBuilder>(CATEGORY_NAME, "tissue", this);
        }
    }

    public static class EmEntityAssemblyMolwtBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_entity_assembly_molwt";

        public EmEntityAssemblyMolwtBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEntityAssemblyMolwtBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyMolwtBuilder> enterExperimentalFlag() {
            return new StrColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "experimental_flag", this);
        }

        public StrColumnBuilder<EmEntityAssemblyMolwtBuilder> enterId() {
            return new StrColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyMolwtBuilder> enterUnits() {
            return new StrColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "units", this);
        }

        public FloatColumnBuilder<EmEntityAssemblyMolwtBuilder> enterValue() {
            return new FloatColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<EmEntityAssemblyMolwtBuilder> enterMethod() {
            return new StrColumnBuilder<EmEntityAssemblyMolwtBuilder>(CATEGORY_NAME, "method", this);
        }
    }

    public static class EmSupersedeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_supersede";

        public EmSupersedeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSupersedeBuilder> enterDate() {
            return new StrColumnBuilder<EmSupersedeBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<EmSupersedeBuilder> enterDetails() {
            return new StrColumnBuilder<EmSupersedeBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmSupersedeBuilder> enterEntry() {
            return new StrColumnBuilder<EmSupersedeBuilder>(CATEGORY_NAME, "entry", this);
        }

        public StrColumnBuilder<EmSupersedeBuilder> enterId() {
            return new StrColumnBuilder<EmSupersedeBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmObsoleteBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_obsolete";

        public EmObsoleteBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmObsoleteBuilder> enterDate() {
            return new StrColumnBuilder<EmObsoleteBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<EmObsoleteBuilder> enterDetails() {
            return new StrColumnBuilder<EmObsoleteBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmObsoleteBuilder> enterEntry() {
            return new StrColumnBuilder<EmObsoleteBuilder>(CATEGORY_NAME, "entry", this);
        }

        public StrColumnBuilder<EmObsoleteBuilder> enterId() {
            return new StrColumnBuilder<EmObsoleteBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class EmDepuiBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_depui";

        public EmDepuiBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterDepositorHoldInstructions() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "depositor_hold_instructions", this);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterEntryId() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterMacromoleculeDescription() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "macromolecule_description", this);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterObsoleteInstructions() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "obsolete_instructions", this);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterSameAuthorsAsPdb() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "same_authors_as_pdb", this);
        }

        public StrColumnBuilder<EmDepuiBuilder> enterSameTitleAsPdb() {
            return new StrColumnBuilder<EmDepuiBuilder>(CATEGORY_NAME, "same_title_as_pdb", this);
        }
    }

    public static class EmDbReferenceAuxiliaryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_db_reference_auxiliary";

        public EmDbReferenceAuxiliaryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDbReferenceAuxiliaryBuilder> enterId() {
            return new StrColumnBuilder<EmDbReferenceAuxiliaryBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmDbReferenceAuxiliaryBuilder> enterLink() {
            return new StrColumnBuilder<EmDbReferenceAuxiliaryBuilder>(CATEGORY_NAME, "link", this);
        }

        public StrColumnBuilder<EmDbReferenceAuxiliaryBuilder> enterLinkType() {
            return new StrColumnBuilder<EmDbReferenceAuxiliaryBuilder>(CATEGORY_NAME, "link_type", this);
        }
    }

    public static class EmDbReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_db_reference";

        public EmDbReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDbReferenceBuilder> enterAccessCode() {
            return new StrColumnBuilder<EmDbReferenceBuilder>(CATEGORY_NAME, "access_code", this);
        }

        public StrColumnBuilder<EmDbReferenceBuilder> enterDbName() {
            return new StrColumnBuilder<EmDbReferenceBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<EmDbReferenceBuilder> enterDetails() {
            return new StrColumnBuilder<EmDbReferenceBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmDbReferenceBuilder> enterId() {
            return new StrColumnBuilder<EmDbReferenceBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmDbReferenceBuilder> enterRelationship() {
            return new StrColumnBuilder<EmDbReferenceBuilder>(CATEGORY_NAME, "relationship", this);
        }
    }

    public static class EmAuthorListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_author_list";

        public EmAuthorListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmAuthorListBuilder> enterAuthor() {
            return new StrColumnBuilder<EmAuthorListBuilder>(CATEGORY_NAME, "author", this);
        }

        public IntColumnBuilder<EmAuthorListBuilder> enterOrdinal() {
            return new IntColumnBuilder<EmAuthorListBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class EmAdminBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_admin";

        public EmAdminBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmAdminBuilder> enterCurrentStatus() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "current_status", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterDepositionDate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "deposition_date", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterDepositionSite() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "deposition_site", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterDetails() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterEntryId() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterLastUpdate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "last_update", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterMapReleaseDate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "map_release_date", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterMapHoldDate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "map_hold_date", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterHeaderReleaseDate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "header_release_date", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterObsoletedDate() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "obsoleted_date", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterReplaceExistingEntryFlag() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "replace_existing_entry_flag", this);
        }

        public StrColumnBuilder<EmAdminBuilder> enterTitle() {
            return new StrColumnBuilder<EmAdminBuilder>(CATEGORY_NAME, "title", this);
        }
    }

    public static class EmSingleParticleEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_single_particle_entity";

        public EmSingleParticleEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSingleParticleEntityBuilder> enterEntryId() {
            return new StrColumnBuilder<EmSingleParticleEntityBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmSingleParticleEntityBuilder> enterId() {
            return new StrColumnBuilder<EmSingleParticleEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmSingleParticleEntityBuilder> enterSymmetryType() {
            return new StrColumnBuilder<EmSingleParticleEntityBuilder>(CATEGORY_NAME, "symmetry_type", this);
        }

        public StrColumnBuilder<EmSingleParticleEntityBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmSingleParticleEntityBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmSingleParticleEntityBuilder> enterPointSymmetry() {
            return new StrColumnBuilder<EmSingleParticleEntityBuilder>(CATEGORY_NAME, "point_symmetry", this);
        }
    }

    public static class EmExperimentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_experiment";

        public EmExperimentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterEntryId() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterId() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterReconstructionMethod() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "reconstruction_method", this);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterAggregationState() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "aggregation_state", this);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterSpecimenType() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "specimen_type", this);
        }

        public StrColumnBuilder<EmExperimentBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmExperimentBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }
    }

    public static class EmHelicalEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_helical_entity";

        public EmHelicalEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterId() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterDetails() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterDyad() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "dyad", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterAxialSymmetry() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "axial_symmetry", this);
        }

        public FloatColumnBuilder<EmHelicalEntityBuilder> enterAngularRotationPerSubunit() {
            return new FloatColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "angular_rotation_per_subunit", this);
        }

        public FloatColumnBuilder<EmHelicalEntityBuilder> enterAxialRisePerSubunit() {
            return new FloatColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "axial_rise_per_subunit", this);
        }

        public StrColumnBuilder<EmHelicalEntityBuilder> enterHand() {
            return new StrColumnBuilder<EmHelicalEntityBuilder>(CATEGORY_NAME, "hand", this);
        }
    }

    public static class Em3dFittingListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_3d_fitting_list";

        public Em3dFittingListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enterId() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enter_3dFittingId() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "3d_fitting_id", this);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enterPdbEntryId() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "pdb_entry_id", this);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enterPdbChainId() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "pdb_chain_id", this);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enterPdbChainResidueRange() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "pdb_chain_residue_range", this);
        }

        public StrColumnBuilder<Em3dFittingListBuilder> enterDetails() {
            return new StrColumnBuilder<Em3dFittingListBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class Em3dFittingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_3d_fitting";

        public Em3dFittingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterId() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterEntryId() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterMethod() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterTargetCriteria() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "target_criteria", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterSoftwareName() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "software_name", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterDetails() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<Em3dFittingBuilder> enterOverallBValue() {
            return new FloatColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "overall_b_value", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterRefSpace() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "ref_space", this);
        }

        public StrColumnBuilder<Em3dFittingBuilder> enterRefProtocol() {
            return new StrColumnBuilder<Em3dFittingBuilder>(CATEGORY_NAME, "ref_protocol", this);
        }
    }

    public static class Em3dReconstructionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_3d_reconstruction";

        public Em3dReconstructionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterEntryId() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterId() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterMethod() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterAlgorithm() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "algorithm", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterCitationId() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterDetails() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<Em3dReconstructionBuilder> enterResolution() {
            return new FloatColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "resolution", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterResolutionMethod() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "resolution_method", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterMagnificationCalibration() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "magnification_calibration", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterCtfCorrectionMethod() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "ctf_correction_method", this);
        }

        public FloatColumnBuilder<Em3dReconstructionBuilder> enterNominalPixelSize() {
            return new FloatColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "nominal_pixel_size", this);
        }

        public FloatColumnBuilder<Em3dReconstructionBuilder> enterActualPixelSize() {
            return new FloatColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "actual_pixel_size", this);
        }

        public IntColumnBuilder<Em3dReconstructionBuilder> enterNumParticles() {
            return new IntColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "num_particles", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterEulerAnglesDetails() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "euler_angles_details", this);
        }

        public IntColumnBuilder<Em3dReconstructionBuilder> enterNumClassAverages() {
            return new IntColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "num_class_averages", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterSoftware() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "software", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterFscType() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "fsc_type", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterRefinementType() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "refinement_type", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterImageProcessingId() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "image_processing_id", this);
        }

        public StrColumnBuilder<Em3dReconstructionBuilder> enterSymmetryType() {
            return new StrColumnBuilder<Em3dReconstructionBuilder>(CATEGORY_NAME, "symmetry_type", this);
        }
    }

    public static class Em2dProjectionSelectionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_2d_projection_selection";

        public Em2dProjectionSelectionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterEntryId() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterId() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<Em2dProjectionSelectionBuilder> enterNumParticles() {
            return new IntColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "num_particles", this);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterSoftwareName() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "software_name", this);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterMethod() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterDetails() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<Em2dProjectionSelectionBuilder> enterCitationId() {
            return new StrColumnBuilder<Em2dProjectionSelectionBuilder>(CATEGORY_NAME, "citation_id", this);
        }
    }

    public static class EmImageScansBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_image_scans";

        public EmImageScansBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterEntryId() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterId() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<EmImageScansBuilder> enterNumberDigitalImages() {
            return new IntColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "number_digital_images", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterDetails() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterScannerModel() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "scanner_model", this);
        }

        public FloatColumnBuilder<EmImageScansBuilder> enterSamplingSize() {
            return new FloatColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "sampling_size", this);
        }

        public FloatColumnBuilder<EmImageScansBuilder> enterOdRange() {
            return new FloatColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "od_range", this);
        }

        public IntColumnBuilder<EmImageScansBuilder> enterQuantBitSize() {
            return new IntColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "quant_bit_size", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterCitationId() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "citation_id", this);
        }

        public IntColumnBuilder<EmImageScansBuilder> enterDimensionHeight() {
            return new IntColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "dimension_height", this);
        }

        public IntColumnBuilder<EmImageScansBuilder> enterDimensionWidth() {
            return new IntColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "dimension_width", this);
        }

        public IntColumnBuilder<EmImageScansBuilder> enterFramesPerImage() {
            return new IntColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "frames_per_image", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterImageRecordingId() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "image_recording_id", this);
        }

        public StrColumnBuilder<EmImageScansBuilder> enterUsedFramesPerImage() {
            return new StrColumnBuilder<EmImageScansBuilder>(CATEGORY_NAME, "used_frames_per_image", this);
        }
    }

    public static class EmDetectorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_detector";

        public EmDetectorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmDetectorBuilder> enterEntryId() {
            return new StrColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmDetectorBuilder> enterId() {
            return new StrColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmDetectorBuilder> enterDetails() {
            return new StrColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmDetectorBuilder> enterType() {
            return new StrColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "type", this);
        }

        public FloatColumnBuilder<EmDetectorBuilder> enterDetectiveQuantumEfficiency() {
            return new FloatColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "detective_quantum_efficiency", this);
        }

        public StrColumnBuilder<EmDetectorBuilder> enterMode() {
            return new StrColumnBuilder<EmDetectorBuilder>(CATEGORY_NAME, "mode", this);
        }
    }

    public static class EmImagingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_imaging";

        public EmImagingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmImagingBuilder> enterEntryId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterAstigmatism() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "astigmatism", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterElectronBeamTiltParams() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "electron_beam_tilt_params", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterResidualTilt() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "residual_tilt", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterSampleSupportId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "sample_support_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterDetectorId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "detector_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterScansId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "scans_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterMicroscopeId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "microscope_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterMicroscopeModel() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "microscope_model", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterSpecimenHolderType() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "specimen_holder_type", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterSpecimenHolderModel() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "specimen_holder_model", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterDetails() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterDate() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "date", this);
        }

        public IntColumnBuilder<EmImagingBuilder> enterAcceleratingVoltage() {
            return new IntColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "accelerating_voltage", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterIlluminationMode() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "illumination_mode", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterMode() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "mode", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterNominalCs() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "nominal_cs", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterNominalDefocusMin() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "nominal_defocus_min", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterNominalDefocusMax() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "nominal_defocus_max", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterCalibratedDefocusMin() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "calibrated_defocus_min", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterCalibratedDefocusMax() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "calibrated_defocus_max", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterTiltAngleMin() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "tilt_angle_min", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterTiltAngleMax() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "tilt_angle_max", this);
        }

        public IntColumnBuilder<EmImagingBuilder> enterNominalMagnification() {
            return new IntColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "nominal_magnification", this);
        }

        public IntColumnBuilder<EmImagingBuilder> enterCalibratedMagnification() {
            return new IntColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "calibrated_magnification", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterElectronSource() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "electron_source", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterElectronDose() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "electron_dose", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterEnergyFilter() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "energy_filter", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterEnergyWindow() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "energy_window", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterCitationId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "citation_id", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterTemperature() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterDetectorDistance() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "detector_distance", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterRecordingTemperatureMinimum() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "recording_temperature_minimum", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterRecordingTemperatureMaximum() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "recording_temperature_maximum", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterAlignmentProcedure() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "alignment_procedure", this);
        }

        public FloatColumnBuilder<EmImagingBuilder> enterC2ApertureDiameter() {
            return new FloatColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "c2_aperture_diameter", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public StrColumnBuilder<EmImagingBuilder> enterCryogen() {
            return new StrColumnBuilder<EmImagingBuilder>(CATEGORY_NAME, "cryogen", this);
        }
    }

    public static class EmVitrificationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_vitrification";

        public EmVitrificationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterEntryId() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterId() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterSamplePreparationId() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "sample_preparation_id", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterCryogenName() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "cryogen_name", this);
        }

        public FloatColumnBuilder<EmVitrificationBuilder> enterHumidity() {
            return new FloatColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "humidity", this);
        }

        public FloatColumnBuilder<EmVitrificationBuilder> enterTemp() {
            return new FloatColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "temp", this);
        }

        public FloatColumnBuilder<EmVitrificationBuilder> enterChamberTemperature() {
            return new FloatColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "chamber_temperature", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterInstrument() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "instrument", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterMethod() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterTimeResolvedState() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "time_resolved_state", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterCitationId() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<EmVitrificationBuilder> enterDetails() {
            return new StrColumnBuilder<EmVitrificationBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmBufferBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_buffer";

        public EmBufferBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmBufferBuilder> enterId() {
            return new StrColumnBuilder<EmBufferBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmBufferBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmBufferBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public StrColumnBuilder<EmBufferBuilder> enterName() {
            return new StrColumnBuilder<EmBufferBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EmBufferBuilder> enterDetails() {
            return new StrColumnBuilder<EmBufferBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<EmBufferBuilder> enterPH() {
            return new FloatColumnBuilder<EmBufferBuilder>(CATEGORY_NAME, "pH", this);
        }
    }

    public static class EmSampleSupportBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_sample_support";

        public EmSampleSupportBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterId() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterFilmMaterial() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "film_material", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterMethod() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterGridMaterial() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "grid_material", this);
        }

        public IntColumnBuilder<EmSampleSupportBuilder> enterGridMeshSize() {
            return new IntColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "grid_mesh_size", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterGridType() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "grid_type", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterPretreatment() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "pretreatment", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterDetails() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterSpecimenId() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "specimen_id", this);
        }

        public StrColumnBuilder<EmSampleSupportBuilder> enterCitationId() {
            return new StrColumnBuilder<EmSampleSupportBuilder>(CATEGORY_NAME, "citation_id", this);
        }
    }

    public static class EmSamplePreparationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_sample_preparation";

        public EmSamplePreparationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterEntryId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<EmSamplePreparationBuilder> enterPh() {
            return new FloatColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "ph", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterBufferId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "buffer_id", this);
        }

        public FloatColumnBuilder<EmSamplePreparationBuilder> enterSampleConcentration() {
            return new FloatColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "sample_concentration", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enter_2dCrystalGrowId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "2d_crystal_grow_id", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterSupportId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "support_id", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmSamplePreparationBuilder> enterDetails() {
            return new StrColumnBuilder<EmSamplePreparationBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmVirusEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_virus_entity";

        public EmVirusEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterId() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterVirusHostCategory() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "virus_host_category", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterVirusHostSpecies() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "virus_host_species", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterVirusHostGrowthCell() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "virus_host_growth_cell", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterVirusType() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "virus_type", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterVirusIsolate() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "virus_isolate", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterIctvdbId() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "ictvdb_id", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterEntityAssemblyId() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "entity_assembly_id", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterEnveloped() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "enveloped", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterEmpty() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "empty", this);
        }

        public StrColumnBuilder<EmVirusEntityBuilder> enterDetails() {
            return new StrColumnBuilder<EmVirusEntityBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class EmEntityAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_entity_assembly";

        public EmEntityAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterId() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterAssemblyId() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public IntColumnBuilder<EmEntityAssemblyBuilder> enterParentId() {
            return new IntColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "parent_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterSource() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterType() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterName() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterDetails() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterGoId() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "go_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterIprId() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ipr_id", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterSynonym() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "synonym", this);
        }

        public IntColumnBuilder<EmEntityAssemblyBuilder> enterNumberOfCopies() {
            return new IntColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "number_of_copies", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterOligomericDetails() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "oligomeric_details", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEntityIdList() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "entity_id_list", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiOrganismScientific() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_organism_scientific", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiOrganismCommon() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_organism_common", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiStrain() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_strain", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiTissue() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_tissue", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiCell() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_cell", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiOrganelle() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_organelle", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiCellularLocation() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_cellular_location", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiEngineered() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_engineered", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiExpressionSystem() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_expression_system", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterEbiExpressionSystemPlasmid() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "ebi_expression_system_plasmid", this);
        }

        public StrColumnBuilder<EmEntityAssemblyBuilder> enterMutantFlag() {
            return new StrColumnBuilder<EmEntityAssemblyBuilder>(CATEGORY_NAME, "mutant_flag", this);
        }
    }

    public static class EmAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "em_assembly";

        public EmAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterId() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterEntryId() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterName() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterAggregationState() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "aggregation_state", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterComposition() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "composition", this);
        }

        public IntColumnBuilder<EmAssemblyBuilder> enterNumComponents() {
            return new IntColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "num_components", this);
        }

        public FloatColumnBuilder<EmAssemblyBuilder> enterMolWtExp() {
            return new FloatColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "mol_wt_exp", this);
        }

        public FloatColumnBuilder<EmAssemblyBuilder> enterMolWtTheo() {
            return new FloatColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "mol_wt_theo", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterMolWtMethod() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "mol_wt_method", this);
        }

        public StrColumnBuilder<EmAssemblyBuilder> enterDetails() {
            return new StrColumnBuilder<EmAssemblyBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxDatabaseStatusHistoryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_status_history";

        public PdbxDatabaseStatusHistoryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterOrdinal() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterDateBegin() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "date_begin", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterDateEnd() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "date_end", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterStatusCode() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "status_code", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxDatabaseStatusHistoryBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxRelatedExpDataSetBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_related_exp_data_set";

        public PdbxRelatedExpDataSetBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxRelatedExpDataSetBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxRelatedExpDataSetBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxRelatedExpDataSetBuilder> enterDataReference() {
            return new StrColumnBuilder<PdbxRelatedExpDataSetBuilder>(CATEGORY_NAME, "data_reference", this);
        }

        public StrColumnBuilder<PdbxRelatedExpDataSetBuilder> enterMetadataReference() {
            return new StrColumnBuilder<PdbxRelatedExpDataSetBuilder>(CATEGORY_NAME, "metadata_reference", this);
        }

        public StrColumnBuilder<PdbxRelatedExpDataSetBuilder> enterDataSetType() {
            return new StrColumnBuilder<PdbxRelatedExpDataSetBuilder>(CATEGORY_NAME, "data_set_type", this);
        }

        public StrColumnBuilder<PdbxRelatedExpDataSetBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxRelatedExpDataSetBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxReferenceLinkedEntityLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_linked_entity_link";

        public PdbxReferenceLinkedEntityLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterLinkedEntityId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterFromListId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "from_list_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterToCompId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "to_comp_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterFromCompId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "from_comp_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterToAtomId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "to_atom_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterFromAtomId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "from_atom_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterFromLeavingAtomId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "from_leaving_atom_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterFromAtomStereoConfig() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "from_atom_stereo_config", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityLinkBuilder>(CATEGORY_NAME, "value_order", this);
        }
    }

    public static class PdbxReferenceLinkedEntityCompLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_linked_entity_comp_link";

        public PdbxReferenceLinkedEntityCompLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterLinkedEntityId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterListId1() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "list_id_1", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterListId2() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "list_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterLeavingAtomId1() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "leaving_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterAtomStereoConfig1() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "atom_stereo_config_1", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterLeavingAtomId2() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "leaving_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterAtomStereoConfig2() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "atom_stereo_config_2", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompLinkBuilder>(CATEGORY_NAME, "value_order", this);
        }
    }

    public static class PdbxReferenceLinkedEntityCompListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_linked_entity_comp_list";

        public PdbxReferenceLinkedEntityCompListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder> enterLinkedEntityId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder> enterListId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder>(CATEGORY_NAME, "list_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityCompListBuilder>(CATEGORY_NAME, "comp_id", this);
        }
    }

    public static class PdbxReferenceLinkedEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_linked_entity";

        public PdbxReferenceLinkedEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterId() {
            return new IntColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterTaxonomyId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "taxonomy_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterTaxonomyClass() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "taxonomy_class", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterLinkToEntityType() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "link_to_entity_type", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterLinkToCompId() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "link_to_comp_id", this);
        }

        public StrColumnBuilder<PdbxReferenceLinkedEntityBuilder> enterLinkFromEntityType() {
            return new StrColumnBuilder<PdbxReferenceLinkedEntityBuilder>(CATEGORY_NAME, "link_from_entity_type", this);
        }
    }

    public static class PdbxEntityDescriptorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_descriptor";

        public PdbxEntityDescriptorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityDescriptorBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityDescriptorBuilder> enterDescriptor() {
            return new StrColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "descriptor", this);
        }

        public StrColumnBuilder<PdbxEntityDescriptorBuilder> enterType() {
            return new StrColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxEntityDescriptorBuilder> enterProgram() {
            return new StrColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "program", this);
        }

        public StrColumnBuilder<PdbxEntityDescriptorBuilder> enterProgramVersion() {
            return new StrColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "program_version", this);
        }

        public IntColumnBuilder<PdbxEntityDescriptorBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxEntityDescriptorBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxLinkedEntityLinkListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_linked_entity_link_list";

        public PdbxLinkedEntityLinkListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterLinkedEntityId() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterEntityId1() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "entity_id_1", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterEntityId2() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "entity_id_2", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "value_order", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterComponent1() {
            return new IntColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "component_1", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterComponent2() {
            return new IntColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "component_2", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityLinkListBuilder> enterLinkClass() {
            return new StrColumnBuilder<PdbxLinkedEntityLinkListBuilder>(CATEGORY_NAME, "link_class", this);
        }
    }

    public static class PdbxLinkedEntityListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_linked_entity_list";

        public PdbxLinkedEntityListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxLinkedEntityListBuilder> enterLinkedEntityId() {
            return new StrColumnBuilder<PdbxLinkedEntityListBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityListBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxLinkedEntityListBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityListBuilder> enterComponentId() {
            return new IntColumnBuilder<PdbxLinkedEntityListBuilder>(CATEGORY_NAME, "component_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxLinkedEntityListBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxLinkedEntityInstanceListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_linked_entity_instance_list";

        public PdbxLinkedEntityInstanceListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxLinkedEntityInstanceListBuilder> enterLinkedEntityId() {
            return new StrColumnBuilder<PdbxLinkedEntityInstanceListBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public IntColumnBuilder<PdbxLinkedEntityInstanceListBuilder> enterInstanceId() {
            return new IntColumnBuilder<PdbxLinkedEntityInstanceListBuilder>(CATEGORY_NAME, "instance_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityInstanceListBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxLinkedEntityInstanceListBuilder>(CATEGORY_NAME, "asym_id", this);
        }
    }

    public static class PdbxLinkedEntityBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_linked_entity";

        public PdbxLinkedEntityBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterLinkedEntityId() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterType() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterName() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxLinkedEntityBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxLinkedEntityBuilder>(CATEGORY_NAME, "prd_id", this);
        }
    }

    public static class PdbxEntityPolyCompLinkListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_poly_comp_link_list";

        public PdbxEntityPolyCompLinkListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterEntityCompNum1() {
            return new IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "entity_comp_num_1", this);
        }

        public IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterEntityCompNum2() {
            return new IntColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "entity_comp_num_2", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterLeavingAtomId1() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "leaving_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterAtomStereoConfig1() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "atom_stereo_config_1", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterLeavingAtomId2() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "leaving_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterAtomStereoConfig2() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "atom_stereo_config_2", this);
        }

        public StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxEntityPolyCompLinkListBuilder>(CATEGORY_NAME, "value_order", this);
        }
    }

    public static class PdbxEntitySrcSynBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_syn";

        public PdbxEntitySrcSynBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterOrganismScientific() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "organism_scientific", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterOrganismCommonName() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "organism_common_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterStrain() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "strain", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterNcbiTaxonomyId() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "ncbi_taxonomy_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcSynBuilder> enterPdbxSrcId() {
            return new IntColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "pdbx_src_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcSynBuilder> enterPdbxAltSourceFlag() {
            return new StrColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "pdbx_alt_source_flag", this);
        }

        public IntColumnBuilder<PdbxEntitySrcSynBuilder> enterPdbxBegSeqNum() {
            return new IntColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "pdbx_beg_seq_num", this);
        }

        public IntColumnBuilder<PdbxEntitySrcSynBuilder> enterPdbxEndSeqNum() {
            return new IntColumnBuilder<PdbxEntitySrcSynBuilder>(CATEGORY_NAME, "pdbx_end_seq_num", this);
        }
    }

    public static class EntitySrcGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "entity_src_gen";

        public EntitySrcGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterEntityId() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcCommonName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_common_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcDetails() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_details", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcGenus() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_genus", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcSpecies() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_species", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcStrain() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_strain", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcTissue() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_tissue", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcTissueFraction() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_tissue_fraction", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterHostOrgGenus() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "host_org_genus", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterHostOrgSpecies() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "host_org_species", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcFragment() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_fragment", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcGene() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_gene", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcScientificName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_scientific_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcVariant() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_variant", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcCellLine() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_cell_line", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcAtcc() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_atcc", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcOrgan() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_organ", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcOrganelle() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_organelle", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcPlasmid() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_plasmid", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcPlasmidName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_plasmid_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcCell() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_cell", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcCellularLocation() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_cellular_location", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgGene() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_gene", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgOrgan() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_organ", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgOrganelle() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_organelle", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgCellularLocation() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_cellular_location", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgStrain() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_strain", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgTissueFraction() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_tissue_fraction", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxDescription() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_description", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterHostOrgCommonName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "host_org_common_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterHostOrgDetails() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "host_org_details", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterHostOrgStrain() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "host_org_strain", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPlasmidDetails() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "plasmid_details", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPlasmidName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "plasmid_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgVariant() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_variant", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgCellLine() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_cell_line", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgAtcc() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_atcc", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgCultureCollection() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_culture_collection", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgCell() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_cell", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgScientificName() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_scientific_name", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgTissue() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_tissue", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgVector() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_vector", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgVectorType() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_vector_type", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterExpressionSystemId() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "expression_system_id", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterGeneSrcDevStage() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "gene_src_dev_stage", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterStartConstructId() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "start_construct_id", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcNcbiTaxonomyId() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_ncbi_taxonomy_id", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxHostOrgNcbiTaxonomyId() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_host_org_ncbi_taxonomy_id", this);
        }

        public IntColumnBuilder<EntitySrcGenBuilder> enterPdbxSrcId() {
            return new IntColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_src_id", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxAltSourceFlag() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_alt_source_flag", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxSeqType() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_seq_type", this);
        }

        public IntColumnBuilder<EntitySrcGenBuilder> enterPdbxBegSeqNum() {
            return new IntColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_beg_seq_num", this);
        }

        public IntColumnBuilder<EntitySrcGenBuilder> enterPdbxEndSeqNum() {
            return new IntColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_end_seq_num", this);
        }

        public StrColumnBuilder<EntitySrcGenBuilder> enterPdbxGeneSrcCultureCollection() {
            return new StrColumnBuilder<EntitySrcGenBuilder>(CATEGORY_NAME, "pdbx_gene_src_culture_collection", this);
        }
    }

    public static class EntitySrcNatBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "entity_src_nat";

        public EntitySrcNatBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterCommonName() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "common_name", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterDetails() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterEntityId() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterGenus() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "genus", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterSpecies() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "species", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterStrain() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "strain", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterTissue() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "tissue", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterTissueFraction() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "tissue_fraction", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxOrganismScientific() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_organism_scientific", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxSecretion() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_secretion", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxFragment() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_fragment", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxVariant() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_variant", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxCellLine() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_cell_line", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxAtcc() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_atcc", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxCellularLocation() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_cellular_location", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxOrgan() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_organ", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxOrganelle() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_organelle", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxCell() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_cell", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxPlasmidName() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_plasmid_name", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxPlasmidDetails() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_plasmid_details", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxNcbiTaxonomyId() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_ncbi_taxonomy_id", this);
        }

        public IntColumnBuilder<EntitySrcNatBuilder> enterPdbxSrcId() {
            return new IntColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_src_id", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxAltSourceFlag() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_alt_source_flag", this);
        }

        public IntColumnBuilder<EntitySrcNatBuilder> enterPdbxBegSeqNum() {
            return new IntColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_beg_seq_num", this);
        }

        public IntColumnBuilder<EntitySrcNatBuilder> enterPdbxEndSeqNum() {
            return new IntColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_end_seq_num", this);
        }

        public StrColumnBuilder<EntitySrcNatBuilder> enterPdbxCultureCollection() {
            return new StrColumnBuilder<EntitySrcNatBuilder>(CATEGORY_NAME, "pdbx_culture_collection", this);
        }
    }

    public static class PdbxChemCompSubcomponentEntityListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_subcomponent_entity_list";

        public PdbxChemCompSubcomponentEntityListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder> enterId() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder> enterParentCompId() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder>(CATEGORY_NAME, "parent_comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentEntityListBuilder>(CATEGORY_NAME, "class", this);
        }
    }

    public static class PdbxChemCompSubcomponentStructConnBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_subcomponent_struct_conn";

        public PdbxChemCompSubcomponentStructConnBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterId() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterEntityId1() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "entity_id_1", this);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterEntityId2() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "entity_id_2", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterSeqId1() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "seq_id_1", this);
        }

        public IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder> enterSeqId2() {
            return new IntColumnBuilder<PdbxChemCompSubcomponentStructConnBuilder>(CATEGORY_NAME, "seq_id_2", this);
        }
    }

    public static class PdbxAuditSupportBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_audit_support";

        public PdbxAuditSupportBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAuditSupportBuilder> enterFundingOrganization() {
            return new StrColumnBuilder<PdbxAuditSupportBuilder>(CATEGORY_NAME, "funding_organization", this);
        }

        public StrColumnBuilder<PdbxAuditSupportBuilder> enterCountry() {
            return new StrColumnBuilder<PdbxAuditSupportBuilder>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxAuditSupportBuilder> enterGrantNumber() {
            return new StrColumnBuilder<PdbxAuditSupportBuilder>(CATEGORY_NAME, "grant_number", this);
        }

        public StrColumnBuilder<PdbxAuditSupportBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxAuditSupportBuilder>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<PdbxAuditSupportBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxAuditSupportBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxNmrUploadBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_upload";

        public PdbxNmrUploadBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrUploadBuilder> enterDataFileId() {
            return new IntColumnBuilder<PdbxNmrUploadBuilder>(CATEGORY_NAME, "data_file_id", this);
        }

        public StrColumnBuilder<PdbxNmrUploadBuilder> enterDataFileName() {
            return new StrColumnBuilder<PdbxNmrUploadBuilder>(CATEGORY_NAME, "data_file_name", this);
        }

        public StrColumnBuilder<PdbxNmrUploadBuilder> enterDataFileCategory() {
            return new StrColumnBuilder<PdbxNmrUploadBuilder>(CATEGORY_NAME, "data_file_category", this);
        }

        public StrColumnBuilder<PdbxNmrUploadBuilder> enterDataFileSyntax() {
            return new StrColumnBuilder<PdbxNmrUploadBuilder>(CATEGORY_NAME, "data_file_syntax", this);
        }

        public StrColumnBuilder<PdbxNmrUploadBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrUploadBuilder>(CATEGORY_NAME, "entry_id", this);
        }
    }

    public static class PdbxNmrSystematicChemShiftOffsetBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_systematic_chem_shift_offset";

        public PdbxNmrSystematicChemShiftOffsetBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterType() {
            return new StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterAtomType() {
            return new StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "atom_type", this);
        }

        public IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterAtomIsotopeNumber() {
            return new IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "atom_isotope_number", this);
        }

        public FloatColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterVal() {
            return new FloatColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "val", this);
        }

        public FloatColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterValErr() {
            return new FloatColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "val_err", this);
        }

        public StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterAssignedChemShiftListId() {
            return new IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "assigned_chem_shift_list_id", this);
        }

        public IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxNmrSystematicChemShiftOffsetBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxNmrSpectralPeakSoftwareBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_spectral_peak_software";

        public PdbxNmrSpectralPeakSoftwareBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder> enterSoftwareId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder>(CATEGORY_NAME, "software_id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder> enterSpectralPeakListId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakSoftwareBuilder>(CATEGORY_NAME, "spectral_peak_list_id", this);
        }
    }

    public static class PdbxNmrSpectralPeakListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_spectral_peak_list";

        public PdbxNmrSpectralPeakListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterDataFileName() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "data_file_name", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterSolutionId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "solution_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterConditionsId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "conditions_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterExperimentId() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterNumberOfSpectralDimensions() {
            return new IntColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "number_of_spectral_dimensions", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterTextDataFormat() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "text_data_format", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterLabel() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralPeakListBuilder> enterConditionsLabel() {
            return new StrColumnBuilder<PdbxNmrSpectralPeakListBuilder>(CATEGORY_NAME, "conditions_label", this);
        }
    }

    public static class PdbxNmrSpectralDimBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_spectral_dim";

        public PdbxNmrSpectralDimBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrSpectralDimBuilder> enterId() {
            return new IntColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterAtomType() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "atom_type", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralDimBuilder> enterAtomIsotopeNumber() {
            return new IntColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "atom_isotope_number", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterSpectralRegion() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "spectral_region", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralDimBuilder> enterMagnetizationLinkageId() {
            return new IntColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "magnetization_linkage_id", this);
        }

        public FloatColumnBuilder<PdbxNmrSpectralDimBuilder> enterSweepWidth() {
            return new FloatColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "sweep_width", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterEncodingCode() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "encoding_code", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralDimBuilder> enterEncodedSourceDimensionId() {
            return new IntColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "encoded_source_dimension_id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSpectralDimBuilder> enterSpectralPeakListId() {
            return new IntColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "spectral_peak_list_id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterSweepWidthUnits() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "sweep_width_units", this);
        }

        public FloatColumnBuilder<PdbxNmrSpectralDimBuilder> enterCenterFrequencyOffset() {
            return new FloatColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "center_frequency_offset", this);
        }

        public StrColumnBuilder<PdbxNmrSpectralDimBuilder> enterUnderSamplingType() {
            return new StrColumnBuilder<PdbxNmrSpectralDimBuilder>(CATEGORY_NAME, "under_sampling_type", this);
        }
    }

    public static class PdbxNmrSoftwareTaskBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_software_task";

        public PdbxNmrSoftwareTaskBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSoftwareTaskBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrSoftwareTaskBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrSoftwareTaskBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilder<PdbxNmrSoftwareTaskBuilder>(CATEGORY_NAME, "software_ordinal", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareTaskBuilder> enterTask() {
            return new StrColumnBuilder<PdbxNmrSoftwareTaskBuilder>(CATEGORY_NAME, "task", this);
        }
    }

    public static class PdbxNmrConstraintFileBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_constraint_file";

        public PdbxNmrConstraintFileBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder> enterConstraintFilename() {
            return new StrColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "constraint_filename", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder> enterConstraintNumber() {
            return new IntColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "constraint_number", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder> enterConstraintSubtype() {
            return new StrColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "constraint_subtype", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder> enterConstraintType() {
            return new StrColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "constraint_type", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder> enterId() {
            return new IntColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintFileBuilder> enterSoftwareName() {
            return new StrColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "software_name", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintFileBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilder<PdbxNmrConstraintFileBuilder>(CATEGORY_NAME, "software_ordinal", this);
        }
    }

    public static class PdbxNmrChemShiftSoftwareBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_software";

        public PdbxNmrChemShiftSoftwareBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder> enterAssignedChemShiftListId() {
            return new IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder>(CATEGORY_NAME, "assigned_chem_shift_list_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder> enterSoftwareId() {
            return new IntColumnBuilder<PdbxNmrChemShiftSoftwareBuilder>(CATEGORY_NAME, "software_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder> enterSoftwareLabel() {
            return new StrColumnBuilder<PdbxNmrChemShiftSoftwareBuilder>(CATEGORY_NAME, "software_label", this);
        }
    }

    public static class PdbxNmrChemShiftReferenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_reference";

        public PdbxNmrChemShiftReferenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterCarbonShiftsFlag() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "carbon_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterId() {
            return new IntColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterLabel() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterNitrogenShiftsFlag() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "nitrogen_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterOtherShiftsFlag() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "other_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterPhosphorusShiftsFlag() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "phosphorus_shifts_flag", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder> enterProtonShiftsFlag() {
            return new StrColumnBuilder<PdbxNmrChemShiftReferenceBuilder>(CATEGORY_NAME, "proton_shifts_flag", this);
        }
    }

    public static class PdbxNmrChemShiftRefBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_ref";

        public PdbxNmrChemShiftRefBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterAtomGroup() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "atom_group", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftRefBuilder> enterAtomIsotopeNumber() {
            return new IntColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "atom_isotope_number", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterAtomType() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "atom_type", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftRefBuilder> enterChemShiftReferenceId() {
            return new IntColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "chem_shift_reference_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterChemShiftUnits() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "chem_shift_units", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder> enterChemShiftVal() {
            return new FloatColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "chem_shift_val", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder> enterCorrectionVal() {
            return new FloatColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "correction_val", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterExternalRefAxis() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "external_ref_axis", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterExternalRefLoc() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "external_ref_loc", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterExternalRefSampleGeometry() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "external_ref_sample_geometry", this);
        }

        public FloatColumnBuilder<PdbxNmrChemShiftRefBuilder> enterIndirectShiftRatio() {
            return new FloatColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "indirect_shift_ratio", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterMolCommonName() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "mol_common_name", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterRank() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "rank", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterRefCorrectionType() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "ref_correction_type", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterRefMethod() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "ref_method", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterRefType() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "ref_type", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftRefBuilder> enterSolvent() {
            return new StrColumnBuilder<PdbxNmrChemShiftRefBuilder>(CATEGORY_NAME, "solvent", this);
        }
    }

    public static class PdbxNmrChemShiftExperimentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_chem_shift_experiment";

        public PdbxNmrChemShiftExperimentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterAssignedChemShiftListId() {
            return new IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "assigned_chem_shift_list_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterExperimentId() {
            return new IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterExperimentName() {
            return new StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "experiment_name", this);
        }

        public StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterSampleState() {
            return new StrColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "sample_state", this);
        }

        public IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder> enterSolutionId() {
            return new IntColumnBuilder<PdbxNmrChemShiftExperimentBuilder>(CATEGORY_NAME, "solution_id", this);
        }
    }

    public static class PdbxNmrAssignedChemShiftListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_assigned_chem_shift_list";

        public PdbxNmrAssignedChemShiftListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift13CErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_13C_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift15NErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_15N_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift19FErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_19F_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift1HErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_1H_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift2HErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_2H_err", this);
        }

        public FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShift31PErr() {
            return new FloatColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_31P_err", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterChemShiftReferenceId() {
            return new IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "chem_shift_reference_id", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterConditionsId() {
            return new IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterDataFileName() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "data_file_name", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterErrorDerivationMethod() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "error_derivation_method", this);
        }

        public IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterId() {
            return new IntColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterLabel() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder> enterConditionsLabel() {
            return new StrColumnBuilder<PdbxNmrAssignedChemShiftListBuilder>(CATEGORY_NAME, "conditions_label", this);
        }
    }

    public static class PdbxReferencePublicationListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_publication_list";

        public PdbxReferencePublicationListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterPublicationAbbrev() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "publication_abbrev", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterASTMCodeType() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "ASTM_code_type", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterASTMCodeValue() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "ASTM_code_value", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterISSNCodeType() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "ISSN_code_type", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterISSNCodeValue() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "ISSN_code_value", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterCountry() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterStartYear() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "start_year", this);
        }

        public StrColumnBuilder<PdbxReferencePublicationListBuilder> enterEndYear() {
            return new StrColumnBuilder<PdbxReferencePublicationListBuilder>(CATEGORY_NAME, "end_year", this);
        }
    }

    public static class PdbxStructSpecialSymmetryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_special_symmetry";

        public PdbxStructSpecialSymmetryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterId() {
            return new IntColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructSpecialSymmetryBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxStructSpecialSymmetryBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }
    }

    public static class PdbxDistantSolventAtomsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_distant_solvent_atoms";

        public PdbxDistantSolventAtomsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder> enterId() {
            return new IntColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDistantSolventAtomsBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDistantSolventAtomsBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxDistantSolventAtomsBuilder> enterNeighborMacromoleculeDistance() {
            return new FloatColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "neighbor_macromolecule_distance", this);
        }

        public FloatColumnBuilder<PdbxDistantSolventAtomsBuilder> enterNeighborLigandDistance() {
            return new FloatColumnBuilder<PdbxDistantSolventAtomsBuilder>(CATEGORY_NAME, "neighbor_ligand_distance", this);
        }
    }

    public static class PdbxFamilyGroupIndexBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_family_group_index";

        public PdbxFamilyGroupIndexBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFamilyGroupIndexBuilder> enterId() {
            return new StrColumnBuilder<PdbxFamilyGroupIndexBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFamilyGroupIndexBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxFamilyGroupIndexBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }
    }

    public static class PdbxMoleculeFeaturesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_molecule_features";

        public PdbxMoleculeFeaturesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder> enterType() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder> enterName() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxMoleculeFeaturesBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxMoleculeFeaturesBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxMoleculeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_molecule";

        public PdbxMoleculeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxMoleculeBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxMoleculeBuilder> enterInstanceId() {
            return new IntColumnBuilder<PdbxMoleculeBuilder>(CATEGORY_NAME, "instance_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxMoleculeBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxMoleculeBuilder> enterLinkedEntityId() {
            return new StrColumnBuilder<PdbxMoleculeBuilder>(CATEGORY_NAME, "linked_entity_id", this);
        }
    }

    public static class PdbxFamilyPrdAuditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_family_prd_audit";

        public PdbxFamilyPrdAuditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterDate() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterAnnotator() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterProcessingSite() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxFamilyPrdAuditBuilder> enterActionType() {
            return new StrColumnBuilder<PdbxFamilyPrdAuditBuilder>(CATEGORY_NAME, "action_type", this);
        }
    }

    public static class PdbxPrdAuditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_prd_audit";

        public PdbxPrdAuditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterDate() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterAnnotator() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterProcessingSite() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxPrdAuditBuilder> enterActionType() {
            return new StrColumnBuilder<PdbxPrdAuditBuilder>(CATEGORY_NAME, "action_type", this);
        }
    }

    public static class PdbxStructGroupComponentRangeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_component_range";

        public PdbxStructGroupComponentRangeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterStructGroupId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "struct_group_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegAuthCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegPDBInsCode() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegLabelCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterBegLabelAltId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndAuthCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndPDBInsCode() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndLabelCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentRangeBuilder> enterEndLabelAltId() {
            return new StrColumnBuilder<PdbxStructGroupComponentRangeBuilder>(CATEGORY_NAME, "end_label_alt_id", this);
        }
    }

    public static class PdbxStructGroupComponentsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_components";

        public PdbxStructGroupComponentsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterStructGroupId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "struct_group_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructGroupComponentsBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupComponentsBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxStructGroupComponentsBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }
    }

    public static class PdbxStructGroupListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_group_list";

        public PdbxStructGroupListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterStructGroupId() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "struct_group_id", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterName() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterGroupEnumerationType() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "group_enumeration_type", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterSelection() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "selection", this);
        }

        public StrColumnBuilder<PdbxStructGroupListBuilder> enterSelectionDetails() {
            return new StrColumnBuilder<PdbxStructGroupListBuilder>(CATEGORY_NAME, "selection_details", this);
        }
    }

    public static class PdbxReferenceMoleculeRelatedStructuresBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_related_structures";

        public PdbxReferenceMoleculeRelatedStructuresBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterDbAccession() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "db_accession", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterFormula() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder> enterCitationId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeRelatedStructuresBuilder>(CATEGORY_NAME, "citation_id", this);
        }
    }

    public static class PdbxReferenceMoleculeFeaturesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_features";

        public PdbxReferenceMoleculeFeaturesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterSourceOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "source_ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterValue() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterSource() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFeaturesBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }
    }

    public static class PdbxReferenceMoleculeAnnotationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_annotation";

        public PdbxReferenceMoleculeAnnotationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterText() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "text", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterSupport() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "support", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterSource() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeAnnotationBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }
    }

    public static class PdbxReferenceEntitySubcomponentsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_subcomponents";

        public PdbxReferenceEntitySubcomponentsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder> enterSeq() {
            return new StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder>(CATEGORY_NAME, "seq", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceEntitySubcomponentsBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }
    }

    public static class PdbxReferenceMoleculeSynonymsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_synonyms";

        public PdbxReferenceMoleculeSynonymsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterSource() {
            return new StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeSynonymsBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }
    }

    public static class PdbxReferenceMoleculeDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_details";

        public PdbxReferenceMoleculeDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public IntColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterSource() {
            return new StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterSourceId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "source_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder> enterText() {
            return new StrColumnBuilder<PdbxReferenceMoleculeDetailsBuilder>(CATEGORY_NAME, "text", this);
        }
    }

    public static class PdbxReferenceEntitySrcNatBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_src_nat";

        public PdbxReferenceEntitySrcNatBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterOrganismScientific() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "organism_scientific", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterStrain() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "strain", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterTaxid() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "taxid", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterAtcc() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "atcc", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterSource() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "source", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder> enterSourceId() {
            return new StrColumnBuilder<PdbxReferenceEntitySrcNatBuilder>(CATEGORY_NAME, "source_id", this);
        }
    }

    public static class PdbxReferenceEntitySequenceBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_sequence";

        public PdbxReferenceEntitySequenceBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntitySequenceBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntitySequenceBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceEntitySequenceBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder> enterNRPFlag() {
            return new StrColumnBuilder<PdbxReferenceEntitySequenceBuilder>(CATEGORY_NAME, "NRP_flag", this);
        }

        public StrColumnBuilder<PdbxReferenceEntitySequenceBuilder> enterOneLetterCodes() {
            return new StrColumnBuilder<PdbxReferenceEntitySequenceBuilder>(CATEGORY_NAME, "one_letter_codes", this);
        }
    }

    public static class PdbxReferenceEntityPolySeqBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly_seq";

        public PdbxReferenceEntityPolySeqBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterMonId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterParentMonId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "parent_mon_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterNum() {
            return new IntColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "num", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterObserved() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "observed", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder> enterHetero() {
            return new StrColumnBuilder<PdbxReferenceEntityPolySeqBuilder>(CATEGORY_NAME, "hetero", this);
        }
    }

    public static class PdbxReferenceEntityPolyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly";

        public PdbxReferenceEntityPolyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyBuilder>(CATEGORY_NAME, "db_name", this);
        }
    }

    public static class PdbxReferenceEntityPolyLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_poly_link";

        public PdbxReferenceEntityPolyLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterComponentId() {
            return new IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "component_id", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterInsertCode1() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "insert_code_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterInsertCode2() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "insert_code_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxReferenceEntityPolyLinkBuilder>(CATEGORY_NAME, "value_order", this);
        }
    }

    public static class PdbxReferenceEntityLinkBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_link";

        public PdbxReferenceEntityLinkBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder> enterLinkId() {
            return new IntColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "link_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterRefEntityId1() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "ref_entity_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterRefEntityId2() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "ref_entity_id_2", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder> enterEntitySeqNum1() {
            return new IntColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "entity_seq_num_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder> enterEntitySeqNum2() {
            return new IntColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "entity_seq_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterCompId1() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "comp_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterCompId2() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "comp_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterValueOrder() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "value_order", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder> enterComponent1() {
            return new IntColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "component_1", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityLinkBuilder> enterComponent2() {
            return new IntColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "component_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterNonpolyResNum1() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "nonpoly_res_num_1", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterNonpolyResNum2() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "nonpoly_res_num_2", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityLinkBuilder> enterLinkClass() {
            return new StrColumnBuilder<PdbxReferenceEntityLinkBuilder>(CATEGORY_NAME, "link_class", this);
        }
    }

    public static class PdbxReferenceEntityNonpolyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_nonpoly";

        public PdbxReferenceEntityNonpolyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceEntityNonpolyBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }
    }

    public static class PdbxReferenceEntityListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_entity_list";

        public PdbxReferenceEntityListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceEntityListBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder> enterRefEntityId() {
            return new StrColumnBuilder<PdbxReferenceEntityListBuilder>(CATEGORY_NAME, "ref_entity_id", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceEntityListBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceEntityListBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReferenceEntityListBuilder>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<PdbxReferenceEntityListBuilder> enterComponentId() {
            return new IntColumnBuilder<PdbxReferenceEntityListBuilder>(CATEGORY_NAME, "component_id", this);
        }
    }

    public static class PdbxReferenceMoleculeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule";

        public PdbxReferenceMoleculeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public FloatColumnBuilder<PdbxReferenceMoleculeBuilder> enterFormulaWeight() {
            return new FloatColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "formula_weight", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterFormula() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "formula", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterType() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterTypeEvidenceCode() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "type_evidence_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterClassEvidenceCode() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "class_evidence_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterRepresentAs() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "represent_as", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterChemCompId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "chem_comp_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterCompoundDetails() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "compound_details", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterDescription() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "description", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterRepresentativePDBIdCode() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "representative_PDB_id_code", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterReleaseStatus() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "release_status", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterReplaces() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "replaces", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeBuilder> enterReplacedBy() {
            return new StrColumnBuilder<PdbxReferenceMoleculeBuilder>(CATEGORY_NAME, "replaced_by", this);
        }
    }

    public static class PdbxReferenceMoleculeListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_list";

        public PdbxReferenceMoleculeListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeListBuilder> enterPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeListBuilder>(CATEGORY_NAME, "prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeListBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeListBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }
    }

    public static class PdbxReferenceMoleculeFamilyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reference_molecule_family";

        public PdbxReferenceMoleculeFamilyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder> enterFamilyPrdId() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder>(CATEGORY_NAME, "family_prd_id", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder> enterName() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder> enterReleaseStatus() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder>(CATEGORY_NAME, "release_status", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder> enterReplaces() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder>(CATEGORY_NAME, "replaces", this);
        }

        public StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder> enterReplacedBy() {
            return new StrColumnBuilder<PdbxReferenceMoleculeFamilyBuilder>(CATEGORY_NAME, "replaced_by", this);
        }
    }

    public static class PdbxChemCompAtomFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_atom_feature";

        public PdbxChemCompAtomFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompAtomFeatureBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder> enterAtomId() {
            return new StrColumnBuilder<PdbxChemCompAtomFeatureBuilder>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomFeatureBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxChemCompAtomFeatureBuilder>(CATEGORY_NAME, "feature_type", this);
        }
    }

    public static class PdbxStructLegacyOperListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_legacy_oper_list";

        public PdbxStructLegacyOperListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructLegacyOperListBuilder> enterId() {
            return new IntColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructLegacyOperListBuilder> enterName() {
            return new StrColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "name", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix11() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix12() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix13() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix21() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix22() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix23() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix31() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix32() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterMatrix33() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterVector1() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterVector2() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<PdbxStructLegacyOperListBuilder> enterVector3() {
            return new FloatColumnBuilder<PdbxStructLegacyOperListBuilder>(CATEGORY_NAME, "vector[3]", this);
        }
    }

    public static class PdbxStructMsymGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_msym_gen";

        public PdbxStructMsymGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder> enterEntityInstId() {
            return new StrColumnBuilder<PdbxStructMsymGenBuilder>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder> enterMsymId() {
            return new StrColumnBuilder<PdbxStructMsymGenBuilder>(CATEGORY_NAME, "msym_id", this);
        }

        public StrColumnBuilder<PdbxStructMsymGenBuilder> enterOperExpression() {
            return new StrColumnBuilder<PdbxStructMsymGenBuilder>(CATEGORY_NAME, "oper_expression", this);
        }
    }

    public static class PdbxStructAsymGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_asym_gen";

        public PdbxStructAsymGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder> enterEntityInstId() {
            return new StrColumnBuilder<PdbxStructAsymGenBuilder>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructAsymGenBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructAsymGenBuilder> enterOperExpression() {
            return new StrColumnBuilder<PdbxStructAsymGenBuilder>(CATEGORY_NAME, "oper_expression", this);
        }
    }

    public static class PdbxStructAssemblyGenBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_gen";

        public PdbxStructAssemblyGenBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder> enterEntityInstId() {
            return new StrColumnBuilder<PdbxStructAssemblyGenBuilder>(CATEGORY_NAME, "entity_inst_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder> enterAsymIdList() {
            return new StrColumnBuilder<PdbxStructAssemblyGenBuilder>(CATEGORY_NAME, "asym_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder> enterAuthAsymIdList() {
            return new StrColumnBuilder<PdbxStructAssemblyGenBuilder>(CATEGORY_NAME, "auth_asym_id_list", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxStructAssemblyGenBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyGenBuilder> enterOperExpression() {
            return new StrColumnBuilder<PdbxStructAssemblyGenBuilder>(CATEGORY_NAME, "oper_expression", this);
        }
    }

    public static class PdbxStructAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly";

        public PdbxStructAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder> enterMethodDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyBuilder>(CATEGORY_NAME, "method_details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder> enterOligomericDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyBuilder>(CATEGORY_NAME, "oligomeric_details", this);
        }

        public IntColumnBuilder<PdbxStructAssemblyBuilder> enterOligomericCount() {
            return new IntColumnBuilder<PdbxStructAssemblyBuilder>(CATEGORY_NAME, "oligomeric_count", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructAssemblyBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class PdbxStructOperListBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_oper_list";

        public PdbxStructOperListBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder> enterName() {
            return new StrColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxStructOperListBuilder> enterSymmetryOperation() {
            return new StrColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "symmetry_operation", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix11() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[1][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix12() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[1][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix13() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[1][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix21() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[2][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix22() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[2][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix23() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[2][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix31() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[3][1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix32() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[3][2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterMatrix33() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "matrix[3][3]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterVector1() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "vector[1]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterVector2() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "vector[2]", this);
        }

        public FloatColumnBuilder<PdbxStructOperListBuilder> enterVector3() {
            return new FloatColumnBuilder<PdbxStructOperListBuilder>(CATEGORY_NAME, "vector[3]", this);
        }
    }

    public static class PdbxStructEntityInstBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_entity_inst";

        public PdbxStructEntityInstBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructEntityInstBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxStructEntityInstBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxStructEntityInstBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructEntityInstBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class PdbxPointSymmetryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_point_symmetry";

        public PdbxPointSymmetryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPointSymmetryBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder> enterSchoenfliesSymbol() {
            return new StrColumnBuilder<PdbxPointSymmetryBuilder>(CATEGORY_NAME, "Schoenflies_symbol", this);
        }

        public IntColumnBuilder<PdbxPointSymmetryBuilder> enterCircularSymmetry() {
            return new IntColumnBuilder<PdbxPointSymmetryBuilder>(CATEGORY_NAME, "circular_symmetry", this);
        }

        public StrColumnBuilder<PdbxPointSymmetryBuilder> enterH_MNotation() {
            return new StrColumnBuilder<PdbxPointSymmetryBuilder>(CATEGORY_NAME, "H-M_notation", this);
        }
    }

    public static class PdbxHelicalSymmetryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_helical_symmetry";

        public PdbxHelicalSymmetryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder> enterNumberOfOperations() {
            return new IntColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "number_of_operations", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryBuilder> enterRotationPerNSubunits() {
            return new FloatColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "rotation_per_n_subunits", this);
        }

        public FloatColumnBuilder<PdbxHelicalSymmetryBuilder> enterRisePerNSubunits() {
            return new FloatColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "rise_per_n_subunits", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder> enterNSubunitsDivisor() {
            return new IntColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "n_subunits_divisor", this);
        }

        public StrColumnBuilder<PdbxHelicalSymmetryBuilder> enterDyadAxis() {
            return new StrColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "dyad_axis", this);
        }

        public IntColumnBuilder<PdbxHelicalSymmetryBuilder> enterCircularSymmetry() {
            return new IntColumnBuilder<PdbxHelicalSymmetryBuilder>(CATEGORY_NAME, "circular_symmetry", this);
        }
    }

    public static class PdbxValidatePolymerLinkageBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_polymer_linkage";

        public PdbxValidatePolymerLinkageBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidatePolymerLinkageBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxValidatePolymerLinkageBuilder>(CATEGORY_NAME, "dist", this);
        }
    }

    public static class PdbxRemediationAtomSiteMappingBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_remediation_atom_site_mapping";

        public PdbxRemediationAtomSiteMappingBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterGroupPDB() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "group_PDB", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPdbxAlign() {
            return new IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pdbx_align", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreAuthAsymId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreAuthAtomId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreAuthCompId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreAuthSeqId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPrePDBInsCode() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreGroupPDB() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_group_PDB", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreAuthAltId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_auth_alt_id", this);
        }

        public IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPrePdbxAlign() {
            return new IntColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_pdbx_align", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterAuthAltId() {
            return new StrColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "auth_alt_id", this);
        }

        public FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterOccupancy() {
            return new FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder> enterPreOccupancy() {
            return new FloatColumnBuilder<PdbxRemediationAtomSiteMappingBuilder>(CATEGORY_NAME, "pre_occupancy", this);
        }
    }

    public static class PdbxStructRefSeqDeletionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_deletion";

        public PdbxStructRefSeqDeletionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterDbSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "db_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqDeletionBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxStructRefSeqDeletionBuilder>(CATEGORY_NAME, "db_name", this);
        }
    }

    public static class PdbxStructRefSeqInsertionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_insertion";

        public PdbxStructRefSeqInsertionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterDbCode() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "db_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqInsertionBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxStructRefSeqInsertionBuilder>(CATEGORY_NAME, "db_name", this);
        }
    }

    public static class PdbxStructModResidueBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_mod_residue";

        public PdbxStructModResidueBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder> enterId() {
            return new IntColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder> enterAuthSeqId() {
            return new IntColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructModResidueBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterParentCompId() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "parent_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructModResidueBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructModResidueBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntryDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entry_details";

        public PdbxEntryDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntryDetailsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder> enterNonpolymerDetails() {
            return new StrColumnBuilder<PdbxEntryDetailsBuilder>(CATEGORY_NAME, "nonpolymer_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder> enterSequenceDetails() {
            return new StrColumnBuilder<PdbxEntryDetailsBuilder>(CATEGORY_NAME, "sequence_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder> enterCompoundDetails() {
            return new StrColumnBuilder<PdbxEntryDetailsBuilder>(CATEGORY_NAME, "compound_details", this);
        }

        public StrColumnBuilder<PdbxEntryDetailsBuilder> enterSourceDetails() {
            return new StrColumnBuilder<PdbxEntryDetailsBuilder>(CATEGORY_NAME, "source_details", this);
        }
    }

    public static class PdbxUnobsOrZeroOccAtomsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_unobs_or_zero_occ_atoms";

        public PdbxUnobsOrZeroOccAtomsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterId() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterPolymerFlag() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "polymer_flag", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterOccupancyFlag() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "occupancy_flag", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccAtomsBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }
    }

    public static class PdbxUnobsOrZeroOccResiduesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_unobs_or_zero_occ_residues";

        public PdbxUnobsOrZeroOccResiduesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterId() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterPolymerFlag() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "polymer_flag", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterOccupancyFlag() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "occupancy_flag", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxUnobsOrZeroOccResiduesBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }
    }

    public static class PdbxStructConnAngleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_conn_angle";

        public PdbxStructConnAngleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1LabelAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1LabelAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1LabelAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1LabelCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1LabelSeqId() {
            return new IntColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1AuthAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1AuthAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1AuthCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1AuthSeqId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1Symmetry() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2LabelAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2LabelAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2LabelAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2LabelCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2LabelSeqId() {
            return new IntColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2AuthAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2AuthAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2AuthCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2AuthSeqId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2Symmetry() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_symmetry", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1PDBInsCode() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr1AuthAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr1_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2PDBInsCode() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr2AuthAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr2_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3AuthAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_auth_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3AuthAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3AuthAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3AuthCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3PDBInsCode() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3AuthSeqId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3LabelAltId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3LabelAsymId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3LabelAtomId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_label_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3LabelCompId() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3LabelSeqId() {
            return new IntColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructConnAngleBuilder> enterPtnr3Symmetry() {
            return new StrColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "ptnr3_symmetry", this);
        }

        public FloatColumnBuilder<PdbxStructConnAngleBuilder> enterValue() {
            return new FloatColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "value", this);
        }

        public FloatColumnBuilder<PdbxStructConnAngleBuilder> enterValueEsd() {
            return new FloatColumnBuilder<PdbxStructConnAngleBuilder>(CATEGORY_NAME, "value_esd", this);
        }
    }

    public static class PdbxValidateMainChainPlaneBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_main_chain_plane";

        public PdbxValidateMainChainPlaneBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidateMainChainPlaneBuilder> enterImproperTorsionAngle() {
            return new FloatColumnBuilder<PdbxValidateMainChainPlaneBuilder>(CATEGORY_NAME, "improper_torsion_angle", this);
        }
    }

    public static class PdbxValidatePlanesAtomBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_planes_atom";

        public PdbxValidatePlanesAtomBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder> enterPlaneId() {
            return new IntColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "plane_id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesAtomBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesAtomBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public FloatColumnBuilder<PdbxValidatePlanesAtomBuilder> enterAtomDeviation() {
            return new FloatColumnBuilder<PdbxValidatePlanesAtomBuilder>(CATEGORY_NAME, "atom_deviation", this);
        }
    }

    public static class PdbxValidatePlanesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_planes";

        public PdbxValidatePlanesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePlanesBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePlanesBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidatePlanesBuilder> enterRmsd() {
            return new FloatColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "rmsd", this);
        }

        public StrColumnBuilder<PdbxValidatePlanesBuilder> enterType() {
            return new StrColumnBuilder<PdbxValidatePlanesBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxValidateChiralBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_chiral";

        public PdbxValidateChiralBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateChiralBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateChiralBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public FloatColumnBuilder<PdbxValidateChiralBuilder> enterOmega() {
            return new FloatColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "omega", this);
        }

        public StrColumnBuilder<PdbxValidateChiralBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxValidateChiralBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxValidatePeptideOmegaBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_peptide_omega";

        public PdbxValidatePeptideOmegaBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidatePeptideOmegaBuilder> enterOmega() {
            return new FloatColumnBuilder<PdbxValidatePeptideOmegaBuilder>(CATEGORY_NAME, "omega", this);
        }
    }

    public static class PdbxValidateTorsionBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_torsion";

        public PdbxValidateTorsionBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateTorsionBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateTorsionBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxValidateTorsionBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public FloatColumnBuilder<PdbxValidateTorsionBuilder> enterPhi() {
            return new FloatColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "phi", this);
        }

        public FloatColumnBuilder<PdbxValidateTorsionBuilder> enterPsi() {
            return new FloatColumnBuilder<PdbxValidateTorsionBuilder>(CATEGORY_NAME, "psi", this);
        }
    }

    public static class PdbxValidateRmsdAngleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_rmsd_angle";

        public PdbxValidateRmsdAngleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateRmsdAngleBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateRmsdAngleBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAtomId3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_atom_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthAsymId3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_asym_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthCompId3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_comp_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAuthSeqId3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "auth_seq_id_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterPDBInsCode3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "PDB_ins_code_3", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterLabelAltId3() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "label_alt_id_3", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAngleDeviation() {
            return new FloatColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "angle_deviation", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAngleValue() {
            return new FloatColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "angle_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAngleTargetValue() {
            return new FloatColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "angle_target_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdAngleBuilder> enterAngleStandardDeviation() {
            return new FloatColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "angle_standard_deviation", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdAngleBuilder> enterLinkerFlag() {
            return new StrColumnBuilder<PdbxValidateRmsdAngleBuilder>(CATEGORY_NAME, "linker_flag", this);
        }
    }

    public static class PdbxValidateRmsdBondBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_rmsd_bond";

        public PdbxValidateRmsdBondBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateRmsdBondBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateRmsdBondBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder> enterBondDeviation() {
            return new FloatColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "bond_deviation", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder> enterBondValue() {
            return new FloatColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "bond_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder> enterBondTargetValue() {
            return new FloatColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "bond_target_value", this);
        }

        public FloatColumnBuilder<PdbxValidateRmsdBondBuilder> enterBondStandardDeviation() {
            return new FloatColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "bond_standard_deviation", this);
        }

        public StrColumnBuilder<PdbxValidateRmsdBondBuilder> enterLinkerFlag() {
            return new StrColumnBuilder<PdbxValidateRmsdBondBuilder>(CATEGORY_NAME, "linker_flag", this);
        }
    }

    public static class PdbxValidateSymmContactBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_symm_contact";

        public PdbxValidateSymmContactBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateSymmContactBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateSymmContactBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterSiteSymmetry1() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "site_symmetry_1", this);
        }

        public StrColumnBuilder<PdbxValidateSymmContactBuilder> enterSiteSymmetry2() {
            return new StrColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "site_symmetry_2", this);
        }

        public FloatColumnBuilder<PdbxValidateSymmContactBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxValidateSymmContactBuilder>(CATEGORY_NAME, "dist", this);
        }
    }

    public static class PdbxValidateCloseContactBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_validate_close_contact";

        public PdbxValidateCloseContactBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxValidateCloseContactBuilder> enterId() {
            return new IntColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "id", this);
        }

        public IntColumnBuilder<PdbxValidateCloseContactBuilder> enterPDBModelNum() {
            return new IntColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "PDB_model_num", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthAsymId1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_asym_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthAtomId1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_atom_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthCompId1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_comp_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthSeqId1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_seq_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthAtomId2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_atom_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthAsymId2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_asym_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthCompId2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_comp_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterAuthSeqId2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "auth_seq_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterPDBInsCode1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "PDB_ins_code_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterPDBInsCode2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "PDB_ins_code_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterLabelAltId1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "label_alt_id_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterLabelAltId2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "label_alt_id_2", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterSymmAsXyz1() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "symm_as_xyz_1", this);
        }

        public StrColumnBuilder<PdbxValidateCloseContactBuilder> enterSymmAsXyz2() {
            return new StrColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "symm_as_xyz_2", this);
        }

        public FloatColumnBuilder<PdbxValidateCloseContactBuilder> enterDist() {
            return new FloatColumnBuilder<PdbxValidateCloseContactBuilder>(CATEGORY_NAME, "dist", this);
        }
    }

    public static class PdbxChemCompAuditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_audit";

        public PdbxChemCompAuditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterDate() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterAnnotator() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "annotator", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterProcessingSite() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "processing_site", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxChemCompAuditBuilder> enterActionType() {
            return new StrColumnBuilder<PdbxChemCompAuditBuilder>(CATEGORY_NAME, "action_type", this);
        }
    }

    public static class PdbxChemCompBondEditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_bond_edit";

        public PdbxChemCompBondEditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompBondEditBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder> enterEditOp() {
            return new StrColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "edit_op", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder> enterAtomId1() {
            return new StrColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "atom_id_1", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder> enterAtomId2() {
            return new StrColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "atom_id_2", this);
        }

        public StrColumnBuilder<PdbxChemCompBondEditBuilder> enterEditBondValue() {
            return new StrColumnBuilder<PdbxChemCompBondEditBuilder>(CATEGORY_NAME, "edit_bond_value", this);
        }
    }

    public static class PdbxChemCompAtomEditBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_atom_edit";

        public PdbxChemCompAtomEditBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxChemCompAtomEditBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder> enterEditOp() {
            return new StrColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "edit_op", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder> enterAtomId() {
            return new StrColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder> enterEditAtomId() {
            return new StrColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "edit_atom_id", this);
        }

        public StrColumnBuilder<PdbxChemCompAtomEditBuilder> enterEditAtomValue() {
            return new StrColumnBuilder<PdbxChemCompAtomEditBuilder>(CATEGORY_NAME, "edit_atom_value", this);
        }
    }

    public static class PdbxChemCompImportBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_import";

        public PdbxChemCompImportBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompImportBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompImportBuilder>(CATEGORY_NAME, "comp_id", this);
        }
    }

    public static class PdbxChemCompIdentifierBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_identifier";

        public PdbxChemCompIdentifierBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder> enterIdentifier() {
            return new StrColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "identifier", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder> enterProgram() {
            return new StrColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "program", this);
        }

        public StrColumnBuilder<PdbxChemCompIdentifierBuilder> enterProgramVersion() {
            return new StrColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "program_version", this);
        }

        public IntColumnBuilder<PdbxChemCompIdentifierBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompIdentifierBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxChemCompDescriptorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_descriptor";

        public PdbxChemCompDescriptorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder> enterDescriptor() {
            return new StrColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "descriptor", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder> enterProgram() {
            return new StrColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "program", this);
        }

        public StrColumnBuilder<PdbxChemCompDescriptorBuilder> enterProgramVersion() {
            return new StrColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "program_version", this);
        }

        public IntColumnBuilder<PdbxChemCompDescriptorBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxChemCompDescriptorBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxSolnScatterModelBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_soln_scatter_model";

        public PdbxSolnScatterModelBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterScatterId() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "scatter_id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterId() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterSoftwareList() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "software_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterSoftwareAuthorList() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "software_author_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterEntryFittingList() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "entry_fitting_list", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder> enterNumConformersCalculated() {
            return new IntColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "num_conformers_calculated", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder> enterNumConformersSubmitted() {
            return new IntColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "num_conformers_submitted", this);
        }

        public IntColumnBuilder<PdbxSolnScatterModelBuilder> enterRepresentativeConformer() {
            return new IntColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "representative_conformer", this);
        }

        public StrColumnBuilder<PdbxSolnScatterModelBuilder> enterConformerSelectionCriteria() {
            return new StrColumnBuilder<PdbxSolnScatterModelBuilder>(CATEGORY_NAME, "conformer_selection_criteria", this);
        }
    }

    public static class PdbxSolnScatterBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_soln_scatter";

        public PdbxSolnScatterBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterId() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterType() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterSourceBeamline() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "source_beamline", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterSourceBeamlineInstrument() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "source_beamline_instrument", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterDetectorType() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "detector_type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterDetectorSpecific() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "detector_specific", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterSourceType() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "source_type", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterSourceClass() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "source_class", this);
        }

        public IntColumnBuilder<PdbxSolnScatterBuilder> enterNumTimeFrames() {
            return new IntColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "num_time_frames", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterSamplePH() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "sample_pH", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterTemperature() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterConcentrationRange() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "concentration_range", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterBufferName() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "buffer_name", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMeanGuinerRadius() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "mean_guiner_radius", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMeanGuinerRadiusEsd() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "mean_guiner_radius_esd", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMinMeanCrossSectionalRadiiGyration() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "min_mean_cross_sectional_radii_gyration", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMinMeanCrossSectionalRadiiGyrationEsd() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "min_mean_cross_sectional_radii_gyration_esd", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMaxMeanCrossSectionalRadiiGyration() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "max_mean_cross_sectional_radii_gyration", this);
        }

        public FloatColumnBuilder<PdbxSolnScatterBuilder> enterMaxMeanCrossSectionalRadiiGyrationEsd() {
            return new FloatColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "max_mean_cross_sectional_radii_gyration_esd", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterProteinLength() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "protein_length", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterDataReductionSoftwareList() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "data_reduction_software_list", this);
        }

        public StrColumnBuilder<PdbxSolnScatterBuilder> enterDataAnalysisSoftwareList() {
            return new StrColumnBuilder<PdbxSolnScatterBuilder>(CATEGORY_NAME, "data_analysis_software_list", this);
        }
    }

    public static class PdbxBondDistanceLimitsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_bond_distance_limits";

        public PdbxBondDistanceLimitsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBondDistanceLimitsBuilder> enterAtomType1() {
            return new StrColumnBuilder<PdbxBondDistanceLimitsBuilder>(CATEGORY_NAME, "atom_type_1", this);
        }

        public StrColumnBuilder<PdbxBondDistanceLimitsBuilder> enterAtomType2() {
            return new StrColumnBuilder<PdbxBondDistanceLimitsBuilder>(CATEGORY_NAME, "atom_type_2", this);
        }

        public FloatColumnBuilder<PdbxBondDistanceLimitsBuilder> enterLowerLimit() {
            return new FloatColumnBuilder<PdbxBondDistanceLimitsBuilder>(CATEGORY_NAME, "lower_limit", this);
        }

        public FloatColumnBuilder<PdbxBondDistanceLimitsBuilder> enterUpperLimit() {
            return new FloatColumnBuilder<PdbxBondDistanceLimitsBuilder>(CATEGORY_NAME, "upper_limit", this);
        }
    }

    public static class PdbxDiffrnReflnsShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_diffrn_reflns_shell";

        public PdbxDiffrnReflnsShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterDResLow() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterDResHigh() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterPercentPossibleObs() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "percent_possible_obs", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterRmergeIObs() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "Rmerge_I_obs", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterRsymValue() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "Rsym_value", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterChiSquared() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "chi_squared", this);
        }

        public FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterRedundancy() {
            return new FloatColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "redundancy", this);
        }

        public IntColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterRejects() {
            return new IntColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "rejects", this);
        }

        public IntColumnBuilder<PdbxDiffrnReflnsShellBuilder> enterNumberObs() {
            return new IntColumnBuilder<PdbxDiffrnReflnsShellBuilder>(CATEGORY_NAME, "number_obs", this);
        }
    }

    public static class PdbxStructChemCompFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_chem_comp_feature";

        public PdbxStructChemCompFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterPdbStrandId() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructChemCompFeatureBuilder> enterSeqNum() {
            return new IntColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompFeatureBuilder> enterPdbInsCode() {
            return new StrColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "pdb_ins_code", this);
        }

        public IntColumnBuilder<PdbxStructChemCompFeatureBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxStructChemCompFeatureBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxCoordinateModelBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_coordinate_model";

        public PdbxCoordinateModelBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxCoordinateModelBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxCoordinateModelBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxCoordinateModelBuilder> enterType() {
            return new StrColumnBuilder<PdbxCoordinateModelBuilder>(CATEGORY_NAME, "type", this);
        }
    }

    public static class PdbxChemCompFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_chem_comp_feature";

        public PdbxChemCompFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxChemCompFeatureBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder> enterType() {
            return new StrColumnBuilder<PdbxChemCompFeatureBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder> enterSupport() {
            return new StrColumnBuilder<PdbxChemCompFeatureBuilder>(CATEGORY_NAME, "support", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder> enterValue() {
            return new StrColumnBuilder<PdbxChemCompFeatureBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxChemCompFeatureBuilder> enterSource() {
            return new StrColumnBuilder<PdbxChemCompFeatureBuilder>(CATEGORY_NAME, "source", this);
        }
    }

    public static class PdbxStructChemCompDiagnosticsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_chem_comp_diagnostics";

        public PdbxStructChemCompDiagnosticsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterPdbStrandId() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterSeqNum() {
            return new IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "seq_num", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterPdbInsCode() {
            return new StrColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "pdb_ins_code", this);
        }

        public IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxStructChemCompDiagnosticsBuilder>(CATEGORY_NAME, "ordinal", this);
        }
    }

    public static class PdbxStructRefSeqFeaturePropBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_feature_prop";

        public PdbxStructRefSeqFeaturePropBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterFeatureId() {
            return new IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterPropertyId() {
            return new IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "property_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterValue() {
            return new StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterBegDbMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "beg_db_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterEndDbMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "end_db_mon_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterBegDbSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "beg_db_seq_id", this);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder> enterEndDbSeqId() {
            return new IntColumnBuilder<PdbxStructRefSeqFeaturePropBuilder>(CATEGORY_NAME, "end_db_seq_id", this);
        }
    }

    public static class PdbxStructRefSeqFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_ref_seq_feature";

        public PdbxStructRefSeqFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterFeatureId() {
            return new IntColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "feature_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterAlignId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "align_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterPdbStrandId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterBegSeqNum() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "beg_seq_num", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterEndSeqNum() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "end_seq_num", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterBegAuthMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "beg_auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterEndAuthMonId() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "end_auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterBegPdbInsCode() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "beg_pdb_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructRefSeqFeatureBuilder> enterEndPdbInsCode() {
            return new StrColumnBuilder<PdbxStructRefSeqFeatureBuilder>(CATEGORY_NAME, "end_pdb_ins_code", this);
        }
    }

    public static class PdbxStructAssemblyPropBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_assembly_prop";

        public PdbxStructAssemblyPropBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder> enterBiolId() {
            return new StrColumnBuilder<PdbxStructAssemblyPropBuilder>(CATEGORY_NAME, "biol_id", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructAssemblyPropBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder> enterValue() {
            return new StrColumnBuilder<PdbxStructAssemblyPropBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructAssemblyPropBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructAssemblyPropBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxReRefinementBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_re_refinement";

        public PdbxReRefinementBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxReRefinementBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder> enterCitationId() {
            return new StrColumnBuilder<PdbxReRefinementBuilder>(CATEGORY_NAME, "citation_id", this);
        }

        public StrColumnBuilder<PdbxReRefinementBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxReRefinementBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxStructInfoBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_info";

        public PdbxStructInfoBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder> enterType() {
            return new StrColumnBuilder<PdbxStructInfoBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder> enterValue() {
            return new StrColumnBuilder<PdbxStructInfoBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxStructInfoBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxStructInfoBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxReflnsTwinBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_reflns_twin";

        public PdbxReflnsTwinBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder> enterDiffrnId() {
            return new StrColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "diffrn_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder> enterCrystalId() {
            return new StrColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder> enterDomainId() {
            return new StrColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder> enterType() {
            return new StrColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxReflnsTwinBuilder> enterOperator() {
            return new StrColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "operator", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder> enterFraction() {
            return new FloatColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "fraction", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder> enterMeanI2OverMeanISquare() {
            return new FloatColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "mean_I2_over_mean_I_square", this);
        }

        public FloatColumnBuilder<PdbxReflnsTwinBuilder> enterMeanFSquareOverMeanF2() {
            return new FloatColumnBuilder<PdbxReflnsTwinBuilder>(CATEGORY_NAME, "mean_F_square_over_mean_F2", this);
        }
    }

    public static class PdbxExptlPdBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_pd";

        public PdbxExptlPdBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxExptlPdBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxExptlPdBuilder> enterSpecPreparationPH() {
            return new FloatColumnBuilder<PdbxExptlPdBuilder>(CATEGORY_NAME, "spec_preparation_pH", this);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder> enterSpecPreparationPHRange() {
            return new StrColumnBuilder<PdbxExptlPdBuilder>(CATEGORY_NAME, "spec_preparation_pH_range", this);
        }

        public StrColumnBuilder<PdbxExptlPdBuilder> enterSpecPreparation() {
            return new StrColumnBuilder<PdbxExptlPdBuilder>(CATEGORY_NAME, "spec_preparation", this);
        }
    }

    public static class PdbxFeatureMonomerBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_monomer";

        public PdbxFeatureMonomerBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureCitationId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "feature_software_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxFeatureMonomerBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxFeatureMonomerBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxFeatureMonomerBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }
    }

    public static class PdbxFeatureAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_assembly";

        public PdbxFeatureAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterId() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterAssemblyId() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "assembly_id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureCitationId() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureAssemblyBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilder<PdbxFeatureAssemblyBuilder>(CATEGORY_NAME, "feature_software_id", this);
        }
    }

    public static class PdbxFeatureSequenceRangeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_sequence_range";

        public PdbxFeatureSequenceRangeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterId() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterSeqRangeId() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "seq_range_id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureCitationId() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureSequenceRangeBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilder<PdbxFeatureSequenceRangeBuilder>(CATEGORY_NAME, "feature_software_id", this);
        }
    }

    public static class PdbxFeatureDomainBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_domain";

        public PdbxFeatureDomainBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterId() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterDomainId() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureCitationId() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureDomainBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilder<PdbxFeatureDomainBuilder>(CATEGORY_NAME, "feature_software_id", this);
        }
    }

    public static class PdbxFeatureEntryBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_feature_entry";

        public PdbxFeatureEntryBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterId() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureName() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_name", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureType() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_type", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeature() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureIdentifier() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_identifier", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureAssignedBy() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_assigned_by", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureCitationId() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_citation_id", this);
        }

        public StrColumnBuilder<PdbxFeatureEntryBuilder> enterFeatureSoftwareId() {
            return new StrColumnBuilder<PdbxFeatureEntryBuilder>(CATEGORY_NAME, "feature_software_id", this);
        }
    }

    public static class PdbxSequenceRangeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_sequence_range";

        public PdbxSequenceRangeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegLabelAltId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegLabelCompId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSequenceRangeBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegAuthCompId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterSeqRangeId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "seq_range_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndLabelAltId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndLabelCompId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxSequenceRangeBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndAuthCompId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxSequenceRangeBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilder<PdbxSequenceRangeBuilder>(CATEGORY_NAME, "end_auth_seq_id", this);
        }
    }

    public static class PdbxDomainRangeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_domain_range";

        public PdbxDomainRangeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegLabelAltId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegLabelCompId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDomainRangeBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegAuthCompId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterDomainId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "domain_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndLabelAltId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_label_alt_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndLabelCompId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_label_comp_id", this);
        }

        public IntColumnBuilder<PdbxDomainRangeBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndAuthCompId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxDomainRangeBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilder<PdbxDomainRangeBuilder>(CATEGORY_NAME, "end_auth_seq_id", this);
        }
    }

    public static class PdbxDomainBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_domain";

        public PdbxDomainBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDomainBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxDomainBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxDomainBuilder> enterId() {
            return new StrColumnBuilder<PdbxDomainBuilder>(CATEGORY_NAME, "id", this);
        }
    }

    public static class PdbxBufferComponentsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_buffer_components";

        public PdbxBufferComponentsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterId() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterBufferId() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "buffer_id", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterName() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterVolume() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterConc() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "conc", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterConcUnits() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "conc_units", this);
        }

        public StrColumnBuilder<PdbxBufferComponentsBuilder> enterIsotopicLabeling() {
            return new StrColumnBuilder<PdbxBufferComponentsBuilder>(CATEGORY_NAME, "isotopic_labeling", this);
        }
    }

    public static class PdbxBufferBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_buffer";

        public PdbxBufferBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxBufferBuilder> enterId() {
            return new StrColumnBuilder<PdbxBufferBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxBufferBuilder> enterName() {
            return new StrColumnBuilder<PdbxBufferBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxBufferBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxBufferBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxRobotSystemBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_robot_system";

        public PdbxRobotSystemBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder> enterId() {
            return new StrColumnBuilder<PdbxRobotSystemBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder> enterModel() {
            return new StrColumnBuilder<PdbxRobotSystemBuilder>(CATEGORY_NAME, "model", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder> enterType() {
            return new StrColumnBuilder<PdbxRobotSystemBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxRobotSystemBuilder> enterManufacturer() {
            return new StrColumnBuilder<PdbxRobotSystemBuilder>(CATEGORY_NAME, "manufacturer", this);
        }
    }

    public static class PdbxConstructFeatureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_construct_feature";

        public PdbxConstructFeatureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder> enterId() {
            return new StrColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder> enterConstructId() {
            return new StrColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "construct_id", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxConstructFeatureBuilder> enterStartSeq() {
            return new IntColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "start_seq", this);
        }

        public IntColumnBuilder<PdbxConstructFeatureBuilder> enterEndSeq() {
            return new IntColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "end_seq", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder> enterType() {
            return new StrColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxConstructFeatureBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxConstructFeatureBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxConstructBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_construct";

        public PdbxConstructBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterId() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterName() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterOrganisation() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "organisation", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterDate() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterClazz() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "class", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterType() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxConstructBuilder> enterSeq() {
            return new StrColumnBuilder<PdbxConstructBuilder>(CATEGORY_NAME, "seq", this);
        }
    }

    public static class PdbxEntitySrcGenCharacterBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_character";

        public PdbxEntitySrcGenCharacterBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterResult() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "result", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenCharacterBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenPureBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_pure";

        public PdbxEntitySrcGenPureBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenPureBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterProductId() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "product_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterConcDeviceId() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "conc_device_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterConcDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "conc_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterConcAssayMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "conc_assay_method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder> enterProteinConcentration() {
            return new FloatColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "protein_concentration", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder> enterProteinYield() {
            return new FloatColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "protein_yield", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder> enterProteinPurity() {
            return new FloatColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "protein_purity", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenPureBuilder> enterProteinOligomericState() {
            return new IntColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "protein_oligomeric_state", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterStorageBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "storage_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenPureBuilder> enterStorageTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "storage_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenPureBuilder> enterSummary() {
            return new StrColumnBuilder<PdbxEntitySrcGenPureBuilder>(CATEGORY_NAME, "summary", this);
        }
    }

    public static class PdbxEntitySrcGenFractBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_fract";

        public PdbxEntitySrcGenFractBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenFractBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenFractBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder> enterTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterProteinLocation() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "protein_location", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder> enterProteinVolume() {
            return new FloatColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "protein_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenFractBuilder> enterProteinYield() {
            return new FloatColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "protein_yield", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenFractBuilder> enterProteinYieldMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenFractBuilder>(CATEGORY_NAME, "protein_yield_method", this);
        }
    }

    public static class PdbxEntitySrcGenChromBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_chrom";

        public PdbxEntitySrcGenChromBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenChromBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenChromBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterColumnType() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "column_type", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterColumnVolume() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "column_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterColumnTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "column_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterEquilibrationBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "equilibration_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterFlowRate() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "flow_rate", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterElutionBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "elution_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterElutionProtocol() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "elution_protocol", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterSamplePrepDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "sample_prep_details", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterSampleVolume() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "sample_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterSampleConcentration() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "sample_concentration", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterSampleConcMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "sample_conc_method", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterVolumePooledFractions() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "volume_pooled_fractions", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenChromBuilder> enterYieldPooledFractions() {
            return new FloatColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "yield_pooled_fractions", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterYieldMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "yield_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenChromBuilder> enterPostTreatment() {
            return new StrColumnBuilder<PdbxEntitySrcGenChromBuilder>(CATEGORY_NAME, "post_treatment", this);
        }
    }

    public static class PdbxEntitySrcGenProteolysisBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_proteolysis";

        public PdbxEntitySrcGenProteolysisBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterProtease() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "protease", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterProteinProteaseRatio() {
            return new FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "protein_protease_ratio", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterCleavageBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "cleavage_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterCleavageTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "cleavage_temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder> enterCleavageTime() {
            return new FloatColumnBuilder<PdbxEntitySrcGenProteolysisBuilder>(CATEGORY_NAME, "cleavage_time", this);
        }
    }

    public static class PdbxEntitySrcGenRefoldBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_refold";

        public PdbxEntitySrcGenRefoldBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterDenatureBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "denature_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterRefoldBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "refold_buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterTime() {
            return new FloatColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterStorageBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "storage_buffer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenRefoldBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenLysisBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_lysis";

        public PdbxEntitySrcGenLysisBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterBufferId() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "buffer_id", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterBufferVolume() {
            return new FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "buffer_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterTime() {
            return new FloatColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenLysisBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenLysisBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenExpressTimepointBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_express_timepoint";

        public PdbxEntitySrcGenExpressTimepointBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterSerial() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "serial", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterOD() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "OD", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder> enterTime() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressTimepointBuilder>(CATEGORY_NAME, "time", this);
        }
    }

    public static class PdbxEntitySrcGenExpressBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_express";

        public PdbxEntitySrcGenExpressBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterPromoterType() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "promoter_type", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterPlasmidId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "plasmid_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterVectorType() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "vector_type", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterNTerminalSeqTag() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "N_terminal_seq_tag", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCTerminalSeqTag() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "C_terminal_seq_tag", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgScientificName() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_scientific_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgCommonName() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_common_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgVariant() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_variant", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgStrain() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_strain", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgTissue() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_tissue", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgCultureCollection() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_culture_collection", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgCellLine() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_cell_line", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgTaxId() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_tax_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHostOrgDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "host_org_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCultureBaseMedia() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "culture_base_media", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCultureAdditives() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "culture_additives", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCultureVolume() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "culture_volume", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCultureTime() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "culture_time", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterCultureTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "culture_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterInducer() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "inducer", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterInducerConcentration() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "inducer_concentration", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterInductionDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "induction_details", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterMultiplicityOfInfection() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "multiplicity_of_infection", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterInductionTimepoint() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "induction_timepoint", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterInductionTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "induction_temperature", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterHarvestingDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "harvesting_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterStorageDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "storage_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenExpressBuilder> enterSummary() {
            return new StrColumnBuilder<PdbxEntitySrcGenExpressBuilder>(CATEGORY_NAME, "summary", this);
        }
    }

    public static class PdbxEntitySrcGenCloneRecombinationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone_recombination";

        public PdbxEntitySrcGenCloneRecombinationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterSystem() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "system", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterRecombinationEnzymes() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "recombination_enzymes", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneRecombinationBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenCloneLigationBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone_ligation";

        public PdbxEntitySrcGenCloneLigationBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterCleavageEnzymes() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "cleavage_enzymes", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterLigationEnzymes() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "ligation_enzymes", this);
        }

        public FloatColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterTemperature() {
            return new FloatColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterTime() {
            return new IntColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "time", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneLigationBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenCloneBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_clone";

        public PdbxEntitySrcGenCloneBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterGeneInsertMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "gene_insert_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterVectorName() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "vector_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterVectorDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "vector_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterTransformationMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "transformation_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterMarker() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "marker", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterVerificationMethod() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "verification_method", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterPurificationDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenCloneBuilder> enterSummary() {
            return new StrColumnBuilder<PdbxEntitySrcGenCloneBuilder>(CATEGORY_NAME, "summary", this);
        }
    }

    public static class PdbxEntitySrcGenProdDigestBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_digest";

        public PdbxEntitySrcGenProdDigestBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterRestrictionEnzyme1() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "restriction_enzyme_1", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterRestrictionEnzyme2() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "restriction_enzyme_2", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterPurificationDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder> enterSummary() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdDigestBuilder>(CATEGORY_NAME, "summary", this);
        }
    }

    public static class PdbxEntitySrcGenProdPcrBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_pcr";

        public PdbxEntitySrcGenProdPcrBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterForwardPrimerId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "forward_primer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterReversePrimerId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "reverse_primer_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterReactionDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "reaction_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterPurificationDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "purification_details", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder> enterSummary() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdPcrBuilder>(CATEGORY_NAME, "summary", this);
        }
    }

    public static class PdbxEntitySrcGenProdOtherParameterBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_other_parameter";

        public PdbxEntitySrcGenProdOtherParameterBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterParameter() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "parameter", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterValue() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "value", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherParameterBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntitySrcGenProdOtherBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_src_gen_prod_other";

        public PdbxEntitySrcGenProdOtherBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "step_id", this);
        }

        public IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterNextStepId() {
            return new IntColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "next_step_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterEndConstructId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "end_construct_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterRobotId() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "robot_id", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterDate() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "date", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterProcessName() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "process_name", this);
        }

        public StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxEntitySrcGenProdOtherBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxEntityProdProtocolBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_prod_protocol";

        public PdbxEntityProdProtocolBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxEntityProdProtocolBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityProdProtocolBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder> enterProtocol() {
            return new StrColumnBuilder<PdbxEntityProdProtocolBuilder>(CATEGORY_NAME, "protocol", this);
        }

        public StrColumnBuilder<PdbxEntityProdProtocolBuilder> enterProtocolType() {
            return new StrColumnBuilder<PdbxEntityProdProtocolBuilder>(CATEGORY_NAME, "protocol_type", this);
        }
    }

    public static class PdbxRefineComponentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_component";

        public PdbxRefineComponentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxRefineComponentBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineComponentBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterBIso() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "B_iso", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterBIsoMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "B_iso_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterBIsoSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "B_iso_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterShift() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "shift", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterShiftSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "shift_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterShiftMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "shift_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterCorrelation() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "correlation", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterCorrelationSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "correlation_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterCorrelationMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "correlation_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterRealSpaceR() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "real_space_R", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterRealSpaceRSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "real_space_R_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterRealSpaceRMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "real_space_R_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterConnect() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "connect", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityIndex() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_index", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityIndexMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_index_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityIndexSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_index_side_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityRatio() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_ratio", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityRatioMainChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_ratio_main_chain", this);
        }

        public FloatColumnBuilder<PdbxRefineComponentBuilder> enterDensityRatioSideChain() {
            return new FloatColumnBuilder<PdbxRefineComponentBuilder>(CATEGORY_NAME, "density_ratio_side_chain", this);
        }
    }

    public static class PdbxPhasingMRBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MR";

        public PdbxPhasingMRBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder> enterMethodRotation() {
            return new StrColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "method_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResHighRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_high_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResLowRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_low_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterSigmaFRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "sigma_F_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterSigmaIRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "sigma_I_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterReflnsPercentRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "reflns_percent_rotation", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder> enterMethodTranslation() {
            return new StrColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "method_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResHighTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_high_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResLowTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_low_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterSigmaFTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "sigma_F_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterSigmaITranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "sigma_I_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterReflnsPercentTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "reflns_percent_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterCorrelationCoeffIoToIc() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "correlation_coeff_Io_to_Ic", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterCorrelationCoeffFoToFc() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "correlation_coeff_Fo_to_Fc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterRFactor() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "R_factor", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterRRigidBody() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "R_rigid_body", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterPacking() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "packing", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder> enterModelDetails() {
            return new StrColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "model_details", this);
        }

        public StrColumnBuilder<PdbxPhasingMRBuilder> enterNativeSetId() {
            return new StrColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "native_set_id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResHighFit() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_high_fit", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterDResLowFit() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "d_res_low_fit", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterZscoreRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "zscore_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterLLGainRotation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "LL_gain_rotation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterZscoreTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "zscore_translation", this);
        }

        public FloatColumnBuilder<PdbxPhasingMRBuilder> enterLLGainTranslation() {
            return new FloatColumnBuilder<PdbxPhasingMRBuilder>(CATEGORY_NAME, "LL_gain_translation", this);
        }
    }

    public static class PdbxPhasingMADSetSiteBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set_site";

        public PdbxPhasingMADSetSiteBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterId() {
            return new StrColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterAtomTypeSymbol() {
            return new StrColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "atom_type_symbol", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnX() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_x", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnY() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_y", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnZ() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_z", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnXEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_x_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnYEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_y_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterCartnZEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "Cartn_z_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractX() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_x", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractY() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_y", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractZ() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_z", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractXEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_x_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractYEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_y_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterFractZEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "fract_z_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterBIso() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "b_iso", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterBIsoEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "b_iso_esd", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterOccupancy() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "occupancy", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterOccupancyEsd() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "occupancy_esd", this);
        }

        public StrColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterSetId() {
            return new StrColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "set_id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder> enterOccupancyIso() {
            return new FloatColumnBuilder<PdbxPhasingMADSetSiteBuilder>(CATEGORY_NAME, "occupancy_iso", this);
        }
    }

    public static class PdbxPhasingMADSetShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set_shell";

        public PdbxPhasingMADSetShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetShellBuilder> enterId() {
            return new StrColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterDResLow() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterDResHigh() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "d_res_high", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder> enterReflnsAcentric() {
            return new IntColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder> enterReflnsCentric() {
            return new IntColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetShellBuilder> enterReflns() {
            return new IntColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterFomAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterFomCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRCullisCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRCullis() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRKrautCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterRKraut() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterLocCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterLocAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterLoc() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterPowerCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterPowerAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetShellBuilder> enterPower() {
            return new FloatColumnBuilder<PdbxPhasingMADSetShellBuilder>(CATEGORY_NAME, "power", this);
        }
    }

    public static class PdbxPhasingMADSetBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_set";

        public PdbxPhasingMADSetBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingMADSetBuilder> enterId() {
            return new StrColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "id", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterDResLow() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterDResHigh() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "d_res_high", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder> enterNumberOfSites() {
            return new IntColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "number_of_sites", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder> enterReflnsAcentric() {
            return new IntColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder> enterReflnsCentric() {
            return new IntColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADSetBuilder> enterReflns() {
            return new IntColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterFomAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterFomCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRCullisCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRCullis() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRKrautCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterRKraut() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterLocCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterLocAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterLoc() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterPowerCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterPowerAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADSetBuilder> enterPower() {
            return new FloatColumnBuilder<PdbxPhasingMADSetBuilder>(CATEGORY_NAME, "power", this);
        }
    }

    public static class PdbxPhasingMADShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_MAD_shell";

        public PdbxPhasingMADShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterDResLow() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterDResHigh() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterReflnsAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADShellBuilder> enterReflnsCentric() {
            return new IntColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingMADShellBuilder> enterReflns() {
            return new IntColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterFomAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterFomCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "fom", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRCullisCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_cullis_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRCullisAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_cullis_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRCullis() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_cullis", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRKrautCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_kraut_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRKrautAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_kraut_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterRKraut() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "R_kraut", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterLocCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "loc_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterLocAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "loc_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterLoc() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "loc", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterPowerCentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "power_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterPowerAcentric() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "power_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingMADShellBuilder> enterPower() {
            return new FloatColumnBuilder<PdbxPhasingMADShellBuilder>(CATEGORY_NAME, "power", this);
        }
    }

    public static class PdbxPhasingDmShellBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_dm_shell";

        public PdbxPhasingDmShellBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterDResHigh() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "d_res_high", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterDResLow() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "d_res_low", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterFomAcentric() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterFomCentric() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "fom", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder> enterReflnsAcentric() {
            return new IntColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder> enterReflnsCentric() {
            return new IntColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmShellBuilder> enterReflns() {
            return new IntColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterDeltaPhiInitial() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "delta_phi_initial", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmShellBuilder> enterDeltaPhiFinal() {
            return new FloatColumnBuilder<PdbxPhasingDmShellBuilder>(CATEGORY_NAME, "delta_phi_final", this);
        }
    }

    public static class PdbxPhasingDmBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_phasing_dm";

        public PdbxPhasingDmBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxPhasingDmBuilder> enterMaskType() {
            return new StrColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "mask_type", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder> enterFomAcentric() {
            return new FloatColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "fom_acentric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder> enterFomCentric() {
            return new FloatColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "fom_centric", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder> enterFom() {
            return new FloatColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "fom", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder> enterReflnsAcentric() {
            return new IntColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "reflns_acentric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder> enterReflnsCentric() {
            return new IntColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "reflns_centric", this);
        }

        public IntColumnBuilder<PdbxPhasingDmBuilder> enterReflns() {
            return new IntColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "reflns", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder> enterDeltaPhiInitial() {
            return new FloatColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "delta_phi_initial", this);
        }

        public FloatColumnBuilder<PdbxPhasingDmBuilder> enterDeltaPhiFinal() {
            return new FloatColumnBuilder<PdbxPhasingDmBuilder>(CATEGORY_NAME, "delta_phi_final", this);
        }
    }

    public static class PdbxEntityNonpolyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_nonpoly";

        public PdbxEntityNonpolyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityNonpolyBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxEntityNonpolyBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxEntityNonpolyBuilder> enterName() {
            return new StrColumnBuilder<PdbxEntityNonpolyBuilder>(CATEGORY_NAME, "name", this);
        }
    }

    public static class NdbOriginalNdbCoordinatesBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_original_ndb_coordinates";

        public NdbOriginalNdbCoordinatesBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbOriginalNdbCoordinatesBuilder> enterCoordSection() {
            return new StrColumnBuilder<NdbOriginalNdbCoordinatesBuilder>(CATEGORY_NAME, "coord_section", this);
        }
    }

    public static class NdbStructNaBasePairStepBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_na_base_pair_step";

        public NdbStructNaBasePairStepBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterModelNumber() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "model_number", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterStepNumber() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "step_number", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterStepName() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "step_name", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelAsymId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelCompId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_comp_id_1", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelSeqId1() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterISymmetry1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_symmetry_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelAsymId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelCompId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_comp_id_1", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelSeqId1() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJSymmetry1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_symmetry_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelAsymId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelCompId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_comp_id_2", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterILabelSeqId2() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_label_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterISymmetry2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_symmetry_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelAsymId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelCompId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_comp_id_2", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairStepBuilder> enterJLabelSeqId2() {
            return new IntColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_label_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJSymmetry2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_symmetry_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIAuthAsymId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_auth_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIAuthSeqId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_auth_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIPDBInsCode1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJAuthAsymId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_auth_asym_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJAuthSeqId1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_auth_seq_id_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJPDBInsCode1() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_PDB_ins_code_1", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIAuthAsymId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_auth_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIAuthSeqId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_auth_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterIPDBInsCode2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "i_PDB_ins_code_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJAuthAsymId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_auth_asym_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJAuthSeqId2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_auth_seq_id_2", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairStepBuilder> enterJPDBInsCode2() {
            return new StrColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "j_PDB_ins_code_2", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterShift() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "shift", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterSlide() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "slide", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterRise() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "rise", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterTilt() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "tilt", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterRoll() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "roll", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterTwist() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "twist", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterXDisplacement() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "x_displacement", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterYDisplacement() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "y_displacement", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterHelicalRise() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "helical_rise", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterInclination() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "inclination", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterTip() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "tip", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairStepBuilder> enterHelicalTwist() {
            return new FloatColumnBuilder<NdbStructNaBasePairStepBuilder>(CATEGORY_NAME, "helical_twist", this);
        }
    }

    public static class NdbStructNaBasePairBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_na_base_pair";

        public NdbStructNaBasePairBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterModelNumber() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "model_number", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterPairNumber() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "pair_number", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterPairName() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "pair_name", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterILabelAsymId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_label_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterILabelCompId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_label_comp_id", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterILabelSeqId() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_label_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterISymmetry() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_symmetry", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJLabelAsymId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_label_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJLabelCompId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_label_comp_id", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterJLabelSeqId() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_label_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJSymmetry() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_symmetry", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterIAuthAsymId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_auth_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterIAuthSeqId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_auth_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterIPDBInsCode() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "i_PDB_ins_code", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJAuthAsymId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_auth_asym_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJAuthSeqId() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_auth_seq_id", this);
        }

        public StrColumnBuilder<NdbStructNaBasePairBuilder> enterJPDBInsCode() {
            return new StrColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "j_PDB_ins_code", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterShear() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "shear", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterStretch() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "stretch", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterStagger() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "stagger", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterBuckle() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "buckle", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterPropeller() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "propeller", this);
        }

        public FloatColumnBuilder<NdbStructNaBasePairBuilder> enterOpening() {
            return new FloatColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "opening", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterHbondType12() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "hbond_type_12", this);
        }

        public IntColumnBuilder<NdbStructNaBasePairBuilder> enterHbondType28() {
            return new IntColumnBuilder<NdbStructNaBasePairBuilder>(CATEGORY_NAME, "hbond_type_28", this);
        }
    }

    public static class NdbStructFeatureNaBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_feature_na";

        public NdbStructFeatureNaBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbStructFeatureNaBuilder> enterEntryId() {
            return new StrColumnBuilder<NdbStructFeatureNaBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<NdbStructFeatureNaBuilder> enterFeature() {
            return new StrColumnBuilder<NdbStructFeatureNaBuilder>(CATEGORY_NAME, "feature", this);
        }

        public IntColumnBuilder<NdbStructFeatureNaBuilder> enterFeatureCount() {
            return new IntColumnBuilder<NdbStructFeatureNaBuilder>(CATEGORY_NAME, "feature_count", this);
        }
    }

    public static class NdbStructConfNaBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "ndb_struct_conf_na";

        public NdbStructConfNaBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<NdbStructConfNaBuilder> enterEntryId() {
            return new StrColumnBuilder<NdbStructConfNaBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<NdbStructConfNaBuilder> enterFeature() {
            return new StrColumnBuilder<NdbStructConfNaBuilder>(CATEGORY_NAME, "feature", this);
        }

        public IntColumnBuilder<NdbStructConfNaBuilder> enterFeatureCount() {
            return new IntColumnBuilder<NdbStructConfNaBuilder>(CATEGORY_NAME, "feature_count", this);
        }
    }

    public static class PdbxNmrForceConstantsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_force_constants";

        public PdbxNmrForceConstantsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDistanceTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_distance_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDistanceTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_distance_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlTorsionAnglesTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_torsion_angles_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlTorsionAnglesTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_torsion_angles_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlJCouplingTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_J_coupling_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlJCouplingTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_J_coupling_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptl13CShiftTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_13C_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptl13CShiftTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_13C_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptl1HShiftTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_1H_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptl1HShiftTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_1H_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDipolarCouplingTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_dipolar_coupling_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDipolarCouplingTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_dipolar_coupling_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDIsotopeShiftTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_D_isotope_shift_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterExptlDIsotopeShiftTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "exptl_D_isotope_shift_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomBondTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_bond_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomBondTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_bond_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomAnglesTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_angles_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomAnglesTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_angles_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomImpropersTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_impropers_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterCovalentGeomImpropersTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "covalent_geom_impropers_term_units", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterVanDerWaalsTermType() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term_type", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterVanDerWaalsTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterVanDerWaalsTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_van_der_Waals_term_units", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterConfDbPotentialTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_conf_db_potential_term", this);
        }

        public FloatColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterRadiusOfGyrationTerm() {
            return new FloatColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_radius_of_gyration_term", this);
        }

        public StrColumnBuilder<PdbxNmrForceConstantsBuilder> enterNon_bondedInterRadiusOfGyrationTermUnits() {
            return new StrColumnBuilder<PdbxNmrForceConstantsBuilder>(CATEGORY_NAME, "non-bonded_inter_radius_of_gyration_term_units", this);
        }
    }

    public static class PdbxNmrRefineBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_refine";

        public PdbxNmrRefineBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrRefineBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxNmrRefineBuilder>(CATEGORY_NAME, "method", this);
        }

        public StrColumnBuilder<PdbxNmrRefineBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrRefineBuilder>(CATEGORY_NAME, "details", this);
        }

        public IntColumnBuilder<PdbxNmrRefineBuilder> enterSoftwareOrdinal() {
            return new IntColumnBuilder<PdbxNmrRefineBuilder>(CATEGORY_NAME, "software_ordinal", this);
        }
    }

    public static class PdbxNmrRepresentativeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_representative";

        public PdbxNmrRepresentativeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrRepresentativeBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder> enterConformerId() {
            return new StrColumnBuilder<PdbxNmrRepresentativeBuilder>(CATEGORY_NAME, "conformer_id", this);
        }

        public StrColumnBuilder<PdbxNmrRepresentativeBuilder> enterSelectionCriteria() {
            return new StrColumnBuilder<PdbxNmrRepresentativeBuilder>(CATEGORY_NAME, "selection_criteria", this);
        }
    }

    public static class PdbxNmrEnsembleRmsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_ensemble_rms";

        public PdbxNmrEnsembleRmsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterResidueRangeBegin() {
            return new IntColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "residue_range_begin", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterChainRangeBegin() {
            return new StrColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "chain_range_begin", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterResidueRangeEnd() {
            return new IntColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "residue_range_end", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterChainRangeEnd() {
            return new StrColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "chain_range_end", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterAtomType() {
            return new StrColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "atom_type", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterDistanceRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "distance_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterDistanceRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "distance_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterCovalentBondRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "covalent_bond_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterCovalentBondRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "covalent_bond_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterBondAngleRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "bond_angle_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterBondAngleRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "bond_angle_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterImproperTorsionAngleRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "improper_torsion_angle_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterImproperTorsionAngleRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "improper_torsion_angle_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterPeptidePlanarityRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "peptide_planarity_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterPeptidePlanarityRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "peptide_planarity_rms_dev_error", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterDihedralAnglesRmsDev() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "dihedral_angles_rms_dev", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterDihedralAnglesRmsDevError() {
            return new FloatColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "dihedral_angles_rms_dev_error", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleRmsBuilder> enterCoordAverageRmsdMethod() {
            return new StrColumnBuilder<PdbxNmrEnsembleRmsBuilder>(CATEGORY_NAME, "coord_average_rmsd_method", this);
        }
    }

    public static class PdbxNmrEnsembleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_ensemble";

        public PdbxNmrEnsembleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder> enterConformersCalculatedTotalNumber() {
            return new IntColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "conformers_calculated_total_number", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder> enterConformersSubmittedTotalNumber() {
            return new IntColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "conformers_submitted_total_number", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder> enterConformerSelectionCriteria() {
            return new StrColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "conformer_selection_criteria", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder> enterRepresentativeConformer() {
            return new IntColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "representative_conformer", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder> enterAverageConstraintsPerResidue() {
            return new IntColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "average_constraints_per_residue", this);
        }

        public IntColumnBuilder<PdbxNmrEnsembleBuilder> enterAverageConstraintViolationsPerResidue() {
            return new IntColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "average_constraint_violations_per_residue", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterMaximumDistanceConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "maximum_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterAverageDistanceConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "average_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterMaximumUpperDistanceConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "maximum_upper_distance_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterMaximumLowerDistanceConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "maximum_lower_distance_constraint_violation", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder> enterDistanceConstraintViolationMethod() {
            return new StrColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "distance_constraint_violation_method", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterMaximumTorsionAngleConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "maximum_torsion_angle_constraint_violation", this);
        }

        public FloatColumnBuilder<PdbxNmrEnsembleBuilder> enterAverageTorsionAngleConstraintViolation() {
            return new FloatColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "average_torsion_angle_constraint_violation", this);
        }

        public StrColumnBuilder<PdbxNmrEnsembleBuilder> enterTorsionAngleConstraintViolationMethod() {
            return new StrColumnBuilder<PdbxNmrEnsembleBuilder>(CATEGORY_NAME, "torsion_angle_constraint_violation_method", this);
        }
    }

    public static class PdbxNmrConstraintsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_constraints";

        public PdbxNmrConstraintsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEConstraintsTotal() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_constraints_total", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEIntraresidueTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_intraresidue_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEInterentityTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_interentity_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOESequentialTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_sequential_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEMediumRangeTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_medium_range_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNOELongRangeTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_long_range_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterProteinPhiAngleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "protein_phi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterProteinPsiAngleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "protein_psi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterProteinChiAngleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "protein_chi_angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterProteinOtherAngleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "protein_other_angle_constraints_total_count", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEInterprotonDistanceEvaluation() {
            return new StrColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_interproton_distance_evaluation", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEPseudoatomCorrections() {
            return new StrColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_pseudoatom_corrections", this);
        }

        public StrColumnBuilder<PdbxNmrConstraintsBuilder> enterNOEMotionalAveragingCorrection() {
            return new StrColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NOE_motional_averaging_correction", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterHydrogenBondConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "hydrogen_bond_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterDisulfideBondConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "disulfide_bond_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNAAlpha_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_alpha-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNABeta_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_beta-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNAGamma_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_gamma-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNADelta_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_delta-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNAEpsilon_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_epsilon-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNAChi_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_chi-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNAOther_angleConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_other-angle_constraints_total_count", this);
        }

        public IntColumnBuilder<PdbxNmrConstraintsBuilder> enterNASugarPuckerConstraintsTotalCount() {
            return new IntColumnBuilder<PdbxNmrConstraintsBuilder>(CATEGORY_NAME, "NA_sugar_pucker_constraints_total_count", this);
        }
    }

    public static class PdbxNmrSoftwareBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_software";

        public PdbxNmrSoftwareBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public IntColumnBuilder<PdbxNmrSoftwareBuilder> enterOrdinal() {
            return new IntColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "ordinal", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder> enterClassification() {
            return new StrColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "classification", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder> enterName() {
            return new StrColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder> enterVersion() {
            return new StrColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "version", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder> enterAuthors() {
            return new StrColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "authors", this);
        }

        public StrColumnBuilder<PdbxNmrSoftwareBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrSoftwareBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxNmrExptlBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl";

        public PdbxNmrExptlBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder> enterExperimentId() {
            return new StrColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "experiment_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder> enterConditionsId() {
            return new StrColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder> enterSolutionId() {
            return new StrColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder> enterType() {
            return new StrColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "type", this);
        }

        public IntColumnBuilder<PdbxNmrExptlBuilder> enterSpectrometerId() {
            return new IntColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "spectrometer_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlBuilder> enterSampleState() {
            return new StrColumnBuilder<PdbxNmrExptlBuilder>(CATEGORY_NAME, "sample_state", this);
        }
    }

    public static class PdbxNmrSpectrometerBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_spectrometer";

        public PdbxNmrSpectrometerBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterSpectrometerId() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "spectrometer_id", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterModel() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "model", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterType() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterManufacturer() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "manufacturer", this);
        }

        public FloatColumnBuilder<PdbxNmrSpectrometerBuilder> enterFieldStrength() {
            return new FloatColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "field_strength", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxNmrSpectrometerBuilder> enterName() {
            return new StrColumnBuilder<PdbxNmrSpectrometerBuilder>(CATEGORY_NAME, "name", this);
        }
    }

    public static class PdbxNmrExptlSampleConditionsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl_sample_conditions";

        public PdbxNmrExptlSampleConditionsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterConditionsId() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "conditions_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterTemperature() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "temperature", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPressureUnits() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pressure_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPressure() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pressure", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPH() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pH", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterIonicStrength() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "ionic_strength", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "details", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterIonicStrengthErr() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "ionic_strength_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterIonicStrengthUnits() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "ionic_strength_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterLabel() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "label", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPHErr() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pH_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPHUnits() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pH_units", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterPressureErr() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "pressure_err", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterTemperatureErr() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "temperature_err", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder> enterTemperatureUnits() {
            return new StrColumnBuilder<PdbxNmrExptlSampleConditionsBuilder>(CATEGORY_NAME, "temperature_units", this);
        }
    }

    public static class PdbxNmrExptlSampleBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_exptl_sample";

        public PdbxNmrExptlSampleBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder> enterSolutionId() {
            return new StrColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder> enterComponent() {
            return new StrColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "component", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleBuilder> enterConcentration() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "concentration", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder> enterConcentrationRange() {
            return new StrColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "concentration_range", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder> enterConcentrationUnits() {
            return new StrColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "concentration_units", this);
        }

        public StrColumnBuilder<PdbxNmrExptlSampleBuilder> enterIsotopicLabeling() {
            return new StrColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "isotopic_labeling", this);
        }

        public FloatColumnBuilder<PdbxNmrExptlSampleBuilder> enterConcentrationErr() {
            return new FloatColumnBuilder<PdbxNmrExptlSampleBuilder>(CATEGORY_NAME, "concentration_err", this);
        }
    }

    public static class PdbxNmrSampleDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_sample_details";

        public PdbxNmrSampleDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterSolutionId() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "solution_id", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterContents() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "contents", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterSolventSystem() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "solvent_system", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterLabel() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "label", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterType() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "type", this);
        }

        public StrColumnBuilder<PdbxNmrSampleDetailsBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxNmrSampleDetailsBuilder>(CATEGORY_NAME, "details", this);
        }
    }

    public static class PdbxNmrDetailsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nmr_details";

        public PdbxNmrDetailsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNmrDetailsBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxNmrDetailsBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxNmrDetailsBuilder> enterText() {
            return new StrColumnBuilder<PdbxNmrDetailsBuilder>(CATEGORY_NAME, "text", this);
        }
    }

    public static class PdbxAtomSiteAnisoTlsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_atom_site_aniso_tls";

        public PdbxAtomSiteAnisoTlsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterTypeSymbol() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "type_symbol", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterTlsGroupId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "tls_group_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterAuthCompId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterAuthSeqId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterAuthAtomId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterAuthAsymId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterPDBInsCode() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterLabelAltId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "label_alt_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterLabelAsymId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "label_asym_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterLabelAtomId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "label_atom_id", this);
        }

        public StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterLabelCompId() {
            return new StrColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "label_comp_id", this);
        }

        public IntColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterLabelSeqId() {
            return new IntColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "label_seq_id", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls11() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[1][1]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls22() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[2][2]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls33() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[3][3]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls12() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[1][2]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls13() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[1][3]", this);
        }

        public FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder> enterUTls23() {
            return new FloatColumnBuilder<PdbxAtomSiteAnisoTlsBuilder>(CATEGORY_NAME, "U_tls[2][3]", this);
        }
    }

    public static class PdbxSGProjectBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_SG_project";

        public PdbxSGProjectBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder> enterId() {
            return new StrColumnBuilder<PdbxSGProjectBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder> enterProjectName() {
            return new StrColumnBuilder<PdbxSGProjectBuilder>(CATEGORY_NAME, "project_name", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder> enterFullNameOfCenter() {
            return new StrColumnBuilder<PdbxSGProjectBuilder>(CATEGORY_NAME, "full_name_of_center", this);
        }

        public StrColumnBuilder<PdbxSGProjectBuilder> enterInitialOfCenter() {
            return new StrColumnBuilder<PdbxSGProjectBuilder>(CATEGORY_NAME, "initial_of_center", this);
        }
    }

    public static class PdbxContactAuthorBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_contact_author";

        public PdbxContactAuthorBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterId() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterAddress1() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "address_1", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterAddress2() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "address_2", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterAddress3() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "address_3", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterLegacyAddress() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "legacy_address", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterCity() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "city", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterStateProvince() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "state_province", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterPostalCode() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "postal_code", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterEmail() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "email", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterFax() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "fax", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterNameFirst() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "name_first", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterNameLast() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "name_last", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterNameMi() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "name_mi", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterNameSalutation() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "name_salutation", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterCountry() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "country", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterContinent() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "continent", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterPhone() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "phone", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterRole() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "role", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterOrganizationType() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "organization_type", this);
        }

        public StrColumnBuilder<PdbxContactAuthorBuilder> enterIdentifierORCID() {
            return new StrColumnBuilder<PdbxContactAuthorBuilder>(CATEGORY_NAME, "identifier_ORCID", this);
        }
    }

    public static class PdbxRefineTlsGroupBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_tls_group";

        public PdbxRefineTlsGroupBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterPdbxRefineId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterRefineTlsId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "refine_tls_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterBegLabelAsymId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "beg_label_asym_id", this);
        }

        public IntColumnBuilder<PdbxRefineTlsGroupBuilder> enterBegLabelSeqId() {
            return new IntColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "beg_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterBegAuthAsymId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "beg_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterBegAuthSeqId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "beg_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterEndLabelAsymId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "end_label_asym_id", this);
        }

        public IntColumnBuilder<PdbxRefineTlsGroupBuilder> enterEndLabelSeqId() {
            return new IntColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "end_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterEndAuthAsymId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "end_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterEndAuthSeqId() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "end_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterSelection() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "selection", this);
        }

        public StrColumnBuilder<PdbxRefineTlsGroupBuilder> enterSelectionDetails() {
            return new StrColumnBuilder<PdbxRefineTlsGroupBuilder>(CATEGORY_NAME, "selection_details", this);
        }
    }

    public static class PdbxRefineTlsBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_tls";

        public PdbxRefineTlsBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder> enterId() {
            return new StrColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder> enterPdbxRefineId() {
            return new StrColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxRefineTlsBuilder> enterMethod() {
            return new StrColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "method", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterOriginX() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "origin_x", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterOriginY() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "origin_y", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterOriginZ() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "origin_z", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT11() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT11Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT12() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT12Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT13() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT13Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT22() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT22Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT23() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT23Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT33() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterT33Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "T[3][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL11() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL11Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL12() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL12Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL13() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL13Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL22() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL22Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL23() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL23Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL33() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterL33Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "L[3][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS11() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS11Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS12() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS12Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS13() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS13Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[1][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS21() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS21Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS22() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS22Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS23() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS23Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[2][3]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS31() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][1]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS31Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][1]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS32() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][2]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS32Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][2]_esd", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS33() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][3]", this);
        }

        public FloatColumnBuilder<PdbxRefineTlsBuilder> enterS33Esd() {
            return new FloatColumnBuilder<PdbxRefineTlsBuilder>(CATEGORY_NAME, "S[3][3]_esd", this);
        }
    }

    public static class PdbxExptlCrystalCryoTreatmentBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_cryo_treatment";

        public PdbxExptlCrystalCryoTreatmentBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder> enterCrystalId() {
            return new StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder> enterFinalSolutionDetails() {
            return new StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder>(CATEGORY_NAME, "final_solution_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder> enterSoakingDetails() {
            return new StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder>(CATEGORY_NAME, "soaking_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder> enterCoolingDetails() {
            return new StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder>(CATEGORY_NAME, "cooling_details", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder> enterAnnealingDetails() {
            return new StrColumnBuilder<PdbxExptlCrystalCryoTreatmentBuilder>(CATEGORY_NAME, "annealing_details", this);
        }
    }

    public static class PdbxExptlCrystalGrowSolBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_grow_sol";

        public PdbxExptlCrystalGrowSolBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder> enterCrystalId() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder> enterSolId() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder>(CATEGORY_NAME, "sol_id", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder> enterVolume() {
            return new FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder>(CATEGORY_NAME, "volume", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder> enterVolumeUnits() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowSolBuilder>(CATEGORY_NAME, "volume_units", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder> enterPH() {
            return new FloatColumnBuilder<PdbxExptlCrystalGrowSolBuilder>(CATEGORY_NAME, "pH", this);
        }
    }

    public static class PdbxExptlCrystalGrowCompBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_exptl_crystal_grow_comp";

        public PdbxExptlCrystalGrowCompBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterCrystalId() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "crystal_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterCompId() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "comp_id", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterCompName() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "comp_name", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterSolId() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "sol_id", this);
        }

        public FloatColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterConc() {
            return new FloatColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "conc", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterConcRange() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "conc_range", this);
        }

        public StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder> enterConcUnits() {
            return new StrColumnBuilder<PdbxExptlCrystalGrowCompBuilder>(CATEGORY_NAME, "conc_units", this);
        }
    }

    public static class PdbxEntityAssemblyBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_assembly";

        public PdbxEntityAssemblyBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder> enterId() {
            return new StrColumnBuilder<PdbxEntityAssemblyBuilder>(CATEGORY_NAME, "id", this);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityAssemblyBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityAssemblyBuilder> enterBiolId() {
            return new StrColumnBuilder<PdbxEntityAssemblyBuilder>(CATEGORY_NAME, "biol_id", this);
        }

        public IntColumnBuilder<PdbxEntityAssemblyBuilder> enterNumCopies() {
            return new IntColumnBuilder<PdbxEntityAssemblyBuilder>(CATEGORY_NAME, "num_copies", this);
        }
    }

    public static class PdbxDatabaseRelatedBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_related";

        public PdbxDatabaseRelatedBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder> enterDbName() {
            return new StrColumnBuilder<PdbxDatabaseRelatedBuilder>(CATEGORY_NAME, "db_name", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder> enterDetails() {
            return new StrColumnBuilder<PdbxDatabaseRelatedBuilder>(CATEGORY_NAME, "details", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder> enterDbId() {
            return new StrColumnBuilder<PdbxDatabaseRelatedBuilder>(CATEGORY_NAME, "db_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseRelatedBuilder> enterContentType() {
            return new StrColumnBuilder<PdbxDatabaseRelatedBuilder>(CATEGORY_NAME, "content_type", this);
        }
    }

    public static class PdbxRefineAuxFileBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine_aux_file";

        public PdbxRefineAuxFileBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder> enterSerialNo() {
            return new StrColumnBuilder<PdbxRefineAuxFileBuilder>(CATEGORY_NAME, "serial_no", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilder<PdbxRefineAuxFileBuilder>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder> enterFileName() {
            return new StrColumnBuilder<PdbxRefineAuxFileBuilder>(CATEGORY_NAME, "file_name", this);
        }

        public StrColumnBuilder<PdbxRefineAuxFileBuilder> enterFileType() {
            return new StrColumnBuilder<PdbxRefineAuxFileBuilder>(CATEGORY_NAME, "file_type", this);
        }
    }

    public static class PdbxXplorFileBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_xplor_file";

        public PdbxXplorFileBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder> enterSerialNo() {
            return new StrColumnBuilder<PdbxXplorFileBuilder>(CATEGORY_NAME, "serial_no", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder> enterPdbxRefineId() {
            return new StrColumnBuilder<PdbxXplorFileBuilder>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder> enterParamFile() {
            return new StrColumnBuilder<PdbxXplorFileBuilder>(CATEGORY_NAME, "param_file", this);
        }

        public StrColumnBuilder<PdbxXplorFileBuilder> enterTopolFile() {
            return new StrColumnBuilder<PdbxXplorFileBuilder>(CATEGORY_NAME, "topol_file", this);
        }
    }

    public static class PdbxStructSheetHbondBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_struct_sheet_hbond";

        public PdbxStructSheetHbondBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRangeId1() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_id_1", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRangeId2() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_id_2", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterSheetId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "sheet_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1LabelAtomId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_label_atom_id", this);
        }

        public IntColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1LabelSeqId() {
            return new IntColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1LabelCompId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_label_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1LabelAsymId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1AuthAtomId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1AuthSeqId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1AuthCompId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1AuthAsymId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange1PDBInsCode() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_1_PDB_ins_code", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2LabelAtomId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_label_atom_id", this);
        }

        public IntColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2LabelSeqId() {
            return new IntColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_label_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2LabelCompId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_label_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2LabelAsymId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_label_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2AuthAtomId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_auth_atom_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2AuthSeqId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_auth_seq_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2AuthCompId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_auth_comp_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2AuthAsymId() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_auth_asym_id", this);
        }

        public StrColumnBuilder<PdbxStructSheetHbondBuilder> enterRange2PDBInsCode() {
            return new StrColumnBuilder<PdbxStructSheetHbondBuilder>(CATEGORY_NAME, "range_2_PDB_ins_code", this);
        }
    }

    public static class PdbxRefineBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_refine";

        public PdbxRefineBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxRefineBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxRefineBuilder> enterPdbxRefineId() {
            return new StrColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "pdbx_refine_id", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterRFactorAllNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "R_factor_all_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterRFactorObsNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "R_factor_obs_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRFactor4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_factor_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRFactorNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_factor_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRErrorNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_error_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRValTestSetSizePercNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_test_set_size_perc_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRValTestSetCtNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_test_set_ct_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterNumberReflnsObsNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "number_reflns_obs_no_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterRFactorAll4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "R_factor_all_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterRFactorObs4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "R_factor_obs_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRVal4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRValTestSetSizePerc4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_test_set_size_perc_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRValTestSetCt4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_test_set_ct_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterNumberReflnsObs4sigCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "number_reflns_obs_4sig_cutoff", this);
        }

        public FloatColumnBuilder<PdbxRefineBuilder> enterFreeRValNoCutoff() {
            return new FloatColumnBuilder<PdbxRefineBuilder>(CATEGORY_NAME, "free_R_val_no_cutoff", this);
        }
    }

    public static class PdbxNonpolySchemeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_nonpoly_scheme";

        public PdbxNonpolySchemeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterMonId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterPdbStrandId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterNdbSeqNum() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "ndb_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterPdbSeqNum() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "pdb_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterAuthSeqNum() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterPdbMonId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "pdb_mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterAuthMonId() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxNonpolySchemeBuilder> enterPdbInsCode() {
            return new StrColumnBuilder<PdbxNonpolySchemeBuilder>(CATEGORY_NAME, "pdb_ins_code", this);
        }
    }

    public static class PdbxPolySeqSchemeBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_poly_seq_scheme";

        public PdbxPolySeqSchemeBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterAsymId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "asym_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public IntColumnBuilder<PdbxPolySeqSchemeBuilder> enterSeqId() {
            return new IntColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "seq_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterHetero() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "hetero", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterMonId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterPdbStrandId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "pdb_strand_id", this);
        }

        public IntColumnBuilder<PdbxPolySeqSchemeBuilder> enterNdbSeqNum() {
            return new IntColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "ndb_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterPdbSeqNum() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "pdb_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterAuthSeqNum() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "auth_seq_num", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterPdbMonId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "pdb_mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterAuthMonId() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "auth_mon_id", this);
        }

        public StrColumnBuilder<PdbxPolySeqSchemeBuilder> enterPdbInsCode() {
            return new StrColumnBuilder<PdbxPolySeqSchemeBuilder>(CATEGORY_NAME, "pdb_ins_code", this);
        }
    }

    public static class PdbxPrereleaseSeqBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_prerelease_seq";

        public PdbxPrereleaseSeqBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxPrereleaseSeqBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxPrereleaseSeqBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxPrereleaseSeqBuilder> enterSeqOneLetterCode() {
            return new StrColumnBuilder<PdbxPrereleaseSeqBuilder>(CATEGORY_NAME, "seq_one_letter_code", this);
        }
    }

    public static class PdbxEntityNameBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_entity_name";

        public PdbxEntityNameBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder> enterEntityId() {
            return new StrColumnBuilder<PdbxEntityNameBuilder>(CATEGORY_NAME, "entity_id", this);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder> enterName() {
            return new StrColumnBuilder<PdbxEntityNameBuilder>(CATEGORY_NAME, "name", this);
        }

        public StrColumnBuilder<PdbxEntityNameBuilder> enterNameType() {
            return new StrColumnBuilder<PdbxEntityNameBuilder>(CATEGORY_NAME, "name_type", this);
        }
    }

    public static class PdbxDatabaseStatusBuilder
    extends CategoryBuilder {
        private static final String CATEGORY_NAME = "pdbx_database_status";

        public PdbxDatabaseStatusBuilder(BlockBuilder parent) {
            super(CATEGORY_NAME, parent);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterStatusCode() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "status_code", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterAuthorReleaseStatusCode() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "author_release_status_code", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterStatusCodeSf() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "status_code_sf", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterStatusCodeMr() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "status_code_mr", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDepReleaseCodeCoordinates() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "dep_release_code_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDepReleaseCodeSequence() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "dep_release_code_sequence", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDepReleaseCodeStructFact() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "dep_release_code_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDepReleaseCodeNmrConstraints() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "dep_release_code_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterEntryId() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "entry_id", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdDepositForm() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_deposit_form", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateDepositionForm() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_deposition_form", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateBeginDeposition() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_begin_deposition", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateBeginProcessing() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_begin_processing", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateEndProcessing() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_end_processing", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateBeginReleasePreparation() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_begin_release_preparation", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateAuthorReleaseRequest() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_author_release_request", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdCoordinates() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateCoordinates() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_coordinates", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdStructFact() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateStructFact() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_struct_fact", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdNmrConstraints() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateNmrConstraints() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_nmr_constraints", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdInternalApproval() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_internal_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdManuscript() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_manuscript", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateManuscript() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "date_manuscript", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterNameDepositor() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "name_depositor", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterRecvdAuthorApproval() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "recvd_author_approval", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterAuthorApprovalType() {
            return new StrColumnBuilder<PdbxDatabaseStatusBuilder>(CATEGORY_NAME, "author_approval_type", this);
        }

        public StrColumnBuilder<PdbxDatabaseStatusBuilder> enterDateAuthorApproval() {
          