/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.model.BaseColumn;

public class StrColumn
extends BaseColumn {
    private final String[] binaryData;

    public StrColumn(String name, int rowCount, String data, int[] startToken, int[] endToken) {
        super(name, rowCount, data, startToken, endToken);
        this.binaryData = null;
    }

    public StrColumn(String name, int rowCount, Object data, int[] mask) {
        super(name, rowCount, mask);
        if (data instanceof String[]) {
            this.binaryData = (String[])data;
        } else if (data instanceof int[]) {
            int[] intData = (int[])data;
            this.binaryData = new String[intData.length];
            for (int i = 0; i < intData.length; ++i) {
                this.binaryData[i] = Integer.toString(intData[i]);
            }
        } else {
            double[] doubleData = (double[])data;
            this.binaryData = new String[doubleData.length];
            for (int i = 0; i < doubleData.length; ++i) {
                this.binaryData[i] = Double.toString(doubleData[i]);
            }
        }
    }

    public StrColumn(String name) {
        super(name);
        this.binaryData = new String[0];
    }

    public String get(int row) {
        return this.isText ? this.getTextData(row) : this.honorValueKind(this.binaryData[row]);
    }

    public Stream<String> values() {
        return IntStream.range(0, this.rowCount).mapToObj(this::get);
    }

    @Override
    protected String getBinaryStringData(int row) {
        return this.honorValueKind(this.binaryData[row]);
    }

    public String[] getBinaryData() {
        return this.binaryData;
    }
}

