/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.rcsb.cif.binary.codec.Codec;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.model.BaseCategory;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;

public class ModelFactory {
    private static final Map<String, SchemaHandler> SCHEMA_MAP = Collections.synchronizedMap(new TreeMap(String.CASE_INSENSITIVE_ORDER));
    private static final MessagePackCodec MESSAGE_PACK_CODEC = new MessagePackCodec();

    private static Column fallbackToTextByType(String columnName, int rowCount, String data, int[] startToken, int[] endToken, Class<? extends Column> columnType) {
        if (columnType.equals(IntColumn.class)) {
            return new IntColumn(columnName, rowCount, data, startToken, endToken);
        }
        if (columnType.equals(FloatColumn.class)) {
            return new FloatColumn(columnName, rowCount, data, startToken, endToken);
        }
        return new StrColumn(columnName, rowCount, data, startToken, endToken);
    }

    private static Column fallbackToBinaryByData(String columnName, int rowCount, Object binaryData, int[] mask) {
        if (binaryData instanceof int[]) {
            return new IntColumn(columnName, rowCount, binaryData, mask);
        }
        if (binaryData instanceof double[]) {
            return new FloatColumn(columnName, rowCount, binaryData, mask);
        }
        return new StrColumn(columnName, rowCount, binaryData, mask);
    }

    public static Category createCategoryText(String categoryName, Map<String, Column> textColumns) {
        String topLevel = ModelFactory.toTopLevel(categoryName);
        SchemaHandler schemaHandler = SCHEMA_MAP.computeIfAbsent(topLevel, ModelFactory::ensureProperties);
        if (schemaHandler != null) {
            return schemaHandler.construct(categoryName, textColumns);
        }
        return new BaseCategory(categoryName, textColumns);
    }

    private static String toTopLevel(String categoryName) {
        int index = categoryName.indexOf("_");
        return index != -1 ? categoryName.substring(0, index) : categoryName;
    }

    private static SchemaHandler ensureProperties(String topLevel) {
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("class-map/" + topLevel + ".bin");
        if (inputStream == null) {
            return null;
        }
        try {
            Map<String, Object> schemaMap = MESSAGE_PACK_CODEC.decode(inputStream);
            TreeMap<String, Constructor<? extends BaseCategory>> textConstructors = new TreeMap<String, Constructor<? extends BaseCategory>>(String.CASE_INSENSITIVE_ORDER);
            TreeMap<String, Constructor<? extends BaseCategory>> binaryConstructors = new TreeMap<String, Constructor<? extends BaseCategory>>(String.CASE_INSENSITIVE_ORDER);
            TreeSet<String> intColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            TreeSet<String> floatColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            TreeSet<String> strColumns = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            for (Map.Entry<String, Object> entry : schemaMap.entrySet()) {
                String categoryName = entry.getKey();
                Object[] value = (Object[])entry.getValue();
                String categoryConstructorName = (String)value[0];
                Class<?> clazz = Class.forName(categoryConstructorName);
                textConstructors.put(categoryName, clazz.getConstructor(String.class, Map.class));
                binaryConstructors.put(categoryName, clazz.getConstructor(String.class, Integer.TYPE, Object[].class));
                for (Object i : (Object[])value[1]) {
                    intColumns.add(categoryName + "." + i);
                }
                for (Object f : (Object[])value[2]) {
                    floatColumns.add(categoryName + "." + f);
                }
                for (Object s : (Object[])value[3]) {
                    strColumns.add(categoryName + "." + s);
                }
            }
            return new SchemaHandler(textConstructors, binaryConstructors, intColumns, floatColumns, strColumns);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Category createCategoryTextGeneric(String categoryName, Map<String, Column> textColumns) {
        return new BaseCategory(categoryName, textColumns);
    }

    public static Category createCategoryBinary(String categoryName, int rowCount, Object[] encodedColumns) {
        String topLevel = ModelFactory.toTopLevel(categoryName);
        SchemaHandler schemaHandler = SCHEMA_MAP.computeIfAbsent(topLevel, ModelFactory::ensureProperties);
        if (schemaHandler != null) {
            return schemaHandler.construct(categoryName, rowCount, encodedColumns);
        }
        return new BaseCategory(categoryName, rowCount, encodedColumns);
    }

    public static Category createCategoryBinaryGeneric(String categoryName, int rowCount, Object[] encodedColumns) {
        return new BaseCategory(categoryName, rowCount, encodedColumns);
    }

    public static Category createEmptyCategory(String name) {
        return new BaseCategory(name);
    }

    public static Column createColumnText(String categoryName, String columnName, String data, int[] startToken, int[] endToken) {
        return ModelFactory.createColumnText(categoryName, columnName, data, startToken, endToken, StrColumn.class);
    }

    public static Column createColumnText(String categoryName, String columnName, String data, int[] startToken, int[] endToken, Class<? extends Column> columnType) {
        String topLevel = ModelFactory.toTopLevel(categoryName);
        SchemaHandler schemaHandler = SCHEMA_MAP.computeIfAbsent(topLevel, ModelFactory::ensureProperties);
        int rowCount = startToken.length;
        if (schemaHandler != null) {
            return schemaHandler.construct(categoryName, columnName, rowCount, data, startToken, endToken, columnType);
        }
        return ModelFactory.fallbackToTextByType(columnName, rowCount, data, startToken, endToken, columnType);
    }

    public static Column createColumnTextGeneric(String columnName, String data, int[] startToken, int[] endToken) {
        return new StrColumn(columnName, startToken.length, data, startToken, endToken);
    }

    public static Column createColumnBinary(String categoryName, String columnName, Map<String, Object> encodedColumn) {
        Object binaryData = Codec.decode((Map)encodedColumn.get("data"));
        int rowCount = Array.getLength(binaryData);
        Map maskMap = (Map)encodedColumn.get("mask");
        int[] mask = maskMap == null || maskMap.isEmpty() ? null : (int[])Codec.decode(maskMap);
        String topLevel = ModelFactory.toTopLevel(categoryName);
        SchemaHandler schemaHandler = SCHEMA_MAP.computeIfAbsent(topLevel, ModelFactory::ensureProperties);
        if (schemaHandler != null) {
            return schemaHandler.construct(categoryName, columnName, rowCount, binaryData, mask);
        }
        return ModelFactory.fallbackToBinaryByData(columnName, rowCount, binaryData, mask);
    }

    public static Column createEmptyColumn(String categoryName, String columnName) {
        String topLevel = ModelFactory.toTopLevel(categoryName);
        SchemaHandler schemaHandler = SCHEMA_MAP.computeIfAbsent(topLevel, ModelFactory::ensureProperties);
        if (schemaHandler != null) {
            return schemaHandler.construct(categoryName, columnName);
        }
        return new StrColumn(columnName);
    }

    static class SchemaHandler {
        private final Map<String, Constructor<? extends BaseCategory>> textCategory;
        private final Map<String, Constructor<? extends BaseCategory>> binaryCategory;
        private final Set<String> intColumns;
        private final Set<String> floatColumns;
        private final Set<String> strColumns;

        SchemaHandler(Map<String, Constructor<? extends BaseCategory>> textCategory, Map<String, Constructor<? extends BaseCategory>> binaryCategory, Set<String> intColumns, Set<String> floatColumns, Set<String> strColumns) {
            this.textCategory = textCategory;
            this.binaryCategory = binaryCategory;
            this.intColumns = intColumns;
            this.floatColumns = floatColumns;
            this.strColumns = strColumns;
        }

        Category construct(String categoryName, Map<String, Column> textColumns) {
            Constructor<? extends BaseCategory> constructor = this.textCategory.get(categoryName);
            if (constructor == null) {
                return new BaseCategory(categoryName, textColumns);
            }
            try {
                return this.textCategory.get(categoryName).newInstance(categoryName, textColumns);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("could not instantiate category class", e);
            }
        }

        Category construct(String categoryName, int rowCount, Object[] encodedColumns) {
            Constructor<? extends BaseCategory> constructor = this.binaryCategory.get(categoryName);
            if (constructor == null) {
                return new BaseCategory(categoryName, rowCount, encodedColumns);
            }
            try {
                return this.binaryCategory.get(categoryName).newInstance(categoryName, rowCount, encodedColumns);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException("could not instantiate category class", e);
            }
        }

        Column construct(String categoryName, String columnName, int rowCount, String data, int[] startToken, int[] endToken, Class<? extends Column> columnType) {
            String name = categoryName + "." + columnName;
            if (this.intColumns.contains(name)) {
                return new IntColumn(columnName, rowCount, data, startToken, endToken);
            }
            if (this.floatColumns.contains(name)) {
                return new FloatColumn(columnName, rowCount, data, startToken, endToken);
            }
            if (this.strColumns.contains(name)) {
                return new StrColumn(columnName, rowCount, data, startToken, endToken);
            }
            return ModelFactory.fallbackToTextByType(columnName, rowCount, data, startToken, endToken, columnType);
        }

        Column construct(String categoryName, String columnName, int rowCount, Object binaryData, int[] mask) {
            String name = categoryName + "." + columnName;
            if (this.intColumns.contains(name)) {
                return new IntColumn(columnName, rowCount, binaryData, mask);
            }
            if (this.floatColumns.contains(name)) {
                return new FloatColumn(columnName, rowCount, binaryData, mask);
            }
            if (this.strColumns.contains(name)) {
                return new StrColumn(columnName, rowCount, binaryData, mask);
            }
            return ModelFactory.fallbackToBinaryByData(columnName, rowCount, binaryData, mask);
        }

        Column construct(String categoryName, String columnName) {
            String name = categoryName + "." + columnName;
            if (this.intColumns.contains(name)) {
                return new IntColumn(columnName);
            }
            if (this.floatColumns.contains(name)) {
                return new FloatColumn(columnName);
            }
            return new StrColumn(columnName);
        }
    }
}

