/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.stream.IntStream;
import org.rcsb.cif.model.BaseColumn;

public class IntColumn
extends BaseColumn {
    private final int[] binaryData;

    public IntColumn(String name, int rowCount, String data, int[] startToken, int[] endToken) {
        super(name, rowCount, data, startToken, endToken);
        this.binaryData = null;
    }

    public IntColumn(String name, int rowCount, Object data, int[] mask) {
        super(name, rowCount, mask);
        if (data instanceof int[]) {
            this.binaryData = (int[])data;
        } else if (data instanceof double[]) {
            double[] intData = (double[])data;
            this.binaryData = new int[intData.length];
            for (int i = 0; i < intData.length; ++i) {
                this.binaryData[i] = (int)intData[i];
            }
        } else {
            String[] stringData = (String[])data;
            this.binaryData = new int[stringData.length];
            for (int i = 0; i < stringData.length; ++i) {
                this.binaryData[i] = this.parseInt(stringData[i]);
            }
        }
    }

    public IntColumn(String name) {
        super(name);
        this.binaryData = new int[0];
    }

    public int get(int row) {
        return this.isText ? this.parseInt(this.getTextData(row)) : this.binaryData[row];
    }

    private int parseInt(String text) {
        if (text.isEmpty() || ".".equals(text) || "?".equals(text)) {
            return 0;
        }
        return Integer.parseInt(text);
    }

    public IntStream values() {
        return IntStream.range(0, this.rowCount).map(this::get);
    }

    @Override
    protected String getBinaryStringData(int row) {
        return Integer.toString(this.binaryData[row]);
    }

    public int[] getBinaryData() {
        return this.binaryData;
    }
}

