/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import org.rcsb.cif.model.BaseColumn;

public class FloatColumn
extends BaseColumn {
    private final double[] binaryData;

    public FloatColumn(String name, int rowCount, String data, int[] startToken, int[] endToken) {
        super(name, rowCount, data, startToken, endToken);
        this.binaryData = null;
    }

    public FloatColumn(String name, int rowCount, Object data, int[] mask) {
        super(name, rowCount, mask);
        if (data instanceof double[]) {
            this.binaryData = (double[])data;
        } else if (data instanceof int[]) {
            int[] intData = (int[])data;
            this.binaryData = new double[intData.length];
            for (int i = 0; i < intData.length; ++i) {
                this.binaryData[i] = intData[i];
            }
        } else {
            String[] stringData = (String[])data;
            this.binaryData = new double[stringData.length];
            for (int i = 0; i < stringData.length; ++i) {
                this.binaryData[i] = this.parseFloat(stringData[i]);
            }
        }
    }

    public FloatColumn(String name) {
        super(name);
        this.binaryData = new double[0];
    }

    public double get(int row) {
        return this.isText ? this.parseFloat(this.getTextData(row)) : this.binaryData[row];
    }

    private double parseFloat(String text) {
        if (text.isEmpty() || ".".equals(text) || "?".equals(text)) {
            return 0.0;
        }
        return Double.parseDouble(text);
    }

    public DoubleStream values() {
        return IntStream.range(0, this.rowCount).mapToDouble(this::get);
    }

    @Override
    protected String getBinaryStringData(int row) {
        return Double.toString(this.binaryData[row]);
    }

    public double[] getBinaryData() {
        return this.binaryData;
    }
}

