/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.text.DecimalFormat;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.ValueKind;

public abstract class BaseColumn
implements Column {
    private final String name;
    final int rowCount;
    final boolean isText;
    private final String textData;
    private final int[] startToken;
    private final int[] endToken;
    private final boolean hasMask;
    private final int[] mask;
    private final boolean defined;
    private static final DecimalFormat FLOAT_2 = new DecimalFormat("0.00");
    private static final DecimalFormat FLOAT_3 = new DecimalFormat("0.000");
    private static final DecimalFormat FLOAT_6 = new DecimalFormat("0.######");

    BaseColumn(String name) {
        this.name = name;
        this.rowCount = 0;
        this.isText = false;
        this.textData = null;
        this.startToken = null;
        this.endToken = null;
        this.hasMask = false;
        this.mask = null;
        this.defined = false;
    }

    BaseColumn(String name, int rowCount, String data, int[] startToken, int[] endToken) {
        this.name = name;
        this.rowCount = rowCount;
        this.isText = true;
        this.textData = data;
        this.startToken = startToken;
        this.endToken = endToken;
        this.hasMask = false;
        this.mask = null;
        this.defined = true;
    }

    BaseColumn(String name, int rowCount, int[] mask) {
        this.name = name;
        this.rowCount = rowCount;
        this.isText = false;
        this.textData = null;
        this.startToken = null;
        this.endToken = null;
        this.hasMask = mask != null && mask.length > 0;
        this.mask = mask;
        this.defined = true;
    }

    String getTextData(int row) {
        return this.honorValueKind(this.textData.substring(this.startToken[row], this.endToken[row]));
    }

    String honorValueKind(String value) {
        return ".".equals(value) || "?".equals(value) ? "" : value;
    }

    @Override
    public String getStringData(int row) {
        if (this instanceof FloatColumn) {
            return this.format(((FloatColumn)this).get(row));
        }
        return this.isText ? this.getTextData(row) : this.getBinaryStringData(row);
    }

    private String format(double val) {
        if ("Cartn_x".equals(this.name) || "Cartn_y".equals(this.name) || "Cartn_z".equals(this.name)) {
            return FLOAT_3.format(val);
        }
        if ("occupancy".equals(this.name)) {
            return FLOAT_2.format(val);
        }
        return FLOAT_6.format(val);
    }

    protected abstract String getBinaryStringData(int var1);

    @Override
    public String getColumnName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public ValueKind getValueKind(int row) {
        if (this.isText) {
            String value = this.textData.substring(this.startToken[row], this.endToken[row]);
            if (value.isEmpty() || ".".equals(value)) {
                return ValueKind.NOT_PRESENT;
            }
            if ("?".equals(value)) {
                return ValueKind.UNKNOWN;
            }
            return ValueKind.PRESENT;
        }
        if (!this.hasMask) {
            return ValueKind.PRESENT;
        }
        return ValueKind.values()[this.mask[row]];
    }

    @Override
    public Stream<ValueKind> valueKinds() {
        return IntStream.range(0, this.rowCount).mapToObj(this::getValueKind);
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }
}

