/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.LinkedCaseInsensitiveMap;
import org.rcsb.cif.model.ModelFactory;

public class BaseCategory
implements Category {
    private final String name;
    private final int rowCount;
    private final List<String> columnNames;
    protected final boolean isText;
    protected final Map<String, Column> textFields;
    private final Object[] encodedColumns;
    private final Map<String, Column> decodedColumns;
    private final boolean defined;

    public BaseCategory(String name) {
        this.name = name;
        this.rowCount = 0;
        this.columnNames = Collections.emptyList();
        this.isText = false;
        this.textFields = Collections.emptyMap();
        this.encodedColumns = new Object[0];
        this.decodedColumns = Collections.emptyMap();
        this.defined = false;
    }

    public BaseCategory(String name, Map<String, Column> textColumns) {
        this.name = name;
        this.rowCount = textColumns.values().stream().findFirst().map(Column::getRowCount).orElse(0);
        this.columnNames = new ArrayList<String>(textColumns.keySet());
        this.isText = true;
        this.textFields = textColumns;
        this.encodedColumns = null;
        this.decodedColumns = null;
        this.defined = true;
    }

    public BaseCategory(String name, int rowCount, Object[] encodedColumns) {
        this.name = name;
        this.rowCount = rowCount;
        this.isText = false;
        this.encodedColumns = encodedColumns;
        this.decodedColumns = new LinkedCaseInsensitiveMap<Column>();
        try {
            this.columnNames = Stream.of(encodedColumns).map(map -> ((Map)map).get("name")).map(String.class::cast).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.textFields = null;
        this.defined = true;
    }

    @Override
    public String getCategoryName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Column getColumn(String name) {
        return this.isText ? this.getTextColumn(name) : this.getBinaryColumn(name);
    }

    private Column getTextColumn(String name) {
        return this.textFields.computeIfAbsent(name, n -> ModelFactory.createEmptyColumn(this.name, n));
    }

    protected Column getBinaryColumn(String name) {
        Optional<Map<String, Object>> optional = this.find(name);
        if (!optional.isPresent()) {
            return ModelFactory.createEmptyColumn(this.name, name);
        }
        if (this.decodedColumns.containsKey(name)) {
            return this.decodedColumns.get(name);
        }
        Column decodedColumn = ModelFactory.createColumnBinary(this.name, name, optional.get());
        this.decodedColumns.put(name, decodedColumn);
        return decodedColumn;
    }

    private Optional<Map<String, Object>> find(String name) {
        return Stream.of(this.encodedColumns).map(m -> (Map)m).filter(m -> name.equalsIgnoreCase((String)m.get("name"))).findFirst();
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public boolean isDefined() {
        return this.defined;
    }
}

