/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.ModelFactory;
import org.rcsb.cif.model.generated.AtomSite;
import org.rcsb.cif.model.generated.AtomSiteAnisotrop;
import org.rcsb.cif.model.generated.AtomSites;
import org.rcsb.cif.model.generated.AtomSitesAlt;
import org.rcsb.cif.model.generated.AtomSitesAltEns;
import org.rcsb.cif.model.generated.AtomSitesAltGen;
import org.rcsb.cif.model.generated.AtomSitesFootnote;
import org.rcsb.cif.model.generated.AtomType;
import org.rcsb.cif.model.generated.Audit;
import org.rcsb.cif.model.generated.AuditAuthor;
import org.rcsb.cif.model.generated.AuditConform;
import org.rcsb.cif.model.generated.AuditContactAuthor;
import org.rcsb.cif.model.generated.AuditLink;
import org.rcsb.cif.model.generated.Cell;
import org.rcsb.cif.model.generated.CellMeasurement;
import org.rcsb.cif.model.generated.CellMeasurementRefln;
import org.rcsb.cif.model.generated.ChemComp;
import org.rcsb.cif.model.generated.ChemCompAngle;
import org.rcsb.cif.model.generated.ChemCompAtom;
import org.rcsb.cif.model.generated.ChemCompBond;
import org.rcsb.cif.model.generated.ChemCompChir;
import org.rcsb.cif.model.generated.ChemCompChirAtom;
import org.rcsb.cif.model.generated.ChemCompLink;
import org.rcsb.cif.model.generated.ChemCompPlane;
import org.rcsb.cif.model.generated.ChemCompPlaneAtom;
import org.rcsb.cif.model.generated.ChemCompTor;
import org.rcsb.cif.model.generated.ChemCompTorValue;
import org.rcsb.cif.model.generated.ChemLink;
import org.rcsb.cif.model.generated.ChemLinkAngle;
import org.rcsb.cif.model.generated.ChemLinkBond;
import org.rcsb.cif.model.generated.ChemLinkChir;
import org.rcsb.cif.model.generated.ChemLinkChirAtom;
import org.rcsb.cif.model.generated.ChemLinkPlane;
import org.rcsb.cif.model.generated.ChemLinkPlaneAtom;
import org.rcsb.cif.model.generated.ChemLinkTor;
import org.rcsb.cif.model.generated.ChemLinkTorValue;
import org.rcsb.cif.model.generated.Chemical;
import org.rcsb.cif.model.generated.ChemicalConnAtom;
import org.rcsb.cif.model.generated.ChemicalConnBond;
import org.rcsb.cif.model.generated.ChemicalFormula;
import org.rcsb.cif.model.generated.Citation;
import org.rcsb.cif.model.generated.CitationAuthor;
import org.rcsb.cif.model.generated.CitationEditor;
import org.rcsb.cif.model.generated.Computing;
import org.rcsb.cif.model.generated.Database;
import org.rcsb.cif.model.generated.Database2;
import org.rcsb.cif.model.generated.DatabasePDBCaveat;
import org.rcsb.cif.model.generated.DatabasePDBMatrix;
import org.rcsb.cif.model.generated.DatabasePDBRemark;
import org.rcsb.cif.model.generated.DatabasePDBRev;
import org.rcsb.cif.model.generated.DatabasePDBRevRecord;
import org.rcsb.cif.model.generated.DatabasePDBTvect;
import org.rcsb.cif.model.generated.Diffrn;
import org.rcsb.cif.model.generated.DiffrnAttenuator;
import org.rcsb.cif.model.generated.DiffrnDetector;
import org.rcsb.cif.model.generated.DiffrnMeasurement;
import org.rcsb.cif.model.generated.DiffrnOrientMatrix;
import org.rcsb.cif.model.generated.DiffrnOrientRefln;
import org.rcsb.cif.model.generated.DiffrnRadiation;
import org.rcsb.cif.model.generated.DiffrnRadiationWavelength;
import org.rcsb.cif.model.generated.DiffrnRefln;
import org.rcsb.cif.model.generated.DiffrnReflns;
import org.rcsb.cif.model.generated.DiffrnReflnsClass;
import org.rcsb.cif.model.generated.DiffrnScaleGroup;
import org.rcsb.cif.model.generated.DiffrnSource;
import org.rcsb.cif.model.generated.DiffrnStandardRefln;
import org.rcsb.cif.model.generated.DiffrnStandards;
import org.rcsb.cif.model.generated.Em2dCrystalEntity;
import org.rcsb.cif.model.generated.Em2dProjectionSelection;
import org.rcsb.cif.model.generated.Em3dCrystalEntity;
import org.rcsb.cif.model.generated.Em3dFitting;
import org.rcsb.cif.model.generated.Em3dFittingList;
import org.rcsb.cif.model.generated.Em3dReconstruction;
import org.rcsb.cif.model.generated.EmAdmin;
import org.rcsb.cif.model.generated.EmAssembly;
import org.rcsb.cif.model.generated.EmAuthorList;
import org.rcsb.cif.model.generated.EmBuffer;
import org.rcsb.cif.model.generated.EmBufferComponent;
import org.rcsb.cif.model.generated.EmCrystalFormation;
import org.rcsb.cif.model.generated.EmCtfCorrection;
import org.rcsb.cif.model.generated.EmDbReference;
import org.rcsb.cif.model.generated.EmDbReferenceAuxiliary;
import org.rcsb.cif.model.generated.EmDepositorInfo;
import org.rcsb.cif.model.generated.EmDepui;
import org.rcsb.cif.model.generated.EmDetector;
import org.rcsb.cif.model.generated.EmDiffraction;
import org.rcsb.cif.model.generated.EmDiffractionShell;
import org.rcsb.cif.model.generated.EmDiffractionStats;
import org.rcsb.cif.model.generated.EmEmbedding;
import org.rcsb.cif.model.generated.EmEntityAssembly;
import org.rcsb.cif.model.generated.EmEntityAssemblyMolwt;
import org.rcsb.cif.model.generated.EmEntityAssemblyNaturalsource;
import org.rcsb.cif.model.generated.EmEntityAssemblyRecombinant;
import org.rcsb.cif.model.generated.EmEulerAngleAssignment;
import org.rcsb.cif.model.generated.EmExperiment;
import org.rcsb.cif.model.generated.EmFiducialMarkers;
import org.rcsb.cif.model.generated.EmFigureDepositorInfo;
import org.rcsb.cif.model.generated.EmFinalClassification;
import org.rcsb.cif.model.generated.EmFocusedIonBeam;
import org.rcsb.cif.model.generated.EmFscCurve;
import org.rcsb.cif.model.generated.EmGridPretreatment;
import org.rcsb.cif.model.generated.EmHelicalEntity;
import org.rcsb.cif.model.generated.EmHighPressureFreezing;
import org.rcsb.cif.model.generated.EmImageProcessing;
import org.rcsb.cif.model.generated.EmImageRecording;
import org.rcsb.cif.model.generated.EmImageScans;
import org.rcsb.cif.model.generated.EmImaging;
import org.rcsb.cif.model.generated.EmImagingOptics;
import org.rcsb.cif.model.generated.EmInterpretFigure;
import org.rcsb.cif.model.generated.EmLayerLines;
import org.rcsb.cif.model.generated.EmLayerLinesDepositorInfo;
import org.rcsb.cif.model.generated.EmMap;
import org.rcsb.cif.model.generated.EmMapDepositorInfo;
import org.rcsb.cif.model.generated.EmMaskDepositorInfo;
import org.rcsb.cif.model.generated.EmObsolete;
import org.rcsb.cif.model.generated.EmParticleSelection;
import org.rcsb.cif.model.generated.EmSamplePreparation;
import org.rcsb.cif.model.generated.EmSampleSupport;
import org.rcsb.cif.model.generated.EmShadowing;
import org.rcsb.cif.model.generated.EmSingleParticleEntity;
import org.rcsb.cif.model.generated.EmSoftware;
import org.rcsb.cif.model.generated.EmSpecimen;
import org.rcsb.cif.model.generated.EmStaining;
import org.rcsb.cif.model.generated.EmStartModel;
import org.rcsb.cif.model.generated.EmStructureFactors;
import org.rcsb.cif.model.generated.EmStructureFactorsDepositorInfo;
import org.rcsb.cif.model.generated.EmSupersede;
import org.rcsb.cif.model.generated.EmSupportFilm;
import org.rcsb.cif.model.generated.EmTomography;
import org.rcsb.cif.model.generated.EmTomographySpecimen;
import org.rcsb.cif.model.generated.EmUltramicrotomy;
import org.rcsb.cif.model.generated.EmVirusEntity;
import org.rcsb.cif.model.generated.EmVirusNaturalHost;
import org.rcsb.cif.model.generated.EmVirusShell;
import org.rcsb.cif.model.generated.EmVitrification;
import org.rcsb.cif.model.generated.EmVolumeSelection;
import org.rcsb.cif.model.generated.Entity;
import org.rcsb.cif.model.generated.EntityKeywords;
import org.rcsb.cif.model.generated.EntityLink;
import org.rcsb.cif.model.generated.EntityNameCom;
import org.rcsb.cif.model.generated.EntityNameSys;
import org.rcsb.cif.model.generated.EntityPoly;
import org.rcsb.cif.model.generated.EntityPolySeq;
import org.rcsb.cif.model.generated.EntitySrcGen;
import org.rcsb.cif.model.generated.EntitySrcNat;
import org.rcsb.cif.model.generated.Entry;
import org.rcsb.cif.model.generated.EntryLink;
import org.rcsb.cif.model.generated.Exptl;
import org.rcsb.cif.model.generated.ExptlCrystal;
import org.rcsb.cif.model.generated.ExptlCrystalFace;
import org.rcsb.cif.model.generated.ExptlCrystalGrow;
import org.rcsb.cif.model.generated.ExptlCrystalGrowComp;
import org.rcsb.cif.model.generated.Geom;
import org.rcsb.cif.model.generated.GeomAngle;
import org.rcsb.cif.model.generated.GeomBond;
import org.rcsb.cif.model.generated.GeomContact;
import org.rcsb.cif.model.generated.GeomHbond;
import org.rcsb.cif.model.generated.GeomTorsion;
import org.rcsb.cif.model.generated.Ihm2demClassAverageFitting;
import org.rcsb.cif.model.generated.Ihm2demClassAverageRestraint;
import org.rcsb.cif.model.generated.Ihm3demRestraint;
import org.rcsb.cif.model.generated.IhmCrossLinkList;
import org.rcsb.cif.model.generated.IhmCrossLinkRestraint;
import org.rcsb.cif.model.generated.IhmCrossLinkResult;
import org.rcsb.cif.model.generated.IhmCrossLinkResultParameters;
import org.rcsb.cif.model.generated.IhmDatasetExternalReference;
import org.rcsb.cif.model.generated.IhmDatasetGroup;
import org.rcsb.cif.model.generated.IhmDatasetList;
import org.rcsb.cif.model.generated.IhmDatasetRelatedDbReference;
import org.rcsb.cif.model.generated.IhmDerivedDistanceRestraint;
import org.rcsb.cif.model.generated.IhmEnsembleInfo;
import org.rcsb.cif.model.generated.IhmExternalFiles;
import org.rcsb.cif.model.generated.IhmExternalReferenceInfo;
import org.rcsb.cif.model.generated.IhmFeatureList;
import org.rcsb.cif.model.generated.IhmGaussianObjEnsemble;
import org.rcsb.cif.model.generated.IhmGaussianObjSite;
import org.rcsb.cif.model.generated.IhmGeometricObjectAxis;
import org.rcsb.cif.model.generated.IhmGeometricObjectCenter;
import org.rcsb.cif.model.generated.IhmGeometricObjectDistanceRestraint;
import org.rcsb.cif.model.generated.IhmGeometricObjectHalfTorus;
import org.rcsb.cif.model.generated.IhmGeometricObjectList;
import org.rcsb.cif.model.generated.IhmGeometricObjectPlane;
import org.rcsb.cif.model.generated.IhmGeometricObjectSphere;
import org.rcsb.cif.model.generated.IhmGeometricObjectTorus;
import org.rcsb.cif.model.generated.IhmGeometricObjectTransformation;
import org.rcsb.cif.model.generated.IhmHydroxylRadicalFpRestraint;
import org.rcsb.cif.model.generated.IhmInterfaceResidueFeature;
import org.rcsb.cif.model.generated.IhmLocalizationDensityFiles;
import org.rcsb.cif.model.generated.IhmModelList;
import org.rcsb.cif.model.generated.IhmModelRepresentation;
import org.rcsb.cif.model.generated.IhmModelRepresentative;
import org.rcsb.cif.model.generated.IhmModelingPostProcess;
import org.rcsb.cif.model.generated.IhmModelingProtocol;
import org.rcsb.cif.model.generated.IhmMultiStateModeling;
import org.rcsb.cif.model.generated.IhmNonPolyFeature;
import org.rcsb.cif.model.generated.IhmOrderedEnsemble;
import org.rcsb.cif.model.generated.IhmPolyAtomFeature;
import org.rcsb.cif.model.generated.IhmPolyResidueFeature;
import org.rcsb.cif.model.generated.IhmPredictedContactRestraint;
import org.rcsb.cif.model.generated.IhmPseudoSiteFeature;
import org.rcsb.cif.model.generated.IhmRelatedDatasets;
import org.rcsb.cif.model.generated.IhmResiduesNotModeled;
import org.rcsb.cif.model.generated.IhmSasRestraint;
import org.rcsb.cif.model.generated.IhmSphereObjSite;
import org.rcsb.cif.model.generated.IhmStartingComparativeModels;
import org.rcsb.cif.model.generated.IhmStartingComputationalModels;
import org.rcsb.cif.model.generated.IhmStartingModelCoord;
import org.rcsb.cif.model.generated.IhmStartingModelDetails;
import org.rcsb.cif.model.generated.IhmStartingModelSeqDif;
import org.rcsb.cif.model.generated.IhmStructAssembly;
import org.rcsb.cif.model.generated.IhmStructAssemblyClass;
import org.rcsb.cif.model.generated.IhmStructAssemblyClassList;
import org.rcsb.cif.model.generated.IhmStructAssemblyDetails;
import org.rcsb.cif.model.generated.Journal;
import org.rcsb.cif.model.generated.JournalIndex;
import org.rcsb.cif.model.generated.NdbOriginalNdbCoordinates;
import org.rcsb.cif.model.generated.NdbStructConfNa;
import org.rcsb.cif.model.generated.NdbStructFeatureNa;
import org.rcsb.cif.model.generated.NdbStructNaBasePair;
import org.rcsb.cif.model.generated.NdbStructNaBasePairStep;
import org.rcsb.cif.model.generated.PdbxAtlas;
import org.rcsb.cif.model.generated.PdbxAtomSiteAnisoTls;
import org.rcsb.cif.model.generated.PdbxAudit;
import org.rcsb.cif.model.generated.PdbxAuditAuthor;
import org.rcsb.cif.model.generated.PdbxAuditConformExtension;
import org.rcsb.cif.model.generated.PdbxAuditRevisionCategory;
import org.rcsb.cif.model.generated.PdbxAuditRevisionDetails;
import org.rcsb.cif.model.generated.PdbxAuditRevisionGroup;
import org.rcsb.cif.model.generated.PdbxAuditRevisionHistory;
import org.rcsb.cif.model.generated.PdbxAuditRevisionItem;
import org.rcsb.cif.model.generated.PdbxAuditSupport;
import org.rcsb.cif.model.generated.PdbxBondDistanceLimits;
import org.rcsb.cif.model.generated.PdbxBranchScheme;
import org.rcsb.cif.model.generated.PdbxBuffer;
import org.rcsb.cif.model.generated.PdbxBufferComponents;
import org.rcsb.cif.model.generated.PdbxChemCompAtomEdit;
import org.rcsb.cif.model.generated.PdbxChemCompAtomFeature;
import org.rcsb.cif.model.generated.PdbxChemCompAtomRelated;
import org.rcsb.cif.model.generated.PdbxChemCompAudit;
import org.rcsb.cif.model.generated.PdbxChemCompBondEdit;
import org.rcsb.cif.model.generated.PdbxChemCompDepositorInfo;
import org.rcsb.cif.model.generated.PdbxChemCompDescriptor;
import org.rcsb.cif.model.generated.PdbxChemCompFeature;
import org.rcsb.cif.model.generated.PdbxChemCompIdentifier;
import org.rcsb.cif.model.generated.PdbxChemCompImport;
import org.rcsb.cif.model.generated.PdbxChemCompInstanceDepositorInfo;
import org.rcsb.cif.model.generated.PdbxChemCompModel;
import org.rcsb.cif.model.generated.PdbxChemCompModelAtom;
import org.rcsb.cif.model.generated.PdbxChemCompModelAudit;
import org.rcsb.cif.model.generated.PdbxChemCompModelBond;
import org.rcsb.cif.model.generated.PdbxChemCompModelDescriptor;
import org.rcsb.cif.model.generated.PdbxChemCompModelFeature;
import org.rcsb.cif.model.generated.PdbxChemCompModelReference;
import org.rcsb.cif.model.generated.PdbxChemCompNonstandard;
import org.rcsb.cif.model.generated.PdbxChemCompRelated;
import org.rcsb.cif.model.generated.PdbxChemCompSubcomponentEntityList;
import org.rcsb.cif.model.generated.PdbxChemCompSubcomponentStructConn;
import org.rcsb.cif.model.generated.PdbxChemCompSynonyms;
import org.rcsb.cif.model.generated.PdbxChemCompUploadDepositorInfo;
import org.rcsb.cif.model.generated.PdbxColumninfo;
import org.rcsb.cif.model.generated.PdbxConnect;
import org.rcsb.cif.model.generated.PdbxConnectAtom;
import org.rcsb.cif.model.generated.PdbxConnectModification;
import org.rcsb.cif.model.generated.PdbxConnectType;
import org.rcsb.cif.model.generated.PdbxConstruct;
import org.rcsb.cif.model.generated.PdbxConstructFeature;
import org.rcsb.cif.model.generated.PdbxContactAuthor;
import org.rcsb.cif.model.generated.PdbxCoord;
import org.rcsb.cif.model.generated.PdbxCoordinateModel;
import org.rcsb.cif.model.generated.PdbxCrystalAlignment;
import org.rcsb.cif.model.generated.PdbxDataProcessingCell;
import org.rcsb.cif.model.generated.PdbxDataProcessingDetector;
import org.rcsb.cif.model.generated.PdbxDataProcessingReflns;
import org.rcsb.cif.model.generated.PdbxDataProcessingStatus;
import org.rcsb.cif.model.generated.PdbxDatabaseMessage;
import org.rcsb.cif.model.generated.PdbxDatabasePDBMaster;
import org.rcsb.cif.model.generated.PdbxDatabasePDBObsSpr;
import org.rcsb.cif.model.generated.PdbxDatabasePdbOmit;
import org.rcsb.cif.model.generated.PdbxDatabaseProc;
import org.rcsb.cif.model.generated.PdbxDatabaseRelated;
import org.rcsb.cif.model.generated.PdbxDatabaseRemark;
import org.rcsb.cif.model.generated.PdbxDatabaseStatus;
import org.rcsb.cif.model.generated.PdbxDatabaseStatusHistory;
import org.rcsb.cif.model.generated.PdbxDbref;
import org.rcsb.cif.model.generated.PdbxDccDensity;
import org.rcsb.cif.model.generated.PdbxDccDensityCorr;
import org.rcsb.cif.model.generated.PdbxDccGeometry;
import org.rcsb.cif.model.generated.PdbxDccMap;
import org.rcsb.cif.model.generated.PdbxDccMapman;
import org.rcsb.cif.model.generated.PdbxDccRsccMapman;
import org.rcsb.cif.model.generated.PdbxDccRsccMapmanOverall;
import org.rcsb.cif.model.generated.PdbxDepositGroup;
import org.rcsb.cif.model.generated.PdbxDepositGroupIndex;
import org.rcsb.cif.model.generated.PdbxDepositionMessageFileReference;
import org.rcsb.cif.model.generated.PdbxDepositionMessageInfo;
import org.rcsb.cif.model.generated.PdbxDepuiEntityFeatures;
import org.rcsb.cif.model.generated.PdbxDepuiEntityStatusFlags;
import org.rcsb.cif.model.generated.PdbxDepuiEntryDetails;
import org.rcsb.cif.model.generated.PdbxDepuiStatusFlags;
import org.rcsb.cif.model.generated.PdbxDepuiUpload;
import org.rcsb.cif.model.generated.PdbxDepuiValidationStatusFlags;
import org.rcsb.cif.model.generated.PdbxDiffrnReflnsShell;
import org.rcsb.cif.model.generated.PdbxDistantSolventAtoms;
import org.rcsb.cif.model.generated.PdbxDomain;
import org.rcsb.cif.model.generated.PdbxDomainRange;
import org.rcsb.cif.model.generated.PdbxDrugInfo;
import org.rcsb.cif.model.generated.PdbxEntityAssembly;
import org.rcsb.cif.model.generated.PdbxEntityBranch;
import org.rcsb.cif.model.generated.PdbxEntityBranchLink;
import org.rcsb.cif.model.generated.PdbxEntityBranchList;
import org.rcsb.cif.model.generated.PdbxEntityDescriptor;
import org.rcsb.cif.model.generated.PdbxEntityFuncBindMode;
import org.rcsb.cif.model.generated.PdbxEntityFuncEnzyme;
import org.rcsb.cif.model.generated.PdbxEntityFuncOther;
import org.rcsb.cif.model.generated.PdbxEntityFuncRegulatory;
import org.rcsb.cif.model.generated.PdbxEntityFuncStructural;
import org.rcsb.cif.model.generated.PdbxEntityInstanceFeature;
import org.rcsb.cif.model.generated.PdbxEntityName;
import org.rcsb.cif.model.generated.PdbxEntityNameInstance;
import org.rcsb.cif.model.generated.PdbxEntityNameTaxonomy;
import org.rcsb.cif.model.generated.PdbxEntityNameTaxonomyTree;
import org.rcsb.cif.model.generated.PdbxEntityNonpoly;
import org.rcsb.cif.model.generated.PdbxEntityPolyCompLinkList;
import org.rcsb.cif.model.generated.PdbxEntityPolyDomain;
import org.rcsb.cif.model.generated.PdbxEntityPolyNaNonstandard;
import org.rcsb.cif.model.generated.PdbxEntityPolyNaType;
import org.rcsb.cif.model.generated.PdbxEntityPolyProteinClass;
import org.rcsb.cif.model.generated.PdbxEntityProdProtocol;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenCharacter;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenChrom;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenClone;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenCloneLigation;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenCloneRecombination;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenDepositorInfo;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenExpress;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenExpressTimepoint;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenFract;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenLysis;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenProdDigest;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenProdOther;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenProdOtherParameter;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenProdPcr;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenProteolysis;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenPure;
import org.rcsb.cif.model.generated.PdbxEntitySrcGenRefold;
import org.rcsb.cif.model.generated.PdbxEntitySrcSyn;
import org.rcsb.cif.model.generated.PdbxEntryDetails;
import org.rcsb.cif.model.generated.PdbxExptlCrystalCryoTreatment;
import org.rcsb.cif.model.generated.PdbxExptlCrystalGrowComp;
import org.rcsb.cif.model.generated.PdbxExptlCrystalGrowSol;
import org.rcsb.cif.model.generated.PdbxExptlPd;
import org.rcsb.cif.model.generated.PdbxFamilyGroupIndex;
import org.rcsb.cif.model.generated.PdbxFamilyPrdAudit;
import org.rcsb.cif.model.generated.PdbxFeatureAssembly;
import org.rcsb.cif.model.generated.PdbxFeatureDomain;
import org.rcsb.cif.model.generated.PdbxFeatureEntry;
import org.rcsb.cif.model.generated.PdbxFeatureMonomer;
import org.rcsb.cif.model.generated.PdbxFeatureSequenceRange;
import org.rcsb.cif.model.generated.PdbxHelicalSymmetry;
import org.rcsb.cif.model.generated.PdbxHelicalSymmetryDepositorInfo;
import org.rcsb.cif.model.generated.PdbxHybrid;
import org.rcsb.cif.model.generated.PdbxInhibitorInfo;
import org.rcsb.cif.model.generated.PdbxIonInfo;
import org.rcsb.cif.model.generated.PdbxLinkedEntity;
import org.rcsb.cif.model.generated.PdbxLinkedEntityInstanceList;
import org.rcsb.cif.model.generated.PdbxLinkedEntityLinkList;
import org.rcsb.cif.model.generated.PdbxLinkedEntityList;
import org.rcsb.cif.model.generated.PdbxMissingAtomNonpoly;
import org.rcsb.cif.model.generated.PdbxMissingAtomPoly;
import org.rcsb.cif.model.generated.PdbxMissingResidueList;
import org.rcsb.cif.model.generated.PdbxMolecule;
import org.rcsb.cif.model.generated.PdbxMoleculeFeatures;
import org.rcsb.cif.model.generated.PdbxMoleculeFeaturesDepositorInfo;
import org.rcsb.cif.model.generated.PdbxNaStrandInfo;
import org.rcsb.cif.model.generated.PdbxNaStructKeywds;
import org.rcsb.cif.model.generated.PdbxNmrAssignedChemShiftList;
import org.rcsb.cif.model.generated.PdbxNmrChemShiftExperiment;
import org.rcsb.cif.model.generated.PdbxNmrChemShiftRef;
import org.rcsb.cif.model.generated.PdbxNmrChemShiftReference;
import org.rcsb.cif.model.generated.PdbxNmrChemShiftSoftware;
import org.rcsb.cif.model.generated.PdbxNmrComputing;
import org.rcsb.cif.model.generated.PdbxNmrConstraintFile;
import org.rcsb.cif.model.generated.PdbxNmrConstraints;
import org.rcsb.cif.model.generated.PdbxNmrDetails;
import org.rcsb.cif.model.generated.PdbxNmrEnsemble;
import org.rcsb.cif.model.generated.PdbxNmrEnsembleRms;
import org.rcsb.cif.model.generated.PdbxNmrExptl;
import org.rcsb.cif.model.generated.PdbxNmrExptlSample;
import org.rcsb.cif.model.generated.PdbxNmrExptlSampleConditions;
import org.rcsb.cif.model.generated.PdbxNmrForceConstants;
import org.rcsb.cif.model.generated.PdbxNmrRefine;
import org.rcsb.cif.model.generated.PdbxNmrRepresentative;
import org.rcsb.cif.model.generated.PdbxNmrSampleDetails;
import org.rcsb.cif.model.generated.PdbxNmrSoftware;
import org.rcsb.cif.model.generated.PdbxNmrSoftwareTask;
import org.rcsb.cif.model.generated.PdbxNmrSpectralDim;
import org.rcsb.cif.model.generated.PdbxNmrSpectralPeakList;
import org.rcsb.cif.model.generated.PdbxNmrSpectralPeakSoftware;
import org.rcsb.cif.model.generated.PdbxNmrSpectrometer;
import org.rcsb.cif.model.generated.PdbxNmrSystematicChemShiftOffset;
import org.rcsb.cif.model.generated.PdbxNmrUpload;
import org.rcsb.cif.model.generated.PdbxNonpolyScheme;
import org.rcsb.cif.model.generated.PdbxNonstandardList;
import org.rcsb.cif.model.generated.PdbxPdbCompnd;
import org.rcsb.cif.model.generated.PdbxPdbSource;
import org.rcsb.cif.model.generated.PdbxPhasingDm;
import org.rcsb.cif.model.generated.PdbxPhasingDmShell;
import org.rcsb.cif.model.generated.PdbxPhasingMADSet;
import org.rcsb.cif.model.generated.PdbxPhasingMADSetShell;
import org.rcsb.cif.model.generated.PdbxPhasingMADSetSite;
import org.rcsb.cif.model.generated.PdbxPhasingMADShell;
import org.rcsb.cif.model.generated.PdbxPhasingMR;
import org.rcsb.cif.model.generated.PdbxPointSymmetry;
import org.rcsb.cif.model.generated.PdbxPointSymmetryDepositorInfo;
import org.rcsb.cif.model.generated.PdbxPolySeqScheme;
import org.rcsb.cif.model.generated.PdbxPostProcessDetails;
import org.rcsb.cif.model.generated.PdbxPostProcessStatus;
import org.rcsb.cif.model.generated.PdbxPrdAudit;
import org.rcsb.cif.model.generated.PdbxPrereleaseSeq;
import org.rcsb.cif.model.generated.PdbxProteinInfo;
import org.rcsb.cif.model.generated.PdbxReRefinement;
import org.rcsb.cif.model.generated.PdbxReferenceEntityLink;
import org.rcsb.cif.model.generated.PdbxReferenceEntityList;
import org.rcsb.cif.model.generated.PdbxReferenceEntityNonpoly;
import org.rcsb.cif.model.generated.PdbxReferenceEntityPoly;
import org.rcsb.cif.model.generated.PdbxReferenceEntityPolyLink;
import org.rcsb.cif.model.generated.PdbxReferenceEntityPolySeq;
import org.rcsb.cif.model.generated.PdbxReferenceEntitySequence;
import org.rcsb.cif.model.generated.PdbxReferenceEntitySrcNat;
import org.rcsb.cif.model.generated.PdbxReferenceEntitySubcomponents;
import org.rcsb.cif.model.generated.PdbxReferenceLinkedEntity;
import org.rcsb.cif.model.generated.PdbxReferenceLinkedEntityCompLink;
import org.rcsb.cif.model.generated.PdbxReferenceLinkedEntityCompList;
import org.rcsb.cif.model.generated.PdbxReferenceLinkedEntityLink;
import org.rcsb.cif.model.generated.PdbxReferenceMolecule;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeAnnotation;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeDetails;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeFamily;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeFeatures;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeList;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeRelatedStructures;
import org.rcsb.cif.model.generated.PdbxReferenceMoleculeSynonyms;
import org.rcsb.cif.model.generated.PdbxReferencePublicationList;
import org.rcsb.cif.model.generated.PdbxRefine;
import org.rcsb.cif.model.generated.PdbxRefineAuxFile;
import org.rcsb.cif.model.generated.PdbxRefineComponent;
import org.rcsb.cif.model.generated.PdbxRefineLsRestrNcs;
import org.rcsb.cif.model.generated.PdbxRefineTls;
import org.rcsb.cif.model.generated.PdbxRefineTlsGroup;
import org.rcsb.cif.model.generated.PdbxReflnsTwin;
import org.rcsb.cif.model.generated.PdbxRelatedExpDataSet;
import org.rcsb.cif.model.generated.PdbxRemediationAtomSiteMapping;
import org.rcsb.cif.model.generated.PdbxRmchOutlier;
import org.rcsb.cif.model.generated.PdbxRmsDevsCovByMonomer;
import org.rcsb.cif.model.generated.PdbxRmsDevsCovalent;
import org.rcsb.cif.model.generated.PdbxRobotSystem;
import org.rcsb.cif.model.generated.PdbxSGProject;
import org.rcsb.cif.model.generated.PdbxSeqMapDepositorInfo;
import org.rcsb.cif.model.generated.PdbxSequenceAnnotation;
import org.rcsb.cif.model.generated.PdbxSequencePattern;
import org.rcsb.cif.model.generated.PdbxSequenceRange;
import org.rcsb.cif.model.generated.PdbxSerialCrystallographyDataReduction;
import org.rcsb.cif.model.generated.PdbxSerialCrystallographyMeasurement;
import org.rcsb.cif.model.generated.PdbxSerialCrystallographySampleDelivery;
import org.rcsb.cif.model.generated.PdbxSerialCrystallographySampleDeliveryFixedTarget;
import org.rcsb.cif.model.generated.PdbxSerialCrystallographySampleDeliveryInjection;
import org.rcsb.cif.model.generated.PdbxSolnScatter;
import org.rcsb.cif.model.generated.PdbxSolnScatterModel;
import org.rcsb.cif.model.generated.PdbxSolventAtomSiteMapping;
import org.rcsb.cif.model.generated.PdbxSolventInfo;
import org.rcsb.cif.model.generated.PdbxSource;
import org.rcsb.cif.model.generated.PdbxStereochemistry;
import org.rcsb.cif.model.generated.PdbxStructAssembly;
import org.rcsb.cif.model.generated.PdbxStructAssemblyAuthClassification;
import org.rcsb.cif.model.generated.PdbxStructAssemblyAuthEvidence;
import org.rcsb.cif.model.generated.PdbxStructAssemblyAuthEvidenceDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructAssemblyDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructAssemblyGen;
import org.rcsb.cif.model.generated.PdbxStructAssemblyGenDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructAssemblyProp;
import org.rcsb.cif.model.generated.PdbxStructAssemblyPropDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructAsymGen;
import org.rcsb.cif.model.generated.PdbxStructBiolFunc;
import org.rcsb.cif.model.generated.PdbxStructChemCompDiagnostics;
import org.rcsb.cif.model.generated.PdbxStructChemCompFeature;
import org.rcsb.cif.model.generated.PdbxStructConnAngle;
import org.rcsb.cif.model.generated.PdbxStructEntityInst;
import org.rcsb.cif.model.generated.PdbxStructGroupComponentRange;
import org.rcsb.cif.model.generated.PdbxStructGroupComponents;
import org.rcsb.cif.model.generated.PdbxStructGroupList;
import org.rcsb.cif.model.generated.PdbxStructInfo;
import org.rcsb.cif.model.generated.PdbxStructLegacyOperList;
import org.rcsb.cif.model.generated.PdbxStructLink;
import org.rcsb.cif.model.generated.PdbxStructModResidue;
import org.rcsb.cif.model.generated.PdbxStructMsymGen;
import org.rcsb.cif.model.generated.PdbxStructNcsVirusGen;
import org.rcsb.cif.model.generated.PdbxStructOperList;
import org.rcsb.cif.model.generated.PdbxStructOperListDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructPackGen;
import org.rcsb.cif.model.generated.PdbxStructRefSeqDeletion;
import org.rcsb.cif.model.generated.PdbxStructRefSeqDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructRefSeqDifDepositorInfo;
import org.rcsb.cif.model.generated.PdbxStructRefSeqFeature;
import org.rcsb.cif.model.generated.PdbxStructRefSeqFeatureProp;
import org.rcsb.cif.model.generated.PdbxStructRefSeqInsertion;
import org.rcsb.cif.model.generated.PdbxStructSheetHbond;
import org.rcsb.cif.model.generated.PdbxStructSpecialSymmetry;
import org.rcsb.cif.model.generated.PdbxSugarPhosphateGeometry;
import org.rcsb.cif.model.generated.PdbxSummaryFlags;
import org.rcsb.cif.model.generated.PdbxSupportingExpDataSet;
import org.rcsb.cif.model.generated.PdbxTableinfo;
import org.rcsb.cif.model.generated.PdbxTrnaInfo;
import org.rcsb.cif.model.generated.PdbxUnobsOrZeroOccAtoms;
import org.rcsb.cif.model.generated.PdbxUnobsOrZeroOccResidues;
import org.rcsb.cif.model.generated.PdbxUnpair;
import org.rcsb.cif.model.generated.PdbxValAngle;
import org.rcsb.cif.model.generated.PdbxValBond;
import org.rcsb.cif.model.generated.PdbxValChiral;
import org.rcsb.cif.model.generated.PdbxValContact;
import org.rcsb.cif.model.generated.PdbxValSymContact;
import org.rcsb.cif.model.generated.PdbxValidateChiral;
import org.rcsb.cif.model.generated.PdbxValidateCloseContact;
import org.rcsb.cif.model.generated.PdbxValidateMainChainPlane;
import org.rcsb.cif.model.generated.PdbxValidatePeptideOmega;
import org.rcsb.cif.model.generated.PdbxValidatePlanes;
import org.rcsb.cif.model.generated.PdbxValidatePlanesAtom;
import org.rcsb.cif.model.generated.PdbxValidatePolymerLinkage;
import org.rcsb.cif.model.generated.PdbxValidateRmsdAngle;
import org.rcsb.cif.model.generated.PdbxValidateRmsdBond;
import org.rcsb.cif.model.generated.PdbxValidateSymmContact;
import org.rcsb.cif.model.generated.PdbxValidateTorsion;
import org.rcsb.cif.model.generated.PdbxVersion;
import org.rcsb.cif.model.generated.PdbxViewCategory;
import org.rcsb.cif.model.generated.PdbxViewCategoryGroup;
import org.rcsb.cif.model.generated.PdbxViewItem;
import org.rcsb.cif.model.generated.PdbxVirtualAngle;
import org.rcsb.cif.model.generated.PdbxVirtualBond;
import org.rcsb.cif.model.generated.PdbxVirtualTorsion;
import org.rcsb.cif.model.generated.PdbxXplorFile;
import org.rcsb.cif.model.generated.Phasing;
import org.rcsb.cif.model.generated.PhasingAveraging;
import org.rcsb.cif.model.generated.PhasingIsomorphous;
import org.rcsb.cif.model.generated.PhasingMAD;
import org.rcsb.cif.model.generated.PhasingMADClust;
import org.rcsb.cif.model.generated.PhasingMADExpt;
import org.rcsb.cif.model.generated.PhasingMADRatio;
import org.rcsb.cif.model.generated.PhasingMADSet;
import org.rcsb.cif.model.generated.PhasingMIR;
import org.rcsb.cif.model.generated.PhasingMIRDer;
import org.rcsb.cif.model.generated.PhasingMIRDerRefln;
import org.rcsb.cif.model.generated.PhasingMIRDerShell;
import org.rcsb.cif.model.generated.PhasingMIRDerSite;
import org.rcsb.cif.model.generated.PhasingMIRShell;
import org.rcsb.cif.model.generated.PhasingSet;
import org.rcsb.cif.model.generated.PhasingSetRefln;
import org.rcsb.cif.model.generated.Publ;
import org.rcsb.cif.model.generated.PublAuthor;
import org.rcsb.cif.model.generated.PublBody;
import org.rcsb.cif.model.generated.PublManuscriptIncl;
import org.rcsb.cif.model.generated.Refine;
import org.rcsb.cif.model.generated.RefineAnalyze;
import org.rcsb.cif.model.generated.RefineBIso;
import org.rcsb.cif.model.generated.RefineFunctMinimized;
import org.rcsb.cif.model.generated.RefineHist;
import org.rcsb.cif.model.generated.RefineLsClass;
import org.rcsb.cif.model.generated.RefineLsRestr;
import org.rcsb.cif.model.generated.RefineLsRestrNcs;
import org.rcsb.cif.model.generated.RefineLsRestrType;
import org.rcsb.cif.model.generated.RefineLsShell;
import org.rcsb.cif.model.generated.RefineOccupancy;
import org.rcsb.cif.model.generated.Refln;
import org.rcsb.cif.model.generated.ReflnSysAbs;
import org.rcsb.cif.model.generated.Reflns;
import org.rcsb.cif.model.generated.ReflnsClass;
import org.rcsb.cif.model.generated.ReflnsScale;
import org.rcsb.cif.model.generated.ReflnsShell;
import org.rcsb.cif.model.generated.Software;
import org.rcsb.cif.model.generated.SpaceGroup;
import org.rcsb.cif.model.generated.SpaceGroupSymop;
import org.rcsb.cif.model.generated.Struct;
import org.rcsb.cif.model.generated.StructAsym;
import org.rcsb.cif.model.generated.StructBiol;
import org.rcsb.cif.model.generated.StructBiolGen;
import org.rcsb.cif.model.generated.StructBiolKeywords;
import org.rcsb.cif.model.generated.StructBiolView;
import org.rcsb.cif.model.generated.StructConf;
import org.rcsb.cif.model.generated.StructConfType;
import org.rcsb.cif.model.generated.StructConn;
import org.rcsb.cif.model.generated.StructConnType;
import org.rcsb.cif.model.generated.StructKeywords;
import org.rcsb.cif.model.generated.StructMonDetails;
import org.rcsb.cif.model.generated.StructMonNucl;
import org.rcsb.cif.model.generated.StructMonProt;
import org.rcsb.cif.model.generated.StructMonProtCis;
import org.rcsb.cif.model.generated.StructNcsDom;
import org.rcsb.cif.model.generated.StructNcsDomLim;
import org.rcsb.cif.model.generated.StructNcsEns;
import org.rcsb.cif.model.generated.StructNcsEnsGen;
import org.rcsb.cif.model.generated.StructNcsOper;
import org.rcsb.cif.model.generated.StructRef;
import org.rcsb.cif.model.generated.StructRefSeq;
import org.rcsb.cif.model.generated.StructRefSeqDif;
import org.rcsb.cif.model.generated.StructSheet;
import org.rcsb.cif.model.generated.StructSheetHbond;
import org.rcsb.cif.model.generated.StructSheetOrder;
import org.rcsb.cif.model.generated.StructSheetRange;
import org.rcsb.cif.model.generated.StructSheetTopology;
import org.rcsb.cif.model.generated.StructSite;
import org.rcsb.cif.model.generated.StructSiteGen;
import org.rcsb.cif.model.generated.StructSiteKeywords;
import org.rcsb.cif.model.generated.StructSiteView;
import org.rcsb.cif.model.generated.Symmetry;
import org.rcsb.cif.model.generated.SymmetryEquiv;
import org.rcsb.cif.model.generated.ValenceParam;
import org.rcsb.cif.model.generated.ValenceRef;

public class BaseBlock
implements Block {
    private final Map<String, Category> categories;
    private final List<Block> saveFrames;
    private final String header;

    public BaseBlock(Map<String, Category> categories, String header, List<Block> saveFrames) {
        this.categories = categories;
        this.saveFrames = saveFrames;
        this.header = header;
    }

    public BaseBlock(Map<String, Category> categories, String header) {
        this(categories, header, new ArrayList<Block>());
    }

    @Override
    public String getBlockHeader() {
        return this.header;
    }

    @Override
    public Category getCategory(String name) {
        return this.categories.computeIfAbsent(name, ModelFactory::createEmptyCategory);
    }

    @Override
    public Column getColumn(String name) {
        if (this.categories.containsKey(name)) {
            return this.categories.get(name).getColumn("");
        }
        return ModelFactory.createEmptyColumn(name, "");
    }

    @Override
    public List<String> getCategoryNames() {
        return new ArrayList<String>(this.categories.keySet());
    }

    @Override
    public List<Block> getSaveFrames() {
        return this.saveFrames;
    }

    @Override
    public AtomSite getAtomSite() {
        return (AtomSite)this.categories.computeIfAbsent("atom_site", AtomSite::new).get();
    }

    @Override
    public AtomSiteAnisotrop getAtomSiteAnisotrop() {
        return (AtomSiteAnisotrop)this.categories.computeIfAbsent("atom_site_anisotrop", AtomSiteAnisotrop::new).get();
    }

    @Override
    public AtomSites getAtomSites() {
        return (AtomSites)this.categories.computeIfAbsent("atom_sites", AtomSites::new).get();
    }

    @Override
    public AtomSitesAlt getAtomSitesAlt() {
        return (AtomSitesAlt)this.categories.computeIfAbsent("atom_sites_alt", AtomSitesAlt::new).get();
    }

    @Override
    public AtomSitesAltEns getAtomSitesAltEns() {
        return (AtomSitesAltEns)this.categories.computeIfAbsent("atom_sites_alt_ens", AtomSitesAltEns::new).get();
    }

    @Override
    public AtomSitesAltGen getAtomSitesAltGen() {
        return (AtomSitesAltGen)this.categories.computeIfAbsent("atom_sites_alt_gen", AtomSitesAltGen::new).get();
    }

    @Override
    public AtomSitesFootnote getAtomSitesFootnote() {
        return (AtomSitesFootnote)this.categories.computeIfAbsent("atom_sites_footnote", AtomSitesFootnote::new).get();
    }

    @Override
    public AtomType getAtomType() {
        return (AtomType)this.categories.computeIfAbsent("atom_type", AtomType::new).get();
    }

    @Override
    public Audit getAudit() {
        return (Audit)this.categories.computeIfAbsent("audit", Audit::new).get();
    }

    @Override
    public AuditAuthor getAuditAuthor() {
        return (AuditAuthor)this.categories.computeIfAbsent("audit_author", AuditAuthor::new).get();
    }

    @Override
    public AuditConform getAuditConform() {
        return (AuditConform)this.categories.computeIfAbsent("audit_conform", AuditConform::new).get();
    }

    @Override
    public AuditContactAuthor getAuditContactAuthor() {
        return (AuditContactAuthor)this.categories.computeIfAbsent("audit_contact_author", AuditContactAuthor::new).get();
    }

    @Override
    public Cell getCell() {
        return (Cell)this.categories.computeIfAbsent("cell", Cell::new).get();
    }

    @Override
    public CellMeasurement getCellMeasurement() {
        return (CellMeasurement)this.categories.computeIfAbsent("cell_measurement", CellMeasurement::new).get();
    }

    @Override
    public CellMeasurementRefln getCellMeasurementRefln() {
        return (CellMeasurementRefln)this.categories.computeIfAbsent("cell_measurement_refln", CellMeasurementRefln::new).get();
    }

    @Override
    public ChemComp getChemComp() {
        return (ChemComp)this.categories.computeIfAbsent("chem_comp", ChemComp::new).get();
    }

    @Override
    public ChemCompAngle getChemCompAngle() {
        return (ChemCompAngle)this.categories.computeIfAbsent("chem_comp_angle", ChemCompAngle::new).get();
    }

    @Override
    public ChemCompAtom getChemCompAtom() {
        return (ChemCompAtom)this.categories.computeIfAbsent("chem_comp_atom", ChemCompAtom::new).get();
    }

    @Override
    public ChemCompBond getChemCompBond() {
        return (ChemCompBond)this.categories.computeIfAbsent("chem_comp_bond", ChemCompBond::new).get();
    }

    @Override
    public ChemCompChir getChemCompChir() {
        return (ChemCompChir)this.categories.computeIfAbsent("chem_comp_chir", ChemCompChir::new).get();
    }

    @Override
    public ChemCompChirAtom getChemCompChirAtom() {
        return (ChemCompChirAtom)this.categories.computeIfAbsent("chem_comp_chir_atom", ChemCompChirAtom::new).get();
    }

    @Override
    public ChemCompLink getChemCompLink() {
        return (ChemCompLink)this.categories.computeIfAbsent("chem_comp_link", ChemCompLink::new).get();
    }

    @Override
    public ChemCompPlane getChemCompPlane() {
        return (ChemCompPlane)this.categories.computeIfAbsent("chem_comp_plane", ChemCompPlane::new).get();
    }

    @Override
    public ChemCompPlaneAtom getChemCompPlaneAtom() {
        return (ChemCompPlaneAtom)this.categories.computeIfAbsent("chem_comp_plane_atom", ChemCompPlaneAtom::new).get();
    }

    @Override
    public ChemCompTor getChemCompTor() {
        return (ChemCompTor)this.categories.computeIfAbsent("chem_comp_tor", ChemCompTor::new).get();
    }

    @Override
    public ChemCompTorValue getChemCompTorValue() {
        return (ChemCompTorValue)this.categories.computeIfAbsent("chem_comp_tor_value", ChemCompTorValue::new).get();
    }

    @Override
    public ChemLink getChemLink() {
        return (ChemLink)this.categories.computeIfAbsent("chem_link", ChemLink::new).get();
    }

    @Override
    public ChemLinkAngle getChemLinkAngle() {
        return (ChemLinkAngle)this.categories.computeIfAbsent("chem_link_angle", ChemLinkAngle::new).get();
    }

    @Override
    public ChemLinkBond getChemLinkBond() {
        return (ChemLinkBond)this.categories.computeIfAbsent("chem_link_bond", ChemLinkBond::new).get();
    }

    @Override
    public ChemLinkChir getChemLinkChir() {
        return (ChemLinkChir)this.categories.computeIfAbsent("chem_link_chir", ChemLinkChir::new).get();
    }

    @Override
    public ChemLinkChirAtom getChemLinkChirAtom() {
        return (ChemLinkChirAtom)this.categories.computeIfAbsent("chem_link_chir_atom", ChemLinkChirAtom::new).get();
    }

    @Override
    public ChemLinkPlane getChemLinkPlane() {
        return (ChemLinkPlane)this.categories.computeIfAbsent("chem_link_plane", ChemLinkPlane::new).get();
    }

    @Override
    public ChemLinkPlaneAtom getChemLinkPlaneAtom() {
        return (ChemLinkPlaneAtom)this.categories.computeIfAbsent("chem_link_plane_atom", ChemLinkPlaneAtom::new).get();
    }

    @Override
    public ChemLinkTor getChemLinkTor() {
        return (ChemLinkTor)this.categories.computeIfAbsent("chem_link_tor", ChemLinkTor::new).get();
    }

    @Override
    public ChemLinkTorValue getChemLinkTorValue() {
        return (ChemLinkTorValue)this.categories.computeIfAbsent("chem_link_tor_value", ChemLinkTorValue::new).get();
    }

    @Override
    public Chemical getChemical() {
        return (Chemical)this.categories.computeIfAbsent("chemical", Chemical::new).get();
    }

    @Override
    public ChemicalConnAtom getChemicalConnAtom() {
        return (ChemicalConnAtom)this.categories.computeIfAbsent("chemical_conn_atom", ChemicalConnAtom::new).get();
    }

    @Override
    public ChemicalConnBond getChemicalConnBond() {
        return (ChemicalConnBond)this.categories.computeIfAbsent("chemical_conn_bond", ChemicalConnBond::new).get();
    }

    @Override
    public ChemicalFormula getChemicalFormula() {
        return (ChemicalFormula)this.categories.computeIfAbsent("chemical_formula", ChemicalFormula::new).get();
    }

    @Override
    public Citation getCitation() {
        return (Citation)this.categories.computeIfAbsent("citation", Citation::new).get();
    }

    @Override
    public CitationAuthor getCitationAuthor() {
        return (CitationAuthor)this.categories.computeIfAbsent("citation_author", CitationAuthor::new).get();
    }

    @Override
    public CitationEditor getCitationEditor() {
        return (CitationEditor)this.categories.computeIfAbsent("citation_editor", CitationEditor::new).get();
    }

    @Override
    public Computing getComputing() {
        return (Computing)this.categories.computeIfAbsent("computing", Computing::new).get();
    }

    @Override
    public Database getDatabase() {
        return (Database)this.categories.computeIfAbsent("database", Database::new).get();
    }

    @Override
    public Database2 getDatabase2() {
        return (Database2)this.categories.computeIfAbsent("database_2", Database2::new).get();
    }

    @Override
    public DatabasePDBCaveat getDatabasePDBCaveat() {
        return (DatabasePDBCaveat)this.categories.computeIfAbsent("database_PDB_caveat", DatabasePDBCaveat::new).get();
    }

    @Override
    public DatabasePDBMatrix getDatabasePDBMatrix() {
        return (DatabasePDBMatrix)this.categories.computeIfAbsent("database_PDB_matrix", DatabasePDBMatrix::new).get();
    }

    @Override
    public DatabasePDBRemark getDatabasePDBRemark() {
        return (DatabasePDBRemark)this.categories.computeIfAbsent("database_PDB_remark", DatabasePDBRemark::new).get();
    }

    @Override
    public DatabasePDBRev getDatabasePDBRev() {
        return (DatabasePDBRev)this.categories.computeIfAbsent("database_PDB_rev", DatabasePDBRev::new).get();
    }

    @Override
    public DatabasePDBRevRecord getDatabasePDBRevRecord() {
        return (DatabasePDBRevRecord)this.categories.computeIfAbsent("database_PDB_rev_record", DatabasePDBRevRecord::new).get();
    }

    @Override
    public DatabasePDBTvect getDatabasePDBTvect() {
        return (DatabasePDBTvect)this.categories.computeIfAbsent("database_PDB_tvect", DatabasePDBTvect::new).get();
    }

    @Override
    public Diffrn getDiffrn() {
        return (Diffrn)this.categories.computeIfAbsent("diffrn", Diffrn::new).get();
    }

    @Override
    public DiffrnAttenuator getDiffrnAttenuator() {
        return (DiffrnAttenuator)this.categories.computeIfAbsent("diffrn_attenuator", DiffrnAttenuator::new).get();
    }

    @Override
    public DiffrnDetector getDiffrnDetector() {
        return (DiffrnDetector)this.categories.computeIfAbsent("diffrn_detector", DiffrnDetector::new).get();
    }

    @Override
    public DiffrnMeasurement getDiffrnMeasurement() {
        return (DiffrnMeasurement)this.categories.computeIfAbsent("diffrn_measurement", DiffrnMeasurement::new).get();
    }

    @Override
    public DiffrnOrientMatrix getDiffrnOrientMatrix() {
        return (DiffrnOrientMatrix)this.categories.computeIfAbsent("diffrn_orient_matrix", DiffrnOrientMatrix::new).get();
    }

    @Override
    public DiffrnOrientRefln getDiffrnOrientRefln() {
        return (DiffrnOrientRefln)this.categories.computeIfAbsent("diffrn_orient_refln", DiffrnOrientRefln::new).get();
    }

    @Override
    public DiffrnRadiation getDiffrnRadiation() {
        return (DiffrnRadiation)this.categories.computeIfAbsent("diffrn_radiation", DiffrnRadiation::new).get();
    }

    @Override
    public DiffrnRadiationWavelength getDiffrnRadiationWavelength() {
        return (DiffrnRadiationWavelength)this.categories.computeIfAbsent("diffrn_radiation_wavelength", DiffrnRadiationWavelength::new).get();
    }

    @Override
    public DiffrnRefln getDiffrnRefln() {
        return (DiffrnRefln)this.categories.computeIfAbsent("diffrn_refln", DiffrnRefln::new).get();
    }

    @Override
    public DiffrnReflns getDiffrnReflns() {
        return (DiffrnReflns)this.categories.computeIfAbsent("diffrn_reflns", DiffrnReflns::new).get();
    }

    @Override
    public DiffrnScaleGroup getDiffrnScaleGroup() {
        return (DiffrnScaleGroup)this.categories.computeIfAbsent("diffrn_scale_group", DiffrnScaleGroup::new).get();
    }

    @Override
    public DiffrnSource getDiffrnSource() {
        return (DiffrnSource)this.categories.computeIfAbsent("diffrn_source", DiffrnSource::new).get();
    }

    @Override
    public DiffrnStandardRefln getDiffrnStandardRefln() {
        return (DiffrnStandardRefln)this.categories.computeIfAbsent("diffrn_standard_refln", DiffrnStandardRefln::new).get();
    }

    @Override
    public DiffrnStandards getDiffrnStandards() {
        return (DiffrnStandards)this.categories.computeIfAbsent("diffrn_standards", DiffrnStandards::new).get();
    }

    @Override
    public Entity getEntity() {
        return (Entity)this.categories.computeIfAbsent("entity", Entity::new).get();
    }

    @Override
    public EntityKeywords getEntityKeywords() {
        return (EntityKeywords)this.categories.computeIfAbsent("entity_keywords", EntityKeywords::new).get();
    }

    @Override
    public EntityLink getEntityLink() {
        return (EntityLink)this.categories.computeIfAbsent("entity_link", EntityLink::new).get();
    }

    @Override
    public EntityNameCom getEntityNameCom() {
        return (EntityNameCom)this.categories.computeIfAbsent("entity_name_com", EntityNameCom::new).get();
    }

    @Override
    public EntityNameSys getEntityNameSys() {
        return (EntityNameSys)this.categories.computeIfAbsent("entity_name_sys", EntityNameSys::new).get();
    }

    @Override
    public EntityPoly getEntityPoly() {
        return (EntityPoly)this.categories.computeIfAbsent("entity_poly", EntityPoly::new).get();
    }

    @Override
    public EntityPolySeq getEntityPolySeq() {
        return (EntityPolySeq)this.categories.computeIfAbsent("entity_poly_seq", EntityPolySeq::new).get();
    }

    @Override
    public Entry getEntry() {
        return (Entry)this.categories.computeIfAbsent("entry", Entry::new).get();
    }

    @Override
    public EntryLink getEntryLink() {
        return (EntryLink)this.categories.computeIfAbsent("entry_link", EntryLink::new).get();
    }

    @Override
    public Exptl getExptl() {
        return (Exptl)this.categories.computeIfAbsent("exptl", Exptl::new).get();
    }

    @Override
    public ExptlCrystal getExptlCrystal() {
        return (ExptlCrystal)this.categories.computeIfAbsent("exptl_crystal", ExptlCrystal::new).get();
    }

    @Override
    public ExptlCrystalFace getExptlCrystalFace() {
        return (ExptlCrystalFace)this.categories.computeIfAbsent("exptl_crystal_face", ExptlCrystalFace::new).get();
    }

    @Override
    public ExptlCrystalGrow getExptlCrystalGrow() {
        return (ExptlCrystalGrow)this.categories.computeIfAbsent("exptl_crystal_grow", ExptlCrystalGrow::new).get();
    }

    @Override
    public ExptlCrystalGrowComp getExptlCrystalGrowComp() {
        return (ExptlCrystalGrowComp)this.categories.computeIfAbsent("exptl_crystal_grow_comp", ExptlCrystalGrowComp::new).get();
    }

    @Override
    public Geom getGeom() {
        return (Geom)this.categories.computeIfAbsent("geom", Geom::new).get();
    }

    @Override
    public GeomAngle getGeomAngle() {
        return (GeomAngle)this.categories.computeIfAbsent("geom_angle", GeomAngle::new).get();
    }

    @Override
    public GeomBond getGeomBond() {
        return (GeomBond)this.categories.computeIfAbsent("geom_bond", GeomBond::new).get();
    }

    @Override
    public GeomContact getGeomContact() {
        return (GeomContact)this.categories.computeIfAbsent("geom_contact", GeomContact::new).get();
    }

    @Override
    public GeomHbond getGeomHbond() {
        return (GeomHbond)this.categories.computeIfAbsent("geom_hbond", GeomHbond::new).get();
    }

    @Override
    public GeomTorsion getGeomTorsion() {
        return (GeomTorsion)this.categories.computeIfAbsent("geom_torsion", GeomTorsion::new).get();
    }

    @Override
    public Journal getJournal() {
        return (Journal)this.categories.computeIfAbsent("journal", Journal::new).get();
    }

    @Override
    public JournalIndex getJournalIndex() {
        return (JournalIndex)this.categories.computeIfAbsent("journal_index", JournalIndex::new).get();
    }

    @Override
    public Phasing getPhasing() {
        return (Phasing)this.categories.computeIfAbsent("phasing", Phasing::new).get();
    }

    @Override
    public PhasingAveraging getPhasingAveraging() {
        return (PhasingAveraging)this.categories.computeIfAbsent("phasing_averaging", PhasingAveraging::new).get();
    }

    @Override
    public PhasingIsomorphous getPhasingIsomorphous() {
        return (PhasingIsomorphous)this.categories.computeIfAbsent("phasing_isomorphous", PhasingIsomorphous::new).get();
    }

    @Override
    public PhasingMAD getPhasingMAD() {
        return (PhasingMAD)this.categories.computeIfAbsent("phasing_MAD", PhasingMAD::new).get();
    }

    @Override
    public PhasingMADClust getPhasingMADClust() {
        return (PhasingMADClust)this.categories.computeIfAbsent("phasing_MAD_clust", PhasingMADClust::new).get();
    }

    @Override
    public PhasingMADExpt getPhasingMADExpt() {
        return (PhasingMADExpt)this.categories.computeIfAbsent("phasing_MAD_expt", PhasingMADExpt::new).get();
    }

    @Override
    public PhasingMADRatio getPhasingMADRatio() {
        return (PhasingMADRatio)this.categories.computeIfAbsent("phasing_MAD_ratio", PhasingMADRatio::new).get();
    }

    @Override
    public PhasingMADSet getPhasingMADSet() {
        return (PhasingMADSet)this.categories.computeIfAbsent("phasing_MAD_set", PhasingMADSet::new).get();
    }

    @Override
    public PhasingMIR getPhasingMIR() {
        return (PhasingMIR)this.categories.computeIfAbsent("phasing_MIR", PhasingMIR::new).get();
    }

    @Override
    public PhasingMIRDer getPhasingMIRDer() {
        return (PhasingMIRDer)this.categories.computeIfAbsent("phasing_MIR_der", PhasingMIRDer::new).get();
    }

    @Override
    public PhasingMIRDerRefln getPhasingMIRDerRefln() {
        return (PhasingMIRDerRefln)this.categories.computeIfAbsent("phasing_MIR_der_refln", PhasingMIRDerRefln::new).get();
    }

    @Override
    public PhasingMIRDerShell getPhasingMIRDerShell() {
        return (PhasingMIRDerShell)this.categories.computeIfAbsent("phasing_MIR_der_shell", PhasingMIRDerShell::new).get();
    }

    @Override
    public PhasingMIRDerSite getPhasingMIRDerSite() {
        return (PhasingMIRDerSite)this.categories.computeIfAbsent("phasing_MIR_der_site", PhasingMIRDerSite::new).get();
    }

    @Override
    public PhasingMIRShell getPhasingMIRShell() {
        return (PhasingMIRShell)this.categories.computeIfAbsent("phasing_MIR_shell", PhasingMIRShell::new).get();
    }

    @Override
    public PhasingSet getPhasingSet() {
        return (PhasingSet)this.categories.computeIfAbsent("phasing_set", PhasingSet::new).get();
    }

    @Override
    public PhasingSetRefln getPhasingSetRefln() {
        return (PhasingSetRefln)this.categories.computeIfAbsent("phasing_set_refln", PhasingSetRefln::new).get();
    }

    @Override
    public Publ getPubl() {
        return (Publ)this.categories.computeIfAbsent("publ", Publ::new).get();
    }

    @Override
    public PublAuthor getPublAuthor() {
        return (PublAuthor)this.categories.computeIfAbsent("publ_author", PublAuthor::new).get();
    }

    @Override
    public PublBody getPublBody() {
        return (PublBody)this.categories.computeIfAbsent("publ_body", PublBody::new).get();
    }

    @Override
    public PublManuscriptIncl getPublManuscriptIncl() {
        return (PublManuscriptIncl)this.categories.computeIfAbsent("publ_manuscript_incl", PublManuscriptIncl::new).get();
    }

    @Override
    public Refine getRefine() {
        return (Refine)this.categories.computeIfAbsent("refine", Refine::new).get();
    }

    @Override
    public RefineAnalyze getRefineAnalyze() {
        return (RefineAnalyze)this.categories.computeIfAbsent("refine_analyze", RefineAnalyze::new).get();
    }

    @Override
    public RefineBIso getRefineBIso() {
        return (RefineBIso)this.categories.computeIfAbsent("refine_B_iso", RefineBIso::new).get();
    }

    @Override
    public RefineFunctMinimized getRefineFunctMinimized() {
        return (RefineFunctMinimized)this.categories.computeIfAbsent("refine_funct_minimized", RefineFunctMinimized::new).get();
    }

    @Override
    public RefineHist getRefineHist() {
        return (RefineHist)this.categories.computeIfAbsent("refine_hist", RefineHist::new).get();
    }

    @Override
    public RefineLsRestr getRefineLsRestr() {
        return (RefineLsRestr)this.categories.computeIfAbsent("refine_ls_restr", RefineLsRestr::new).get();
    }

    @Override
    public RefineLsRestrNcs getRefineLsRestrNcs() {
        return (RefineLsRestrNcs)this.categories.computeIfAbsent("refine_ls_restr_ncs", RefineLsRestrNcs::new).get();
    }

    @Override
    public RefineLsRestrType getRefineLsRestrType() {
        return (RefineLsRestrType)this.categories.computeIfAbsent("refine_ls_restr_type", RefineLsRestrType::new).get();
    }

    @Override
    public RefineLsShell getRefineLsShell() {
        return (RefineLsShell)this.categories.computeIfAbsent("refine_ls_shell", RefineLsShell::new).get();
    }

    @Override
    public RefineOccupancy getRefineOccupancy() {
        return (RefineOccupancy)this.categories.computeIfAbsent("refine_occupancy", RefineOccupancy::new).get();
    }

    @Override
    public Refln getRefln() {
        return (Refln)this.categories.computeIfAbsent("refln", Refln::new).get();
    }

    @Override
    public ReflnSysAbs getReflnSysAbs() {
        return (ReflnSysAbs)this.categories.computeIfAbsent("refln_sys_abs", ReflnSysAbs::new).get();
    }

    @Override
    public Reflns getReflns() {
        return (Reflns)this.categories.computeIfAbsent("reflns", Reflns::new).get();
    }

    @Override
    public ReflnsScale getReflnsScale() {
        return (ReflnsScale)this.categories.computeIfAbsent("reflns_scale", ReflnsScale::new).get();
    }

    @Override
    public ReflnsShell getReflnsShell() {
        return (ReflnsShell)this.categories.computeIfAbsent("reflns_shell", ReflnsShell::new).get();
    }

    @Override
    public Software getSoftware() {
        return (Software)this.categories.computeIfAbsent("software", Software::new).get();
    }

    @Override
    public Struct getStruct() {
        return (Struct)this.categories.computeIfAbsent("struct", Struct::new).get();
    }

    @Override
    public StructAsym getStructAsym() {
        return (StructAsym)this.categories.computeIfAbsent("struct_asym", StructAsym::new).get();
    }

    @Override
    public StructBiol getStructBiol() {
        return (StructBiol)this.categories.computeIfAbsent("struct_biol", StructBiol::new).get();
    }

    @Override
    public StructBiolGen getStructBiolGen() {
        return (StructBiolGen)this.categories.computeIfAbsent("struct_biol_gen", StructBiolGen::new).get();
    }

    @Override
    public StructBiolKeywords getStructBiolKeywords() {
        return (StructBiolKeywords)this.categories.computeIfAbsent("struct_biol_keywords", StructBiolKeywords::new).get();
    }

    @Override
    public StructBiolView getStructBiolView() {
        return (StructBiolView)this.categories.computeIfAbsent("struct_biol_view", StructBiolView::new).get();
    }

    @Override
    public StructConf getStructConf() {
        return (StructConf)this.categories.computeIfAbsent("struct_conf", StructConf::new).get();
    }

    @Override
    public StructConfType getStructConfType() {
        return (StructConfType)this.categories.computeIfAbsent("struct_conf_type", StructConfType::new).get();
    }

    @Override
    public StructConn getStructConn() {
        return (StructConn)this.categories.computeIfAbsent("struct_conn", StructConn::new).get();
    }

    @Override
    public StructConnType getStructConnType() {
        return (StructConnType)this.categories.computeIfAbsent("struct_conn_type", StructConnType::new).get();
    }

    @Override
    public StructKeywords getStructKeywords() {
        return (StructKeywords)this.categories.computeIfAbsent("struct_keywords", StructKeywords::new).get();
    }

    @Override
    public StructMonDetails getStructMonDetails() {
        return (StructMonDetails)this.categories.computeIfAbsent("struct_mon_details", StructMonDetails::new).get();
    }

    @Override
    public StructMonNucl getStructMonNucl() {
        return (StructMonNucl)this.categories.computeIfAbsent("struct_mon_nucl", StructMonNucl::new).get();
    }

    @Override
    public StructMonProt getStructMonProt() {
        return (StructMonProt)this.categories.computeIfAbsent("struct_mon_prot", StructMonProt::new).get();
    }

    @Override
    public StructMonProtCis getStructMonProtCis() {
        return (StructMonProtCis)this.categories.computeIfAbsent("struct_mon_prot_cis", StructMonProtCis::new).get();
    }

    @Override
    public StructNcsDom getStructNcsDom() {
        return (StructNcsDom)this.categories.computeIfAbsent("struct_ncs_dom", StructNcsDom::new).get();
    }

    @Override
    public StructNcsDomLim getStructNcsDomLim() {
        return (StructNcsDomLim)this.categories.computeIfAbsent("struct_ncs_dom_lim", StructNcsDomLim::new).get();
    }

    @Override
    public StructNcsEns getStructNcsEns() {
        return (StructNcsEns)this.categories.computeIfAbsent("struct_ncs_ens", StructNcsEns::new).get();
    }

    @Override
    public StructNcsEnsGen getStructNcsEnsGen() {
        return (StructNcsEnsGen)this.categories.computeIfAbsent("struct_ncs_ens_gen", StructNcsEnsGen::new).get();
    }

    @Override
    public StructNcsOper getStructNcsOper() {
        return (StructNcsOper)this.categories.computeIfAbsent("struct_ncs_oper", StructNcsOper::new).get();
    }

    @Override
    public StructRef getStructRef() {
        return (StructRef)this.categories.computeIfAbsent("struct_ref", StructRef::new).get();
    }

    @Override
    public StructRefSeq getStructRefSeq() {
        return (StructRefSeq)this.categories.computeIfAbsent("struct_ref_seq", StructRefSeq::new).get();
    }

    @Override
    public StructRefSeqDif getStructRefSeqDif() {
        return (StructRefSeqDif)this.categories.computeIfAbsent("struct_ref_seq_dif", StructRefSeqDif::new).get();
    }

    @Override
    public StructSheet getStructSheet() {
        return (StructSheet)this.categories.computeIfAbsent("struct_sheet", StructSheet::new).get();
    }

    @Override
    public StructSheetHbond getStructSheetHbond() {
        return (StructSheetHbond)this.categories.computeIfAbsent("struct_sheet_hbond", StructSheetHbond::new).get();
    }

    @Override
    public StructSheetOrder getStructSheetOrder() {
        return (StructSheetOrder)this.categories.computeIfAbsent("struct_sheet_order", StructSheetOrder::new).get();
    }

    @Override
    public StructSheetRange getStructSheetRange() {
        return (StructSheetRange)this.categories.computeIfAbsent("struct_sheet_range", StructSheetRange::new).get();
    }

    @Override
    public StructSheetTopology getStructSheetTopology() {
        return (StructSheetTopology)this.categories.computeIfAbsent("struct_sheet_topology", StructSheetTopology::new).get();
    }

    @Override
    public StructSite getStructSite() {
        return (StructSite)this.categories.computeIfAbsent("struct_site", StructSite::new).get();
    }

    @Override
    public StructSiteGen getStructSiteGen() {
        return (StructSiteGen)this.categories.computeIfAbsent("struct_site_gen", StructSiteGen::new).get();
    }

    @Override
    public StructSiteKeywords getStructSiteKeywords() {
        return (StructSiteKeywords)this.categories.computeIfAbsent("struct_site_keywords", StructSiteKeywords::new).get();
    }

    @Override
    public StructSiteView getStructSiteView() {
        return (StructSiteView)this.categories.computeIfAbsent("struct_site_view", StructSiteView::new).get();
    }

    @Override
    public Symmetry getSymmetry() {
        return (Symmetry)this.categories.computeIfAbsent("symmetry", Symmetry::new).get();
    }

    @Override
    public SymmetryEquiv getSymmetryEquiv() {
        return (SymmetryEquiv)this.categories.computeIfAbsent("symmetry_equiv", SymmetryEquiv::new).get();
    }

    @Override
    public AuditLink getAuditLink() {
        return (AuditLink)this.categories.computeIfAbsent("audit_link", AuditLink::new).get();
    }

    @Override
    public DiffrnReflnsClass getDiffrnReflnsClass() {
        return (DiffrnReflnsClass)this.categories.computeIfAbsent("diffrn_reflns_class", DiffrnReflnsClass::new).get();
    }

    @Override
    public RefineLsClass getRefineLsClass() {
        return (RefineLsClass)this.categories.computeIfAbsent("refine_ls_class", RefineLsClass::new).get();
    }

    @Override
    public ReflnsClass getReflnsClass() {
        return (ReflnsClass)this.categories.computeIfAbsent("reflns_class", ReflnsClass::new).get();
    }

    @Override
    public SpaceGroup getSpaceGroup() {
        return (SpaceGroup)this.categories.computeIfAbsent("space_group", SpaceGroup::new).get();
    }

    @Override
    public SpaceGroupSymop getSpaceGroupSymop() {
        return (SpaceGroupSymop)this.categories.computeIfAbsent("space_group_symop", SpaceGroupSymop::new).get();
    }

    @Override
    public ValenceParam getValenceParam() {
        return (ValenceParam)this.categories.computeIfAbsent("valence_param", ValenceParam::new).get();
    }

    @Override
    public ValenceRef getValenceRef() {
        return (ValenceRef)this.categories.computeIfAbsent("valence_ref", ValenceRef::new).get();
    }

    @Override
    public PdbxAudit getPdbxAudit() {
        return (PdbxAudit)this.categories.computeIfAbsent("pdbx_audit", PdbxAudit::new).get();
    }

    @Override
    public PdbxVersion getPdbxVersion() {
        return (PdbxVersion)this.categories.computeIfAbsent("pdbx_version", PdbxVersion::new).get();
    }

    @Override
    public PdbxAuditAuthor getPdbxAuditAuthor() {
        return (PdbxAuditAuthor)this.categories.computeIfAbsent("pdbx_audit_author", PdbxAuditAuthor::new).get();
    }

    @Override
    public PdbxDatabaseMessage getPdbxDatabaseMessage() {
        return (PdbxDatabaseMessage)this.categories.computeIfAbsent("pdbx_database_message", PdbxDatabaseMessage::new).get();
    }

    @Override
    public PdbxDatabasePDBObsSpr getPdbxDatabasePDBObsSpr() {
        return (PdbxDatabasePDBObsSpr)this.categories.computeIfAbsent("pdbx_database_PDB_obs_spr", PdbxDatabasePDBObsSpr::new).get();
    }

    @Override
    public PdbxDatabaseProc getPdbxDatabaseProc() {
        return (PdbxDatabaseProc)this.categories.computeIfAbsent("pdbx_database_proc", PdbxDatabaseProc::new).get();
    }

    @Override
    public PdbxDatabaseRemark getPdbxDatabaseRemark() {
        return (PdbxDatabaseRemark)this.categories.computeIfAbsent("pdbx_database_remark", PdbxDatabaseRemark::new).get();
    }

    @Override
    public PdbxDatabaseStatus getPdbxDatabaseStatus() {
        return (PdbxDatabaseStatus)this.categories.computeIfAbsent("pdbx_database_status", PdbxDatabaseStatus::new).get();
    }

    @Override
    public PdbxEntityName getPdbxEntityName() {
        return (PdbxEntityName)this.categories.computeIfAbsent("pdbx_entity_name", PdbxEntityName::new).get();
    }

    @Override
    public PdbxPrereleaseSeq getPdbxPrereleaseSeq() {
        return (PdbxPrereleaseSeq)this.categories.computeIfAbsent("pdbx_prerelease_seq", PdbxPrereleaseSeq::new).get();
    }

    @Override
    public PdbxPolySeqScheme getPdbxPolySeqScheme() {
        return (PdbxPolySeqScheme)this.categories.computeIfAbsent("pdbx_poly_seq_scheme", PdbxPolySeqScheme::new).get();
    }

    @Override
    public PdbxNonpolyScheme getPdbxNonpolyScheme() {
        return (PdbxNonpolyScheme)this.categories.computeIfAbsent("pdbx_nonpoly_scheme", PdbxNonpolyScheme::new).get();
    }

    @Override
    public PdbxRefine getPdbxRefine() {
        return (PdbxRefine)this.categories.computeIfAbsent("pdbx_refine", PdbxRefine::new).get();
    }

    @Override
    public PdbxStructSheetHbond getPdbxStructSheetHbond() {
        return (PdbxStructSheetHbond)this.categories.computeIfAbsent("pdbx_struct_sheet_hbond", PdbxStructSheetHbond::new).get();
    }

    @Override
    public PdbxXplorFile getPdbxXplorFile() {
        return (PdbxXplorFile)this.categories.computeIfAbsent("pdbx_xplor_file", PdbxXplorFile::new).get();
    }

    @Override
    public PdbxRefineAuxFile getPdbxRefineAuxFile() {
        return (PdbxRefineAuxFile)this.categories.computeIfAbsent("pdbx_refine_aux_file", PdbxRefineAuxFile::new).get();
    }

    @Override
    public PdbxDatabaseRelated getPdbxDatabaseRelated() {
        return (PdbxDatabaseRelated)this.categories.computeIfAbsent("pdbx_database_related", PdbxDatabaseRelated::new).get();
    }

    @Override
    public PdbxEntityAssembly getPdbxEntityAssembly() {
        return (PdbxEntityAssembly)this.categories.computeIfAbsent("pdbx_entity_assembly", PdbxEntityAssembly::new).get();
    }

    @Override
    public PdbxExptlCrystalGrowComp getPdbxExptlCrystalGrowComp() {
        return (PdbxExptlCrystalGrowComp)this.categories.computeIfAbsent("pdbx_exptl_crystal_grow_comp", PdbxExptlCrystalGrowComp::new).get();
    }

    @Override
    public PdbxExptlCrystalGrowSol getPdbxExptlCrystalGrowSol() {
        return (PdbxExptlCrystalGrowSol)this.categories.computeIfAbsent("pdbx_exptl_crystal_grow_sol", PdbxExptlCrystalGrowSol::new).get();
    }

    @Override
    public PdbxExptlCrystalCryoTreatment getPdbxExptlCrystalCryoTreatment() {
        return (PdbxExptlCrystalCryoTreatment)this.categories.computeIfAbsent("pdbx_exptl_crystal_cryo_treatment", PdbxExptlCrystalCryoTreatment::new).get();
    }

    @Override
    public PdbxRefineTls getPdbxRefineTls() {
        return (PdbxRefineTls)this.categories.computeIfAbsent("pdbx_refine_tls", PdbxRefineTls::new).get();
    }

    @Override
    public PdbxRefineTlsGroup getPdbxRefineTlsGroup() {
        return (PdbxRefineTlsGroup)this.categories.computeIfAbsent("pdbx_refine_tls_group", PdbxRefineTlsGroup::new).get();
    }

    @Override
    public PdbxContactAuthor getPdbxContactAuthor() {
        return (PdbxContactAuthor)this.categories.computeIfAbsent("pdbx_contact_author", PdbxContactAuthor::new).get();
    }

    @Override
    public PdbxSGProject getPdbxSGProject() {
        return (PdbxSGProject)this.categories.computeIfAbsent("pdbx_SG_project", PdbxSGProject::new).get();
    }

    @Override
    public PdbxAtomSiteAnisoTls getPdbxAtomSiteAnisoTls() {
        return (PdbxAtomSiteAnisoTls)this.categories.computeIfAbsent("pdbx_atom_site_aniso_tls", PdbxAtomSiteAnisoTls::new).get();
    }

    @Override
    public PdbxNmrDetails getPdbxNmrDetails() {
        return (PdbxNmrDetails)this.categories.computeIfAbsent("pdbx_nmr_details", PdbxNmrDetails::new).get();
    }

    @Override
    public PdbxNmrSampleDetails getPdbxNmrSampleDetails() {
        return (PdbxNmrSampleDetails)this.categories.computeIfAbsent("pdbx_nmr_sample_details", PdbxNmrSampleDetails::new).get();
    }

    @Override
    public PdbxNmrExptlSample getPdbxNmrExptlSample() {
        return (PdbxNmrExptlSample)this.categories.computeIfAbsent("pdbx_nmr_exptl_sample", PdbxNmrExptlSample::new).get();
    }

    @Override
    public PdbxNmrExptlSampleConditions getPdbxNmrExptlSampleConditions() {
        return (PdbxNmrExptlSampleConditions)this.categories.computeIfAbsent("pdbx_nmr_exptl_sample_conditions", PdbxNmrExptlSampleConditions::new).get();
    }

    @Override
    public PdbxNmrSpectrometer getPdbxNmrSpectrometer() {
        return (PdbxNmrSpectrometer)this.categories.computeIfAbsent("pdbx_nmr_spectrometer", PdbxNmrSpectrometer::new).get();
    }

    @Override
    public PdbxNmrExptl getPdbxNmrExptl() {
        return (PdbxNmrExptl)this.categories.computeIfAbsent("pdbx_nmr_exptl", PdbxNmrExptl::new).get();
    }

    @Override
    public PdbxNmrSoftware getPdbxNmrSoftware() {
        return (PdbxNmrSoftware)this.categories.computeIfAbsent("pdbx_nmr_software", PdbxNmrSoftware::new).get();
    }

    @Override
    public PdbxNmrConstraints getPdbxNmrConstraints() {
        return (PdbxNmrConstraints)this.categories.computeIfAbsent("pdbx_nmr_constraints", PdbxNmrConstraints::new).get();
    }

    @Override
    public PdbxNmrEnsemble getPdbxNmrEnsemble() {
        return (PdbxNmrEnsemble)this.categories.computeIfAbsent("pdbx_nmr_ensemble", PdbxNmrEnsemble::new).get();
    }

    @Override
    public PdbxNmrEnsembleRms getPdbxNmrEnsembleRms() {
        return (PdbxNmrEnsembleRms)this.categories.computeIfAbsent("pdbx_nmr_ensemble_rms", PdbxNmrEnsembleRms::new).get();
    }

    @Override
    public PdbxNmrRepresentative getPdbxNmrRepresentative() {
        return (PdbxNmrRepresentative)this.categories.computeIfAbsent("pdbx_nmr_representative", PdbxNmrRepresentative::new).get();
    }

    @Override
    public PdbxNmrRefine getPdbxNmrRefine() {
        return (PdbxNmrRefine)this.categories.computeIfAbsent("pdbx_nmr_refine", PdbxNmrRefine::new).get();
    }

    @Override
    public PdbxNmrForceConstants getPdbxNmrForceConstants() {
        return (PdbxNmrForceConstants)this.categories.computeIfAbsent("pdbx_nmr_force_constants", PdbxNmrForceConstants::new).get();
    }

    @Override
    public NdbStructConfNa getNdbStructConfNa() {
        return (NdbStructConfNa)this.categories.computeIfAbsent("ndb_struct_conf_na", NdbStructConfNa::new).get();
    }

    @Override
    public NdbStructFeatureNa getNdbStructFeatureNa() {
        return (NdbStructFeatureNa)this.categories.computeIfAbsent("ndb_struct_feature_na", NdbStructFeatureNa::new).get();
    }

    @Override
    public NdbStructNaBasePair getNdbStructNaBasePair() {
        return (NdbStructNaBasePair)this.categories.computeIfAbsent("ndb_struct_na_base_pair", NdbStructNaBasePair::new).get();
    }

    @Override
    public NdbStructNaBasePairStep getNdbStructNaBasePairStep() {
        return (NdbStructNaBasePairStep)this.categories.computeIfAbsent("ndb_struct_na_base_pair_step", NdbStructNaBasePairStep::new).get();
    }

    @Override
    public NdbOriginalNdbCoordinates getNdbOriginalNdbCoordinates() {
        return (NdbOriginalNdbCoordinates)this.categories.computeIfAbsent("ndb_original_ndb_coordinates", NdbOriginalNdbCoordinates::new).get();
    }

    @Override
    public PdbxEntityNonpoly getPdbxEntityNonpoly() {
        return (PdbxEntityNonpoly)this.categories.computeIfAbsent("pdbx_entity_nonpoly", PdbxEntityNonpoly::new).get();
    }

    @Override
    public PdbxPhasingDm getPdbxPhasingDm() {
        return (PdbxPhasingDm)this.categories.computeIfAbsent("pdbx_phasing_dm", PdbxPhasingDm::new).get();
    }

    @Override
    public PdbxPhasingDmShell getPdbxPhasingDmShell() {
        return (PdbxPhasingDmShell)this.categories.computeIfAbsent("pdbx_phasing_dm_shell", PdbxPhasingDmShell::new).get();
    }

    @Override
    public PdbxPhasingMADShell getPdbxPhasingMADShell() {
        return (PdbxPhasingMADShell)this.categories.computeIfAbsent("pdbx_phasing_MAD_shell", PdbxPhasingMADShell::new).get();
    }

    @Override
    public PdbxPhasingMADSet getPdbxPhasingMADSet() {
        return (PdbxPhasingMADSet)this.categories.computeIfAbsent("pdbx_phasing_MAD_set", PdbxPhasingMADSet::new).get();
    }

    @Override
    public PdbxPhasingMADSetShell getPdbxPhasingMADSetShell() {
        return (PdbxPhasingMADSetShell)this.categories.computeIfAbsent("pdbx_phasing_MAD_set_shell", PdbxPhasingMADSetShell::new).get();
    }

    @Override
    public PdbxPhasingMADSetSite getPdbxPhasingMADSetSite() {
        return (PdbxPhasingMADSetSite)this.categories.computeIfAbsent("pdbx_phasing_MAD_set_site", PdbxPhasingMADSetSite::new).get();
    }

    @Override
    public PdbxPhasingMR getPdbxPhasingMR() {
        return (PdbxPhasingMR)this.categories.computeIfAbsent("pdbx_phasing_MR", PdbxPhasingMR::new).get();
    }

    @Override
    public PdbxRefineComponent getPdbxRefineComponent() {
        return (PdbxRefineComponent)this.categories.computeIfAbsent("pdbx_refine_component", PdbxRefineComponent::new).get();
    }

    @Override
    public PdbxEntityProdProtocol getPdbxEntityProdProtocol() {
        return (PdbxEntityProdProtocol)this.categories.computeIfAbsent("pdbx_entity_prod_protocol", PdbxEntityProdProtocol::new).get();
    }

    @Override
    public PdbxEntitySrcGenProdOther getPdbxEntitySrcGenProdOther() {
        return (PdbxEntitySrcGenProdOther)this.categories.computeIfAbsent("pdbx_entity_src_gen_prod_other", PdbxEntitySrcGenProdOther::new).get();
    }

    @Override
    public PdbxEntitySrcGenProdOtherParameter getPdbxEntitySrcGenProdOtherParameter() {
        return (PdbxEntitySrcGenProdOtherParameter)this.categories.computeIfAbsent("pdbx_entity_src_gen_prod_other_parameter", PdbxEntitySrcGenProdOtherParameter::new).get();
    }

    @Override
    public PdbxEntitySrcGenProdPcr getPdbxEntitySrcGenProdPcr() {
        return (PdbxEntitySrcGenProdPcr)this.categories.computeIfAbsent("pdbx_entity_src_gen_prod_pcr", PdbxEntitySrcGenProdPcr::new).get();
    }

    @Override
    public PdbxEntitySrcGenProdDigest getPdbxEntitySrcGenProdDigest() {
        return (PdbxEntitySrcGenProdDigest)this.categories.computeIfAbsent("pdbx_entity_src_gen_prod_digest", PdbxEntitySrcGenProdDigest::new).get();
    }

    @Override
    public PdbxEntitySrcGenClone getPdbxEntitySrcGenClone() {
        return (PdbxEntitySrcGenClone)this.categories.computeIfAbsent("pdbx_entity_src_gen_clone", PdbxEntitySrcGenClone::new).get();
    }

    @Override
    public PdbxEntitySrcGenCloneLigation getPdbxEntitySrcGenCloneLigation() {
        return (PdbxEntitySrcGenCloneLigation)this.categories.computeIfAbsent("pdbx_entity_src_gen_clone_ligation", PdbxEntitySrcGenCloneLigation::new).get();
    }

    @Override
    public PdbxEntitySrcGenCloneRecombination getPdbxEntitySrcGenCloneRecombination() {
        return (PdbxEntitySrcGenCloneRecombination)this.categories.computeIfAbsent("pdbx_entity_src_gen_clone_recombination", PdbxEntitySrcGenCloneRecombination::new).get();
    }

    @Override
    public PdbxEntitySrcGenExpress getPdbxEntitySrcGenExpress() {
        return (PdbxEntitySrcGenExpress)this.categories.computeIfAbsent("pdbx_entity_src_gen_express", PdbxEntitySrcGenExpress::new).get();
    }

    @Override
    public PdbxEntitySrcGenExpressTimepoint getPdbxEntitySrcGenExpressTimepoint() {
        return (PdbxEntitySrcGenExpressTimepoint)this.categories.computeIfAbsent("pdbx_entity_src_gen_express_timepoint", PdbxEntitySrcGenExpressTimepoint::new).get();
    }

    @Override
    public PdbxEntitySrcGenLysis getPdbxEntitySrcGenLysis() {
        return (PdbxEntitySrcGenLysis)this.categories.computeIfAbsent("pdbx_entity_src_gen_lysis", PdbxEntitySrcGenLysis::new).get();
    }

    @Override
    public PdbxEntitySrcGenRefold getPdbxEntitySrcGenRefold() {
        return (PdbxEntitySrcGenRefold)this.categories.computeIfAbsent("pdbx_entity_src_gen_refold", PdbxEntitySrcGenRefold::new).get();
    }

    @Override
    public PdbxEntitySrcGenProteolysis getPdbxEntitySrcGenProteolysis() {
        return (PdbxEntitySrcGenProteolysis)this.categories.computeIfAbsent("pdbx_entity_src_gen_proteolysis", PdbxEntitySrcGenProteolysis::new).get();
    }

    @Override
    public PdbxEntitySrcGenChrom getPdbxEntitySrcGenChrom() {
        return (PdbxEntitySrcGenChrom)this.categories.computeIfAbsent("pdbx_entity_src_gen_chrom", PdbxEntitySrcGenChrom::new).get();
    }

    @Override
    public PdbxEntitySrcGenFract getPdbxEntitySrcGenFract() {
        return (PdbxEntitySrcGenFract)this.categories.computeIfAbsent("pdbx_entity_src_gen_fract", PdbxEntitySrcGenFract::new).get();
    }

    @Override
    public PdbxEntitySrcGenPure getPdbxEntitySrcGenPure() {
        return (PdbxEntitySrcGenPure)this.categories.computeIfAbsent("pdbx_entity_src_gen_pure", PdbxEntitySrcGenPure::new).get();
    }

    @Override
    public PdbxEntitySrcGenCharacter getPdbxEntitySrcGenCharacter() {
        return (PdbxEntitySrcGenCharacter)this.categories.computeIfAbsent("pdbx_entity_src_gen_character", PdbxEntitySrcGenCharacter::new).get();
    }

    @Override
    public PdbxConstruct getPdbxConstruct() {
        return (PdbxConstruct)this.categories.computeIfAbsent("pdbx_construct", PdbxConstruct::new).get();
    }

    @Override
    public PdbxConstructFeature getPdbxConstructFeature() {
        return (PdbxConstructFeature)this.categories.computeIfAbsent("pdbx_construct_feature", PdbxConstructFeature::new).get();
    }

    @Override
    public PdbxRobotSystem getPdbxRobotSystem() {
        return (PdbxRobotSystem)this.categories.computeIfAbsent("pdbx_robot_system", PdbxRobotSystem::new).get();
    }

    @Override
    public PdbxBuffer getPdbxBuffer() {
        return (PdbxBuffer)this.categories.computeIfAbsent("pdbx_buffer", PdbxBuffer::new).get();
    }

    @Override
    public PdbxBufferComponents getPdbxBufferComponents() {
        return (PdbxBufferComponents)this.categories.computeIfAbsent("pdbx_buffer_components", PdbxBufferComponents::new).get();
    }

    @Override
    public PdbxDomain getPdbxDomain() {
        return (PdbxDomain)this.categories.computeIfAbsent("pdbx_domain", PdbxDomain::new).get();
    }

    @Override
    public PdbxDomainRange getPdbxDomainRange() {
        return (PdbxDomainRange)this.categories.computeIfAbsent("pdbx_domain_range", PdbxDomainRange::new).get();
    }

    @Override
    public PdbxSequenceRange getPdbxSequenceRange() {
        return (PdbxSequenceRange)this.categories.computeIfAbsent("pdbx_sequence_range", PdbxSequenceRange::new).get();
    }

    @Override
    public PdbxFeatureEntry getPdbxFeatureEntry() {
        return (PdbxFeatureEntry)this.categories.computeIfAbsent("pdbx_feature_entry", PdbxFeatureEntry::new).get();
    }

    @Override
    public PdbxFeatureDomain getPdbxFeatureDomain() {
        return (PdbxFeatureDomain)this.categories.computeIfAbsent("pdbx_feature_domain", PdbxFeatureDomain::new).get();
    }

    @Override
    public PdbxFeatureSequenceRange getPdbxFeatureSequenceRange() {
        return (PdbxFeatureSequenceRange)this.categories.computeIfAbsent("pdbx_feature_sequence_range", PdbxFeatureSequenceRange::new).get();
    }

    @Override
    public PdbxFeatureAssembly getPdbxFeatureAssembly() {
        return (PdbxFeatureAssembly)this.categories.computeIfAbsent("pdbx_feature_assembly", PdbxFeatureAssembly::new).get();
    }

    @Override
    public PdbxFeatureMonomer getPdbxFeatureMonomer() {
        return (PdbxFeatureMonomer)this.categories.computeIfAbsent("pdbx_feature_monomer", PdbxFeatureMonomer::new).get();
    }

    @Override
    public PdbxExptlPd getPdbxExptlPd() {
        return (PdbxExptlPd)this.categories.computeIfAbsent("pdbx_exptl_pd", PdbxExptlPd::new).get();
    }

    @Override
    public PdbxReflnsTwin getPdbxReflnsTwin() {
        return (PdbxReflnsTwin)this.categories.computeIfAbsent("pdbx_reflns_twin", PdbxReflnsTwin::new).get();
    }

    @Override
    public PdbxStructInfo getPdbxStructInfo() {
        return (PdbxStructInfo)this.categories.computeIfAbsent("pdbx_struct_info", PdbxStructInfo::new).get();
    }

    @Override
    public PdbxReRefinement getPdbxReRefinement() {
        return (PdbxReRefinement)this.categories.computeIfAbsent("pdbx_re_refinement", PdbxReRefinement::new).get();
    }

    @Override
    public PdbxStructAssemblyProp getPdbxStructAssemblyProp() {
        return (PdbxStructAssemblyProp)this.categories.computeIfAbsent("pdbx_struct_assembly_prop", PdbxStructAssemblyProp::new).get();
    }

    @Override
    public PdbxStructRefSeqFeature getPdbxStructRefSeqFeature() {
        return (PdbxStructRefSeqFeature)this.categories.computeIfAbsent("pdbx_struct_ref_seq_feature", PdbxStructRefSeqFeature::new).get();
    }

    @Override
    public PdbxStructRefSeqFeatureProp getPdbxStructRefSeqFeatureProp() {
        return (PdbxStructRefSeqFeatureProp)this.categories.computeIfAbsent("pdbx_struct_ref_seq_feature_prop", PdbxStructRefSeqFeatureProp::new).get();
    }

    @Override
    public PdbxStructChemCompDiagnostics getPdbxStructChemCompDiagnostics() {
        return (PdbxStructChemCompDiagnostics)this.categories.computeIfAbsent("pdbx_struct_chem_comp_diagnostics", PdbxStructChemCompDiagnostics::new).get();
    }

    @Override
    public PdbxChemCompFeature getPdbxChemCompFeature() {
        return (PdbxChemCompFeature)this.categories.computeIfAbsent("pdbx_chem_comp_feature", PdbxChemCompFeature::new).get();
    }

    @Override
    public PdbxCoordinateModel getPdbxCoordinateModel() {
        return (PdbxCoordinateModel)this.categories.computeIfAbsent("pdbx_coordinate_model", PdbxCoordinateModel::new).get();
    }

    @Override
    public PdbxStructChemCompFeature getPdbxStructChemCompFeature() {
        return (PdbxStructChemCompFeature)this.categories.computeIfAbsent("pdbx_struct_chem_comp_feature", PdbxStructChemCompFeature::new).get();
    }

    @Override
    public PdbxDiffrnReflnsShell getPdbxDiffrnReflnsShell() {
        return (PdbxDiffrnReflnsShell)this.categories.computeIfAbsent("pdbx_diffrn_reflns_shell", PdbxDiffrnReflnsShell::new).get();
    }

    @Override
    public PdbxBondDistanceLimits getPdbxBondDistanceLimits() {
        return (PdbxBondDistanceLimits)this.categories.computeIfAbsent("pdbx_bond_distance_limits", PdbxBondDistanceLimits::new).get();
    }

    @Override
    public PdbxSolnScatter getPdbxSolnScatter() {
        return (PdbxSolnScatter)this.categories.computeIfAbsent("pdbx_soln_scatter", PdbxSolnScatter::new).get();
    }

    @Override
    public PdbxSolnScatterModel getPdbxSolnScatterModel() {
        return (PdbxSolnScatterModel)this.categories.computeIfAbsent("pdbx_soln_scatter_model", PdbxSolnScatterModel::new).get();
    }

    @Override
    public PdbxChemCompDescriptor getPdbxChemCompDescriptor() {
        return (PdbxChemCompDescriptor)this.categories.computeIfAbsent("pdbx_chem_comp_descriptor", PdbxChemCompDescriptor::new).get();
    }

    @Override
    public PdbxChemCompIdentifier getPdbxChemCompIdentifier() {
        return (PdbxChemCompIdentifier)this.categories.computeIfAbsent("pdbx_chem_comp_identifier", PdbxChemCompIdentifier::new).get();
    }

    @Override
    public PdbxChemCompImport getPdbxChemCompImport() {
        return (PdbxChemCompImport)this.categories.computeIfAbsent("pdbx_chem_comp_import", PdbxChemCompImport::new).get();
    }

    @Override
    public PdbxChemCompAtomEdit getPdbxChemCompAtomEdit() {
        return (PdbxChemCompAtomEdit)this.categories.computeIfAbsent("pdbx_chem_comp_atom_edit", PdbxChemCompAtomEdit::new).get();
    }

    @Override
    public PdbxChemCompBondEdit getPdbxChemCompBondEdit() {
        return (PdbxChemCompBondEdit)this.categories.computeIfAbsent("pdbx_chem_comp_bond_edit", PdbxChemCompBondEdit::new).get();
    }

    @Override
    public PdbxChemCompAudit getPdbxChemCompAudit() {
        return (PdbxChemCompAudit)this.categories.computeIfAbsent("pdbx_chem_comp_audit", PdbxChemCompAudit::new).get();
    }

    @Override
    public PdbxValidateCloseContact getPdbxValidateCloseContact() {
        return (PdbxValidateCloseContact)this.categories.computeIfAbsent("pdbx_validate_close_contact", PdbxValidateCloseContact::new).get();
    }

    @Override
    public PdbxValidateSymmContact getPdbxValidateSymmContact() {
        return (PdbxValidateSymmContact)this.categories.computeIfAbsent("pdbx_validate_symm_contact", PdbxValidateSymmContact::new).get();
    }

    @Override
    public PdbxValidateRmsdBond getPdbxValidateRmsdBond() {
        return (PdbxValidateRmsdBond)this.categories.computeIfAbsent("pdbx_validate_rmsd_bond", PdbxValidateRmsdBond::new).get();
    }

    @Override
    public PdbxValidateRmsdAngle getPdbxValidateRmsdAngle() {
        return (PdbxValidateRmsdAngle)this.categories.computeIfAbsent("pdbx_validate_rmsd_angle", PdbxValidateRmsdAngle::new).get();
    }

    @Override
    public PdbxValidateTorsion getPdbxValidateTorsion() {
        return (PdbxValidateTorsion)this.categories.computeIfAbsent("pdbx_validate_torsion", PdbxValidateTorsion::new).get();
    }

    @Override
    public PdbxValidatePeptideOmega getPdbxValidatePeptideOmega() {
        return (PdbxValidatePeptideOmega)this.categories.computeIfAbsent("pdbx_validate_peptide_omega", PdbxValidatePeptideOmega::new).get();
    }

    @Override
    public PdbxValidateChiral getPdbxValidateChiral() {
        return (PdbxValidateChiral)this.categories.computeIfAbsent("pdbx_validate_chiral", PdbxValidateChiral::new).get();
    }

    @Override
    public PdbxValidatePlanes getPdbxValidatePlanes() {
        return (PdbxValidatePlanes)this.categories.computeIfAbsent("pdbx_validate_planes", PdbxValidatePlanes::new).get();
    }

    @Override
    public PdbxValidatePlanesAtom getPdbxValidatePlanesAtom() {
        return (PdbxValidatePlanesAtom)this.categories.computeIfAbsent("pdbx_validate_planes_atom", PdbxValidatePlanesAtom::new).get();
    }

    @Override
    public PdbxValidateMainChainPlane getPdbxValidateMainChainPlane() {
        return (PdbxValidateMainChainPlane)this.categories.computeIfAbsent("pdbx_validate_main_chain_plane", PdbxValidateMainChainPlane::new).get();
    }

    @Override
    public PdbxStructConnAngle getPdbxStructConnAngle() {
        return (PdbxStructConnAngle)this.categories.computeIfAbsent("pdbx_struct_conn_angle", PdbxStructConnAngle::new).get();
    }

    @Override
    public PdbxUnobsOrZeroOccResidues getPdbxUnobsOrZeroOccResidues() {
        return (PdbxUnobsOrZeroOccResidues)this.categories.computeIfAbsent("pdbx_unobs_or_zero_occ_residues", PdbxUnobsOrZeroOccResidues::new).get();
    }

    @Override
    public PdbxUnobsOrZeroOccAtoms getPdbxUnobsOrZeroOccAtoms() {
        return (PdbxUnobsOrZeroOccAtoms)this.categories.computeIfAbsent("pdbx_unobs_or_zero_occ_atoms", PdbxUnobsOrZeroOccAtoms::new).get();
    }

    @Override
    public PdbxEntryDetails getPdbxEntryDetails() {
        return (PdbxEntryDetails)this.categories.computeIfAbsent("pdbx_entry_details", PdbxEntryDetails::new).get();
    }

    @Override
    public PdbxStructModResidue getPdbxStructModResidue() {
        return (PdbxStructModResidue)this.categories.computeIfAbsent("pdbx_struct_mod_residue", PdbxStructModResidue::new).get();
    }

    @Override
    public PdbxStructRefSeqInsertion getPdbxStructRefSeqInsertion() {
        return (PdbxStructRefSeqInsertion)this.categories.computeIfAbsent("pdbx_struct_ref_seq_insertion", PdbxStructRefSeqInsertion::new).get();
    }

    @Override
    public PdbxStructRefSeqDeletion getPdbxStructRefSeqDeletion() {
        return (PdbxStructRefSeqDeletion)this.categories.computeIfAbsent("pdbx_struct_ref_seq_deletion", PdbxStructRefSeqDeletion::new).get();
    }

    @Override
    public PdbxRemediationAtomSiteMapping getPdbxRemediationAtomSiteMapping() {
        return (PdbxRemediationAtomSiteMapping)this.categories.computeIfAbsent("pdbx_remediation_atom_site_mapping", PdbxRemediationAtomSiteMapping::new).get();
    }

    @Override
    public PdbxValidatePolymerLinkage getPdbxValidatePolymerLinkage() {
        return (PdbxValidatePolymerLinkage)this.categories.computeIfAbsent("pdbx_validate_polymer_linkage", PdbxValidatePolymerLinkage::new).get();
    }

    @Override
    public PdbxHelicalSymmetry getPdbxHelicalSymmetry() {
        return (PdbxHelicalSymmetry)this.categories.computeIfAbsent("pdbx_helical_symmetry", PdbxHelicalSymmetry::new).get();
    }

    @Override
    public PdbxPointSymmetry getPdbxPointSymmetry() {
        return (PdbxPointSymmetry)this.categories.computeIfAbsent("pdbx_point_symmetry", PdbxPointSymmetry::new).get();
    }

    @Override
    public PdbxStructEntityInst getPdbxStructEntityInst() {
        return (PdbxStructEntityInst)this.categories.computeIfAbsent("pdbx_struct_entity_inst", PdbxStructEntityInst::new).get();
    }

    @Override
    public PdbxStructOperList getPdbxStructOperList() {
        return (PdbxStructOperList)this.categories.computeIfAbsent("pdbx_struct_oper_list", PdbxStructOperList::new).get();
    }

    @Override
    public PdbxStructAssembly getPdbxStructAssembly() {
        return (PdbxStructAssembly)this.categories.computeIfAbsent("pdbx_struct_assembly", PdbxStructAssembly::new).get();
    }

    @Override
    public PdbxStructAssemblyGen getPdbxStructAssemblyGen() {
        return (PdbxStructAssemblyGen)this.categories.computeIfAbsent("pdbx_struct_assembly_gen", PdbxStructAssemblyGen::new).get();
    }

    @Override
    public PdbxStructAsymGen getPdbxStructAsymGen() {
        return (PdbxStructAsymGen)this.categories.computeIfAbsent("pdbx_struct_asym_gen", PdbxStructAsymGen::new).get();
    }

    @Override
    public PdbxStructMsymGen getPdbxStructMsymGen() {
        return (PdbxStructMsymGen)this.categories.computeIfAbsent("pdbx_struct_msym_gen", PdbxStructMsymGen::new).get();
    }

    @Override
    public PdbxStructLegacyOperList getPdbxStructLegacyOperList() {
        return (PdbxStructLegacyOperList)this.categories.computeIfAbsent("pdbx_struct_legacy_oper_list", PdbxStructLegacyOperList::new).get();
    }

    @Override
    public PdbxChemCompAtomFeature getPdbxChemCompAtomFeature() {
        return (PdbxChemCompAtomFeature)this.categories.computeIfAbsent("pdbx_chem_comp_atom_feature", PdbxChemCompAtomFeature::new).get();
    }

    @Override
    public PdbxReferenceMoleculeFamily getPdbxReferenceMoleculeFamily() {
        return (PdbxReferenceMoleculeFamily)this.categories.computeIfAbsent("pdbx_reference_molecule_family", PdbxReferenceMoleculeFamily::new).get();
    }

    @Override
    public PdbxReferenceMoleculeList getPdbxReferenceMoleculeList() {
        return (PdbxReferenceMoleculeList)this.categories.computeIfAbsent("pdbx_reference_molecule_list", PdbxReferenceMoleculeList::new).get();
    }

    @Override
    public PdbxReferenceMolecule getPdbxReferenceMolecule() {
        return (PdbxReferenceMolecule)this.categories.computeIfAbsent("pdbx_reference_molecule", PdbxReferenceMolecule::new).get();
    }

    @Override
    public PdbxReferenceEntityList getPdbxReferenceEntityList() {
        return (PdbxReferenceEntityList)this.categories.computeIfAbsent("pdbx_reference_entity_list", PdbxReferenceEntityList::new).get();
    }

    @Override
    public PdbxReferenceEntityNonpoly getPdbxReferenceEntityNonpoly() {
        return (PdbxReferenceEntityNonpoly)this.categories.computeIfAbsent("pdbx_reference_entity_nonpoly", PdbxReferenceEntityNonpoly::new).get();
    }

    @Override
    public PdbxReferenceEntityLink getPdbxReferenceEntityLink() {
        return (PdbxReferenceEntityLink)this.categories.computeIfAbsent("pdbx_reference_entity_link", PdbxReferenceEntityLink::new).get();
    }

    @Override
    public PdbxReferenceEntityPolyLink getPdbxReferenceEntityPolyLink() {
        return (PdbxReferenceEntityPolyLink)this.categories.computeIfAbsent("pdbx_reference_entity_poly_link", PdbxReferenceEntityPolyLink::new).get();
    }

    @Override
    public PdbxReferenceEntityPoly getPdbxReferenceEntityPoly() {
        return (PdbxReferenceEntityPoly)this.categories.computeIfAbsent("pdbx_reference_entity_poly", PdbxReferenceEntityPoly::new).get();
    }

    @Override
    public PdbxReferenceEntityPolySeq getPdbxReferenceEntityPolySeq() {
        return (PdbxReferenceEntityPolySeq)this.categories.computeIfAbsent("pdbx_reference_entity_poly_seq", PdbxReferenceEntityPolySeq::new).get();
    }

    @Override
    public PdbxReferenceEntitySequence getPdbxReferenceEntitySequence() {
        return (PdbxReferenceEntitySequence)this.categories.computeIfAbsent("pdbx_reference_entity_sequence", PdbxReferenceEntitySequence::new).get();
    }

    @Override
    public PdbxReferenceEntitySrcNat getPdbxReferenceEntitySrcNat() {
        return (PdbxReferenceEntitySrcNat)this.categories.computeIfAbsent("pdbx_reference_entity_src_nat", PdbxReferenceEntitySrcNat::new).get();
    }

    @Override
    public PdbxReferenceMoleculeDetails getPdbxReferenceMoleculeDetails() {
        return (PdbxReferenceMoleculeDetails)this.categories.computeIfAbsent("pdbx_reference_molecule_details", PdbxReferenceMoleculeDetails::new).get();
    }

    @Override
    public PdbxReferenceMoleculeSynonyms getPdbxReferenceMoleculeSynonyms() {
        return (PdbxReferenceMoleculeSynonyms)this.categories.computeIfAbsent("pdbx_reference_molecule_synonyms", PdbxReferenceMoleculeSynonyms::new).get();
    }

    @Override
    public PdbxReferenceEntitySubcomponents getPdbxReferenceEntitySubcomponents() {
        return (PdbxReferenceEntitySubcomponents)this.categories.computeIfAbsent("pdbx_reference_entity_subcomponents", PdbxReferenceEntitySubcomponents::new).get();
    }

    @Override
    public PdbxReferenceMoleculeAnnotation getPdbxReferenceMoleculeAnnotation() {
        return (PdbxReferenceMoleculeAnnotation)this.categories.computeIfAbsent("pdbx_reference_molecule_annotation", PdbxReferenceMoleculeAnnotation::new).get();
    }

    @Override
    public PdbxReferenceMoleculeFeatures getPdbxReferenceMoleculeFeatures() {
        return (PdbxReferenceMoleculeFeatures)this.categories.computeIfAbsent("pdbx_reference_molecule_features", PdbxReferenceMoleculeFeatures::new).get();
    }

    @Override
    public PdbxReferenceMoleculeRelatedStructures getPdbxReferenceMoleculeRelatedStructures() {
        return (PdbxReferenceMoleculeRelatedStructures)this.categories.computeIfAbsent("pdbx_reference_molecule_related_structures", PdbxReferenceMoleculeRelatedStructures::new).get();
    }

    @Override
    public PdbxStructGroupList getPdbxStructGroupList() {
        return (PdbxStructGroupList)this.categories.computeIfAbsent("pdbx_struct_group_list", PdbxStructGroupList::new).get();
    }

    @Override
    public PdbxStructGroupComponents getPdbxStructGroupComponents() {
        return (PdbxStructGroupComponents)this.categories.computeIfAbsent("pdbx_struct_group_components", PdbxStructGroupComponents::new).get();
    }

    @Override
    public PdbxStructGroupComponentRange getPdbxStructGroupComponentRange() {
        return (PdbxStructGroupComponentRange)this.categories.computeIfAbsent("pdbx_struct_group_component_range", PdbxStructGroupComponentRange::new).get();
    }

    @Override
    public PdbxPrdAudit getPdbxPrdAudit() {
        return (PdbxPrdAudit)this.categories.computeIfAbsent("pdbx_prd_audit", PdbxPrdAudit::new).get();
    }

    @Override
    public PdbxFamilyPrdAudit getPdbxFamilyPrdAudit() {
        return (PdbxFamilyPrdAudit)this.categories.computeIfAbsent("pdbx_family_prd_audit", PdbxFamilyPrdAudit::new).get();
    }

    @Override
    public PdbxMolecule getPdbxMolecule() {
        return (PdbxMolecule)this.categories.computeIfAbsent("pdbx_molecule", PdbxMolecule::new).get();
    }

    @Override
    public PdbxMoleculeFeatures getPdbxMoleculeFeatures() {
        return (PdbxMoleculeFeatures)this.categories.computeIfAbsent("pdbx_molecule_features", PdbxMoleculeFeatures::new).get();
    }

    @Override
    public PdbxFamilyGroupIndex getPdbxFamilyGroupIndex() {
        return (PdbxFamilyGroupIndex)this.categories.computeIfAbsent("pdbx_family_group_index", PdbxFamilyGroupIndex::new).get();
    }

    @Override
    public PdbxDistantSolventAtoms getPdbxDistantSolventAtoms() {
        return (PdbxDistantSolventAtoms)this.categories.computeIfAbsent("pdbx_distant_solvent_atoms", PdbxDistantSolventAtoms::new).get();
    }

    @Override
    public PdbxStructSpecialSymmetry getPdbxStructSpecialSymmetry() {
        return (PdbxStructSpecialSymmetry)this.categories.computeIfAbsent("pdbx_struct_special_symmetry", PdbxStructSpecialSymmetry::new).get();
    }

    @Override
    public PdbxReferencePublicationList getPdbxReferencePublicationList() {
        return (PdbxReferencePublicationList)this.categories.computeIfAbsent("pdbx_reference_publication_list", PdbxReferencePublicationList::new).get();
    }

    @Override
    public PdbxNmrAssignedChemShiftList getPdbxNmrAssignedChemShiftList() {
        return (PdbxNmrAssignedChemShiftList)this.categories.computeIfAbsent("pdbx_nmr_assigned_chem_shift_list", PdbxNmrAssignedChemShiftList::new).get();
    }

    @Override
    public PdbxNmrChemShiftExperiment getPdbxNmrChemShiftExperiment() {
        return (PdbxNmrChemShiftExperiment)this.categories.computeIfAbsent("pdbx_nmr_chem_shift_experiment", PdbxNmrChemShiftExperiment::new).get();
    }

    @Override
    public PdbxNmrChemShiftRef getPdbxNmrChemShiftRef() {
        return (PdbxNmrChemShiftRef)this.categories.computeIfAbsent("pdbx_nmr_chem_shift_ref", PdbxNmrChemShiftRef::new).get();
    }

    @Override
    public PdbxNmrChemShiftReference getPdbxNmrChemShiftReference() {
        return (PdbxNmrChemShiftReference)this.categories.computeIfAbsent("pdbx_nmr_chem_shift_reference", PdbxNmrChemShiftReference::new).get();
    }

    @Override
    public PdbxNmrChemShiftSoftware getPdbxNmrChemShiftSoftware() {
        return (PdbxNmrChemShiftSoftware)this.categories.computeIfAbsent("pdbx_nmr_chem_shift_software", PdbxNmrChemShiftSoftware::new).get();
    }

    @Override
    public PdbxNmrConstraintFile getPdbxNmrConstraintFile() {
        return (PdbxNmrConstraintFile)this.categories.computeIfAbsent("pdbx_nmr_constraint_file", PdbxNmrConstraintFile::new).get();
    }

    @Override
    public PdbxNmrSoftwareTask getPdbxNmrSoftwareTask() {
        return (PdbxNmrSoftwareTask)this.categories.computeIfAbsent("pdbx_nmr_software_task", PdbxNmrSoftwareTask::new).get();
    }

    @Override
    public PdbxNmrSpectralDim getPdbxNmrSpectralDim() {
        return (PdbxNmrSpectralDim)this.categories.computeIfAbsent("pdbx_nmr_spectral_dim", PdbxNmrSpectralDim::new).get();
    }

    @Override
    public PdbxNmrSpectralPeakList getPdbxNmrSpectralPeakList() {
        return (PdbxNmrSpectralPeakList)this.categories.computeIfAbsent("pdbx_nmr_spectral_peak_list", PdbxNmrSpectralPeakList::new).get();
    }

    @Override
    public PdbxNmrSpectralPeakSoftware getPdbxNmrSpectralPeakSoftware() {
        return (PdbxNmrSpectralPeakSoftware)this.categories.computeIfAbsent("pdbx_nmr_spectral_peak_software", PdbxNmrSpectralPeakSoftware::new).get();
    }

    @Override
    public PdbxNmrSystematicChemShiftOffset getPdbxNmrSystematicChemShiftOffset() {
        return (PdbxNmrSystematicChemShiftOffset)this.categories.computeIfAbsent("pdbx_nmr_systematic_chem_shift_offset", PdbxNmrSystematicChemShiftOffset::new).get();
    }

    @Override
    public PdbxNmrUpload getPdbxNmrUpload() {
        return (PdbxNmrUpload)this.categories.computeIfAbsent("pdbx_nmr_upload", PdbxNmrUpload::new).get();
    }

    @Override
    public PdbxAuditSupport getPdbxAuditSupport() {
        return (PdbxAuditSupport)this.categories.computeIfAbsent("pdbx_audit_support", PdbxAuditSupport::new).get();
    }

    @Override
    public PdbxChemCompSubcomponentStructConn getPdbxChemCompSubcomponentStructConn() {
        return (PdbxChemCompSubcomponentStructConn)this.categories.computeIfAbsent("pdbx_chem_comp_subcomponent_struct_conn", PdbxChemCompSubcomponentStructConn::new).get();
    }

    @Override
    public PdbxChemCompSubcomponentEntityList getPdbxChemCompSubcomponentEntityList() {
        return (PdbxChemCompSubcomponentEntityList)this.categories.computeIfAbsent("pdbx_chem_comp_subcomponent_entity_list", PdbxChemCompSubcomponentEntityList::new).get();
    }

    @Override
    public EntitySrcNat getEntitySrcNat() {
        return (EntitySrcNat)this.categories.computeIfAbsent("entity_src_nat", EntitySrcNat::new).get();
    }

    @Override
    public EntitySrcGen getEntitySrcGen() {
        return (EntitySrcGen)this.categories.computeIfAbsent("entity_src_gen", EntitySrcGen::new).get();
    }

    @Override
    public PdbxEntitySrcSyn getPdbxEntitySrcSyn() {
        return (PdbxEntitySrcSyn)this.categories.computeIfAbsent("pdbx_entity_src_syn", PdbxEntitySrcSyn::new).get();
    }

    @Override
    public PdbxEntityPolyCompLinkList getPdbxEntityPolyCompLinkList() {
        return (PdbxEntityPolyCompLinkList)this.categories.computeIfAbsent("pdbx_entity_poly_comp_link_list", PdbxEntityPolyCompLinkList::new).get();
    }

    @Override
    public PdbxLinkedEntity getPdbxLinkedEntity() {
        return (PdbxLinkedEntity)this.categories.computeIfAbsent("pdbx_linked_entity", PdbxLinkedEntity::new).get();
    }

    @Override
    public PdbxLinkedEntityInstanceList getPdbxLinkedEntityInstanceList() {
        return (PdbxLinkedEntityInstanceList)this.categories.computeIfAbsent("pdbx_linked_entity_instance_list", PdbxLinkedEntityInstanceList::new).get();
    }

    @Override
    public PdbxLinkedEntityList getPdbxLinkedEntityList() {
        return (PdbxLinkedEntityList)this.categories.computeIfAbsent("pdbx_linked_entity_list", PdbxLinkedEntityList::new).get();
    }

    @Override
    public PdbxLinkedEntityLinkList getPdbxLinkedEntityLinkList() {
        return (PdbxLinkedEntityLinkList)this.categories.computeIfAbsent("pdbx_linked_entity_link_list", PdbxLinkedEntityLinkList::new).get();
    }

    @Override
    public PdbxEntityDescriptor getPdbxEntityDescriptor() {
        return (PdbxEntityDescriptor)this.categories.computeIfAbsent("pdbx_entity_descriptor", PdbxEntityDescriptor::new).get();
    }

    @Override
    public PdbxReferenceLinkedEntity getPdbxReferenceLinkedEntity() {
        return (PdbxReferenceLinkedEntity)this.categories.computeIfAbsent("pdbx_reference_linked_entity", PdbxReferenceLinkedEntity::new).get();
    }

    @Override
    public PdbxReferenceLinkedEntityCompList getPdbxReferenceLinkedEntityCompList() {
        return (PdbxReferenceLinkedEntityCompList)this.categories.computeIfAbsent("pdbx_reference_linked_entity_comp_list", PdbxReferenceLinkedEntityCompList::new).get();
    }

    @Override
    public PdbxReferenceLinkedEntityCompLink getPdbxReferenceLinkedEntityCompLink() {
        return (PdbxReferenceLinkedEntityCompLink)this.categories.computeIfAbsent("pdbx_reference_linked_entity_comp_link", PdbxReferenceLinkedEntityCompLink::new).get();
    }

    @Override
    public PdbxReferenceLinkedEntityLink getPdbxReferenceLinkedEntityLink() {
        return (PdbxReferenceLinkedEntityLink)this.categories.computeIfAbsent("pdbx_reference_linked_entity_link", PdbxReferenceLinkedEntityLink::new).get();
    }

    @Override
    public PdbxRelatedExpDataSet getPdbxRelatedExpDataSet() {
        return (PdbxRelatedExpDataSet)this.categories.computeIfAbsent("pdbx_related_exp_data_set", PdbxRelatedExpDataSet::new).get();
    }

    @Override
    public PdbxDatabaseStatusHistory getPdbxDatabaseStatusHistory() {
        return (PdbxDatabaseStatusHistory)this.categories.computeIfAbsent("pdbx_database_status_history", PdbxDatabaseStatusHistory::new).get();
    }

    @Override
    public EmAssembly getEmAssembly() {
        return (EmAssembly)this.categories.computeIfAbsent("em_assembly", EmAssembly::new).get();
    }

    @Override
    public EmEntityAssembly getEmEntityAssembly() {
        return (EmEntityAssembly)this.categories.computeIfAbsent("em_entity_assembly", EmEntityAssembly::new).get();
    }

    @Override
    public EmVirusEntity getEmVirusEntity() {
        return (EmVirusEntity)this.categories.computeIfAbsent("em_virus_entity", EmVirusEntity::new).get();
    }

    @Override
    public EmSamplePreparation getEmSamplePreparation() {
        return (EmSamplePreparation)this.categories.computeIfAbsent("em_sample_preparation", EmSamplePreparation::new).get();
    }

    @Override
    public EmSampleSupport getEmSampleSupport() {
        return (EmSampleSupport)this.categories.computeIfAbsent("em_sample_support", EmSampleSupport::new).get();
    }

    @Override
    public EmBuffer getEmBuffer() {
        return (EmBuffer)this.categories.computeIfAbsent("em_buffer", EmBuffer::new).get();
    }

    @Override
    public EmVitrification getEmVitrification() {
        return (EmVitrification)this.categories.computeIfAbsent("em_vitrification", EmVitrification::new).get();
    }

    @Override
    public EmImaging getEmImaging() {
        return (EmImaging)this.categories.computeIfAbsent("em_imaging", EmImaging::new).get();
    }

    @Override
    public EmDetector getEmDetector() {
        return (EmDetector)this.categories.computeIfAbsent("em_detector", EmDetector::new).get();
    }

    @Override
    public EmImageScans getEmImageScans() {
        return (EmImageScans)this.categories.computeIfAbsent("em_image_scans", EmImageScans::new).get();
    }

    @Override
    public Em2dProjectionSelection getEm2dProjectionSelection() {
        return (Em2dProjectionSelection)this.categories.computeIfAbsent("em_2d_projection_selection", Em2dProjectionSelection::new).get();
    }

    @Override
    public Em3dReconstruction getEm3dReconstruction() {
        return (Em3dReconstruction)this.categories.computeIfAbsent("em_3d_reconstruction", Em3dReconstruction::new).get();
    }

    @Override
    public Em3dFitting getEm3dFitting() {
        return (Em3dFitting)this.categories.computeIfAbsent("em_3d_fitting", Em3dFitting::new).get();
    }

    @Override
    public Em3dFittingList getEm3dFittingList() {
        return (Em3dFittingList)this.categories.computeIfAbsent("em_3d_fitting_list", Em3dFittingList::new).get();
    }

    @Override
    public EmHelicalEntity getEmHelicalEntity() {
        return (EmHelicalEntity)this.categories.computeIfAbsent("em_helical_entity", EmHelicalEntity::new).get();
    }

    @Override
    public EmExperiment getEmExperiment() {
        return (EmExperiment)this.categories.computeIfAbsent("em_experiment", EmExperiment::new).get();
    }

    @Override
    public EmSingleParticleEntity getEmSingleParticleEntity() {
        return (EmSingleParticleEntity)this.categories.computeIfAbsent("em_single_particle_entity", EmSingleParticleEntity::new).get();
    }

    @Override
    public EmAdmin getEmAdmin() {
        return (EmAdmin)this.categories.computeIfAbsent("em_admin", EmAdmin::new).get();
    }

    @Override
    public EmAuthorList getEmAuthorList() {
        return (EmAuthorList)this.categories.computeIfAbsent("em_author_list", EmAuthorList::new).get();
    }

    @Override
    public EmDbReference getEmDbReference() {
        return (EmDbReference)this.categories.computeIfAbsent("em_db_reference", EmDbReference::new).get();
    }

    @Override
    public EmDbReferenceAuxiliary getEmDbReferenceAuxiliary() {
        return (EmDbReferenceAuxiliary)this.categories.computeIfAbsent("em_db_reference_auxiliary", EmDbReferenceAuxiliary::new).get();
    }

    @Override
    public EmDepui getEmDepui() {
        return (EmDepui)this.categories.computeIfAbsent("em_depui", EmDepui::new).get();
    }

    @Override
    public EmObsolete getEmObsolete() {
        return (EmObsolete)this.categories.computeIfAbsent("em_obsolete", EmObsolete::new).get();
    }

    @Override
    public EmSupersede getEmSupersede() {
        return (EmSupersede)this.categories.computeIfAbsent("em_supersede", EmSupersede::new).get();
    }

    @Override
    public EmEntityAssemblyMolwt getEmEntityAssemblyMolwt() {
        return (EmEntityAssemblyMolwt)this.categories.computeIfAbsent("em_entity_assembly_molwt", EmEntityAssemblyMolwt::new).get();
    }

    @Override
    public EmEntityAssemblyNaturalsource getEmEntityAssemblyNaturalsource() {
        return (EmEntityAssemblyNaturalsource)this.categories.computeIfAbsent("em_entity_assembly_naturalsource", EmEntityAssemblyNaturalsource::new).get();
    }

    @Override
    public EmEntityAssemblyRecombinant getEmEntityAssemblyRecombinant() {
        return (EmEntityAssemblyRecombinant)this.categories.computeIfAbsent("em_entity_assembly_recombinant", EmEntityAssemblyRecombinant::new).get();
    }

    @Override
    public EmVirusNaturalHost getEmVirusNaturalHost() {
        return (EmVirusNaturalHost)this.categories.computeIfAbsent("em_virus_natural_host", EmVirusNaturalHost::new).get();
    }

    @Override
    public EmVirusShell getEmVirusShell() {
        return (EmVirusShell)this.categories.computeIfAbsent("em_virus_shell", EmVirusShell::new).get();
    }

    @Override
    public EmSpecimen getEmSpecimen() {
        return (EmSpecimen)this.categories.computeIfAbsent("em_specimen", EmSpecimen::new).get();
    }

    @Override
    public EmEmbedding getEmEmbedding() {
        return (EmEmbedding)this.categories.computeIfAbsent("em_embedding", EmEmbedding::new).get();
    }

    @Override
    public EmFiducialMarkers getEmFiducialMarkers() {
        return (EmFiducialMarkers)this.categories.computeIfAbsent("em_fiducial_markers", EmFiducialMarkers::new).get();
    }

    @Override
    public EmFocusedIonBeam getEmFocusedIonBeam() {
        return (EmFocusedIonBeam)this.categories.computeIfAbsent("em_focused_ion_beam", EmFocusedIonBeam::new).get();
    }

    @Override
    public EmGridPretreatment getEmGridPretreatment() {
        return (EmGridPretreatment)this.categories.computeIfAbsent("em_grid_pretreatment", EmGridPretreatment::new).get();
    }

    @Override
    public EmUltramicrotomy getEmUltramicrotomy() {
        return (EmUltramicrotomy)this.categories.computeIfAbsent("em_ultramicrotomy", EmUltramicrotomy::new).get();
    }

    @Override
    public EmHighPressureFreezing getEmHighPressureFreezing() {
        return (EmHighPressureFreezing)this.categories.computeIfAbsent("em_high_pressure_freezing", EmHighPressureFreezing::new).get();
    }

    @Override
    public EmShadowing getEmShadowing() {
        return (EmShadowing)this.categories.computeIfAbsent("em_shadowing", EmShadowing::new).get();
    }

    @Override
    public EmTomographySpecimen getEmTomographySpecimen() {
        return (EmTomographySpecimen)this.categories.computeIfAbsent("em_tomography_specimen", EmTomographySpecimen::new).get();
    }

    @Override
    public EmCrystalFormation getEmCrystalFormation() {
        return (EmCrystalFormation)this.categories.computeIfAbsent("em_crystal_formation", EmCrystalFormation::new).get();
    }

    @Override
    public EmStaining getEmStaining() {
        return (EmStaining)this.categories.computeIfAbsent("em_staining", EmStaining::new).get();
    }

    @Override
    public EmSupportFilm getEmSupportFilm() {
        return (EmSupportFilm)this.categories.computeIfAbsent("em_support_film", EmSupportFilm::new).get();
    }

    @Override
    public EmBufferComponent getEmBufferComponent() {
        return (EmBufferComponent)this.categories.computeIfAbsent("em_buffer_component", EmBufferComponent::new).get();
    }

    @Override
    public EmDiffraction getEmDiffraction() {
        return (EmDiffraction)this.categories.computeIfAbsent("em_diffraction", EmDiffraction::new).get();
    }

    @Override
    public EmDiffractionShell getEmDiffractionShell() {
        return (EmDiffractionShell)this.categories.computeIfAbsent("em_diffraction_shell", EmDiffractionShell::new).get();
    }

    @Override
    public EmDiffractionStats getEmDiffractionStats() {
        return (EmDiffractionStats)this.categories.computeIfAbsent("em_diffraction_stats", EmDiffractionStats::new).get();
    }

    @Override
    public EmTomography getEmTomography() {
        return (EmTomography)this.categories.computeIfAbsent("em_tomography", EmTomography::new).get();
    }

    @Override
    public EmImageRecording getEmImageRecording() {
        return (EmImageRecording)this.categories.computeIfAbsent("em_image_recording", EmImageRecording::new).get();
    }

    @Override
    public EmImagingOptics getEmImagingOptics() {
        return (EmImagingOptics)this.categories.computeIfAbsent("em_imaging_optics", EmImagingOptics::new).get();
    }

    @Override
    public EmFinalClassification getEmFinalClassification() {
        return (EmFinalClassification)this.categories.computeIfAbsent("em_final_classification", EmFinalClassification::new).get();
    }

    @Override
    public EmStartModel getEmStartModel() {
        return (EmStartModel)this.categories.computeIfAbsent("em_start_model", EmStartModel::new).get();
    }

    @Override
    public EmSoftware getEmSoftware() {
        return (EmSoftware)this.categories.computeIfAbsent("em_software", EmSoftware::new).get();
    }

    @Override
    public EmEulerAngleAssignment getEmEulerAngleAssignment() {
        return (EmEulerAngleAssignment)this.categories.computeIfAbsent("em_euler_angle_assignment", EmEulerAngleAssignment::new).get();
    }

    @Override
    public EmCtfCorrection getEmCtfCorrection() {
        return (EmCtfCorrection)this.categories.computeIfAbsent("em_ctf_correction", EmCtfCorrection::new).get();
    }

    @Override
    public EmVolumeSelection getEmVolumeSelection() {
        return (EmVolumeSelection)this.categories.computeIfAbsent("em_volume_selection", EmVolumeSelection::new).get();
    }

    @Override
    public Em3dCrystalEntity getEm3dCrystalEntity() {
        return (Em3dCrystalEntity)this.categories.computeIfAbsent("em_3d_crystal_entity", Em3dCrystalEntity::new).get();
    }

    @Override
    public Em2dCrystalEntity getEm2dCrystalEntity() {
        return (Em2dCrystalEntity)this.categories.computeIfAbsent("em_2d_crystal_entity", Em2dCrystalEntity::new).get();
    }

    @Override
    public EmImageProcessing getEmImageProcessing() {
        return (EmImageProcessing)this.categories.computeIfAbsent("em_image_processing", EmImageProcessing::new).get();
    }

    @Override
    public EmParticleSelection getEmParticleSelection() {
        return (EmParticleSelection)this.categories.computeIfAbsent("em_particle_selection", EmParticleSelection::new).get();
    }

    @Override
    public EmMap getEmMap() {
        return (EmMap)this.categories.computeIfAbsent("em_map", EmMap::new).get();
    }

    @Override
    public EmFscCurve getEmFscCurve() {
        return (EmFscCurve)this.categories.computeIfAbsent("em_fsc_curve", EmFscCurve::new).get();
    }

    @Override
    public EmInterpretFigure getEmInterpretFigure() {
        return (EmInterpretFigure)this.categories.computeIfAbsent("em_interpret_figure", EmInterpretFigure::new).get();
    }

    @Override
    public EmLayerLines getEmLayerLines() {
        return (EmLayerLines)this.categories.computeIfAbsent("em_layer_lines", EmLayerLines::new).get();
    }

    @Override
    public EmStructureFactors getEmStructureFactors() {
        return (EmStructureFactors)this.categories.computeIfAbsent("em_structure_factors", EmStructureFactors::new).get();
    }

    @Override
    public EmDepositorInfo getEmDepositorInfo() {
        return (EmDepositorInfo)this.categories.computeIfAbsent("em_depositor_info", EmDepositorInfo::new).get();
    }

    @Override
    public EmMapDepositorInfo getEmMapDepositorInfo() {
        return (EmMapDepositorInfo)this.categories.computeIfAbsent("em_map_depositor_info", EmMapDepositorInfo::new).get();
    }

    @Override
    public EmMaskDepositorInfo getEmMaskDepositorInfo() {
        return (EmMaskDepositorInfo)this.categories.computeIfAbsent("em_mask_depositor_info", EmMaskDepositorInfo::new).get();
    }

    @Override
    public EmFigureDepositorInfo getEmFigureDepositorInfo() {
        return (EmFigureDepositorInfo)this.categories.computeIfAbsent("em_figure_depositor_info", EmFigureDepositorInfo::new).get();
    }

    @Override
    public EmLayerLinesDepositorInfo getEmLayerLinesDepositorInfo() {
        return (EmLayerLinesDepositorInfo)this.categories.computeIfAbsent("em_layer_lines_depositor_info", EmLayerLinesDepositorInfo::new).get();
    }

    @Override
    public EmStructureFactorsDepositorInfo getEmStructureFactorsDepositorInfo() {
        return (EmStructureFactorsDepositorInfo)this.categories.computeIfAbsent("em_structure_factors_depositor_info", EmStructureFactorsDepositorInfo::new).get();
    }

    @Override
    public PdbxSeqMapDepositorInfo getPdbxSeqMapDepositorInfo() {
        return (PdbxSeqMapDepositorInfo)this.categories.computeIfAbsent("pdbx_seq_map_depositor_info", PdbxSeqMapDepositorInfo::new).get();
    }

    @Override
    public PdbxChemCompDepositorInfo getPdbxChemCompDepositorInfo() {
        return (PdbxChemCompDepositorInfo)this.categories.computeIfAbsent("pdbx_chem_comp_depositor_info", PdbxChemCompDepositorInfo::new).get();
    }

    @Override
    public PdbxStructRefSeqDepositorInfo getPdbxStructRefSeqDepositorInfo() {
        return (PdbxStructRefSeqDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_ref_seq_depositor_info", PdbxStructRefSeqDepositorInfo::new).get();
    }

    @Override
    public PdbxStructRefSeqDifDepositorInfo getPdbxStructRefSeqDifDepositorInfo() {
        return (PdbxStructRefSeqDifDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_ref_seq_dif_depositor_info", PdbxStructRefSeqDifDepositorInfo::new).get();
    }

    @Override
    public PdbxStructAssemblyPropDepositorInfo getPdbxStructAssemblyPropDepositorInfo() {
        return (PdbxStructAssemblyPropDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_assembly_prop_depositor_info", PdbxStructAssemblyPropDepositorInfo::new).get();
    }

    @Override
    public PdbxStructAssemblyDepositorInfo getPdbxStructAssemblyDepositorInfo() {
        return (PdbxStructAssemblyDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_assembly_depositor_info", PdbxStructAssemblyDepositorInfo::new).get();
    }

    @Override
    public PdbxStructAssemblyGenDepositorInfo getPdbxStructAssemblyGenDepositorInfo() {
        return (PdbxStructAssemblyGenDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_assembly_gen_depositor_info", PdbxStructAssemblyGenDepositorInfo::new).get();
    }

    @Override
    public PdbxStructOperListDepositorInfo getPdbxStructOperListDepositorInfo() {
        return (PdbxStructOperListDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_oper_list_depositor_info", PdbxStructOperListDepositorInfo::new).get();
    }

    @Override
    public PdbxPointSymmetryDepositorInfo getPdbxPointSymmetryDepositorInfo() {
        return (PdbxPointSymmetryDepositorInfo)this.categories.computeIfAbsent("pdbx_point_symmetry_depositor_info", PdbxPointSymmetryDepositorInfo::new).get();
    }

    @Override
    public PdbxHelicalSymmetryDepositorInfo getPdbxHelicalSymmetryDepositorInfo() {
        return (PdbxHelicalSymmetryDepositorInfo)this.categories.computeIfAbsent("pdbx_helical_symmetry_depositor_info", PdbxHelicalSymmetryDepositorInfo::new).get();
    }

    @Override
    public PdbxStructAssemblyAuthEvidenceDepositorInfo getPdbxStructAssemblyAuthEvidenceDepositorInfo() {
        return (PdbxStructAssemblyAuthEvidenceDepositorInfo)this.categories.computeIfAbsent("pdbx_struct_assembly_auth_evidence_depositor_info", PdbxStructAssemblyAuthEvidenceDepositorInfo::new).get();
    }

    @Override
    public PdbxSolventAtomSiteMapping getPdbxSolventAtomSiteMapping() {
        return (PdbxSolventAtomSiteMapping)this.categories.computeIfAbsent("pdbx_solvent_atom_site_mapping", PdbxSolventAtomSiteMapping::new).get();
    }

    @Override
    public PdbxMoleculeFeaturesDepositorInfo getPdbxMoleculeFeaturesDepositorInfo() {
        return (PdbxMoleculeFeaturesDepositorInfo)this.categories.computeIfAbsent("pdbx_molecule_features_depositor_info", PdbxMoleculeFeaturesDepositorInfo::new).get();
    }

    @Override
    public PdbxChemCompInstanceDepositorInfo getPdbxChemCompInstanceDepositorInfo() {
        return (PdbxChemCompInstanceDepositorInfo)this.categories.computeIfAbsent("pdbx_chem_comp_instance_depositor_info", PdbxChemCompInstanceDepositorInfo::new).get();
    }

    @Override
    public PdbxDepuiStatusFlags getPdbxDepuiStatusFlags() {
        return (PdbxDepuiStatusFlags)this.categories.computeIfAbsent("pdbx_depui_status_flags", PdbxDepuiStatusFlags::new).get();
    }

    @Override
    public PdbxDepuiUpload getPdbxDepuiUpload() {
        return (PdbxDepuiUpload)this.categories.computeIfAbsent("pdbx_depui_upload", PdbxDepuiUpload::new).get();
    }

    @Override
    public PdbxDepuiValidationStatusFlags getPdbxDepuiValidationStatusFlags() {
        return (PdbxDepuiValidationStatusFlags)this.categories.computeIfAbsent("pdbx_depui_validation_status_flags", PdbxDepuiValidationStatusFlags::new).get();
    }

    @Override
    public PdbxChemCompUploadDepositorInfo getPdbxChemCompUploadDepositorInfo() {
        return (PdbxChemCompUploadDepositorInfo)this.categories.computeIfAbsent("pdbx_chem_comp_upload_depositor_info", PdbxChemCompUploadDepositorInfo::new).get();
    }

    @Override
    public PdbxDepuiEntityStatusFlags getPdbxDepuiEntityStatusFlags() {
        return (PdbxDepuiEntityStatusFlags)this.categories.computeIfAbsent("pdbx_depui_entity_status_flags", PdbxDepuiEntityStatusFlags::new).get();
    }

    @Override
    public PdbxDepuiEntityFeatures getPdbxDepuiEntityFeatures() {
        return (PdbxDepuiEntityFeatures)this.categories.computeIfAbsent("pdbx_depui_entity_features", PdbxDepuiEntityFeatures::new).get();
    }

    @Override
    public PdbxDepositionMessageInfo getPdbxDepositionMessageInfo() {
        return (PdbxDepositionMessageInfo)this.categories.computeIfAbsent("pdbx_deposition_message_info", PdbxDepositionMessageInfo::new).get();
    }

    @Override
    public PdbxDepositionMessageFileReference getPdbxDepositionMessageFileReference() {
        return (PdbxDepositionMessageFileReference)this.categories.computeIfAbsent("pdbx_deposition_message_file_reference", PdbxDepositionMessageFileReference::new).get();
    }

    @Override
    public PdbxDepuiEntryDetails getPdbxDepuiEntryDetails() {
        return (PdbxDepuiEntryDetails)this.categories.computeIfAbsent("pdbx_depui_entry_details", PdbxDepuiEntryDetails::new).get();
    }

    @Override
    public PdbxDataProcessingStatus getPdbxDataProcessingStatus() {
        return (PdbxDataProcessingStatus)this.categories.computeIfAbsent("pdbx_data_processing_status", PdbxDataProcessingStatus::new).get();
    }

    @Override
    public PdbxEntityInstanceFeature getPdbxEntityInstanceFeature() {
        return (PdbxEntityInstanceFeature)this.categories.computeIfAbsent("pdbx_entity_instance_feature", PdbxEntityInstanceFeature::new).get();
    }

    @Override
    public PdbxEntitySrcGenDepositorInfo getPdbxEntitySrcGenDepositorInfo() {
        return (PdbxEntitySrcGenDepositorInfo)this.categories.computeIfAbsent("pdbx_entity_src_gen_depositor_info", PdbxEntitySrcGenDepositorInfo::new).get();
    }

    @Override
    public PdbxChemCompModel getPdbxChemCompModel() {
        return (PdbxChemCompModel)this.categories.computeIfAbsent("pdbx_chem_comp_model", PdbxChemCompModel::new).get();
    }

    @Override
    public PdbxChemCompModelAtom getPdbxChemCompModelAtom() {
        return (PdbxChemCompModelAtom)this.categories.computeIfAbsent("pdbx_chem_comp_model_atom", PdbxChemCompModelAtom::new).get();
    }

    @Override
    public PdbxChemCompModelBond getPdbxChemCompModelBond() {
        return (PdbxChemCompModelBond)this.categories.computeIfAbsent("pdbx_chem_comp_model_bond", PdbxChemCompModelBond::new).get();
    }

    @Override
    public PdbxChemCompModelFeature getPdbxChemCompModelFeature() {
        return (PdbxChemCompModelFeature)this.categories.computeIfAbsent("pdbx_chem_comp_model_feature", PdbxChemCompModelFeature::new).get();
    }

    @Override
    public PdbxChemCompModelDescriptor getPdbxChemCompModelDescriptor() {
        return (PdbxChemCompModelDescriptor)this.categories.computeIfAbsent("pdbx_chem_comp_model_descriptor", PdbxChemCompModelDescriptor::new).get();
    }

    @Override
    public PdbxChemCompModelAudit getPdbxChemCompModelAudit() {
        return (PdbxChemCompModelAudit)this.categories.computeIfAbsent("pdbx_chem_comp_model_audit", PdbxChemCompModelAudit::new).get();
    }

    @Override
    public PdbxChemCompModelReference getPdbxChemCompModelReference() {
        return (PdbxChemCompModelReference)this.categories.computeIfAbsent("pdbx_chem_comp_model_reference", PdbxChemCompModelReference::new).get();
    }

    @Override
    public PdbxViewCategoryGroup getPdbxViewCategoryGroup() {
        return (PdbxViewCategoryGroup)this.categories.computeIfAbsent("pdbx_view_category_group", PdbxViewCategoryGroup::new).get();
    }

    @Override
    public PdbxViewCategory getPdbxViewCategory() {
        return (PdbxViewCategory)this.categories.computeIfAbsent("pdbx_view_category", PdbxViewCategory::new).get();
    }

    @Override
    public PdbxViewItem getPdbxViewItem() {
        return (PdbxViewItem)this.categories.computeIfAbsent("pdbx_view_item", PdbxViewItem::new).get();
    }

    @Override
    public PdbxCoord getPdbxCoord() {
        return (PdbxCoord)this.categories.computeIfAbsent("pdbx_coord", PdbxCoord::new).get();
    }

    @Override
    public PdbxConnect getPdbxConnect() {
        return (PdbxConnect)this.categories.computeIfAbsent("pdbx_connect", PdbxConnect::new).get();
    }

    @Override
    public PdbxConnectType getPdbxConnectType() {
        return (PdbxConnectType)this.categories.computeIfAbsent("pdbx_connect_type", PdbxConnectType::new).get();
    }

    @Override
    public PdbxConnectModification getPdbxConnectModification() {
        return (PdbxConnectModification)this.categories.computeIfAbsent("pdbx_connect_modification", PdbxConnectModification::new).get();
    }

    @Override
    public PdbxConnectAtom getPdbxConnectAtom() {
        return (PdbxConnectAtom)this.categories.computeIfAbsent("pdbx_connect_atom", PdbxConnectAtom::new).get();
    }

    @Override
    public PdbxDatabasePDBMaster getPdbxDatabasePDBMaster() {
        return (PdbxDatabasePDBMaster)this.categories.computeIfAbsent("pdbx_database_PDB_master", PdbxDatabasePDBMaster::new).get();
    }

    @Override
    public PdbxDatabasePdbOmit getPdbxDatabasePdbOmit() {
        return (PdbxDatabasePdbOmit)this.categories.computeIfAbsent("pdbx_database_pdb_omit", PdbxDatabasePdbOmit::new).get();
    }

    @Override
    public PdbxDbref getPdbxDbref() {
        return (PdbxDbref)this.categories.computeIfAbsent("pdbx_dbref", PdbxDbref::new).get();
    }

    @Override
    public PdbxDrugInfo getPdbxDrugInfo() {
        return (PdbxDrugInfo)this.categories.computeIfAbsent("pdbx_drug_info", PdbxDrugInfo::new).get();
    }

    @Override
    public PdbxInhibitorInfo getPdbxInhibitorInfo() {
        return (PdbxInhibitorInfo)this.categories.computeIfAbsent("pdbx_inhibitor_info", PdbxInhibitorInfo::new).get();
    }

    @Override
    public PdbxIonInfo getPdbxIonInfo() {
        return (PdbxIonInfo)this.categories.computeIfAbsent("pdbx_ion_info", PdbxIonInfo::new).get();
    }

    @Override
    public PdbxHybrid getPdbxHybrid() {
        return (PdbxHybrid)this.categories.computeIfAbsent("pdbx_hybrid", PdbxHybrid::new).get();
    }

    @Override
    public PdbxNaStrandInfo getPdbxNaStrandInfo() {
        return (PdbxNaStrandInfo)this.categories.computeIfAbsent("pdbx_na_strand_info", PdbxNaStrandInfo::new).get();
    }

    @Override
    public PdbxNonstandardList getPdbxNonstandardList() {
        return (PdbxNonstandardList)this.categories.computeIfAbsent("pdbx_nonstandard_list", PdbxNonstandardList::new).get();
    }

    @Override
    public PdbxPdbCompnd getPdbxPdbCompnd() {
        return (PdbxPdbCompnd)this.categories.computeIfAbsent("pdbx_pdb_compnd", PdbxPdbCompnd::new).get();
    }

    @Override
    public PdbxPdbSource getPdbxPdbSource() {
        return (PdbxPdbSource)this.categories.computeIfAbsent("pdbx_pdb_source", PdbxPdbSource::new).get();
    }

    @Override
    public PdbxProteinInfo getPdbxProteinInfo() {
        return (PdbxProteinInfo)this.categories.computeIfAbsent("pdbx_protein_info", PdbxProteinInfo::new).get();
    }

    @Override
    public PdbxSolventInfo getPdbxSolventInfo() {
        return (PdbxSolventInfo)this.categories.computeIfAbsent("pdbx_solvent_info", PdbxSolventInfo::new).get();
    }

    @Override
    public PdbxSource getPdbxSource() {
        return (PdbxSource)this.categories.computeIfAbsent("pdbx_source", PdbxSource::new).get();
    }

    @Override
    public PdbxStructBiolFunc getPdbxStructBiolFunc() {
        return (PdbxStructBiolFunc)this.categories.computeIfAbsent("pdbx_struct_biol_func", PdbxStructBiolFunc::new).get();
    }

    @Override
    public PdbxStructPackGen getPdbxStructPackGen() {
        return (PdbxStructPackGen)this.categories.computeIfAbsent("pdbx_struct_pack_gen", PdbxStructPackGen::new).get();
    }

    @Override
    public PdbxTrnaInfo getPdbxTrnaInfo() {
        return (PdbxTrnaInfo)this.categories.computeIfAbsent("pdbx_trna_info", PdbxTrnaInfo::new).get();
    }

    @Override
    public PdbxUnpair getPdbxUnpair() {
        return (PdbxUnpair)this.categories.computeIfAbsent("pdbx_unpair", PdbxUnpair::new).get();
    }

    @Override
    public PdbxRefineLsRestrNcs getPdbxRefineLsRestrNcs() {
        return (PdbxRefineLsRestrNcs)this.categories.computeIfAbsent("pdbx_refine_ls_restr_ncs", PdbxRefineLsRestrNcs::new).get();
    }

    @Override
    public PdbxStructNcsVirusGen getPdbxStructNcsVirusGen() {
        return (PdbxStructNcsVirusGen)this.categories.computeIfAbsent("pdbx_struct_ncs_virus_gen", PdbxStructNcsVirusGen::new).get();
    }

    @Override
    public PdbxSequenceAnnotation getPdbxSequenceAnnotation() {
        return (PdbxSequenceAnnotation)this.categories.computeIfAbsent("pdbx_sequence_annotation", PdbxSequenceAnnotation::new).get();
    }

    @Override
    public PdbxPostProcessDetails getPdbxPostProcessDetails() {
        return (PdbxPostProcessDetails)this.categories.computeIfAbsent("pdbx_post_process_details", PdbxPostProcessDetails::new).get();
    }

    @Override
    public PdbxPostProcessStatus getPdbxPostProcessStatus() {
        return (PdbxPostProcessStatus)this.categories.computeIfAbsent("pdbx_post_process_status", PdbxPostProcessStatus::new).get();
    }

    @Override
    public PdbxStructLink getPdbxStructLink() {
        return (PdbxStructLink)this.categories.computeIfAbsent("pdbx_struct_link", PdbxStructLink::new).get();
    }

    @Override
    public PdbxMissingResidueList getPdbxMissingResidueList() {
        return (PdbxMissingResidueList)this.categories.computeIfAbsent("pdbx_missing_residue_list", PdbxMissingResidueList::new).get();
    }

    @Override
    public PdbxDataProcessingCell getPdbxDataProcessingCell() {
        return (PdbxDataProcessingCell)this.categories.computeIfAbsent("pdbx_data_processing_cell", PdbxDataProcessingCell::new).get();
    }

    @Override
    public PdbxDataProcessingReflns getPdbxDataProcessingReflns() {
        return (PdbxDataProcessingReflns)this.categories.computeIfAbsent("pdbx_data_processing_reflns", PdbxDataProcessingReflns::new).get();
    }

    @Override
    public PdbxDataProcessingDetector getPdbxDataProcessingDetector() {
        return (PdbxDataProcessingDetector)this.categories.computeIfAbsent("pdbx_data_processing_detector", PdbxDataProcessingDetector::new).get();
    }

    @Override
    public PdbxChemCompNonstandard getPdbxChemCompNonstandard() {
        return (PdbxChemCompNonstandard)this.categories.computeIfAbsent("pdbx_chem_comp_nonstandard", PdbxChemCompNonstandard::new).get();
    }

    @Override
    public PdbxEntityPolyProteinClass getPdbxEntityPolyProteinClass() {
        return (PdbxEntityPolyProteinClass)this.categories.computeIfAbsent("pdbx_entity_poly_protein_class", PdbxEntityPolyProteinClass::new).get();
    }

    @Override
    public PdbxEntityNameTaxonomyTree getPdbxEntityNameTaxonomyTree() {
        return (PdbxEntityNameTaxonomyTree)this.categories.computeIfAbsent("pdbx_entity_name_taxonomy_tree", PdbxEntityNameTaxonomyTree::new).get();
    }

    @Override
    public PdbxEntityNameTaxonomy getPdbxEntityNameTaxonomy() {
        return (PdbxEntityNameTaxonomy)this.categories.computeIfAbsent("pdbx_entity_name_taxonomy", PdbxEntityNameTaxonomy::new).get();
    }

    @Override
    public PdbxEntityNameInstance getPdbxEntityNameInstance() {
        return (PdbxEntityNameInstance)this.categories.computeIfAbsent("pdbx_entity_name_instance", PdbxEntityNameInstance::new).get();
    }

    @Override
    public PdbxTableinfo getPdbxTableinfo() {
        return (PdbxTableinfo)this.categories.computeIfAbsent("pdbx_tableinfo", PdbxTableinfo::new).get();
    }

    @Override
    public PdbxColumninfo getPdbxColumninfo() {
        return (PdbxColumninfo)this.categories.computeIfAbsent("pdbx_columninfo", PdbxColumninfo::new).get();
    }

    @Override
    public PdbxValAngle getPdbxValAngle() {
        return (PdbxValAngle)this.categories.computeIfAbsent("pdbx_val_angle", PdbxValAngle::new).get();
    }

    @Override
    public PdbxValBond getPdbxValBond() {
        return (PdbxValBond)this.categories.computeIfAbsent("pdbx_val_bond", PdbxValBond::new).get();
    }

    @Override
    public PdbxValContact getPdbxValContact() {
        return (PdbxValContact)this.categories.computeIfAbsent("pdbx_val_contact", PdbxValContact::new).get();
    }

    @Override
    public PdbxValSymContact getPdbxValSymContact() {
        return (PdbxValSymContact)this.categories.computeIfAbsent("pdbx_val_sym_contact", PdbxValSymContact::new).get();
    }

    @Override
    public PdbxRmchOutlier getPdbxRmchOutlier() {
        return (PdbxRmchOutlier)this.categories.computeIfAbsent("pdbx_rmch_outlier", PdbxRmchOutlier::new).get();
    }

    @Override
    public PdbxMissingAtomPoly getPdbxMissingAtomPoly() {
        return (PdbxMissingAtomPoly)this.categories.computeIfAbsent("pdbx_missing_atom_poly", PdbxMissingAtomPoly::new).get();
    }

    @Override
    public PdbxMissingAtomNonpoly getPdbxMissingAtomNonpoly() {
        return (PdbxMissingAtomNonpoly)this.categories.computeIfAbsent("pdbx_missing_atom_nonpoly", PdbxMissingAtomNonpoly::new).get();
    }

    @Override
    public PdbxValChiral getPdbxValChiral() {
        return (PdbxValChiral)this.categories.computeIfAbsent("pdbx_val_chiral", PdbxValChiral::new).get();
    }

    @Override
    public PdbxAtlas getPdbxAtlas() {
        return (PdbxAtlas)this.categories.computeIfAbsent("pdbx_atlas", PdbxAtlas::new).get();
    }

    @Override
    public PdbxSummaryFlags getPdbxSummaryFlags() {
        return (PdbxSummaryFlags)this.categories.computeIfAbsent("pdbx_summary_flags", PdbxSummaryFlags::new).get();
    }

    @Override
    public PdbxEntityFuncBindMode getPdbxEntityFuncBindMode() {
        return (PdbxEntityFuncBindMode)this.categories.computeIfAbsent("pdbx_entity_func_bind_mode", PdbxEntityFuncBindMode::new).get();
    }

    @Override
    public PdbxEntityFuncEnzyme getPdbxEntityFuncEnzyme() {
        return (PdbxEntityFuncEnzyme)this.categories.computeIfAbsent("pdbx_entity_func_enzyme", PdbxEntityFuncEnzyme::new).get();
    }

    @Override
    public PdbxEntityFuncRegulatory getPdbxEntityFuncRegulatory() {
        return (PdbxEntityFuncRegulatory)this.categories.computeIfAbsent("pdbx_entity_func_regulatory", PdbxEntityFuncRegulatory::new).get();
    }

    @Override
    public PdbxEntityFuncStructural getPdbxEntityFuncStructural() {
        return (PdbxEntityFuncStructural)this.categories.computeIfAbsent("pdbx_entity_func_structural", PdbxEntityFuncStructural::new).get();
    }

    @Override
    public PdbxEntityFuncOther getPdbxEntityFuncOther() {
        return (PdbxEntityFuncOther)this.categories.computeIfAbsent("pdbx_entity_func_other", PdbxEntityFuncOther::new).get();
    }

    @Override
    public PdbxEntityPolyDomain getPdbxEntityPolyDomain() {
        return (PdbxEntityPolyDomain)this.categories.computeIfAbsent("pdbx_entity_poly_domain", PdbxEntityPolyDomain::new).get();
    }

    @Override
    public PdbxNaStructKeywds getPdbxNaStructKeywds() {
        return (PdbxNaStructKeywds)this.categories.computeIfAbsent("pdbx_na_struct_keywds", PdbxNaStructKeywds::new).get();
    }

    @Override
    public PdbxEntityPolyNaType getPdbxEntityPolyNaType() {
        return (PdbxEntityPolyNaType)this.categories.computeIfAbsent("pdbx_entity_poly_na_type", PdbxEntityPolyNaType::new).get();
    }

    @Override
    public PdbxEntityPolyNaNonstandard getPdbxEntityPolyNaNonstandard() {
        return (PdbxEntityPolyNaNonstandard)this.categories.computeIfAbsent("pdbx_entity_poly_na_nonstandard", PdbxEntityPolyNaNonstandard::new).get();
    }

    @Override
    public PdbxVirtualAngle getPdbxVirtualAngle() {
        return (PdbxVirtualAngle)this.categories.computeIfAbsent("pdbx_virtual_angle", PdbxVirtualAngle::new).get();
    }

    @Override
    public PdbxVirtualBond getPdbxVirtualBond() {
        return (PdbxVirtualBond)this.categories.computeIfAbsent("pdbx_virtual_bond", PdbxVirtualBond::new).get();
    }

    @Override
    public PdbxVirtualTorsion getPdbxVirtualTorsion() {
        return (PdbxVirtualTorsion)this.categories.computeIfAbsent("pdbx_virtual_torsion", PdbxVirtualTorsion::new).get();
    }

    @Override
    public PdbxSequencePattern getPdbxSequencePattern() {
        return (PdbxSequencePattern)this.categories.computeIfAbsent("pdbx_sequence_pattern", PdbxSequencePattern::new).get();
    }

    @Override
    public PdbxStereochemistry getPdbxStereochemistry() {
        return (PdbxStereochemistry)this.categories.computeIfAbsent("pdbx_stereochemistry", PdbxStereochemistry::new).get();
    }

    @Override
    public PdbxRmsDevsCovalent getPdbxRmsDevsCovalent() {
        return (PdbxRmsDevsCovalent)this.categories.computeIfAbsent("pdbx_rms_devs_covalent", PdbxRmsDevsCovalent::new).get();
    }

    @Override
    public PdbxRmsDevsCovByMonomer getPdbxRmsDevsCovByMonomer() {
        return (PdbxRmsDevsCovByMonomer)this.categories.computeIfAbsent("pdbx_rms_devs_cov_by_monomer", PdbxRmsDevsCovByMonomer::new).get();
    }

    @Override
    public PdbxSugarPhosphateGeometry getPdbxSugarPhosphateGeometry() {
        return (PdbxSugarPhosphateGeometry)this.categories.computeIfAbsent("pdbx_sugar_phosphate_geometry", PdbxSugarPhosphateGeometry::new).get();
    }

    @Override
    public PdbxNmrComputing getPdbxNmrComputing() {
        return (PdbxNmrComputing)this.categories.computeIfAbsent("pdbx_nmr_computing", PdbxNmrComputing::new).get();
    }

    @Override
    public PdbxAuditConformExtension getPdbxAuditConformExtension() {
        return (PdbxAuditConformExtension)this.categories.computeIfAbsent("pdbx_audit_conform_extension", PdbxAuditConformExtension::new).get();
    }

    @Override
    public PdbxDccMapman getPdbxDccMapman() {
        return (PdbxDccMapman)this.categories.computeIfAbsent("pdbx_dcc_mapman", PdbxDccMapman::new).get();
    }

    @Override
    public PdbxDccRsccMapman getPdbxDccRsccMapman() {
        return (PdbxDccRsccMapman)this.categories.computeIfAbsent("pdbx_dcc_rscc_mapman", PdbxDccRsccMapman::new).get();
    }

    @Override
    public PdbxDccRsccMapmanOverall getPdbxDccRsccMapmanOverall() {
        return (PdbxDccRsccMapmanOverall)this.categories.computeIfAbsent("pdbx_dcc_rscc_mapman_overall", PdbxDccRsccMapmanOverall::new).get();
    }

    @Override
    public PdbxDccDensity getPdbxDccDensity() {
        return (PdbxDccDensity)this.categories.computeIfAbsent("pdbx_dcc_density", PdbxDccDensity::new).get();
    }

    @Override
    public PdbxDccGeometry getPdbxDccGeometry() {
        return (PdbxDccGeometry)this.categories.computeIfAbsent("pdbx_dcc_geometry", PdbxDccGeometry::new).get();
    }

    @Override
    public PdbxDccDensityCorr getPdbxDccDensityCorr() {
        return (PdbxDccDensityCorr)this.categories.computeIfAbsent("pdbx_dcc_density_corr", PdbxDccDensityCorr::new).get();
    }

    @Override
    public PdbxDccMap getPdbxDccMap() {
        return (PdbxDccMap)this.categories.computeIfAbsent("pdbx_dcc_map", PdbxDccMap::new).get();
    }

    @Override
    public PdbxDepositGroup getPdbxDepositGroup() {
        return (PdbxDepositGroup)this.categories.computeIfAbsent("pdbx_deposit_group", PdbxDepositGroup::new).get();
    }

    @Override
    public PdbxDepositGroupIndex getPdbxDepositGroupIndex() {
        return (PdbxDepositGroupIndex)this.categories.computeIfAbsent("pdbx_deposit_group_index", PdbxDepositGroupIndex::new).get();
    }

    @Override
    public PdbxStructAssemblyAuthEvidence getPdbxStructAssemblyAuthEvidence() {
        return (PdbxStructAssemblyAuthEvidence)this.categories.computeIfAbsent("pdbx_struct_assembly_auth_evidence", PdbxStructAssemblyAuthEvidence::new).get();
    }

    @Override
    public PdbxStructAssemblyAuthClassification getPdbxStructAssemblyAuthClassification() {
        return (PdbxStructAssemblyAuthClassification)this.categories.computeIfAbsent("pdbx_struct_assembly_auth_classification", PdbxStructAssemblyAuthClassification::new).get();
    }

    @Override
    public PdbxCrystalAlignment getPdbxCrystalAlignment() {
        return (PdbxCrystalAlignment)this.categories.computeIfAbsent("pdbx_crystal_alignment", PdbxCrystalAlignment::new).get();
    }

    @Override
    public PdbxAuditRevisionHistory getPdbxAuditRevisionHistory() {
        return (PdbxAuditRevisionHistory)this.categories.computeIfAbsent("pdbx_audit_revision_history", PdbxAuditRevisionHistory::new).get();
    }

    @Override
    public PdbxAuditRevisionGroup getPdbxAuditRevisionGroup() {
        return (PdbxAuditRevisionGroup)this.categories.computeIfAbsent("pdbx_audit_revision_group", PdbxAuditRevisionGroup::new).get();
    }

    @Override
    public PdbxAuditRevisionCategory getPdbxAuditRevisionCategory() {
        return (PdbxAuditRevisionCategory)this.categories.computeIfAbsent("pdbx_audit_revision_category", PdbxAuditRevisionCategory::new).get();
    }

    @Override
    public PdbxAuditRevisionDetails getPdbxAuditRevisionDetails() {
        return (PdbxAuditRevisionDetails)this.categories.computeIfAbsent("pdbx_audit_revision_details", PdbxAuditRevisionDetails::new).get();
    }

    @Override
    public PdbxAuditRevisionItem getPdbxAuditRevisionItem() {
        return (PdbxAuditRevisionItem)this.categories.computeIfAbsent("pdbx_audit_revision_item", PdbxAuditRevisionItem::new).get();
    }

    @Override
    public PdbxSupportingExpDataSet getPdbxSupportingExpDataSet() {
        return (PdbxSupportingExpDataSet)this.categories.computeIfAbsent("pdbx_supporting_exp_data_set", PdbxSupportingExpDataSet::new).get();
    }

    @Override
    public PdbxSerialCrystallographyMeasurement getPdbxSerialCrystallographyMeasurement() {
        return (PdbxSerialCrystallographyMeasurement)this.categories.computeIfAbsent("pdbx_serial_crystallography_measurement", PdbxSerialCrystallographyMeasurement::new).get();
    }

    @Override
    public PdbxSerialCrystallographySampleDelivery getPdbxSerialCrystallographySampleDelivery() {
        return (PdbxSerialCrystallographySampleDelivery)this.categories.computeIfAbsent("pdbx_serial_crystallography_sample_delivery", PdbxSerialCrystallographySampleDelivery::new).get();
    }

    @Override
    public PdbxSerialCrystallographySampleDeliveryInjection getPdbxSerialCrystallographySampleDeliveryInjection() {
        return (PdbxSerialCrystallographySampleDeliveryInjection)this.categories.computeIfAbsent("pdbx_serial_crystallography_sample_delivery_injection", PdbxSerialCrystallographySampleDeliveryInjection::new).get();
    }

    @Override
    public PdbxSerialCrystallographySampleDeliveryFixedTarget getPdbxSerialCrystallographySampleDeliveryFixedTarget() {
        return (PdbxSerialCrystallographySampleDeliveryFixedTarget)this.categories.computeIfAbsent("pdbx_serial_crystallography_sample_delivery_fixed_target", PdbxSerialCrystallographySampleDeliveryFixedTarget::new).get();
    }

    @Override
    public PdbxSerialCrystallographyDataReduction getPdbxSerialCrystallographyDataReduction() {
        return (PdbxSerialCrystallographyDataReduction)this.categories.computeIfAbsent("pdbx_serial_crystallography_data_reduction", PdbxSerialCrystallographyDataReduction::new).get();
    }

    @Override
    public PdbxChemCompSynonyms getPdbxChemCompSynonyms() {
        return (PdbxChemCompSynonyms)this.categories.computeIfAbsent("pdbx_chem_comp_synonyms", PdbxChemCompSynonyms::new).get();
    }

    @Override
    public PdbxChemCompRelated getPdbxChemCompRelated() {
        return (PdbxChemCompRelated)this.categories.computeIfAbsent("pdbx_chem_comp_related", PdbxChemCompRelated::new).get();
    }

    @Override
    public PdbxChemCompAtomRelated getPdbxChemCompAtomRelated() {
        return (PdbxChemCompAtomRelated)this.categories.computeIfAbsent("pdbx_chem_comp_atom_related", PdbxChemCompAtomRelated::new).get();
    }

    @Override
    public PdbxEntityBranchList getPdbxEntityBranchList() {
        return (PdbxEntityBranchList)this.categories.computeIfAbsent("pdbx_entity_branch_list", PdbxEntityBranchList::new).get();
    }

    @Override
    public PdbxEntityBranchLink getPdbxEntityBranchLink() {
        return (PdbxEntityBranchLink)this.categories.computeIfAbsent("pdbx_entity_branch_link", PdbxEntityBranchLink::new).get();
    }

    @Override
    public PdbxEntityBranch getPdbxEntityBranch() {
        return (PdbxEntityBranch)this.categories.computeIfAbsent("pdbx_entity_branch", PdbxEntityBranch::new).get();
    }

    @Override
    public PdbxBranchScheme getPdbxBranchScheme() {
        return (PdbxBranchScheme)this.categories.computeIfAbsent("pdbx_branch_scheme", PdbxBranchScheme::new).get();
    }

    @Override
    public IhmStartingModelDetails getIhmStartingModelDetails() {
        return (IhmStartingModelDetails)this.categories.computeIfAbsent("ihm_starting_model_details", IhmStartingModelDetails::new).get();
    }

    @Override
    public IhmStartingComparativeModels getIhmStartingComparativeModels() {
        return (IhmStartingComparativeModels)this.categories.computeIfAbsent("ihm_starting_comparative_models", IhmStartingComparativeModels::new).get();
    }

    @Override
    public IhmStartingComputationalModels getIhmStartingComputationalModels() {
        return (IhmStartingComputationalModels)this.categories.computeIfAbsent("ihm_starting_computational_models", IhmStartingComputationalModels::new).get();
    }

    @Override
    public IhmStartingModelSeqDif getIhmStartingModelSeqDif() {
        return (IhmStartingModelSeqDif)this.categories.computeIfAbsent("ihm_starting_model_seq_dif", IhmStartingModelSeqDif::new).get();
    }

    @Override
    public IhmModelRepresentation getIhmModelRepresentation() {
        return (IhmModelRepresentation)this.categories.computeIfAbsent("ihm_model_representation", IhmModelRepresentation::new).get();
    }

    @Override
    public IhmStructAssembly getIhmStructAssembly() {
        return (IhmStructAssembly)this.categories.computeIfAbsent("ihm_struct_assembly", IhmStructAssembly::new).get();
    }

    @Override
    public IhmStructAssemblyDetails getIhmStructAssemblyDetails() {
        return (IhmStructAssemblyDetails)this.categories.computeIfAbsent("ihm_struct_assembly_details", IhmStructAssemblyDetails::new).get();
    }

    @Override
    public IhmStructAssemblyClassList getIhmStructAssemblyClassList() {
        return (IhmStructAssemblyClassList)this.categories.computeIfAbsent("ihm_struct_assembly_class_list", IhmStructAssemblyClassList::new).get();
    }

    @Override
    public IhmStructAssemblyClass getIhmStructAssemblyClass() {
        return (IhmStructAssemblyClass)this.categories.computeIfAbsent("ihm_struct_assembly_class", IhmStructAssemblyClass::new).get();
    }

    @Override
    public IhmModelingProtocol getIhmModelingProtocol() {
        return (IhmModelingProtocol)this.categories.computeIfAbsent("ihm_modeling_protocol", IhmModelingProtocol::new).get();
    }

    @Override
    public IhmMultiStateModeling getIhmMultiStateModeling() {
        return (IhmMultiStateModeling)this.categories.computeIfAbsent("ihm_multi_state_modeling", IhmMultiStateModeling::new).get();
    }

    @Override
    public IhmOrderedEnsemble getIhmOrderedEnsemble() {
        return (IhmOrderedEnsemble)this.categories.computeIfAbsent("ihm_ordered_ensemble", IhmOrderedEnsemble::new).get();
    }

    @Override
    public IhmModelingPostProcess getIhmModelingPostProcess() {
        return (IhmModelingPostProcess)this.categories.computeIfAbsent("ihm_modeling_post_process", IhmModelingPostProcess::new).get();
    }

    @Override
    public IhmEnsembleInfo getIhmEnsembleInfo() {
        return (IhmEnsembleInfo)this.categories.computeIfAbsent("ihm_ensemble_info", IhmEnsembleInfo::new).get();
    }

    @Override
    public IhmModelList getIhmModelList() {
        return (IhmModelList)this.categories.computeIfAbsent("ihm_model_list", IhmModelList::new).get();
    }

    @Override
    public IhmModelRepresentative getIhmModelRepresentative() {
        return (IhmModelRepresentative)this.categories.computeIfAbsent("ihm_model_representative", IhmModelRepresentative::new).get();
    }

    @Override
    public IhmDatasetList getIhmDatasetList() {
        return (IhmDatasetList)this.categories.computeIfAbsent("ihm_dataset_list", IhmDatasetList::new).get();
    }

    @Override
    public IhmDatasetGroup getIhmDatasetGroup() {
        return (IhmDatasetGroup)this.categories.computeIfAbsent("ihm_dataset_group", IhmDatasetGroup::new).get();
    }

    @Override
    public IhmRelatedDatasets getIhmRelatedDatasets() {
        return (IhmRelatedDatasets)this.categories.computeIfAbsent("ihm_related_datasets", IhmRelatedDatasets::new).get();
    }

    @Override
    public IhmDatasetRelatedDbReference getIhmDatasetRelatedDbReference() {
        return (IhmDatasetRelatedDbReference)this.categories.computeIfAbsent("ihm_dataset_related_db_reference", IhmDatasetRelatedDbReference::new).get();
    }

    @Override
    public IhmExternalReferenceInfo getIhmExternalReferenceInfo() {
        return (IhmExternalReferenceInfo)this.categories.computeIfAbsent("ihm_external_reference_info", IhmExternalReferenceInfo::new).get();
    }

    @Override
    public IhmExternalFiles getIhmExternalFiles() {
        return (IhmExternalFiles)this.categories.computeIfAbsent("ihm_external_files", IhmExternalFiles::new).get();
    }

    @Override
    public IhmDatasetExternalReference getIhmDatasetExternalReference() {
        return (IhmDatasetExternalReference)this.categories.computeIfAbsent("ihm_dataset_external_reference", IhmDatasetExternalReference::new).get();
    }

    @Override
    public IhmLocalizationDensityFiles getIhmLocalizationDensityFiles() {
        return (IhmLocalizationDensityFiles)this.categories.computeIfAbsent("ihm_localization_density_files", IhmLocalizationDensityFiles::new).get();
    }

    @Override
    public IhmPredictedContactRestraint getIhmPredictedContactRestraint() {
        return (IhmPredictedContactRestraint)this.categories.computeIfAbsent("ihm_predicted_contact_restraint", IhmPredictedContactRestraint::new).get();
    }

    @Override
    public IhmHydroxylRadicalFpRestraint getIhmHydroxylRadicalFpRestraint() {
        return (IhmHydroxylRadicalFpRestraint)this.categories.computeIfAbsent("ihm_hydroxyl_radical_fp_restraint", IhmHydroxylRadicalFpRestraint::new).get();
    }

    @Override
    public IhmCrossLinkList getIhmCrossLinkList() {
        return (IhmCrossLinkList)this.categories.computeIfAbsent("ihm_cross_link_list", IhmCrossLinkList::new).get();
    }

    @Override
    public IhmCrossLinkRestraint getIhmCrossLinkRestraint() {
        return (IhmCrossLinkRestraint)this.categories.computeIfAbsent("ihm_cross_link_restraint", IhmCrossLinkRestraint::new).get();
    }

    @Override
    public IhmCrossLinkResult getIhmCrossLinkResult() {
        return (IhmCrossLinkResult)this.categories.computeIfAbsent("ihm_cross_link_result", IhmCrossLinkResult::new).get();
    }

    @Override
    public IhmCrossLinkResultParameters getIhmCrossLinkResultParameters() {
        return (IhmCrossLinkResultParameters)this.categories.computeIfAbsent("ihm_cross_link_result_parameters", IhmCrossLinkResultParameters::new).get();
    }

    @Override
    public Ihm2demClassAverageRestraint getIhm2demClassAverageRestraint() {
        return (Ihm2demClassAverageRestraint)this.categories.computeIfAbsent("ihm_2dem_class_average_restraint", Ihm2demClassAverageRestraint::new).get();
    }

    @Override
    public Ihm2demClassAverageFitting getIhm2demClassAverageFitting() {
        return (Ihm2demClassAverageFitting)this.categories.computeIfAbsent("ihm_2dem_class_average_fitting", Ihm2demClassAverageFitting::new).get();
    }

    @Override
    public Ihm3demRestraint getIhm3demRestraint() {
        return (Ihm3demRestraint)this.categories.computeIfAbsent("ihm_3dem_restraint", Ihm3demRestraint::new).get();
    }

    @Override
    public IhmSasRestraint getIhmSasRestraint() {
        return (IhmSasRestraint)this.categories.computeIfAbsent("ihm_sas_restraint", IhmSasRestraint::new).get();
    }

    @Override
    public IhmStartingModelCoord getIhmStartingModelCoord() {
        return (IhmStartingModelCoord)this.categories.computeIfAbsent("ihm_starting_model_coord", IhmStartingModelCoord::new).get();
    }

    @Override
    public IhmSphereObjSite getIhmSphereObjSite() {
        return (IhmSphereObjSite)this.categories.computeIfAbsent("ihm_sphere_obj_site", IhmSphereObjSite::new).get();
    }

    @Override
    public IhmGaussianObjSite getIhmGaussianObjSite() {
        return (IhmGaussianObjSite)this.categories.computeIfAbsent("ihm_gaussian_obj_site", IhmGaussianObjSite::new).get();
    }

    @Override
    public IhmGaussianObjEnsemble getIhmGaussianObjEnsemble() {
        return (IhmGaussianObjEnsemble)this.categories.computeIfAbsent("ihm_gaussian_obj_ensemble", IhmGaussianObjEnsemble::new).get();
    }

    @Override
    public IhmResiduesNotModeled getIhmResiduesNotModeled() {
        return (IhmResiduesNotModeled)this.categories.computeIfAbsent("ihm_residues_not_modeled", IhmResiduesNotModeled::new).get();
    }

    @Override
    public IhmFeatureList getIhmFeatureList() {
        return (IhmFeatureList)this.categories.computeIfAbsent("ihm_feature_list", IhmFeatureList::new).get();
    }

    @Override
    public IhmPseudoSiteFeature getIhmPseudoSiteFeature() {
        return (IhmPseudoSiteFeature)this.categories.computeIfAbsent("ihm_pseudo_site_feature", IhmPseudoSiteFeature::new).get();
    }

    @Override
    public IhmPolyAtomFeature getIhmPolyAtomFeature() {
        return (IhmPolyAtomFeature)this.categories.computeIfAbsent("ihm_poly_atom_feature", IhmPolyAtomFeature::new).get();
    }

    @Override
    public IhmPolyResidueFeature getIhmPolyResidueFeature() {
        return (IhmPolyResidueFeature)this.categories.computeIfAbsent("ihm_poly_residue_feature", IhmPolyResidueFeature::new).get();
    }

    @Override
    public IhmNonPolyFeature getIhmNonPolyFeature() {
        return (IhmNonPolyFeature)this.categories.computeIfAbsent("ihm_non_poly_feature", IhmNonPolyFeature::new).get();
    }

    @Override
    public IhmInterfaceResidueFeature getIhmInterfaceResidueFeature() {
        return (IhmInterfaceResidueFeature)this.categories.computeIfAbsent("ihm_interface_residue_feature", IhmInterfaceResidueFeature::new).get();
    }

    @Override
    public IhmDerivedDistanceRestraint getIhmDerivedDistanceRestraint() {
        return (IhmDerivedDistanceRestraint)this.categories.computeIfAbsent("ihm_derived_distance_restraint", IhmDerivedDistanceRestraint::new).get();
    }

    @Override
    public IhmGeometricObjectList getIhmGeometricObjectList() {
        return (IhmGeometricObjectList)this.categories.computeIfAbsent("ihm_geometric_object_list", IhmGeometricObjectList::new).get();
    }

    @Override
    public IhmGeometricObjectCenter getIhmGeometricObjectCenter() {
        return (IhmGeometricObjectCenter)this.categories.computeIfAbsent("ihm_geometric_object_center", IhmGeometricObjectCenter::new).get();
    }

    @Override
    public IhmGeometricObjectTransformation getIhmGeometricObjectTransformation() {
        return (IhmGeometricObjectTransformation)this.categories.computeIfAbsent("ihm_geometric_object_transformation", IhmGeometricObjectTransformation::new).get();
    }

    @Override
    public IhmGeometricObjectSphere getIhmGeometricObjectSphere() {
        return (IhmGeometricObjectSphere)this.categories.computeIfAbsent("ihm_geometric_object_sphere", IhmGeometricObjectSphere::new).get();
    }

    @Override
    public IhmGeometricObjectTorus getIhmGeometricObjectTorus() {
        return (IhmGeometricObjectTorus)this.categories.computeIfAbsent("ihm_geometric_object_torus", IhmGeometricObjectTorus::new).get();
    }

    @Override
    public IhmGeometricObjectHalfTorus getIhmGeometricObjectHalfTorus() {
        return (IhmGeometricObjectHalfTorus)this.categories.computeIfAbsent("ihm_geometric_object_half_torus", IhmGeometricObjectHalfTorus::new).get();
    }

    @Override
    public IhmGeometricObjectAxis getIhmGeometricObjectAxis() {
        return (IhmGeometricObjectAxis)this.categories.computeIfAbsent("ihm_geometric_object_axis", IhmGeometricObjectAxis::new).get();
    }

    @Override
    public IhmGeometricObjectPlane getIhmGeometricObjectPlane() {
        return (IhmGeometricObjectPlane)this.categories.computeIfAbsent("ihm_geometric_object_plane", IhmGeometricObjectPlane::new).get();
    }

    @Override
    public IhmGeometricObjectDistanceRestraint getIhmGeometricObjectDistanceRestraint() {
        return (IhmGeometricObjectDistanceRestraint)this.categories.computeIfAbsent("ihm_geometric_object_distance_restraint", IhmGeometricObjectDistanceRestraint::new).get();
    }
}

