/*
 * Decompiled with CFR 0.152.
 */
package org.rcsb.cif.generator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.rcsb.cif.CifIO;
import org.rcsb.cif.binary.codec.MessagePackCodec;
import org.rcsb.cif.generator.Col;
import org.rcsb.cif.generator.CoordCol;
import org.rcsb.cif.generator.EnumCol;
import org.rcsb.cif.generator.FloatCol;
import org.rcsb.cif.generator.IntCol;
import org.rcsb.cif.generator.ListCol;
import org.rcsb.cif.generator.MatrixCol;
import org.rcsb.cif.generator.StrCol;
import org.rcsb.cif.generator.Table;
import org.rcsb.cif.generator.VectorCol;
import org.rcsb.cif.model.BaseBlock;
import org.rcsb.cif.model.BaseCategory;
import org.rcsb.cif.model.Block;
import org.rcsb.cif.model.Category;
import org.rcsb.cif.model.CifFile;
import org.rcsb.cif.model.Column;
import org.rcsb.cif.model.FloatColumn;
import org.rcsb.cif.model.IntColumn;
import org.rcsb.cif.model.StrColumn;

class SchemaGenerator {
    private static final Path OUTPUT_PATH = Paths.get("/Users/sebastian/model/", new String[0]);
    private static final String BASE_PACKAGE = "org.rcsb.cif.model";
    private static final String GENERATED_PACKAGE = "org.rcsb.cif.model.generated";
    private static final Map<String, Map<String, Object>> CLASS_MAP_LOOKUP = new HashMap<String, Map<String, Object>>();
    private static final MessagePackCodec MESSAGE_PACK_CODEC = new MessagePackCodec();
    private static final String RE_MATRIX_FIELD = "\\[[1-3]]\\[[1-3]]";
    private static final String RE_VECTOR_FIELD = "\\[[1-3]]";
    private static final List<String> FORCE_INT_FIELDS = Stream.of("_atom_site.id", "_atom_site.auth_seq_id", "_pdbx_struct_mod_residue.auth_seq_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.end_auth_seq_id", "_struct_conn.ptnr1_auth_seq_id", "_struct_conn.ptnr2_auth_seq_id", "_struct_sheet_range.beg_auth_seq_id", "_struct_sheet_range.end_auth_seq_id").collect(Collectors.toList());
    private final Map<String, Table> schema = new LinkedHashMap<String, Table>();
    private final Map<String, Block> categories = new LinkedHashMap<String, Block>();
    private final Map<String, String> links = new LinkedHashMap<String, String>();

    public static void main(String[] args) throws IOException {
        new SchemaGenerator("mmcif_pdbx_v50.dic", "chem_comp-extension.dic", "entity_branch-extension.dic", "ihm-extension.dic");
    }

    static String toClassName(String rawName) {
        String name = Pattern.compile("_").splitAsStream(rawName).map(s -> s.substring(0, 1).toUpperCase() + s.substring(1)).collect(Collectors.joining("")).replaceAll("[/\\\\\\- \t`~!@#$%^&*()=+{}|;:'\",<.>?]", "_").replaceAll("_+", "_").replace("[", "").replace("]", "");
        if (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        if (name.equals("Class")) {
            return "Clazz";
        }
        if (Character.isDigit(name.charAt(0))) {
            return "_" + name;
        }
        return name;
    }

    private void writeClasses() throws IOException {
        this.writeBlockInterface(Block.class.getSimpleName(), this.schema, OUTPUT_PATH);
        this.writeBlockImpl(BaseBlock.class.getSimpleName(), this.schema, OUTPUT_PATH);
        for (Map.Entry<String, Map<String, Object>> entry : CLASS_MAP_LOOKUP.entrySet()) {
            Files.write(OUTPUT_PATH.resolve(entry.getKey() + ".bin"), MESSAGE_PACK_CODEC.encode(entry.getValue()), new OpenOption[0]);
        }
    }

    private void writeBlockInterface(String className, Map<String, Table> content, Path path) throws IOException {
        StringJoiner output = new StringJoiner("\n");
        output.add("package org.rcsb.cif.model;");
        output.add("");
        StringJoiner getters = new StringJoiner("\n");
        getters.add("    String getBlockHeader();");
        getters.add("");
        getters.add("    " + Category.class.getSimpleName() + " getCategory(String name);");
        getters.add("");
        getters.add("    List<String> getCategoryNames();");
        getters.add("");
        getters.add("    List<" + Block.class.getSimpleName() + "> getSaveFrames();");
        getters.add("");
        for (Map.Entry<String, Table> entry : content.entrySet()) {
            String categoryName = entry.getKey();
            Table category = entry.getValue();
            String categoryClassName = SchemaGenerator.toClassName(categoryName);
            getters.add("    /**");
            String description = Pattern.compile("\n").splitAsStream(category.getDescription()).map(s -> "     * " + s).collect(Collectors.joining("\n"));
            getters.add(description);
            getters.add("     * @return " + categoryClassName);
            getters.add("     */");
            getters.add("    org.rcsb.cif.model.generated." + categoryClassName + " get" + categoryClassName + "();");
            getters.add("");
        }
        output.add("import javax.annotation.Generated;");
        output.add("import java.util.List;");
        output.add("");
        output.add("@Generated(\"org.rcsb.cif.generator.SchemaGenerator\")");
        output.add("public interface " + className + " {");
        output.add(getters.toString() + "}");
        output.add("");
        Files.write(path.resolve(className + ".java"), output.toString().getBytes(), new OpenOption[0]);
    }

    private void writeBlockImpl(String className, Map<String, Table> content, Path path) throws IOException {
        StringJoiner output = new StringJoiner("\n");
        output.add("package org.rcsb.cif.model;");
        output.add("");
        StringJoiner getters = new StringJoiner("\n");
        StringJoiner builder = new StringJoiner("\n");
        StringJoiner categoryBuilder = new StringJoiner("\n");
        for (Map.Entry<String, Table> entry : content.entrySet()) {
            String categoryName = entry.getKey();
            Table category = entry.getValue();
            String categoryClassName = SchemaGenerator.toClassName(categoryName);
            getters.add("    public org.rcsb.cif.model.generated." + categoryClassName + " get" + categoryClassName + "() {");
            getters.add("        return (org.rcsb.cif.model.generated." + categoryClassName + ") categories.computeIfAbsent(\"" + categoryName + "\",");
            getters.add("                org.rcsb.cif.model.generated." + categoryClassName + "::new);");
            getters.add("    }");
            getters.add("");
            this.writeCategory(category.getDescription(), categoryClassName, entry.getValue(), path, categoryName, categoryClassName, categoryBuilder);
            builder.add("    public CategoryBuilder." + categoryClassName + "Builder enter" + categoryClassName + "() {");
            builder.add("        return new CategoryBuilder." + categoryClassName + "Builder(this);");
            builder.add("    }");
            builder.add("");
        }
        output.add("import org.rcsb.cif.model.BaseCifBlock;");
        output.add("import org.rcsb.cif.model.Category;");
        output.add("");
        output.add("import javax.annotation.Generated;");
        output.add("import java.util.ArrayList;");
        output.add("import java.util.Map;");
        output.add("");
        output.add("@Generated(\"org.rcsb.cif.generator.SchemaGenerator\")");
        output.add("public class " + className + " implements " + Block.class.getSimpleName() + " {");
        output.add("    public " + className + "(Map<String, Category> categories, String header) {");
        output.add("        super(categories, header, new ArrayList<>());");
        output.add("    }");
        output.add("");
        output.add(getters.toString() + "}");
        output.add("");
        Files.write(path.resolve("BlockBuilder.java"), builder.toString().getBytes(), new OpenOption[0]);
        Files.write(path.resolve("CategoryBuilder.java"), categoryBuilder.toString().getBytes(), new OpenOption[0]);
        Files.write(path.resolve(className + ".java"), output.toString().getBytes(), new OpenOption[0]);
    }

    private void writeCategory(String categoryDescription, String className, Table content, Path path, String categoryName, String categoryClassName, StringJoiner categoryBuilder) throws IOException {
        Path generatedPath;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        if (!Files.exists(generatedPath = path.resolve("generated"), new LinkOption[0])) {
            Files.createDirectory(generatedPath, new FileAttribute[0]);
        }
        Map wordMap = CLASS_MAP_LOOKUP.computeIfAbsent(categoryName.split("_")[0], k -> new HashMap());
        Object categoryInfoRaw = wordMap.computeIfAbsent(categoryName, k -> new Object[4]);
        Object[] categoryInfo = (Object[])categoryInfoRaw;
        categoryInfo[0] = "org.rcsb.cif.model.generated." + className;
        ArrayList<String> intFields = new ArrayList<String>();
        ArrayList<String> floatFields = new ArrayList<String>();
        ArrayList<String> strFields = new ArrayList<String>();
        StringJoiner output = new StringJoiner("\n");
        output.add("package org.rcsb.cif.model.generated;");
        output.add("");
        output.add("import org.rcsb.cif.model.*;");
        output.add("");
        output.add("import javax.annotation.Generated;");
        output.add("import java.util.Map;");
        output.add("");
        output.add("/**");
        categoryDescription = Pattern.compile("\n").splitAsStream(categoryDescription).map(s -> " * " + s).collect(Collectors.joining("\n"));
        output.add(categoryDescription);
        output.add(" */");
        output.add("@Generated(\"org.rcsb.cif.generator.SchemaGenerator\")");
        output.add("public class " + className + " extends " + BaseCategory.class.getSimpleName() + " {");
        StringJoiner getters = new StringJoiner("\n");
        categoryBuilder.add("");
        categoryBuilder.add("    public static class " + categoryClassName + "Builder extends CategoryBuilder {");
        categoryBuilder.add("        private static final String CATEGORY_NAME = \"" + categoryName + "\";");
        categoryBuilder.add("");
        categoryBuilder.add("        public " + categoryClassName + "Builder(BlockBuilder parent) {");
        categoryBuilder.add("            super(CATEGORY_NAME, parent);");
        categoryBuilder.add("        }");
        for (Map.Entry<String, Object> entry : content.getColumns().entrySet()) {
            String columnName = entry.getKey();
            Col column = (Col)entry.getValue();
            String columnClassName = SchemaGenerator.toClassName(columnName);
            Class<? extends Column> baseClass = this.getBaseClass(column.getType());
            String baseClassName = baseClass.getSimpleName();
            getters.add("    /**");
            String description = Pattern.compile("\n").splitAsStream(column.getDescription()).map(s -> "     * " + s).collect(Collectors.joining("\n"));
            getters.add(description);
            getters.add("     * @return " + baseClassName);
            getters.add("     */");
            getters.add("    public " + baseClassName + " get" + columnClassName + "() {");
            getters.add("        return (" + baseClassName + ") (isText ? textFields.computeIfAbsent(\"" + columnName + "\", " + baseClassName + "::new) :");
            getters.add("                getBinaryColumn(\"" + columnName + "\"));");
            getters.add("    }");
            getters.add("");
            if (baseClass.equals(IntColumn.class)) {
                intFields.add(columnName);
            } else if (baseClass.equals(FloatColumn.class)) {
                floatFields.add(columnName);
            } else {
                strFields.add(columnName);
            }
            categoryBuilder.add("");
            categoryBuilder.add("        public " + baseClassName + "Builder<" + categoryClassName + "Builder> enter" + columnClassName + "() {");
            categoryBuilder.add("            return new " + this.getBaseClass(column.getType()) + "Builder<>(CATEGORY_NAME, \"" + columnName + "\", this);");
            categoryBuilder.add("        }");
        }
        output.add("    public " + className + "(String name, Map<String, Column> columns) {");
        output.add("        super(name, columns);");
        output.add("    }");
        output.add("");
        output.add("    public " + className + "(String name, int rowCount, Object[] encodedColumns) {");
        output.add("        super(name, rowCount, encodedColumns);");
        output.add("    }");
        output.add("");
        output.add("    public " + className + "(String name) {");
        output.add("        super(name);");
        output.add("    }");
        output.add("");
        output.add(getters.toString() + "}");
        output.add("");
        categoryBuilder.add("    }");
        categoryInfo[1] = intFields.toArray(new String[0]);
        categoryInfo[2] = floatFields.toArray(new String[0]);
        categoryInfo[3] = strFields.toArray(new String[0]);
        Files.write(path.resolve("generated").resolve(className + ".java"), output.toString().getBytes(), new OpenOption[0]);
    }

    private Class<? extends Column> getBaseClass(String type) {
        switch (type) {
            case "coord": {
                return FloatColumn.class;
            }
            case "enum": {
                return StrColumn.class;
            }
            case "float": {
                return FloatColumn.class;
            }
            case "int": {
                return IntColumn.class;
            }
            case "list": {
                return StrColumn.class;
            }
            case "matrix": {
                return FloatColumn.class;
            }
            case "str": {
                return StrColumn.class;
            }
            case "vector": {
                return FloatColumn.class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private SchemaGenerator(String ... resource) throws IOException {
        for (String res : resource) {
            System.out.println(res);
            CifFile cifFile = CifIO.readFromInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(res));
            this.getCategoryMetadata(cifFile);
            this.buildListOfLinksBetweenCategories(cifFile);
        }
        this.getFieldData();
        this.writeClasses();
    }

    private void getFieldData() {
        this.categories.forEach((fullName, saveFrame) -> {
            String header;
            String categoryName = header.substring(1, (header = saveFrame.getBlockHeader()).contains(".") ? header.indexOf(".") : header.length());
            String itemName = header.substring(header.contains(".") ? header.indexOf(".") + 1 : 1);
            Map<String, Object> fields = this.schema.get(categoryName).getColumns();
            String description = this.getDescription((Block)saveFrame);
            String subCategory = this.getSubCategory((Block)saveFrame);
            if ("cartesian_coordinate".equals(subCategory) || "fractional_coordinate".equals(subCategory)) {
                fields.put(itemName, new CoordCol(description));
            } else if (FORCE_INT_FIELDS.contains(header)) {
                fields.put(itemName, new IntCol(description));
            } else if ("matrix".equals(subCategory)) {
                fields.put(itemName, new MatrixCol(description));
            } else if ("vector".equals(subCategory)) {
                fields.put(itemName, new VectorCol(description));
            } else if (itemName.matches(RE_MATRIX_FIELD)) {
                fields.put(itemName, new MatrixCol(description));
            } else if (itemName.matches(RE_VECTOR_FIELD)) {
                fields.put(itemName, new VectorCol(description));
            } else {
                List<String> code = this.getCode((Block)saveFrame);
                if (code.size() > 0) {
                    Col fieldType = this.getFieldType(code.get(0), description, code.subList(1, code.size()));
                    fields.put(itemName, fieldType);
                }
            }
        });
    }

    private Col getFieldType(String type, String description, List<String> values) {
        switch (type) {
            case "code": 
            case "ucode": 
            case "line": 
            case "uline": 
            case "text": 
            case "char": 
            case "uchar3": 
            case "uchar1": 
            case "boolean": {
                return values.size() > 0 ? new EnumCol(values, "str", description) : new StrCol(description);
            }
            case "aliasname": 
            case "name": 
            case "idname": 
            case "any": 
            case "atcode": 
            case "fax": 
            case "phone": 
            case "email": 
            case "code30": 
            case "seq-one-letter-code": 
            case "author": 
            case "orcid_id": 
            case "sequence_dep": 
            case "pdb_id": 
            case "emd_id": 
            case "yyyy-mm-dd": 
            case "yyyy-mm-dd:hh:mm": 
            case "yyyy-mm-dd:hh:mm-flex": 
            case "int-range": 
            case "float-range": 
            case "binary": 
            case "operation_expression": 
            case "point_symmetry": 
            case "4x3_matrix": 
            case "3x4_matrices": 
            case "point_group": 
            case "point_group_helical": 
            case "symmetry_operation": 
            case "date_dep": 
            case "url": 
            case "symop": {
                return new StrCol(description);
            }
            case "int": 
            case "non_negative_int": 
            case "positive_int": {
                return values.size() > 0 ? new EnumCol(values, "int", description) : new IntCol(description);
            }
            case "float": {
                return new FloatCol(description);
            }
            case "ec-type": 
            case "ucode-alphanum-csv": 
            case "id_list": {
                return new ListCol("str", ",", description);
            }
        }
        return new StrCol(description);
    }

    private List<String> getCode(Block saveFrame) {
        Column code = this.getField("item_type", "code", saveFrame);
        if (code.isDefined() && code.getRowCount() > 0) {
            return Stream.concat(Stream.of(code.getStringData(0)), this.getEnums(saveFrame)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private Stream<String> getEnums(Block saveFrame) {
        Column value = this.getField("item_enumeration", "value", saveFrame);
        if (value != null) {
            return IntStream.range(0, value.getRowCount()).mapToObj(value::getStringData);
        }
        return Stream.empty();
    }

    private String getSubCategory(Block saveFrame) {
        try {
            Column value = this.getField("item_sub_category", "id", saveFrame);
            return value.getStringData(0);
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private String getDescription(Block saveFrame) {
        Column value = this.getField("item_description", "description", saveFrame);
        String escapedDescription = this.escape(value.getStringData(0));
        return Pattern.compile("\n").splitAsStream(escapedDescription).map(String::trim).collect(Collectors.joining("\n")).replaceAll("(\\[[1-3]])+ element", "elements").replaceAll("(\\[[1-3]])+", "");
    }

    private Column getField(String category, String field, Block saveFrame) {
        Category cat = saveFrame.getCategory(category);
        if (cat.isDefined()) {
            return cat.getColumn(field);
        }
        String linkName = this.links.get(saveFrame.getBlockHeader());
        Block block = this.categories.get(linkName);
        if (block != null) {
            return this.getField(category, field, block);
        }
        return null;
    }

    private void buildListOfLinksBetweenCategories(CifFile cifFile) {
        cifFile.getBlocks().get(0).getSaveFrames().stream().filter(saveFrame -> saveFrame.getBlockHeader().startsWith("_")).forEach(saveFrame -> {
            this.categories.put(saveFrame.getBlockHeader(), (Block)saveFrame);
            Category item_linked = saveFrame.getCategory("item_linked");
            if (item_linked == null) {
                return;
            }
            Column child_name = item_linked.getColumn("child_name");
            Column parent_name = item_linked.getColumn("parent_name");
            for (int i = 0; i < item_linked.getRowCount(); ++i) {
                String childName = child_name.getStringData(i);
                String parentName = parent_name.getStringData(i);
                this.links.put(childName, parentName);
            }
        });
    }

    private void getCategoryMetadata(CifFile cifFile) {
        cifFile.getBlocks().get(0).getSaveFrames().stream().filter(saveFrame -> !saveFrame.getBlockHeader().startsWith("_")).forEach(saveFrame -> {
            HashSet<String> categoryKeyNames = new HashSet<String>();
            Column cifColumn = saveFrame.getCategory("category_key").getColumn("name");
            for (int i = 0; i < cifColumn.getRowCount(); ++i) {
                categoryKeyNames.add(cifColumn.getStringData(i));
            }
            String rawDescription = saveFrame.getCategory("category").getColumn("description").getStringData(0);
            String escapedDescription = this.escape(rawDescription);
            String description = Pattern.compile("\n").splitAsStream(escapedDescription).map(String::trim).collect(Collectors.joining("\n"));
            this.schema.put(saveFrame.getBlockHeader(), new Table(description, categoryKeyNames, new LinkedHashMap<String, Object>()));
        });
    }

    private String escape(String description) {
        return description.replace("&", "&amp;").replace(">", "&gt;").replace("<", "&lt;");
    }
}

